/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.solver.curricula.StudentCourseDemands;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnrolledStudentCourseDemands
implements StudentCourseDemands {
    private Hashtable<Long, Set<StudentCourseDemands.WeightedStudentId>> iDemands = new Hashtable();
    private Hashtable<Long, Set<StudentCourseDemands.WeightedCourseOffering>> iStudentRequests = new Hashtable();

    public EnrolledStudentCourseDemands(DataProperties properties) {
    }

    @Override
    public boolean isMakingUpStudents() {
        return false;
    }

    @Override
    public boolean canUseStudentClassEnrollmentsAsSolution() {
        return true;
    }

    @Override
    public boolean isWeightStudentsToFillUpOffering() {
        return false;
    }

    @Override
    public void init(org.hibernate.Session hibSession, Progress progress, Session session, Collection<InstructionalOffering> offerings) {
        for (Object[] o : hibSession.createQuery("select e.courseOffering, s.uniqueId, a.academicAreaAbbreviation, f.code, m.code from StudentClassEnrollment e inner join e.student s left outer join s.academicAreaClassifications c left outer join s.posMajors m left outer join c.academicArea a left outer join c.academicClassification f where e.courseOffering.subjectArea.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list()) {
            CourseOffering course = (CourseOffering)o[0];
            Long sid = (Long)o[1];
            String areaAbbv = (String)o[2];
            String clasfCode = (String)o[3];
            String majorCode = (String)o[4];
            Set<StudentCourseDemands.WeightedStudentId> students = this.iDemands.get(course.getUniqueId());
            if (students == null) {
                students = new HashSet<StudentCourseDemands.WeightedStudentId>();
                this.iDemands.put(course.getUniqueId(), students);
            }
            StudentCourseDemands.WeightedStudentId studentId = new StudentCourseDemands.WeightedStudentId(sid);
            studentId.setStats(areaAbbv, clasfCode, majorCode);
            studentId.setCurriculum(areaAbbv == null ? null : (majorCode == null ? areaAbbv : areaAbbv + "/" + majorCode));
            students.add(studentId);
            Set<StudentCourseDemands.WeightedCourseOffering> courses = this.iStudentRequests.get(studentId);
            if (courses == null) {
                courses = new HashSet<StudentCourseDemands.WeightedCourseOffering>();
                this.iStudentRequests.put(sid, courses);
            }
            courses.add(new StudentCourseDemands.WeightedCourseOffering(course));
        }
    }

    @Override
    public Set<StudentCourseDemands.WeightedStudentId> getDemands(CourseOffering course) {
        return this.iDemands.get(course.getUniqueId());
    }

    @Override
    public Set<StudentCourseDemands.WeightedCourseOffering> getCourses(Long studentId) {
        return this.iStudentRequests.get(studentId);
    }

    @Override
    public Double getEnrollmentPriority(Long studentId, Long courseId) {
        return null;
    }
}

