/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.IdGenerator;
import org.cpsolver.ifs.util.Progress;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.CurriculumCourse;
import org.unitime.timetable.model.CurriculumCourseGroup;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.solver.curricula.CurriculumEnrollmentPriorityProvider;
import org.unitime.timetable.solver.curricula.DefaultCurriculumEnrollmentPriorityProvider;
import org.unitime.timetable.solver.curricula.ParallelInitialization;
import org.unitime.timetable.solver.curricula.StudentCourseDemands;
import org.unitime.timetable.solver.curricula.StudentCourseRequests;
import org.unitime.timetable.solver.curricula.students.CurCourse;
import org.unitime.timetable.solver.curricula.students.CurModel;
import org.unitime.timetable.solver.curricula.students.CurStudent;
import org.unitime.timetable.solver.curricula.students.CurValue;
import org.unitime.timetable.solver.curricula.students.CurVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurriculaRequestsCourseDemands
implements StudentCourseDemands {
    private static Log sLog = LogFactory.getLog(CurriculaRequestsCourseDemands.class);
    private StudentCourseRequests iStudentCourseRequests;
    private IdGenerator iLastStudentId = new IdGenerator();
    private Hashtable<Long, Set<StudentCourseDemands.WeightedStudentId>> iDemands = new Hashtable();
    private Hashtable<Long, Set<StudentCourseDemands.WeightedCourseOffering>> iStudentRequests = new Hashtable();
    private Hashtable<Long, Hashtable<String, Set<String>>> iLoadedCurricula = new Hashtable();
    private Hashtable<Long, Hashtable<Long, Double>> iEnrollmentPriorities = new Hashtable();
    private HashSet<Long> iCheckedCourses = new HashSet();
    private boolean iIncludeOtherStudents = true;
    private boolean iSetStudentCourseLimits = false;
    private CurriculumEnrollmentPriorityProvider iEnrollmentPriorityProvider = null;
    private DataProperties iProperties = null;

    public CurriculaRequestsCourseDemands(DataProperties config) {
        this.iProperties = config;
        this.iStudentCourseRequests = new StudentCourseRequests(config);
        this.iIncludeOtherStudents = config.getPropertyBoolean("CurriculaCourseDemands.IncludeOtherStudents", this.iIncludeOtherStudents);
        this.iSetStudentCourseLimits = config.getPropertyBoolean("CurriculaCourseDemands.SetStudentCourseLimits", this.iSetStudentCourseLimits);
        this.iEnrollmentPriorityProvider = new DefaultCurriculumEnrollmentPriorityProvider(config);
        if (config.getProperty("CurriculaCourseDemands.CurriculumEnrollmentPriorityProvider") != null) {
            try {
                this.iEnrollmentPriorityProvider = (CurriculumEnrollmentPriorityProvider)Class.forName(config.getProperty("CurriculaCourseDemands.CurriculumEnrollmentPriorityProvider")).getConstructor(DataProperties.class).newInstance(config);
            }
            catch (Exception e) {
                sLog.error((Object)("Failed to use custom enrollment priority provider: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public void init(org.hibernate.Session hibSession, Progress progress, Session session, Collection<InstructionalOffering> offerings) {
        this.iStudentCourseRequests.init(hibSession, progress, session, offerings);
        List curricula = null;
        if (offerings != null && offerings.size() <= 1000) {
            String courses = "";
            int nrCourses = 0;
            for (InstructionalOffering offering : offerings) {
                for (CourseOffering course : offering.getCourseOfferings()) {
                    if (!courses.isEmpty()) {
                        courses = courses + ",";
                    }
                    courses = courses + course.getUniqueId();
                    ++nrCourses;
                }
            }
            if (nrCourses <= 1000) {
                curricula = hibSession.createQuery("select distinct c from CurriculumCourse cc inner join cc.classification.curriculum c where c.academicArea.session.uniqueId = :sessionId and cc.course.uniqueId in (" + courses + ")").setLong("sessionId", session.getUniqueId().longValue()).list();
            }
        }
        if (curricula == null) {
            curricula = hibSession.createQuery("select c from Curriculum c where c.academicArea.session.uniqueId = :sessionId").setLong("sessionId", session.getUniqueId().longValue()).list();
        }
        ArrayList<Initialization> inits = new ArrayList<Initialization>();
        for (Curriculum curriculum : curricula) {
            Hashtable<String, Hashtable<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>>> requests = this.loadClasfCourseMajor2req(hibSession, curriculum);
            for (CurriculumClassification clasf : curriculum.getClassifications()) {
                if (clasf.getNrStudents() <= 0) continue;
                inits.add(new Initialization(clasf, requests.get(clasf.getAcademicClassification().getCode())));
            }
        }
        new ParallelInitialization("Loading curricula", this.iProperties.getPropertyInt("CurriculaCourseDemands.NrThreads", 1), inits).execute(hibSession, progress);
    }

    private Hashtable<String, Hashtable<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>>> loadClasfCourseMajor2req(org.hibernate.Session hibSession, Curriculum curriculum) {
        String majorCodes = "";
        for (PosMajor major : curriculum.getMajors()) {
            if (!majorCodes.isEmpty()) {
                majorCodes = majorCodes + ",";
            }
            majorCodes = majorCodes + "'" + major.getCode() + "'";
        }
        Hashtable<String, Hashtable<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>>> clasf2courseReq = new Hashtable<String, Hashtable<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>>>();
        for (Object[] o : hibSession.createQuery("select f.code, co, m.code, s.uniqueId from CourseRequest r inner join r.courseDemand.student s inner join s.academicAreaClassifications a inner join a.academicClassification f inner join s.posMajors m inner join r.courseOffering co where s.session.uniqueId = :sessionId and a.academicArea.academicAreaAbbreviation = :acadAbbv " + (majorCodes.isEmpty() ? "" : "and m.code in (" + majorCodes + ") ")).setLong("sessionId", curriculum.getDepartment().getSession().getUniqueId().longValue()).setString("acadAbbv", curriculum.getAcademicArea().getAcademicAreaAbbreviation()).setCacheable(true).list()) {
            Set<StudentCourseDemands.WeightedStudentId> students;
            String clasfCode = (String)o[0];
            CourseOffering course = (CourseOffering)o[1];
            String majorCode = (String)o[2];
            Long studentId = (Long)o[3];
            StudentCourseDemands.WeightedStudentId student = new StudentCourseDemands.WeightedStudentId(studentId);
            student.setStats(curriculum.getAcademicArea().getAcademicAreaAbbreviation(), clasfCode, majorCode);
            student.setCurriculum(curriculum.getAbbv());
            Hashtable<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>> course2req = clasf2courseReq.get(clasfCode);
            if (course2req == null) {
                course2req = new Hashtable();
                clasf2courseReq.put(clasfCode, course2req);
            }
            if ((students = course2req.get(course)) == null) {
                students = new HashSet<StudentCourseDemands.WeightedStudentId>();
                course2req.put(course, students);
            }
            students.add(student);
        }
        return clasf2courseReq;
    }

    protected String getCacheName() {
        return "curriculum-lastlike-demands";
    }

    protected void computeTargetShare(CurriculumClassification clasf, int nrStudents, double factor, double w, CurModel model) {
        for (CurriculumCourse c1 : clasf.getCourses()) {
            double x1 = model.getCourse(c1.getCourse().getUniqueId()).getOriginalMaxSize();
            HashSet[] group = new HashSet[]{new HashSet(), new HashSet()};
            LinkedList<CurriculumCourse> queue = new LinkedList<CurriculumCourse>();
            queue.add(c1);
            HashSet<CurriculumCourseGroup> done = new HashSet<CurriculumCourseGroup>();
            while (!queue.isEmpty()) {
                CurriculumCourse c = (CurriculumCourse)queue.poll();
                for (CurriculumCourseGroup g : c.getGroups()) {
                    if (!done.add(g)) continue;
                    for (CurriculumCourse x : clasf.getCourses()) {
                        if (x.equals(c) || x.equals(c1) || !x.getGroups().contains(g) || !group[group[0].contains(c) ? 0 : g.getType()].add(x)) continue;
                        queue.add(x);
                    }
                }
            }
            for (CurriculumCourse c2 : clasf.getCourses()) {
                double defaultShare;
                boolean req;
                double x2 = model.getCourse(c2.getCourse().getUniqueId()).getOriginalMaxSize();
                boolean opt = group[0].contains(c2);
                boolean bl = req = !opt && group[1].contains(c2);
                double d = opt ? 0.0 : (defaultShare = req ? Math.min(x1, x2) : (double)(c1.getPercShare().floatValue() * c2.getPercShare().floatValue() * (float)nrStudents));
                if (c1.getUniqueId() >= c2.getUniqueId()) continue;
                double share = defaultShare;
                Set<StudentCourseDemands.WeightedStudentId> s1 = this.iStudentCourseRequests.getDemands(c1.getCourse());
                Set<StudentCourseDemands.WeightedStudentId> s2 = this.iStudentCourseRequests.getDemands(c2.getCourse());
                int sharedStudents = 0;
                int registered = 0;
                if (s1 != null && !s1.isEmpty() && s2 != null && !s2.isEmpty()) {
                    for (StudentCourseDemands.WeightedStudentId s : s1) {
                        if (!s.match(clasf)) continue;
                        ++registered;
                        if (!s2.contains(s)) continue;
                        ++sharedStudents;
                    }
                }
                share = registered == 0 ? (1.0 - w) * defaultShare : w * (x1 / (double)registered) * (double)sharedStudents + (1.0 - w) * defaultShare;
                model.setTargetShare(c1.getCourse().getUniqueId(), c2.getCourse().getUniqueId(), share, false);
            }
        }
    }

    @Override
    public Set<StudentCourseDemands.WeightedCourseOffering> getCourses(Long studentId) {
        Set<StudentCourseDemands.WeightedCourseOffering> courses = this.iStudentRequests.get(studentId);
        if (this.iIncludeOtherStudents && studentId >= 0L && courses == null) {
            return this.iStudentCourseRequests.getCourses(studentId);
        }
        return this.iStudentRequests.get(studentId);
    }

    @Override
    public Set<StudentCourseDemands.WeightedStudentId> getDemands(CourseOffering course) {
        if (this.iDemands.isEmpty()) {
            return this.iStudentCourseRequests.getDemands(course);
        }
        Set<StudentCourseDemands.WeightedStudentId> demands = this.iDemands.get(course.getUniqueId());
        if (!this.iIncludeOtherStudents) {
            return demands;
        }
        if (demands == null) {
            demands = new HashSet<StudentCourseDemands.WeightedStudentId>();
            this.iDemands.put(course.getUniqueId(), demands);
        }
        if (this.iCheckedCourses.add(course.getUniqueId())) {
            int was = demands.size();
            Hashtable<String, Set<String>> curricula = this.iLoadedCurricula.get(course.getUniqueId());
            Set<StudentCourseDemands.WeightedStudentId> other = this.iStudentCourseRequests.getDemands(course);
            if (other == null) {
                sLog.debug((Object)(course.getCourseName() + " has no students."));
            } else {
                if (curricula == null || curricula.isEmpty()) {
                    demands.addAll(other);
                } else {
                    for (StudentCourseDemands.WeightedStudentId student : other) {
                        Set<String> majors;
                        if (student.getArea() == null || (majors = curricula.get(student.getArea() + ":" + student.getClasf())) != null && majors.contains("") || majors != null && (student.getMajor() == null || majors.contains(student.getMajor()))) continue;
                        demands.add(student);
                    }
                }
                if (demands.size() > was) {
                    sLog.debug((Object)(course.getCourseName() + " has " + (demands.size() - was) + " other students (besides of the " + was + " curriculum students)."));
                }
            }
        }
        return demands;
    }

    @Override
    public boolean canUseStudentClassEnrollmentsAsSolution() {
        return false;
    }

    @Override
    public boolean isMakingUpStudents() {
        return false;
    }

    @Override
    public boolean isWeightStudentsToFillUpOffering() {
        return false;
    }

    @Override
    public Double getEnrollmentPriority(Long studentId, Long courseId) {
        if (studentId >= 0L) {
            return this.iStudentCourseRequests.getEnrollmentPriority(studentId, courseId);
        }
        Hashtable<Long, Double> priorities = this.iEnrollmentPriorities.get(studentId);
        return priorities == null ? null : priorities.get(courseId);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Initialization
    implements ParallelInitialization.Task {
        private CurriculumClassification iClassification;
        private Hashtable<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>> iCourseRequests;
        private boolean iUpdateClassification = false;
        private CurModel iModel;
        private Assignment<CurVariable, CurValue> iAssignment;
        private List<StudentCourseDemands.WeightedStudentId> iMadeUpStudents;
        private Hashtable<Long, StudentCourseDemands.WeightedStudentId> iStudentIds;
        private Hashtable<Long, CourseOffering> iCourses;

        public Initialization(CurriculumClassification clasf, Hashtable<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>> courseRequest) {
            this.iClassification = clasf;
            this.iCourseRequests = courseRequest;
        }

        @Override
        public void setup(org.hibernate.Session hibSession) {
            Element cache;
            int n;
            sLog.debug((Object)("Processing " + this.iClassification.getCurriculum().getAbbv() + " " + this.iClassification.getName() + " ... (" + this.iClassification.getNrStudents() + " students, " + this.iClassification.getCourses().size() + " iCourses)"));
            Hashtable students = new Hashtable();
            if (this.iCourseRequests != null) {
                for (Map.Entry<CourseOffering, Set<StudentCourseDemands.WeightedStudentId>> entry : this.iCourseRequests.entrySet()) {
                    for (StudentCourseDemands.WeightedStudentId student : entry.getValue()) {
                        HashSet<CourseOffering> courses = (HashSet<CourseOffering>)students.get(student);
                        if (courses == null) {
                            courses = new HashSet<CourseOffering>();
                            students.put(student, courses);
                        }
                        courses.add(entry.getKey());
                    }
                }
            }
            float totalWeight = 0.0f;
            for (StudentCourseDemands.WeightedStudentId student : students.keySet()) {
                totalWeight += student.getWeight();
            }
            sLog.debug((Object)("  registered students: " + totalWeight + ", target: " + this.iClassification.getNrStudents()));
            int n2 = this.iClassification.getNrStudents();
            this.iMadeUpStudents = new ArrayList<StudentCourseDemands.WeightedStudentId>();
            double w = Math.min((double)(totalWeight / (float)this.iClassification.getNrStudents().intValue()), 1.0);
            float factor = 1.0f;
            if (2.0f * totalWeight < (float)this.iClassification.getNrStudents().intValue()) {
                int studentsToMakeUp = Math.round((float)this.iClassification.getNrStudents().intValue() - totalWeight);
                sLog.debug((Object)("    making up " + studentsToMakeUp + " students"));
                String majors = "";
                for (PosMajor major : this.iClassification.getCurriculum().getMajors()) {
                    if (!majors.isEmpty()) {
                        majors = majors + "|";
                    }
                    majors = majors + major.getCode();
                }
                for (int i = 0; i < studentsToMakeUp; ++i) {
                    StudentCourseDemands.WeightedStudentId student = new StudentCourseDemands.WeightedStudentId(-CurriculaRequestsCourseDemands.this.iLastStudentId.newId());
                    student.setStats(this.iClassification.getCurriculum().getAcademicArea().getAcademicAreaAbbreviation(), this.iClassification.getAcademicClassification().getCode(), majors);
                    student.setCurriculum(this.iClassification.getCurriculum().getAbbv());
                    students.put(student, new HashSet());
                    this.iMadeUpStudents.add(student);
                }
            } else if (totalWeight < (float)this.iClassification.getNrStudents().intValue()) {
                factor = (float)this.iClassification.getNrStudents().intValue() / totalWeight;
                w = 1.0;
                sLog.debug((Object)("    changing student weight " + factor + " times"));
                for (StudentCourseDemands.WeightedStudentId student : students.keySet()) {
                    student.setWeight(student.getWeight() * factor);
                }
            } else if (totalWeight > (float)this.iClassification.getNrStudents().intValue()) {
                sLog.debug((Object)"    more registered students than needed, keeping all");
                n = Math.round(totalWeight);
            }
            ArrayList<CurStudent> curStudents = new ArrayList<CurStudent>();
            this.iStudentIds = new Hashtable();
            int idx = 0;
            for (StudentCourseDemands.WeightedStudentId student : students.keySet()) {
                curStudents.add(new CurStudent(student.getStudentId() < 0L ? (long)(-(++idx)) : student.getStudentId(), student.getWeight()));
                this.iStudentIds.put(student.getStudentId() < 0L ? (long)(-idx) : student.getStudentId(), student);
            }
            this.iModel = new CurModel(curStudents);
            this.iCourses = new Hashtable();
            for (CurriculumCourse course : this.iClassification.getCourses()) {
                HashSet<String> majors;
                Set<StudentCourseDemands.WeightedStudentId> requests = this.iCourseRequests == null ? null : this.iCourseRequests.get(course.getCourse());
                double size = w * (double)factor * (double)(requests == null ? 0 : requests.size()) + (1.0 - w) * (double)n * (double)course.getPercShare().floatValue();
                this.iModel.addCourse(course.getCourse().getUniqueId(), course.getCourse().getCourseName(), size, CurriculaRequestsCourseDemands.this.iEnrollmentPriorityProvider.getEnrollmentPriority(course));
                this.iCourses.put(course.getCourse().getUniqueId(), course.getCourse());
                Hashtable curricula = (Hashtable)CurriculaRequestsCourseDemands.this.iLoadedCurricula.get(course.getCourse().getUniqueId());
                if (curricula == null) {
                    curricula = new Hashtable();
                    CurriculaRequestsCourseDemands.this.iLoadedCurricula.put(course.getCourse().getUniqueId(), curricula);
                }
                if ((majors = (HashSet<String>)curricula.get(this.iClassification.getCurriculum().getAcademicArea().getAcademicAreaAbbreviation() + ":" + this.iClassification.getAcademicClassification().getCode())) == null) {
                    majors = new HashSet<String>();
                    curricula.put(this.iClassification.getCurriculum().getAcademicArea().getAcademicAreaAbbreviation() + ":" + this.iClassification.getAcademicClassification().getCode(), majors);
                }
                if (this.iClassification.getCurriculum().getMajors().isEmpty()) {
                    majors.add("");
                    continue;
                }
                for (PosMajor mj : this.iClassification.getCurriculum().getMajors()) {
                    majors.add(mj.getCode());
                }
            }
            CurriculaRequestsCourseDemands.this.computeTargetShare(this.iClassification, n, factor, w, this.iModel);
            if (CurriculaRequestsCourseDemands.this.iSetStudentCourseLimits) {
                this.iModel.setStudentLimits();
            }
            Solution<CurVariable, CurValue> cachedSolution = null;
            this.iAssignment = new DefaultSingleAssignment();
            Document cachedXml = this.iClassification.getStudentsDocument();
            Element element = cache = cachedXml == null ? null : cachedXml.getRootElement();
            if (cache != null && cache.getName().equals(CurriculaRequestsCourseDemands.this.getCacheName())) {
                cachedSolution = CurModel.loadFromXml(cache);
                if (CurriculaRequestsCourseDemands.this.iSetStudentCourseLimits) {
                    ((CurModel)cachedSolution.getModel()).setStudentLimits();
                }
            }
            if (cachedSolution != null && ((CurModel)cachedSolution.getModel()).isSameModel((Object)this.iModel)) {
                sLog.debug((Object)"  using cached model...");
                this.iModel = (CurModel)cachedSolution.getModel();
                this.iAssignment = cachedSolution.getAssignment();
            } else {
                for (CurStudent student : curStudents) {
                    for (CourseOffering course : (Set)students.get(this.iStudentIds.get(student.getStudentId()))) {
                        CurCourse curCourse = this.iModel.getCourse(course.getUniqueId());
                        if (curCourse == null) continue;
                        CurVariable var = null;
                        for (CurVariable v : curCourse.variables()) {
                            if (this.iAssignment.getValue((Variable)v) != null) continue;
                            var = v;
                            break;
                        }
                        if (var != null) {
                            CurValue val = new CurValue(var, student);
                            if (!this.iModel.inConflict(this.iAssignment, val)) {
                                this.iAssignment.assign(0L, (Value)val);
                                continue;
                            }
                            sLog.debug((Object)("Unable to assign " + (Object)((Object)student) + " to " + (Object)((Object)var)));
                            Map conf = this.iModel.conflictConstraints(this.iAssignment, val);
                            for (Map.Entry entry : conf.entrySet()) {
                                sLog.debug((Object)(entry.getKey() + ": " + entry.getValue()));
                            }
                            continue;
                        }
                        sLog.debug((Object)("No variable for " + (Object)((Object)student) + " to " + (Object)((Object)curCourse)));
                    }
                }
                this.iUpdateClassification = true;
            }
        }

        @Override
        public void execute() {
            if (this.iUpdateClassification) {
                sLog.debug((Object)("Initial: " + this.iModel.getInfo(this.iAssignment)));
                this.iModel.solve(CurriculaRequestsCourseDemands.this.iProperties, this.iAssignment);
                sLog.debug((Object)("Final: " + this.iModel.getInfo(this.iAssignment)));
            }
        }

        @Override
        public void teardown(org.hibernate.Session hibSession) {
            if (this.iUpdateClassification) {
                Document doc = DocumentHelper.createDocument();
                this.iModel.saveAsXml(doc.addElement(CurriculaRequestsCourseDemands.this.getCacheName()), this.iAssignment);
                this.iClassification.setStudentsDocument(doc);
                hibSession.update((Object)this.iClassification);
            }
            int idx = 0;
            for (CurStudent s : this.iModel.getStudents()) {
                StudentCourseDemands.WeightedStudentId student = null;
                student = s.getStudentId() < 0L ? this.iMadeUpStudents.get(idx++) : this.iStudentIds.get(s.getStudentId());
                HashSet<StudentCourseDemands.WeightedCourseOffering> studentCourses = new HashSet<StudentCourseDemands.WeightedCourseOffering>();
                CurriculaRequestsCourseDemands.this.iStudentRequests.put(student.getStudentId(), studentCourses);
                Hashtable<Long, Double> priorities = new Hashtable<Long, Double>();
                CurriculaRequestsCourseDemands.this.iEnrollmentPriorities.put(student.getStudentId(), priorities);
                for (CurCourse course : s.getCourses(this.iAssignment)) {
                    HashSet<StudentCourseDemands.WeightedStudentId> courseStudents;
                    CourseOffering co = this.iCourses.get(course.getCourseId());
                    if (course.getPriority() != null) {
                        priorities.put(co.getUniqueId(), course.getPriority());
                    }
                    if ((courseStudents = (HashSet<StudentCourseDemands.WeightedStudentId>)CurriculaRequestsCourseDemands.this.iDemands.get(co.getUniqueId())) == null) {
                        courseStudents = new HashSet<StudentCourseDemands.WeightedStudentId>();
                        CurriculaRequestsCourseDemands.this.iDemands.put(co.getUniqueId(), courseStudents);
                    }
                    courseStudents.add(student);
                    studentCourses.add(new StudentCourseDemands.WeightedCourseOffering(co, student.getWeight()));
                }
            }
        }
    }
}

