/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.course.ui;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.solver.course.ui.ClassDateInfo;
import org.unitime.timetable.util.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTimeInfo
implements Serializable,
Comparable<ClassTimeInfo> {
    private static final long serialVersionUID = -342155197631035341L;
    private Long iClassId;
    private int iStartSlot;
    private int iPreference;
    private Long iTimePatternId = null;
    private transient TimePattern iTimePattern = null;
    private int iHashCode;
    private int iDayCode;
    private int iLength;
    private int iNrMeetings;
    private int iBreakTime;
    private ClassDateInfo iDate = null;
    private transient Vector<Date> iDates = null;

    public ClassTimeInfo(Long classId, int dayCode, int startTime, int length, int pref, TimePattern timePattern, ClassDateInfo date, int breakTime) {
        this.iClassId = classId;
        this.iPreference = pref;
        this.iStartSlot = startTime;
        this.iDayCode = dayCode;
        this.iLength = length;
        this.iBreakTime = breakTime;
        this.iNrMeetings = 0;
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            if ((this.iDayCode & Constants.DAY_CODES[i]) == 0) continue;
            ++this.iNrMeetings;
        }
        this.iHashCode = ClassTimeInfo.combine(ClassTimeInfo.combine(this.iDayCode, this.iStartSlot), ClassTimeInfo.combine(this.iLength, date.getId().hashCode()));
        this.iDate = date;
        this.iTimePatternId = timePattern.getUniqueId();
        this.iTimePattern = timePattern;
    }

    public ClassTimeInfo(Assignment assignment, int preference, int datePreference) {
        this(assignment.getClassId(), assignment.getDays(), assignment.getStartSlot(), assignment.getSlotPerMtg(), preference, assignment.getTimePattern(), new ClassDateInfo(assignment, datePreference), assignment.getBreakTime());
    }

    public ClassTimeInfo(ClassTimeInfo time, ClassDateInfo date) {
        this.iClassId = time.iClassId;
        this.iPreference = time.getPreference();
        this.iStartSlot = time.getStartSlot();
        this.iDayCode = time.getDayCode();
        this.iLength = time.getLength();
        this.iBreakTime = time.getBreakTime();
        this.iNrMeetings = time.getNrMeetings();
        this.iDate = date;
        this.iTimePatternId = time.getTimePatternId();
        if (time.iTimePattern != null) {
            this.iTimePattern = time.iTimePattern;
        }
        this.iHashCode = ClassTimeInfo.combine(ClassTimeInfo.combine(this.iDayCode, this.iStartSlot), ClassTimeInfo.combine(this.iLength, date.getId().hashCode()));
    }

    public ClassTimeInfo(Assignment assignment) {
        this(assignment, 0, 0);
    }

    public int getNrMeetings() {
        return this.iNrMeetings;
    }

    public int getBreakTime() {
        return this.iBreakTime;
    }

    public int getDayCode() {
        return this.iDayCode;
    }

    public String getDayHeader() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            if ((this.iDayCode & Constants.DAY_CODES[i]) == 0) continue;
            sb.append(Constants.DAY_NAMES_SHORT[i]);
        }
        return sb.toString();
    }

    public String getStartTimeHeader() {
        int min = this.iStartSlot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        int h = min / 60;
        int m = min % 60;
        return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h >= 12 ? "p" : "a");
    }

    public String getEndTimeHeader() {
        int min = (this.iStartSlot + this.iLength) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - this.getBreakTime();
        int m = min % 60;
        int h = min / 60;
        return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h >= 12 ? "p" : "a");
    }

    public String getEndTimeHeaderNoAdj() {
        int min = (this.iStartSlot + this.iLength) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        int m = min % 60;
        int h = min / 60;
        return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h >= 12 ? "p" : "a");
    }

    public int getStartSlot() {
        return this.iStartSlot;
    }

    public boolean shareDays(ClassTimeInfo anotherLocation) {
        return (this.iDayCode & anotherLocation.iDayCode) != 0;
    }

    public boolean shareHours(ClassTimeInfo anotherLocation) {
        return this.iStartSlot + this.iLength > anotherLocation.iStartSlot && anotherLocation.iStartSlot + anotherLocation.iLength > this.iStartSlot;
    }

    public boolean shareWeeks(ClassTimeInfo anotherLocation) {
        return this.getDate().getPattern().intersects(anotherLocation.getDate().getPattern());
    }

    public boolean overlaps(ClassTimeInfo anotherLocation) {
        return this.shareDays(anotherLocation) && this.shareHours(anotherLocation) && this.shareWeeks(anotherLocation);
    }

    public String getName() {
        return this.getDayHeader() + " " + this.getStartTimeHeader();
    }

    public String getLongName() {
        return this.getDayHeader() + " " + this.getStartTimeHeader() + " - " + this.getEndTimeHeader() + " " + this.getDatePatternName();
    }

    public String getLongNameNoAdj() {
        return this.getDayHeader() + " " + this.getStartTimeHeader() + " - " + this.getEndTimeHeaderNoAdj() + " " + this.getDatePatternName();
    }

    public String getNameHtml() {
        return "<span onmouseover=\"showGwtTimeHint(this, '" + this.iClassId + "," + this.iDayCode + "," + this.iStartSlot + "');\" onmouseout=\"hideGwtTimeHint();\"" + " style='color:" + PreferenceLevel.int2color(this.getPreference()) + ";'>" + this.getName() + "</span>";
    }

    public String getLongNameHtml() {
        return "<span onmouseover=\"showGwtTimeHint(this, '" + this.iClassId + "," + this.iDayCode + "," + this.iStartSlot + "');\" onmouseout=\"hideGwtTimeHint();\"" + " style='color:" + PreferenceLevel.int2color(this.getPreference()) + ";'>" + this.getDayHeader() + " " + this.getStartTimeHeader() + " - " + this.getEndTimeHeader() + "</span>";
    }

    public int getPreference() {
        return this.iPreference;
    }

    public int getLength() {
        return this.iLength;
    }

    public int getNrSlotsPerMeeting() {
        return this.iLength;
    }

    public Long getTimePatternId() {
        return this.iTimePatternId;
    }

    public TimePattern getTimePattern() {
        if (this.iTimePattern == null) {
            this.iTimePattern = (TimePattern)TimePatternDAO.getInstance().get(this.iTimePatternId);
        }
        return this.iTimePattern;
    }

    public TimePattern getTimePattern(Session hibSession) {
        return (TimePattern)TimePatternDAO.getInstance().get(this.iTimePatternId, hibSession);
    }

    public ClassDateInfo getDate() {
        return this.iDate;
    }

    public Long getDatePatternId() {
        return this.getDate().getId();
    }

    public DatePattern getDatePattern() {
        return this.getDate().getDatePattern();
    }

    public String getDatePatternName() {
        return this.getDate().getName();
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.iHashCode;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ClassTimeInfo)) {
            return false;
        }
        ClassTimeInfo t = (ClassTimeInfo)o;
        if (this.getStartSlot() != t.getStartSlot()) {
            return false;
        }
        if (this.getLength() != t.getLength()) {
            return false;
        }
        if (this.getDayCode() != t.getDayCode()) {
            return false;
        }
        return ToolBox.equals((Object)this.getTimePatternId(), (Object)t.getTimePatternId()) && ToolBox.equals((Object)this.getDatePatternId(), (Object)t.getDatePatternId());
    }

    @Override
    public int compareTo(ClassTimeInfo time) {
        int cmp = this.getDate().compareTo(time.getDate());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getTimePattern().compareTo(time.getTimePattern());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getDayCode() - time.getDayCode();
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getStartSlot() - time.getStartSlot();
        if (cmp != 0) {
            return cmp;
        }
        return this.hashCode() - time.hashCode();
    }

    private static int combine(int a, int b) {
        int ret = 0;
        for (int i = 0; i < 15; ++i) {
            ret = ret | (a & 1 << i) << i | (b & 1 << i) << i + 1;
        }
        return ret;
    }

    public String getId() {
        return this.getDatePatternId() + ":" + this.getTimePatternId() + ":" + this.getDayCode() + ":" + this.getStartSlot();
    }

    public Vector<Date> getDates() {
        if (this.iDates == null) {
            this.iDates = new Vector();
            Calendar cal = Calendar.getInstance(Locale.US);
            cal.setTime(this.getDatePattern().getStartDate());
            cal.setLenient(true);
            for (int idx = 0; idx < this.getDatePattern().getPattern().length(); ++idx) {
                if (this.getDatePattern().getPattern().charAt(idx) == '1') {
                    boolean offered = false;
                    switch (cal.get(7)) {
                        case 2: {
                            offered = (this.getDayCode() & Constants.DAY_CODES[0]) != 0;
                            break;
                        }
                        case 3: {
                            offered = (this.getDayCode() & Constants.DAY_CODES[1]) != 0;
                            break;
                        }
                        case 4: {
                            offered = (this.getDayCode() & Constants.DAY_CODES[2]) != 0;
                            break;
                        }
                        case 5: {
                            offered = (this.getDayCode() & Constants.DAY_CODES[3]) != 0;
                            break;
                        }
                        case 6: {
                            offered = (this.getDayCode() & Constants.DAY_CODES[4]) != 0;
                            break;
                        }
                        case 7: {
                            offered = (this.getDayCode() & Constants.DAY_CODES[5]) != 0;
                            break;
                        }
                        case 1: {
                            boolean bl = offered = (this.getDayCode() & Constants.DAY_CODES[6]) != 0;
                        }
                    }
                    if (offered) {
                        this.iDates.add(cal.getTime());
                    }
                }
                cal.add(6, 1);
            }
        }
        return this.iDates;
    }

    public RoomAvailabilityInterface.TimeBlock overlaps(Collection<RoomAvailabilityInterface.TimeBlock> times) {
        if (times == null || times.isEmpty()) {
            return null;
        }
        int breakTimeStart = ApplicationProperty.RoomAvailabilityClassBreakTimeStart.intValue();
        int breakTimeStop = ApplicationProperty.RoomAvailabilityClassBreakTimeStop.intValue();
        for (Date date : this.getDates()) {
            DummyTimeBlock dummy = new DummyTimeBlock(date, breakTimeStart, breakTimeStop);
            for (RoomAvailabilityInterface.TimeBlock time : times) {
                if (!dummy.overlaps(time)) continue;
                return time;
            }
        }
        return null;
    }

    public class DummyTimeBlock
    implements RoomAvailabilityInterface.TimeBlock {
        private static final long serialVersionUID = -3806087343289917036L;
        private Date iD1;
        private Date iD2;

        private DummyTimeBlock(Date d, int breakTimeStart, int breakTimeStop) {
            Calendar c = Calendar.getInstance(Locale.US);
            c.setTime(d);
            int min = ClassTimeInfo.this.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - breakTimeStart;
            c.set(10, min / 60);
            c.set(12, min % 60);
            this.iD1 = c.getTime();
            min = (ClassTimeInfo.this.getStartSlot() + ClassTimeInfo.this.getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN + breakTimeStop;
            c.setTime(d);
            c.set(10, min / 60);
            c.set(12, min % 60);
            this.iD2 = c.getTime();
        }

        public String getEventName() {
            return "Dummy event";
        }

        public String getEventType() {
            return RoomAvailabilityInterface.sClassType;
        }

        public Date getStartTime() {
            return this.iD1;
        }

        public Date getEndTime() {
            return this.iD2;
        }

        public boolean overlaps(RoomAvailabilityInterface.TimeBlock block) {
            return block.getStartTime().compareTo(this.iD2) < 0 && this.iD1.compareTo(block.getEndTime()) < 0;
        }

        public String toString() {
            return this.iD1 + " - " + this.iD2;
        }
    }
}

