/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.course.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.preference.MinMaxPreferenceCombination;
import org.cpsolver.coursett.preference.PreferenceCombination;
import org.cpsolver.coursett.preference.SumPreferenceCombination;
import org.hibernate.LazyInitializationException;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.ClassInfoForm;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.ExactTimeMins;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.RoomSharingModel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.course.ui.ClassAssignment;
import org.unitime.timetable.solver.course.ui.ClassAssignmentInfo;
import org.unitime.timetable.solver.course.ui.ClassDateInfo;
import org.unitime.timetable.solver.course.ui.ClassInfo;
import org.unitime.timetable.solver.course.ui.ClassInstructorInfo;
import org.unitime.timetable.solver.course.ui.ClassProposedChange;
import org.unitime.timetable.solver.course.ui.ClassRoomInfo;
import org.unitime.timetable.solver.course.ui.ClassTimeInfo;
import org.unitime.timetable.util.DefaultRoomAvailabilityService;
import org.unitime.timetable.util.RoomAvailability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfoModel
implements Serializable {
    private static final long serialVersionUID = 1373805772613891251L;
    private static Log sLog = LogFactory.getLog(ClassInfoModel.class);
    private ClassInfo iClass = null;
    private ClassInfoForm iForm = null;
    private ClassProposedChange iChange = null;
    private Collection<ClassAssignment> iDates = null;
    private Collection<ClassAssignment> iTimes = null;
    private Vector<ClassRoomInfo> iRooms = null;
    private boolean iShowStudentConflicts = ApplicationProperty.ClassAssignmentShowStudentConflicts.isTrue();
    private boolean iUnassignConflictingAssignments = false;
    private transient SessionContext iContext = null;
    Hashtable<Long, Hashtable> iRoomPreferences = new Hashtable();

    public void clear(String userId) {
        this.iClass = null;
        this.iChange = null;
        this.iRooms = null;
        this.iDates = null;
        this.iTimes = null;
        this.iUnassignConflictingAssignments = false;
    }

    public ClassInfo getClazz() {
        return this.iClass;
    }

    public ClassAssignmentInfo getClassOldAssignment() {
        if (this.iClass instanceof ClassAssignmentInfo) {
            return (ClassAssignmentInfo)this.iClass;
        }
        return null;
    }

    public ClassAssignmentInfo getClassAssignment() {
        if (this.iChange != null && this.iChange.getConflict(this.iClass) != null) {
            return null;
        }
        if (this.iClass instanceof ClassAssignmentInfo) {
            return (ClassAssignmentInfo)this.iClass;
        }
        return null;
    }

    public boolean isClassAssigned() {
        return this.getClassAssignment() != null && this.getClassAssignment().getTime() != null;
    }

    public ClassDateInfo getAssignedDate() {
        try {
            ClassAssignmentInfo info = this.getSelectedAssignment();
            if (info != null && info.hasDate()) {
                return info.getDate();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        DatePattern dp = this.getClazz().getClazz().effectiveDatePattern();
        if (dp == null) {
            return null;
        }
        if (dp.getType() != 1) {
            return new ClassDateInfo(dp.getUniqueId(), this.getClazz().getClassId(), dp.getName(), dp.getPatternBitSet(), PreferenceLevel.sIntLevelNeutral);
        }
        return null;
    }

    public void update() throws Exception {
        if (this.iChange == null) {
            return;
        }
        Vector<ClassAssignmentInfo> assignments = new Vector<ClassAssignmentInfo>(this.iChange.getAssignments());
        Hashtable<Long, ClassAssignment> table = this.iChange.getAssignmentTable();
        this.iUnassignConflictingAssignments = !this.iForm.getKeepConflictingAssignments();
        this.iChange.getAssignments().clear();
        for (ClassAssignment classAssignment : assignments) {
            this.iChange.getAssignments().add(new ClassAssignmentInfo(classAssignment.getClazz(), classAssignment.getTime(), classAssignment.getDate(), classAssignment.getRooms(), table));
        }
        if (assignments.isEmpty()) {
            Iterator<ClassAssignment> i = this.iChange.getConflicts().iterator();
            while (i.hasNext()) {
                ClassAssignment classAssignment = i.next();
                if (classAssignment.getClassId().equals(this.getClazz().getClassId())) continue;
                i.remove();
            }
        } else {
            this.iChange.getConflicts().clear();
        }
        for (ClassAssignment classAssignment : this.iChange.getAssignments()) {
            Assignment a;
            if (!classAssignment.hasTime()) continue;
            if (this.iUnassignConflictingAssignments) {
                if (classAssignment.getRooms() != null) {
                    for (ClassRoomInfo room : classAssignment.getRooms()) {
                        if (room.isIgnoreRoomChecks()) continue;
                        for (Assignment a2 : room.getLocation().getCommitedAssignments()) {
                            if (!classAssignment.getTime().overlaps(new ClassTimeInfo(a2)) || this.iChange.getCurrent(a2.getClassId()) != null || this.iChange.getConflict(a2.getClassId()) != null) continue;
                            this.iChange.getConflicts().add(new ClassAssignment(a2));
                        }
                    }
                }
                if (classAssignment.getInstructors() != null) {
                    for (ClassInstructorInfo instructor : classAssignment.getInstructors()) {
                        if (!instructor.isLead()) continue;
                        for (DepartmentalInstructor di : DepartmentalInstructor.getAllForInstructor(instructor.getInstructor().getInstructor())) {
                            for (ClassInstructor ci : di.getClasses()) {
                                if (ci.equals(instructor.getInstructor()) || (a = ci.getClassInstructing().getCommittedAssignment()) == null || classAssignment.getTime() == null || !classAssignment.getTime().overlaps(new ClassTimeInfo(a)) || this.iChange.getCurrent(a.getClassId()) != null || this.iChange.getConflict(a.getClassId()) != null) continue;
                                this.iChange.getConflicts().add(new ClassAssignment(a));
                            }
                        }
                    }
                }
            }
            Class_ clazz = classAssignment.getClazz(Class_DAO.getInstance().getSession());
            for (Class_ parent = clazz.getParentClass(); parent != null; parent = parent.getParentClass()) {
                Assignment a3;
                if (this.iChange.getCurrent(parent.getUniqueId()) != null || this.iChange.getConflict(parent.getUniqueId()) != null || (a3 = parent.getCommittedAssignment()) == null || !classAssignment.getTime().overlaps(new ClassTimeInfo(a3))) continue;
                this.iChange.getConflicts().add(new ClassAssignment(a3));
            }
            LinkedList<Class_> children = new LinkedList<Class_>();
            try {
                children.addAll(clazz.getChildClasses());
            }
            catch (LazyInitializationException e) {
                sLog.error((Object)"This should never happen.");
                Class_ c = (Class_)Class_DAO.getInstance().get(classAssignment.getClassId());
                children.addAll(c.getChildClasses());
            }
            Class_ child = null;
            while ((child = (Class_)children.poll()) != null) {
                Assignment a4;
                if (this.iChange.getCurrent(child.getUniqueId()) == null && this.iChange.getConflict(child.getUniqueId()) == null && (a4 = child.getCommittedAssignment()) != null && classAssignment.getTime().overlaps(new ClassTimeInfo(a4))) {
                    this.iChange.getConflicts().add(new ClassAssignment(a4));
                }
                if (child.getChildClasses().isEmpty()) continue;
                children.addAll(child.getChildClasses());
            }
            for (SchedulingSubpart ss : clazz.getSchedulingSubpart().getInstrOfferingConfig().getSchedulingSubparts()) {
                if (ss.getClasses().size() != 1) continue;
                child = ss.getClasses().iterator().next();
                if (this.iChange.getCurrent(child.getUniqueId()) == null && this.iChange.getConflict(child.getUniqueId()) == null && (a = child.getCommittedAssignment()) != null && classAssignment.getTime().overlaps(new ClassTimeInfo(a))) {
                    this.iChange.getConflicts().add(new ClassAssignment(a));
                }
                if (child.getChildClasses().isEmpty()) continue;
                children.addAll(child.getChildClasses());
            }
        }
    }

    public String assign(SessionContext context) {
        List<Long> classIds;
        Object m;
        Class_ clazz;
        if (this.iChange == null) {
            return "Nothing to assign.";
        }
        if (ApplicationProperty.ClassAssignmentAllowUnassignments.isFalse() && !this.iChange.getConflicts().isEmpty()) {
            return "It is not allowed to keep a class unassigned.";
        }
        sLog.info((Object)("About to be assigned: " + this.iChange));
        org.hibernate.Session hibSession = Class_DAO.getInstance().getSession();
        String message = null;
        Hashtable touchedOfferingIds = new Hashtable();
        for (ClassAssignment classAssignment : this.iChange.getConflicts()) {
            try {
                Long offeringId2;
                clazz = classAssignment.getClazz(hibSession);
                m = clazz.unassignCommited(context.getUser(), hibSession);
                if (m != null) {
                    message = (message == null ? "" : message + "\n") + (String)m;
                }
                if ((classIds = (ArrayList<Long>)touchedOfferingIds.get(offeringId2 = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId())) == null) {
                    classIds = new ArrayList<Long>();
                    touchedOfferingIds.put(offeringId2, classIds);
                }
                classIds.add(clazz.getUniqueId());
            }
            catch (Exception e) {
                message = (message == null ? "" : message + "\n") + "Unassignment of " + classAssignment.getClassName() + " failed, reason: " + e.getMessage();
            }
        }
        for (ClassAssignment classAssignment : this.iChange.getAssignments()) {
            try {
                Long offeringId;
                clazz = classAssignment.getClazz(hibSession);
                m = clazz.assignCommited(this.getAssignmentInfo(classAssignment), context.getUser(), hibSession);
                if (m != null) {
                    message = (message == null ? "" : message + "\n") + (String)m;
                }
                if ((classIds = (List)touchedOfferingIds.get(offeringId = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getUniqueId())) == null) {
                    classIds = new ArrayList();
                    touchedOfferingIds.put(offeringId, classIds);
                }
                classIds.add(clazz.getUniqueId());
            }
            catch (Exception e) {
                message = (message == null ? "" : message + "\n") + "Assignment of " + classAssignment.getClassName() + " to " + classAssignment.getTime().getName() + " " + classAssignment.getRoomNames(", ") + " failed, reason: " + e.getMessage();
            }
        }
        Long sessionId = context.getUser().getCurrentAcademicSessionId();
        Session session = (Session)SessionDAO.getInstance().get(sessionId, hibSession);
        if (!session.getStatusType().isTestSession()) {
            if (session.getStatusType().canOnlineSectionStudents()) {
                ArrayList<Long> unlockedOfferings = new ArrayList<Long>();
                for (Long offeringId : touchedOfferingIds.keySet()) {
                    if (session.isOfferingLocked(offeringId)) continue;
                    unlockedOfferings.add(offeringId);
                }
                if (!unlockedOfferings.isEmpty()) {
                    StudentSectioningQueue.offeringChanged(hibSession, context.getUser(), sessionId, unlockedOfferings);
                }
            } else if (session.getStatusType().canSectionAssistStudents()) {
                for (Map.Entry entry : touchedOfferingIds.entrySet()) {
                    if (session.isOfferingLocked((Long)entry.getKey())) continue;
                    StudentSectioningQueue.classAssignmentChanged(hibSession, context.getUser(), sessionId, (Collection)entry.getValue());
                }
            }
        }
        hibSession.flush();
        return message;
    }

    public boolean getCanAssign() {
        if (this.iChange == null) {
            return false;
        }
        for (ClassAssignment classAssignment : this.iChange.getAssignments()) {
            if (!classAssignment.isValid()) {
                return false;
            }
            if (this.getSessionContext().hasPermission(classAssignment.getClazz(), Right.ClassAssignment)) continue;
            return false;
        }
        for (ClassAssignment classAssignment : this.iChange.getConflicts()) {
            if (this.getSessionContext().hasPermission(classAssignment.getClazz(), Right.ClassAssignment)) continue;
            return false;
        }
        return !ApplicationProperty.ClassAssignmentAllowUnassignments.isFalse() || this.iChange.getConflicts().isEmpty();
    }

    public String getAssignConfirm() {
        return "The selected assignment will be done directly in the database. Are you sure?";
    }

    public void setForm(ClassInfoForm form) {
        this.iForm = form;
    }

    public void setClazz(Class_ clazz) {
        this.iDates = null;
        this.iTimes = null;
        this.iRooms = null;
        this.iClass = clazz.getCommittedAssignment() != null ? new ClassAssignmentInfo(clazz.getCommittedAssignment()) : new ClassInfo(clazz);
        if (this.iChange != null) {
            this.iChange.setSelected(clazz.getUniqueId());
        }
        if (clazz.getNbrRooms() > 0) {
            this.iForm.setMinRoomSize(String.valueOf(clazz.getMinRoomLimit()));
            this.iForm.setMaxRoomSize(null);
        }
        this.iForm.setRoomFilter(null);
    }

    public ClassAssignmentInfo getAssignmentInfo(ClassAssignment assignment) throws Exception {
        if (assignment instanceof ClassAssignmentInfo) {
            return (ClassAssignmentInfo)assignment;
        }
        if (this.iChange != null) {
            return new ClassAssignmentInfo(assignment.getClazz(), assignment.getTime(), assignment.getDate(), assignment.getRooms(), this.iChange.getAssignmentTable());
        }
        return new ClassAssignmentInfo(assignment.getClazz(), assignment.getTime(), assignment.getDate(), assignment.getRooms());
    }

    public ClassAssignmentInfo getSelectedAssignment() throws Exception {
        if (this.iChange == null) {
            return null;
        }
        for (ClassAssignment classAssignment : this.iChange.getAssignments()) {
            if (!classAssignment.getClassId().equals(this.iClass.getClassId())) continue;
            return this.getAssignmentInfo(classAssignment);
        }
        return null;
    }

    public void setDate(String dateId) throws Exception {
        this.iRooms = null;
        this.iTimes = null;
        if (this.iChange == null) {
            this.iChange = new ClassProposedChange();
        }
        ClassTimeInfo time = this.getSelectedAssignment() == null ? null : this.getSelectedAssignment().getTime();
        Collection<ClassRoomInfo> rooms = this.getSelectedAssignment() == null ? null : this.getSelectedAssignment().getRooms();
        for (ClassAssignment date : this.getDates()) {
            if (!dateId.equals(date.getDateId())) continue;
            this.iChange.addChange(new ClassAssignmentInfo(this.getClazz().getClazz(), time == null ? null : new ClassTimeInfo(time, date.getDate()), date.getDate(), rooms, this.iChange.getAssignmentTable()), this.getClassOldAssignment());
        }
        if (this.iChange.isEmpty()) {
            this.iChange = null;
        }
        this.update();
    }

    public void setTime(String timeId) throws Exception {
        this.iRooms = null;
        if (this.iChange == null) {
            this.iChange = new ClassProposedChange();
        }
        for (ClassAssignment time : this.getAllTimes()) {
            if (!timeId.equals(time.getTimeId())) continue;
            this.iChange.addChange(new ClassAssignmentInfo(this.getClazz().getClazz(), time.getTime(), time.getDate(), null, this.iChange.getAssignmentTable()), this.getClassOldAssignment());
        }
        if ("-1".equals(timeId)) {
            this.iChange.addChange(new ClassAssignmentInfo(this.getClazz().getClazz(), null, null, null, this.iChange.getAssignmentTable()), this.getClassOldAssignment());
        }
        if (this.iChange.isEmpty()) {
            this.iChange = null;
        }
        this.update();
    }

    public void delete(long classId) throws Exception {
        if (this.iChange == null) {
            return;
        }
        Iterator<ClassAssignmentInfo> i = this.iChange.getAssignments().iterator();
        while (i.hasNext()) {
            ClassAssignmentInfo x = i.next();
            if (!x.getClassId().equals(classId)) continue;
            i.remove();
        }
        this.update();
    }

    public void setRooms(String rooms) throws Exception {
        ClassAssignment assignment;
        if (this.iChange == null) {
            this.iChange = new ClassProposedChange();
        }
        if ((assignment = this.iChange.getCurrent(this.iClass)) == null && this.isClassAssigned()) {
            for (ClassAssignment time : this.getAllTimes()) {
                if (!this.getClassOldAssignment().getTimeId().equals(time.getTimeId())) continue;
                assignment = time;
                break;
            }
        }
        if (assignment == null) {
            return;
        }
        TreeSet<ClassRoomInfo> assignedRooms = new TreeSet<ClassRoomInfo>();
        StringTokenizer stk = new StringTokenizer(rooms, ":");
        while (stk.hasMoreTokens()) {
            String token = stk.nextToken();
            if (token.trim().length() == 0) continue;
            Long roomId = Long.valueOf(token.substring(0, token.indexOf(64)));
            ClassRoomInfo room = null;
            for (ClassRoomInfo r : this.getRooms()) {
                if (!r.getLocationId().equals(roomId)) continue;
                room = r;
                break;
            }
            if (room == null) continue;
            assignedRooms.add(room);
        }
        this.iChange.addChange(new ClassAssignmentInfo(this.getClazz().getClazz(), assignment.getTime(), assignment.getDate(), assignedRooms, this.iChange.getAssignmentTable()), this.getClassOldAssignment());
        if (this.iChange.isEmpty()) {
            this.iChange = null;
        }
        this.update();
    }

    public void apply(HttpServletRequest request, ClassInfoForm form) {
        this.iForm = form;
    }

    public void refreshRooms() {
        this.iRooms = null;
    }

    public String getDatesTable() {
        try {
            ClassAssignmentInfo classAssignment;
            String ret = "";
            ret = ret + "<script language='javascript'>";
            ret = ret + "function dateOver(source, id) { ";
            ret = ret + "    document.getElementById('d'+id).style.backgroundColor='rgb(223,231,242)';";
            if (this.iShowStudentConflicts) {
                ret = ret + "    document.getElementById('dc'+id).style.backgroundColor='rgb(223,231,242)';";
            }
            ret = ret + "    source.style.cursor='hand';source.style.cursor='pointer';";
            ret = ret + "}";
            ret = ret + "function dateOut(id) { ";
            ret = ret + "    var bg = 'transparent';";
            ClassAssignmentInfo classAssignmentInfo = classAssignment = this.iChange == null ? null : this.iChange.getCurrent(this.iClass);
            if (classAssignment != null && classAssignment.hasDate()) {
                ret = ret + "    if (id=='" + classAssignment.getDateId() + "') bg='rgb(168,187,225)';";
            }
            ret = ret + "    document.getElementById('d'+id).style.backgroundColor=bg;";
            if (this.iShowStudentConflicts) {
                ret = ret + "    document.getElementById('dc'+id).style.backgroundColor=bg;";
            }
            ret = ret + "}";
            ret = ret + "function dateClick(source, id) { ";
            ret = ret + "    displayLoading();";
            ret = ret + "    document.location='classInfo.do?op=Select&date='+id+'&noCacheTS=" + new Date().getTime() + "';";
            ret = ret + "}";
            ret = ret + "</script>";
            ret = ret + "<table border='0' cellspacing='0' cellpadding='3'>";
            int idx = 0;
            int step = 5;
            for (ClassAssignment date : this.getDates()) {
                boolean initial;
                boolean bl = initial = this.getClassOldAssignment() != null && this.getClassOldAssignment().getDateId() != null && this.getClassOldAssignment().getDateId().equals(date.getDateId());
                if (idx % step == 0) {
                    if (idx > 0) {
                        ret = ret + "</tr>";
                    }
                    ret = ret + "<tr>";
                }
                String style = "";
                if (classAssignment != null && date.getDateId().equals(classAssignment.getDateId())) {
                    style = style + "background-color:rgb(168,187,225);";
                }
                if (initial) {
                    style = style + "text-decoration:underline;";
                }
                String mouse = "onMouseOver=\"dateOver(this,'" + date.getDateId() + "');\" " + "onMouseOut=\"dateOut('" + date.getDateId() + "');\" " + "onClick=\"dateClick(this,'" + date.getDateId() + "');\"";
                if (this.iShowStudentConflicts) {
                    ret = ret + "<td nowrap id='d" + date.getDateId() + "' " + (style.length() > 0 ? "style='" + style + "' " : "") + mouse + ">" + date.getDateNameHtml() + "</td>";
                    if (idx % step < step - 1) {
                        style = style + "border-right: #646464 1px dashed;";
                    }
                    ret = ret + "<td id='dc" + date.getDateId() + "' " + (style.length() > 0 ? "style='" + style + "' " : "") + mouse + ">" + (date instanceof ClassAssignmentInfo ? String.valueOf(((ClassAssignmentInfo)date).getNrStudentCounflicts()) : "") + "</td>";
                } else {
                    if (idx % step < step - 1) {
                        style = style + "border-right: #646464 1px dashed;";
                    }
                    ret = ret + "<td nowrap id='d" + date.getDateId() + "' " + (style.length() > 0 ? "style='" + style + "' " : "") + mouse + ">" + date.getDateNameHtml() + "</td>";
                }
                ++idx;
            }
            while (idx % step != 0) {
                ret = this.iShowStudentConflicts ? ret + "<td colspan='2'>&nbsp;</td>" : ret + "<td>&nbsp;</td>";
                ++idx;
            }
            ret = ret + "</tr>";
            ret = ret + "</table>";
            return ret;
        }
        catch (Exception e) {
            this.iForm.setMessage(e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public String getTimesTable() {
        try {
            ClassAssignmentInfo classAssignment;
            String ret = "";
            ret = ret + "<script language='javascript'>";
            ret = ret + "function timeOver(source, id) { ";
            ret = ret + "    document.getElementById('t'+id).style.backgroundColor='rgb(223,231,242)';";
            if (this.iShowStudentConflicts) {
                ret = ret + "    document.getElementById('c'+id).style.backgroundColor='rgb(223,231,242)';";
            }
            ret = ret + "    source.style.cursor='hand';source.style.cursor='pointer';";
            ret = ret + "}";
            ret = ret + "function timeOut(id) { ";
            ret = ret + "    var bg = 'transparent';";
            ClassAssignmentInfo classAssignmentInfo = classAssignment = this.iChange == null ? null : this.iChange.getCurrent(this.iClass);
            if (classAssignment != null && classAssignment.hasTime()) {
                ret = ret + "    if (id=='" + classAssignment.getTimeId() + "') bg='rgb(168,187,225)';";
            }
            ret = ret + "    document.getElementById('t'+id).style.backgroundColor=bg;";
            if (this.iShowStudentConflicts) {
                ret = ret + "    document.getElementById('c'+id).style.backgroundColor=bg;";
            }
            ret = ret + "}";
            ret = ret + "function timeClick(source, id) { ";
            ret = ret + "    displayLoading();";
            ret = ret + "    document.location='classInfo.do?op=Select&time='+id+'&noCacheTS=" + new Date().getTime() + "';";
            ret = ret + "}";
            ret = ret + "</script>";
            ret = ret + "<table border='0' cellspacing='0' cellpadding='3'>";
            int idx = 0;
            int step = 5;
            for (ClassAssignment time : this.getTimes()) {
                boolean initial;
                boolean bl = initial = this.getClassOldAssignment() != null && this.getClassOldAssignment().getTimeId() != null && this.getClassOldAssignment().getTimeId().equals(time.getTimeId());
                if (idx % step == 0) {
                    if (idx > 0) {
                        ret = ret + "</tr>";
                    }
                    ret = ret + "<tr>";
                }
                String style = "";
                if (classAssignment != null && time.getTimeId().equals(classAssignment.getTimeId())) {
                    style = style + "background-color:rgb(168,187,225);";
                }
                if (initial) {
                    style = style + "text-decoration:underline;";
                }
                String mouse = "onMouseOver=\"timeOver(this,'" + time.getTimeId() + "');\" " + "onMouseOut=\"timeOut('" + time.getTimeId() + "');\" " + "onClick=\"timeClick(this,'" + time.getTimeId() + "');\"";
                if (this.iShowStudentConflicts) {
                    ret = ret + "<td nowrap id='t" + time.getTimeId() + "' " + (style.length() > 0 ? "style='" + style + "' " : "") + mouse + ">" + time.getTime().getLongNameHtml() + "</td>";
                    if (idx % step < step - 1) {
                        style = style + "border-right: #646464 1px dashed;";
                    }
                    ret = ret + "<td id='c" + time.getTimeId() + "' " + (style.length() > 0 ? "style='" + style + "' " : "") + mouse + ">" + ((ClassAssignmentInfo)time).getNrStudentCounflicts() + "</td>";
                } else {
                    if (idx % step < step - 1) {
                        style = style + "border-right: #646464 1px dashed;";
                    }
                    ret = ret + "<td nowrap id='t" + time.getTimeId() + "' " + (style.length() > 0 ? "style='" + style + "' " : "") + mouse + ">" + time.getTime().getLongNameHtml() + "</td>";
                }
                ++idx;
            }
            if (classAssignment != null) {
                if (idx % step == 0) {
                    if (idx > 0) {
                        ret = ret + "</tr>";
                    }
                    ret = ret + "<tr>";
                }
                String style = "font-style:italic; color:#c81e14;";
                String mouse = "onMouseOver=\"timeOver(this,'-1');\" onMouseOut=\"timeOut('-1');\" onClick=\"timeClick(this,'-1');\"";
                if (this.iShowStudentConflicts) {
                    ret = ret + "<td nowrap id='t-1' " + (style.length() > 0 ? "style='" + style + "' " : "") + mouse + ">not-assigned</td>";
                    if (idx % step < step - 1) {
                        style = style + "border-right: #646464 1px dashed;";
                    }
                    ret = ret + "<td id='c-1' " + (style.length() > 0 ? "style='" + style + "' " : "") + mouse + "></td>";
                } else {
                    if (idx % step < step - 1) {
                        style = style + "border-right: #646464 1px dashed;";
                    }
                    ret = ret + "<td nowrap id='t-1' " + (style.length() > 0 ? "style='" + style + "' " : "") + mouse + ">not-assigned</td>";
                }
                ++idx;
            }
            while (idx % step != 0) {
                ret = this.iShowStudentConflicts ? ret + "<td colspan='2'>&nbsp;</td>" : ret + "<td>&nbsp;</td>";
                ++idx;
            }
            ret = ret + "</tr>";
            ret = ret + "</table>";
            return ret;
        }
        catch (Exception e) {
            this.iForm.setMessage(e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public TreeSet<ClassAssignmentInfo.StudentConflict> getStudentConflicts() {
        TreeSet<ClassAssignmentInfo.StudentConflict> ret = new TreeSet<ClassAssignmentInfo.StudentConflict>();
        if (this.iChange != null) {
            HashSet<String> ids = new HashSet<String>();
            for (ClassAssignmentInfo assignment : this.iChange.getAssignments()) {
                for (ClassAssignmentInfo.StudentConflict conf : assignment.getStudentConflicts()) {
                    String id = assignment.getClassId().compareTo(conf.getOtherClass().getClassId()) < 0 ? assignment.getClassId() + ":" + conf.getOtherClass().getClassId() : conf.getOtherClass().getClassId() + ":" + assignment.getClassId();
                    if (!ids.add(id)) continue;
                    ret.add(conf);
                }
            }
        } else if (this.getClassAssignment() != null) {
            ret.addAll(this.getClassAssignment().getStudentConflicts());
        }
        return ret;
    }

    public String getStudentConflictTable() {
        String ret = "<table border='0' width='100%' cellspacing='0' cellpadding='3'>";
        ret = ret + "<tr>";
        ret = ret + "<td><i>Students</i></td>";
        ret = ret + "<td><i>Class</i></td>";
        ret = ret + "<td><i>Date</i></td>";
        ret = ret + "<td><i>Time</i></td>";
        ret = ret + "<td><i>Room</i></td>";
        ret = ret + "</tr>";
        boolean empty = true;
        for (ClassAssignmentInfo.StudentConflict conf : this.getStudentConflicts()) {
            ret = ret + conf.toHtml2();
            empty = false;
        }
        if (empty) {
            ret = ret + "<tr><td colspan='5'><i>There are no student conflicts.</i></td></tr>";
        }
        ret = ret + "</table>";
        return ret;
    }

    public boolean getShowDates() {
        return this.getDates().size() > 1;
    }

    public Collection<ClassAssignment> getDates() {
        if (this.iDates == null) {
            ClassTimeInfo time;
            this.iDates = new Vector<ClassAssignment>();
            Class_ clazz = this.getClazz().getClazz();
            DatePattern datePattern = clazz.effectiveDatePattern();
            if (datePattern == null) {
                this.iForm.setMessage("Class " + this.getClazz().getClassName() + " has no date pattern selected.");
                return this.iTimes;
            }
            ClassTimeInfo classTimeInfo = time = this.getClassAssignment() == null ? null : this.getClassAssignment().getTime();
            if (datePattern.getType() == 4) {
                Set datePatternPrefs = clazz.effectivePreferences(DatePatternPref.class);
                boolean hasReq = false;
                for (DatePatternPref p : datePatternPrefs) {
                    if (!PreferenceLevel.sRequired.equals(p.getPrefLevel().getPrefProlog())) continue;
                    hasReq = true;
                    break;
                }
                for (DatePattern child : datePattern.findChildren()) {
                    String pr = PreferenceLevel.sNeutral;
                    for (DatePatternPref p : datePatternPrefs) {
                        if (!p.getDatePattern().equals(child)) continue;
                        pr = p.getPrefLevel().getPrefProlog();
                    }
                    int prVal = 0;
                    if (!PreferenceLevel.sNeutral.equals(pr) && !PreferenceLevel.sRequired.equals(pr)) {
                        prVal = PreferenceLevel.prolog2int(pr);
                    }
                    if (hasReq && !PreferenceLevel.sRequired.equals(pr)) {
                        prVal += 100;
                    }
                    if (PreferenceLevel.sProhibited.equals(pr)) {
                        prVal += 100;
                    }
                    if (this.iShowStudentConflicts && time != null) {
                        this.iDates.add(new ClassAssignmentInfo(clazz, time, new ClassDateInfo(child.getUniqueId(), clazz.getUniqueId(), child.getName(), child.getPatternBitSet(), prVal), null));
                        continue;
                    }
                    this.iDates.add(new ClassAssignment(clazz, null, new ClassDateInfo(child.getUniqueId(), clazz.getUniqueId(), child.getName(), child.getPatternBitSet(), prVal), null));
                }
            } else if (this.iShowStudentConflicts && time != null) {
                this.iDates.add(new ClassAssignmentInfo(clazz, time, new ClassDateInfo(datePattern.getUniqueId(), clazz.getUniqueId(), datePattern.getName(), datePattern.getPatternBitSet(), PreferenceLevel.sIntLevelNeutral), null));
            } else {
                this.iDates.add(new ClassAssignment(clazz, null, new ClassDateInfo(datePattern.getUniqueId(), clazz.getUniqueId(), datePattern.getName(), datePattern.getPatternBitSet(), PreferenceLevel.sIntLevelNeutral), null));
            }
        }
        return this.iDates;
    }

    public Collection<ClassAssignment> getTimes() {
        if (this.iTimes == null) {
            Collection<ClassAssignment> dates;
            Class_ clazz = this.getClazz().getClazz();
            Set timePrefs = clazz.effectivePreferences(TimePref.class);
            if (timePrefs.isEmpty()) {
                this.iForm.setMessage("Class " + this.getClazz().getClassName() + " has no time pattern selected.");
                return this.iTimes;
            }
            ClassDateInfo date = this.getAssignedDate();
            if (date == null && (dates = this.getDates()) != null && !dates.isEmpty()) {
                date = dates.iterator().next().getDate();
            }
            if (date == null) {
                this.iForm.setMessage("Class " + this.getClazz().getClassName() + " has no date pattern selected.");
                return this.iTimes;
            }
            this.iTimes = this.getTimes(date);
            if (this.iTimes.isEmpty()) {
                this.iForm.setMessage("Class " + this.getClazz().getClassName() + " has no available time.");
            }
        }
        return this.iTimes;
    }

    public Collection<ClassAssignment> getAllTimes() {
        Vector<ClassAssignment> times = new Vector<ClassAssignment>();
        Class_ clazz = this.getClazz().getClazz();
        DatePattern datePattern = clazz.effectiveDatePattern();
        if (datePattern == null) {
            return times;
        }
        if (datePattern.getType() == 4) {
            Set datePatternPrefs = clazz.effectivePreferences(DatePatternPref.class);
            boolean hasReq = false;
            for (DatePatternPref p : datePatternPrefs) {
                if (!PreferenceLevel.sRequired.equals(p.getPrefLevel().getPrefProlog())) continue;
                hasReq = true;
                break;
            }
            for (DatePattern child : datePattern.findChildren()) {
                String pr = PreferenceLevel.sNeutral;
                for (DatePatternPref p : datePatternPrefs) {
                    if (!p.getDatePattern().equals(child)) continue;
                    pr = p.getPrefLevel().getPrefProlog();
                }
                int prVal = 0;
                if (!PreferenceLevel.sNeutral.equals(pr) && !PreferenceLevel.sRequired.equals(pr)) {
                    prVal = PreferenceLevel.prolog2int(pr);
                }
                if (hasReq && !PreferenceLevel.sRequired.equals(pr)) {
                    prVal += 100;
                }
                if (PreferenceLevel.sProhibited.equals(pr)) {
                    prVal += 100;
                }
                times.addAll(this.getTimes(new ClassDateInfo(child.getUniqueId(), clazz.getUniqueId(), child.getName(), child.getPatternBitSet(), prVal)));
            }
        } else {
            times.addAll(this.getTimes(new ClassDateInfo(datePattern.getUniqueId(), clazz.getUniqueId(), datePattern.getName(), datePattern.getPatternBitSet(), PreferenceLevel.sIntLevelNeutral)));
        }
        return times;
    }

    public Collection<ClassAssignment> getTimes(ClassDateInfo date) {
        TimePatternModel pattern;
        Class_ clazz = this.getClazz().getClazz();
        Vector<ClassAssignment> times = new Vector<ClassAssignment>();
        boolean onlyReq = false;
        Set timePrefs = clazz.effectivePreferences(TimePref.class);
        for (TimePref timePref : timePrefs) {
            pattern = timePref.getTimePatternModel();
            if (!pattern.isExactTime() && pattern.countPreferences(PreferenceLevel.sRequired) <= 0) continue;
            onlyReq = true;
        }
        if (onlyReq) {
            sLog.debug((Object)("Class " + this.getClazz().getClassName() + " has required times"));
        }
        for (TimePref timePref : timePrefs) {
            pattern = timePref.getTimePatternModel();
            if (pattern.isExactTime()) {
                int length = ExactTimeMins.getNrSlotsPerMtg(pattern.getExactDays(), clazz.getSchedulingSubpart().getMinutesPerWk());
                int breakTime = ExactTimeMins.getBreakTime(pattern.getExactDays(), clazz.getSchedulingSubpart().getMinutesPerWk());
                ClassTimeInfo time = new ClassTimeInfo(clazz.getUniqueId(), pattern.getExactDays(), pattern.getExactStartSlot(), length, PreferenceLevel.sIntLevelNeutral, timePref.getTimePattern(), date, breakTime);
                if (this.iShowStudentConflicts) {
                    times.add(new ClassAssignmentInfo(clazz, time, date, null, this.iChange == null ? null : this.iChange.getAssignmentTable()));
                    continue;
                }
                times.add(new ClassAssignment(clazz, time, date, null));
                continue;
            }
            if (clazz.getSchedulingSubpart().getMinutesPerWk() != pattern.getMinPerMtg() * pattern.getNrMeetings()) {
                sLog.warn((Object)("Class " + this.getClazz().getClassName() + " has " + clazz.getSchedulingSubpart().getMinutesPerWk() + " minutes per week, but " + pattern.getName() + " time pattern selected."));
            }
            for (int time = 0; time < pattern.getNrTimes(); ++time) {
                block3: for (int day = 0; day < pattern.getNrDays(); ++day) {
                    String pref = pattern.getPreference(day, time);
                    if (onlyReq && !pref.equals(PreferenceLevel.sRequired)) {
                        pref = PreferenceLevel.sProhibited;
                    }
                    ClassTimeInfo loc = new ClassTimeInfo(clazz.getUniqueId(), pattern.getDayCode(day), pattern.getStartSlot(time), pattern.getSlotsPerMtg(), PreferenceLevel.prolog2int(pref), timePref.getTimePattern(), date, pattern.getBreakTime());
                    if (this.iChange != null) {
                        for (ClassAssignment classAssignment : this.iChange.getAssignments()) {
                            if (classAssignment.getClassId().equals(this.getClazz().getClassId())) continue;
                            boolean canConflict = false;
                            if (classAssignment.getParents().contains(this.getClazz().getClassId())) {
                                canConflict = true;
                            }
                            if (this.getClazz().getParents().contains(classAssignment.getClassId())) {
                                canConflict = true;
                            }
                            if (classAssignment.getConfligId().equals(this.getClazz().getConfligId()) && classAssignment.isSingleClass()) {
                                canConflict = true;
                            }
                            if (classAssignment.shareInstructor(this.getClazz())) {
                                canConflict = true;
                            }
                            if (!canConflict || !loc.overlaps(classAssignment.getTime())) continue;
                            continue block3;
                        }
                    }
                    if (this.iShowStudentConflicts) {
                        times.add(new ClassAssignmentInfo(clazz, loc, date, null, this.iChange == null ? null : this.iChange.getAssignmentTable()));
                        continue;
                    }
                    times.add(new ClassAssignment(clazz, loc, date, null));
                }
            }
        }
        return times;
    }

    private PreferenceLevel getRoomPreference(Department department, Long locationId) {
        Hashtable<Long, PreferenceLevel> roomPreferencesThisDept = this.iRoomPreferences.get(department.getUniqueId());
        if (roomPreferencesThisDept == null) {
            roomPreferencesThisDept = new Hashtable<Long, PreferenceLevel>();
            this.iRoomPreferences.put(department.getUniqueId(), roomPreferencesThisDept);
            for (RoomPref pref : department.getPreferences(RoomPref.class)) {
                roomPreferencesThisDept.put(pref.getRoom().getUniqueId(), pref.getPrefLevel());
            }
        }
        return (PreferenceLevel)roomPreferencesThisDept.get(locationId);
    }

    protected List findAllRooms(Long sessionId, boolean roomDepts) {
        int i;
        String a = "";
        String b = "";
        if (this.iForm.getRoomFeatures() != null && this.iForm.getRoomFeatures().length > 0) {
            for (i = 0; i < this.iForm.getRoomFeatures().length; ++i) {
                a = a + ", GlobalRoomFeature f" + i;
                b = b + " and f" + i + ".uniqueId=" + this.iForm.getRoomFeatures()[i] + " and f" + i + " in elements(r.features)";
            }
        }
        if (this.iForm.getRoomGroups() != null && this.iForm.getRoomGroups().length > 0) {
            b = b + " and (";
            for (i = 0; i < this.iForm.getRoomGroups().length; ++i) {
                if (i > 0) {
                    b = b + " or";
                }
                a = a + ", RoomGroup g" + i;
                b = b + " (g" + i + ".uniqueId=" + this.iForm.getRoomGroups()[i] + " and g" + i + " in elements(r.roomGroups))";
            }
            b = b + ")";
        }
        if (this.iForm.getRoomTypes() != null && this.iForm.getRoomTypes().length > 0) {
            b = b + " and r.roomType.uniqueId in (";
            for (i = 0; i < this.iForm.getRoomTypes().length; ++i) {
                if (i > 0) {
                    b = b + ",";
                }
                b = b + this.iForm.getRoomTypes()[i];
            }
            b = b + ")";
        }
        String query = null;
        query = roomDepts ? "select distinct r from Location r inner join r.roomDepts rd " + a + " where r.session.uniqueId = :sessionId " + b : "select r from Location r " + a + " where r.session.uniqueId = :sessionId " + b;
        return LocationDAO.getInstance().getSession().createQuery(query).setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
    }

    /*
     * WARNING - void declaration
     */
    protected Vector<ClassRoomInfo> findRooms(ClassTimeInfo period, int minRoomSize, int maxRoomSize, String filter, boolean allowConflicts, ClassInfoForm.RoomBase showAllRooms) {
        Vector<ClassRoomInfo> rooms = new Vector<ClassRoomInfo>();
        Class_ clazz = this.getClazz().getClazz(Class_DAO.getInstance().getSession());
        int nrRooms = clazz.getNbrRooms() == null ? 1 : clazz.getNbrRooms();
        this.iRoomPreferences.clear();
        Set groupPrefs = clazz.effectivePreferences(RoomGroupPref.class);
        Set roomPrefs = clazz.effectivePreferences(RoomPref.class);
        Set bldgPrefs = clazz.effectivePreferences(BuildingPref.class);
        Set featurePrefs = clazz.effectivePreferences(RoomFeaturePref.class);
        if (nrRooms > 0) {
            int minClassLimit = clazz.getExpectedCapacity();
            int maxClassLimit = clazz.getMaxExpectedCapacity();
            if (maxClassLimit < minClassLimit) {
                maxClassLimit = minClassLimit;
            }
            float room2limitRatio = clazz.getRoomRatio().floatValue();
            int roomCapacity = Math.round(minClassLimit <= 0 ? room2limitRatio : room2limitRatio * (float)minClassLimit);
            int discouragedCapacity = (int)Math.round(0.99 * (double)roomCapacity);
            int stronglyDiscouragedCapacity = (int)Math.round(0.98 * (double)roomCapacity);
            Calendar cal = Calendar.getInstance(Locale.US);
            cal.setTime(new Date());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            Date today = cal.getTime();
            Date[] bounds = DatePattern.getBounds(clazz.getSessionId());
            Set<Location> availRooms = clazz.getAvailableRooms();
            Iterator<Location> i1 = availRooms.iterator();
            block0: while (i1.hasNext()) {
                int i;
                Location room = i1.next();
                if (this.iForm.getRoomTypes() != null && this.iForm.getRoomTypes().length > 0) {
                    boolean ok = false;
                    for (int i2 = 0; i2 < this.iForm.getRoomTypes().length; ++i2) {
                        if (!room.getRoomType().getUniqueId().equals(this.iForm.getRoomTypes()[i2])) continue;
                        ok = true;
                        break;
                    }
                    if (!ok) {
                        i1.remove();
                        continue;
                    }
                }
                if (this.iForm.getRoomFeatures() != null && this.iForm.getRoomFeatures().length > 0) {
                    for (i = 0; i < this.iForm.getRoomFeatures().length; ++i) {
                        if (room.hasFeature(this.iForm.getRoomFeatures()[i])) continue;
                        i1.remove();
                        continue block0;
                    }
                }
                if (this.iForm.getRoomGroups() == null || this.iForm.getRoomGroups().length <= 0) continue;
                for (i = 0; i < this.iForm.getRoomGroups().length; ++i) {
                    if (room.hasGroup(this.iForm.getRoomGroups()[i])) continue block0;
                }
                i1.remove();
            }
            Set<Location> allRooms = availRooms;
            if (showAllRooms != ClassInfoForm.RoomBase.Departmental) {
                allRooms = new TreeSet<Location>(availRooms);
                allRooms.addAll(this.findAllRooms(this.getClazz().getClazz().getSessionId(), showAllRooms == ClassInfoForm.RoomBase.Timetabling));
            }
            Long departmentId = this.getClazz().getClazz().getManagingDept().getUniqueId();
            Hashtable<Location, Integer> filteredRooms = new Hashtable<Location, Integer>();
            HashSet<Long> permIds = new HashSet<Long>();
            block4: for (Location room : allRooms) {
                void var40_56;
                RoomSharingModel sharingModel;
                boolean add = true;
                if (minRoomSize >= 0 && room.getCapacity() < minRoomSize || maxRoomSize >= 0 && room.getCapacity() > maxRoomSize || !ClassInfoModel.match(room.getLabel(), filter)) continue;
                SumPreferenceCombination pref = new SumPreferenceCombination();
                if (showAllRooms != ClassInfoForm.RoomBase.Departmental && !availRooms.contains(room)) {
                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                }
                if ((sharingModel = room.getRoomSharingModel()) != null) {
                    block5: for (int d = 0; d < Constants.NR_DAYS; ++d) {
                        if ((Constants.DAY_CODES[d] & period.getDayCode()) == 0) continue;
                        int startTime = period.getStartSlot();
                        int endTime = period.getStartSlot() + period.getLength() - 1;
                        for (int t = startTime; t <= endTime; ++t) {
                            Long px = Long.valueOf(sharingModel.getPreference(d, t));
                            if (px.equals(RoomSharingModel.sNotAvailablePref)) {
                                if (showAllRooms != ClassInfoForm.RoomBase.Departmental) {
                                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                                    break block5;
                                }
                                if (!room.getLabel().equals(filter)) continue block4;
                                this.iForm.setMessage("Room " + room.getLabel() + " is not available for " + period.getLongName() + " due to the room sharing preferences.");
                                continue block4;
                            }
                            if (px.equals(RoomSharingModel.sFreeForAllPref) || departmentId == null || departmentId.equals(px)) continue;
                            if (showAllRooms != ClassInfoForm.RoomBase.Departmental) {
                                pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                                break block5;
                            }
                            if (!room.getLabel().equals(filter)) continue block4;
                            this.iForm.setMessage("Room " + room.getLabel() + " is not available for " + period.getLongName() + " due to the room sharing preferences.");
                            continue block4;
                        }
                    }
                }
                PreferenceCombination groupPref = PreferenceCombination.getDefault();
                boolean reqGroup = false;
                for (RoomGroupPref p : groupPrefs) {
                    if (p.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sRequired)) {
                        reqGroup = true;
                    }
                    if (!p.getRoomGroup().getRooms().contains(room)) continue;
                    groupPref.addPreferenceProlog(p.getPrefLevel().getPrefProlog());
                }
                if (reqGroup) {
                    if (!PreferenceLevel.sRequired.equals(groupPref.getPreferenceProlog())) {
                        pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                    }
                } else {
                    pref.addPreferenceProlog(groupPref.getPreferenceProlog());
                }
                String roomPref = null;
                PreferenceLevel roomPreference = this.getRoomPreference(clazz.getManagingDept(), room.getUniqueId());
                if (roomPreference != null) {
                    roomPref = roomPreference.getPrefProlog();
                }
                boolean reqRoom = false;
                for (RoomPref p : roomPrefs) {
                    if (p.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sRequired)) {
                        reqRoom = true;
                    }
                    if (!room.equals(p.getRoom())) continue;
                    roomPref = p.getPrefLevel().getPrefProlog();
                }
                if (reqRoom) {
                    if (!PreferenceLevel.sRequired.equals(roomPref)) {
                        pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                    }
                } else if (roomPref != null) {
                    pref.addPreferenceProlog(roomPref);
                }
                Building bldg = room instanceof Room ? ((Room)room).getBuilding() : null;
                boolean reqBldg = false;
                Object var40_57 = null;
                for (BuildingPref p : bldgPrefs) {
                    if (p.getPrefLevel().getPrefProlog().equals(PreferenceLevel.sRequired)) {
                        reqBldg = true;
                    }
                    if (bldg == null || !bldg.equals(p.getBuilding())) continue;
                    String string = p.getPrefLevel().getPrefProlog();
                }
                if (reqBldg) {
                    if (!PreferenceLevel.sRequired.equals(var40_56)) {
                        pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                    }
                } else if (var40_56 != null) {
                    pref.addPreferenceProlog((String)var40_56);
                }
                boolean acceptableFeatures = true;
                MinMaxPreferenceCombination featurePref = new MinMaxPreferenceCombination();
                for (RoomFeaturePref roomFeaturePref : featurePrefs) {
                    RoomFeature feature = roomFeaturePref.getRoomFeature();
                    String p = roomFeaturePref.getPrefLevel().getPrefProlog();
                    boolean hasFeature = feature.getRooms().contains(room);
                    if (p.equals(PreferenceLevel.sProhibited) && hasFeature) {
                        acceptableFeatures = false;
                    }
                    if (p.equals(PreferenceLevel.sRequired) && !hasFeature) {
                        acceptableFeatures = false;
                    }
                    if (p == null || !hasFeature || p.equals(PreferenceLevel.sProhibited) || p.equals(PreferenceLevel.sRequired)) continue;
                    featurePref.addPreferenceProlog(p);
                }
                pref.addPreferenceInt(featurePref.getPreferenceInt());
                if (!acceptableFeatures) {
                    pref.addPreferenceProlog(PreferenceLevel.sProhibited);
                }
                if (room.getCapacity() < stronglyDiscouragedCapacity) {
                    pref.addPreferenceInt(1000);
                } else if (room.getCapacity() < discouragedCapacity) {
                    pref.addPreferenceProlog(PreferenceLevel.sStronglyDiscouraged);
                } else if (room.getCapacity() < roomCapacity) {
                    pref.addPreferenceProlog(PreferenceLevel.sDiscouraged);
                }
                int prefInt = pref.getPreferenceInt();
                if (!add) continue;
                filteredRooms.put(room, prefInt);
                permIds.add(room.getPermanentId());
            }
            boolean changePast = ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue();
            boolean ignorePast = ApplicationProperty.ClassAssignmentIgnorePastMeetings.isTrue();
            Vector<Object> datesToCheck = null;
            if (ignorePast || !changePast) {
                datesToCheck = new Vector();
                for (Date aDate : period.getDates()) {
                    if (aDate.compareTo(today) <= 0) continue;
                    datesToCheck.add(aDate);
                }
            } else {
                datesToCheck = period.getDates();
            }
            Hashtable<Long, Set<Long>> room2classIds = Location.findClassLocationTable(clazz.getSessionId(), permIds, period.getStartSlot(), period.getLength(), changePast ? period.getDates() : datesToCheck);
            Hashtable<Long, Set<Event>> room2events = null;
            if (RoomAvailability.getInstance() != null && RoomAvailability.getInstance() instanceof DefaultRoomAvailabilityService) {
                room2events = Location.findEventTable(clazz.getSessionId(), permIds, period.getStartSlot(), period.getLength(), datesToCheck);
            }
            block12: for (Map.Entry entry : filteredRooms.entrySet()) {
                Collection<RoomAvailabilityInterface.TimeBlock> times;
                Location room = (Location)entry.getKey();
                int prefInt = (Integer)entry.getValue();
                String note = null;
                Set<Long> classIds = room2classIds.get(room.getPermanentId());
                if (classIds == null) {
                    classIds = new HashSet<Long>();
                }
                if (this.getClassAssignment() != null && this.getClassAssignment().hasRoom(room.getUniqueId()) && this.getClassAssignment().getTime().overlaps(period)) {
                    classIds.remove(this.getClassAssignment().getClassId());
                }
                if (this.iChange != null) {
                    for (ClassAssignment classAssignment : this.iChange.getConflicts()) {
                        if (!classAssignment.hasRoom(room.getUniqueId()) || !classAssignment.getTime().overlaps(period)) continue;
                        classIds.remove(classAssignment.getClassId());
                    }
                    for (ClassAssignment classAssignment : this.iChange.getAssignments()) {
                        ClassAssignment initial = this.iChange.getInitial(classAssignment);
                        if (initial == null || !initial.hasRoom(room.getUniqueId()) || !initial.getTime().overlaps(period)) continue;
                        classIds.remove(initial.getClassId());
                    }
                    for (ClassAssignment classAssignment : this.iChange.getAssignments()) {
                        if (this.getClazz().getClassId().equals(classAssignment.getClassId()) || !classAssignment.hasRoom(room.getUniqueId()) || !classAssignment.getTime().overlaps(period)) continue;
                        classIds.add(classAssignment.getClassId());
                    }
                }
                if (!allowConflicts && classIds != null && !classIds.isEmpty()) {
                    Long classId = classIds.iterator().next();
                    if (!room.getLabel().equals(filter)) continue;
                    this.iForm.setMessage("Room " + room.getLabel() + " is not available for " + period.getLongName() + " due to the class " + ((Class_)Class_DAO.getInstance().get(classId)).getClassLabel() + ".");
                    continue;
                }
                if (classIds != null && !classIds.isEmpty()) {
                    prefInt += 10000;
                    note = "Conflicts with " + ((Class_)Class_DAO.getInstance().get((Serializable)classIds.iterator().next())).getClassLabel();
                }
                if (classIds != null && this.iChange != null) {
                    for (Long l : classIds) {
                        if (this.iChange.getCurrent(l) == null) continue;
                        if (!room.getLabel().equals(filter)) continue block12;
                        this.iForm.setMessage("Room " + room.getLabel() + " is not available for " + period.getLongName() + " due to the class " + ((Class_)Class_DAO.getInstance().get(l)).getClassLabel() + ".");
                        continue block12;
                    }
                }
                if (room2events != null) {
                    Set<Event> conflicts = room2events.get(room.getPermanentId());
                    if (conflicts != null && !conflicts.isEmpty()) {
                        if (room.getLabel().equals(filter)) {
                            this.iForm.setMessage("Room " + room.getLabel() + " is not available for " + period.getLongName() + " due to " + conflicts);
                        }
                        sLog.info((Object)("Room " + room.getLabel() + " is not available for " + period.getLongName() + " due to " + conflicts));
                        continue;
                    }
                } else if (RoomAvailability.getInstance() != null && (times = RoomAvailability.getInstance().getRoomAvailability(room.getUniqueId(), bounds[0], bounds[1], RoomAvailabilityInterface.sClassType)) != null && !times.isEmpty()) {
                    void var40_67;
                    RoomAvailabilityInterface.TimeBlock time;
                    Object var40_64 = null;
                    if (!changePast || ignorePast) {
                        Vector<RoomAvailabilityInterface.TimeBlock> vector = new Vector<RoomAvailabilityInterface.TimeBlock>();
                        for (RoomAvailabilityInterface.TimeBlock time2 : times) {
                            if (time2.getEndTime().before(today)) continue;
                            vector.add(time2);
                        }
                    } else {
                        Collection<RoomAvailabilityInterface.TimeBlock> collection = times;
                    }
                    if ((time = period.overlaps((Collection<RoomAvailabilityInterface.TimeBlock>)var40_67)) != null) {
                        if (room.getLabel().equals(filter)) {
                            this.iForm.setMessage("Room " + room.getLabel() + " is not available for " + period.getLongName() + " due to " + time);
                        }
                        sLog.info((Object)("Room " + room.getLabel() + " is not available for " + period.getLongName() + " due to " + time));
                        continue;
                    }
                }
                rooms.addElement(new ClassRoomInfo(room, prefInt, note));
            }
        }
        return rooms;
    }

    public String getRoomTable() {
        try {
            Collection<ClassRoomInfo> original;
            ClassAssignmentInfo ClassAssignment2;
            Vector<ClassRoomInfo> rooms = this.getRooms();
            ClassAssignmentInfo classAssignmentInfo = ClassAssignment2 = this.iChange == null ? null : this.iChange.getCurrent(this.iClass);
            Collection<ClassRoomInfo> assigned = ClassAssignment2 != null ? ClassAssignment2.getRooms() : (this.isClassAssigned() ? this.getClassAssignment().getRooms() : null);
            Collection<ClassRoomInfo> collection = original = this.getClassOldAssignment() != null ? this.getClassOldAssignment().getRooms() : null;
            if (rooms == null || rooms.isEmpty()) {
                return "";
            }
            Collections.sort(rooms, new Comparator<ClassRoomInfo>(){

                @Override
                public int compare(ClassRoomInfo r1, ClassRoomInfo r2) {
                    int cmp = 0;
                    cmp = ClassInfoForm.sRoomOrdNameAsc.equals(ClassInfoModel.this.iForm.getRoomOrder()) ? r1.getName().compareTo(r2.getName()) : (ClassInfoForm.sRoomOrdNameDesc.equals(ClassInfoModel.this.iForm.getRoomOrder()) ? -r1.getName().compareTo(r2.getName()) : (ClassInfoForm.sRoomOrdSizeAsc.equals(ClassInfoModel.this.iForm.getRoomOrder()) ? Double.compare(r1.getCapacity(), r2.getCapacity()) : (ClassInfoForm.sRoomOrdSizeDesc.equals(ClassInfoModel.this.iForm.getRoomOrder()) ? -Double.compare(r1.getCapacity(), r2.getCapacity()) : r1.getName().compareTo(r2.getName()))));
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = r1.getName().compareTo(r2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return r1.getLocationId().compareTo(r2.getLocationId());
                }
            });
            String ret = "";
            ret = ret + "<script language='javascript'>";
            ret = ret + "function roomOver(source, id) { ";
            ret = ret + "    document.getElementById('r'+id).style.backgroundColor='rgb(223,231,242)';";
            ret = ret + "    document.getElementById('c'+id).style.backgroundColor='rgb(223,231,242)';";
            ret = ret + "    source.style.cursor='hand';source.style.cursor='pointer';";
            ret = ret + "}";
            ret = ret + "var sCap = -1;";
            ret = ret + "var sRooms = '";
            if (assigned != null && assigned.size() > 0) {
                for (ClassRoomInfo room : assigned) {
                    ret = ret + ":" + room.getLocationId() + "@" + room.getCapacity();
                }
            }
            ret = ret + "';";
            ret = ret + "var sNrRooms = " + (assigned != null ? assigned.size() : 0) + ";";
            ret = ret + "function roomSelected(id) {";
            ret = ret + "    return sRooms.indexOf(':'+id+'@')>=0;";
            ret = ret + "}";
            ret = ret + "function roomOut(id) { ";
            ret = ret + "    var bg = 'transparent';";
            ret = ret + "    if (roomSelected(id)) bg='rgb(168,187,225)';";
            ret = ret + "    document.getElementById('r'+id).style.backgroundColor=bg;";
            ret = ret + "    document.getElementById('c'+id).style.backgroundColor=bg;";
            ret = ret + "}";
            ret = ret + "function roomClick(source, id, cap) { ";
            ret = ret + "    if (sCap<0) {";
            ret = ret + "        sCap = 0; sRooms=''; sNrRooms=0;";
            if (assigned != null && assigned.size() > 0) {
                for (ClassRoomInfo room : assigned) {
                    ret = ret + "        roomOut(" + room.getLocationId() + ");";
                }
            }
            ret = ret + "    }";
            ret = ret + "    var i = sRooms.indexOf(':'+id+'@');";
            ret = ret + "    if (i>=0) {";
            ret = ret + "        var j = sRooms.indexOf(':',i+1);";
            ret = ret + "        sRooms = sRooms.substring(0, i)+(j>=0?sRooms.substring(j):'');";
            ret = ret + "        sCap -= cap; sNrRooms--;";
            ret = ret + "    } else {";
            ret = ret + "        sRooms = sRooms + ':' + id + '@' + cap;";
            ret = ret + "        sCap += cap; sNrRooms++;";
            ret = ret + "        if (sNrRooms>" + this.getClazz().getNumberOfRooms() + ") {";
            ret = ret + "            var fid = sRooms.substring(1, sRooms.indexOf('@'));";
            ret = ret + "            var fcap = sRooms.substring(sRooms.indexOf('@')+1, sRooms.indexOf(':',1));";
            ret = ret + "            sRooms = sRooms.substring(sRooms.indexOf(':',1));";
            ret = ret + "            sCap -= fcap; sNrRooms--; roomOut(fid);";
            ret = ret + "        };";
            ret = ret + "    }";
            ret = ret + "    roomOut(id);";
            ret = ret + "    if (sNrRooms==" + this.getClazz().getNumberOfRooms() + ") {displayLoading(); document.location='classInfo.do?op=Select&room='+sRooms+'&noCacheTS=" + new Date().getTime() + "';}";
            ret = ret + "    var c = document.getElementById('roomCapacityCounter');";
            ret = ret + "    if (c!=null) c.innerHTML = (sCap<" + this.getClazz().getClassLimit() + "?'<font color=\"red\">'+sCap+'</font>':''+sCap);";
            ret = ret + "}";
            ret = ret + "</script>";
            ret = ret + "<table border='0' cellspacing='0' cellpadding='3'>";
            int idx = 0;
            int step = 6;
            for (ClassRoomInfo room : rooms) {
                if (idx % step == 0) {
                    if (idx > 0) {
                        ret = ret + "</tr>";
                    }
                    ret = ret + "<tr>";
                }
                String style = "";
                if (assigned != null && assigned.contains(room)) {
                    style = style + "background-color:rgb(168,187,225);";
                }
                if (original != null && original.contains(room)) {
                    style = style + "text-decoration:underline;";
                }
                String mouse = "onMouseOver=\"roomOver(this," + room.getLocationId() + ");\" " + "onMouseOut=\"roomOut(" + room.getLocationId() + ");\" " + "onClick=\"roomClick(this," + room.getLocationId() + "," + room.getCapacity() + ");\"";
                ret = ret + "<td nowrap id='r" + room.getLocationId() + "' " + (style.length() > 0 ? "style='" + style + "' " : "") + mouse + ">" + room.toString() + "</td>";
                if (idx % step < step - 1) {
                    style = style + "border-right: #646464 1px dashed;";
                }
                ret = ret + "<td id='c" + room.getLocationId() + "' " + (style.length() > 0 ? "style='" + style + "' " : "") + mouse + ">" + room.getCapacity() + "</td>";
                ++idx;
            }
            while (idx % step != 0) {
                ret = ret + "<td colspan='2'>&nbsp;</td>";
                ++idx;
            }
            ret = ret + "</tr>";
            ret = ret + "</table>";
            return ret;
        }
        catch (Exception e) {
            this.iForm.setMessage(e.getMessage());
            sLog.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public Vector<ClassRoomInfo> getRooms() {
        ClassTimeInfo time = null;
        try {
            time = this.getSelectedAssignment() != null ? this.getSelectedAssignment().getTime() : this.getClassAssignment().getTime();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (time == null) {
            return null;
        }
        int minRoomSize = -1;
        try {
            minRoomSize = this.iForm.getMinRoomSize() == null || this.iForm.getMinRoomSize().length() == 0 ? -1 : Integer.parseInt(this.iForm.getMinRoomSize().trim());
        }
        catch (Exception e) {
            // empty catch block
        }
        int maxRoomSize = -1;
        try {
            maxRoomSize = this.iForm.getMaxRoomSize() == null || this.iForm.getMaxRoomSize().length() == 0 ? -1 : Integer.parseInt(this.iForm.getMaxRoomSize().trim());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.getSelectedAssignment() == null && !this.isClassAssigned()) {
                return null;
            }
            if (this.iRooms == null) {
                this.iRooms = this.findRooms(time, minRoomSize, maxRoomSize, this.iForm.getRoomFilter(), this.iForm.getAllowRoomConflict(), this.iForm.getRoomBaseEnum());
            }
            return this.iRooms;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public int getRoomSize() {
        ClassAssignmentInfo classAssignment;
        ClassAssignmentInfo classAssignmentInfo = classAssignment = this.iChange == null ? null : this.iChange.getCurrent(this.iClass);
        if (classAssignment != null) {
            return classAssignment.getRoomSize();
        }
        if (this.isClassAssigned()) {
            return this.getClassAssignment().getRoomSize();
        }
        return 0;
    }

    public ClassProposedChange getChange() {
        if (this.iChange == null || this.iChange.isEmpty()) {
            return null;
        }
        return this.iChange;
    }

    public boolean isHasChange() {
        return this.iChange != null && !this.iChange.isEmpty();
    }

    public String getChangeHtmlTable() {
        if (this.iChange == null || this.iChange.isEmpty()) {
            return null;
        }
        return this.iChange.getHtmlTable(this.getSessionContext());
    }

    public static boolean match(String name, String filter) {
        if (filter == null || filter.trim().length() == 0) {
            return true;
        }
        String n = name.toUpperCase();
        StringTokenizer stk1 = new StringTokenizer(filter.toUpperCase(), ";");
        while (stk1.hasMoreTokens()) {
            StringTokenizer stk2 = new StringTokenizer(stk1.nextToken(), " ,");
            boolean match = true;
            while (match && stk2.hasMoreTokens()) {
                String token = stk2.nextToken().trim();
                if (token.length() == 0) continue;
                if (token.indexOf(42) >= 0 || token.indexOf(63) >= 0) {
                    try {
                        String tokenRegExp = "\\s+" + token.replaceAll("\\.", "\\.").replaceAll("\\?", ".+").replaceAll("\\*", ".*") + "\\s";
                        if (Pattern.compile(tokenRegExp).matcher(" " + n + " ").find()) continue;
                        match = false;
                    }
                    catch (PatternSyntaxException e) {
                        match = false;
                    }
                    continue;
                }
                if (n.indexOf(token) >= 0) continue;
                match = false;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    public boolean isKeepConflictingAssignments() {
        return !this.iUnassignConflictingAssignments;
    }

    public void setSessionContext(SessionContext context) {
        this.iContext = context;
    }

    public SessionContext getSessionContext() {
        return this.iContext;
    }
}

