/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.exams;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.events.EventEnrollmentsBackend;
import org.unitime.timetable.gwt.client.sectioning.ExaminationEnrollmentTable;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=ExaminationEnrollmentTable.ExaminationEnrollmentsRpcRequest.class)
public class ExaminationEnrollmentsBackend
implements GwtRpcImplementation<ExaminationEnrollmentTable.ExaminationEnrollmentsRpcRequest, GwtRpcResponseList<ClassAssignmentInterface.Enrollment>> {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;

    @Override
    public GwtRpcResponseList<ClassAssignmentInterface.Enrollment> execute(ExaminationEnrollmentTable.ExaminationEnrollmentsRpcRequest request, SessionContext context) {
        Exam exam = (Exam)ExamDAO.getInstance().get(request.getExamId());
        context.checkPermission(exam, Right.ExaminationDetail);
        ExamSolverProxy proxy = this.examinationSolverService.getSolver();
        if (proxy != null && !exam.getExamType().getUniqueId().equals(proxy.getExamTypeId())) {
            proxy = null;
        }
        ExamAssignmentInfo assignment = null;
        ExamPeriod period = null;
        if (proxy != null) {
            assignment = proxy.getAssignmentInfo(exam.getUniqueId());
            period = assignment == null ? null : assignment.getPeriod();
        } else {
            assignment = new ExamAssignmentInfo(exam, false);
            period = exam.getAssignedPeriod();
        }
        GwtRpcResponseList<ClassAssignmentInterface.Enrollment> ret = EventEnrollmentsBackend.convert(exam.getStudentClassEnrollments(), null, context.hasPermission(Right.EnrollmentsShowExternalId));
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_EXAM_PERIOD);
        Map<Long, List<Meeting>> conflicts = this.computeConflicts(exam.getUniqueId(), period);
        if (conflicts != null) {
            for (ClassAssignmentInterface.Enrollment enrollment : ret) {
                List<Meeting> conf = conflicts.get(enrollment.getStudent().getId());
                if (conf == null) continue;
                HashMap<Event, TreeSet<Meeting>> events = new HashMap<Event, TreeSet<Meeting>>();
                for (Meeting m : conf) {
                    TreeSet<Meeting> ms = (TreeSet<Meeting>)events.get(m.getEvent());
                    if (ms == null) {
                        ms = new TreeSet<Meeting>();
                        events.put(m.getEvent(), ms);
                    }
                    ms.add(m);
                }
                for (Event confEvent : new TreeSet(events.keySet())) {
                    Iterator conflict = new ClassAssignmentInterface.Conflict();
                    ((ClassAssignmentInterface.Conflict)((Object)conflict)).setName(confEvent.getEventName());
                    ((ClassAssignmentInterface.Conflict)((Object)conflict)).setType(confEvent.getEventTypeAbbv());
                    String lastDate = null;
                    String lastTime = null;
                    String lastRoom = null;
                    for (Meeting m : (TreeSet)events.get(confEvent)) {
                        String room;
                        String date = df.format(m.getMeetingDate());
                        if (lastDate == null) {
                            ((ClassAssignmentInterface.Conflict)((Object)conflict)).setDate(date);
                        } else if (lastDate.equals(date)) {
                            ((ClassAssignmentInterface.Conflict)((Object)conflict)).setDate(((ClassAssignmentInterface.Conflict)((Object)conflict)).getDate() + "<br>");
                        } else {
                            ((ClassAssignmentInterface.Conflict)((Object)conflict)).setDate(((ClassAssignmentInterface.Conflict)((Object)conflict)).getDate() + "<br>" + date);
                        }
                        lastDate = date;
                        String time = m.startTime() + " - " + m.stopTime();
                        if (lastTime == null) {
                            ((ClassAssignmentInterface.Conflict)((Object)conflict)).setTime(time);
                        } else if (lastTime.equals(time)) {
                            ((ClassAssignmentInterface.Conflict)((Object)conflict)).setTime(((ClassAssignmentInterface.Conflict)((Object)conflict)).getTime() + "<br>");
                        } else {
                            ((ClassAssignmentInterface.Conflict)((Object)conflict)).setTime(((ClassAssignmentInterface.Conflict)((Object)conflict)).getTime() + "<br>" + time);
                        }
                        lastTime = time;
                        String string = room = m.getLocation() == null ? "" : m.getLocation().getLabel();
                        if (lastRoom == null) {
                            ((ClassAssignmentInterface.Conflict)((Object)conflict)).setRoom(room);
                        } else if (lastRoom.equals(room)) {
                            ((ClassAssignmentInterface.Conflict)((Object)conflict)).setRoom(((ClassAssignmentInterface.Conflict)((Object)conflict)).getRoom() + "<br>");
                        } else {
                            ((ClassAssignmentInterface.Conflict)((Object)conflict)).setRoom(((ClassAssignmentInterface.Conflict)((Object)conflict)).getRoom() + "<br>" + room);
                        }
                        lastRoom = room;
                    }
                    ((ClassAssignmentInterface.Conflict)((Object)conflict)).setStyle("dc");
                    enrollment.addConflict((ClassAssignmentInterface.Conflict)((Object)conflict));
                }
            }
        }
        if (assignment != null) {
            ClassAssignmentInterface.Conflict conf;
            ExamAssignment other;
            for (ExamAssignmentInfo.DirectConflict directConflict : assignment.getDirectConflicts()) {
                other = directConflict.getOtherExam();
                if (other == null) continue;
                conf = new ClassAssignmentInterface.Conflict();
                conf.setName(other.getExamName());
                conf.setType("Direct");
                conf.setDate(df.format(other.getPeriod().getStartDate()));
                conf.setTime(other.getTime(false));
                conf.setRoom(other.getRoomsName(false, ", "));
                conf.setStyle("dc");
                for (Long studentId : directConflict.getStudents()) {
                    for (ClassAssignmentInterface.Enrollment enrollment : ret) {
                        if (enrollment.getStudent().getId() != studentId.longValue()) continue;
                        enrollment.addConflict(conf);
                    }
                }
            }
            for (ExamAssignmentInfo.BackToBackConflict backToBackConflict : assignment.getBackToBackConflicts()) {
                other = backToBackConflict.getOtherExam();
                conf = new ClassAssignmentInterface.Conflict();
                conf.setName(other.getExamName());
                conf.setType("Back-To-Back");
                conf.setDate(df.format(other.getPeriod().getStartDate()));
                conf.setTime(other.getTime(false));
                conf.setRoom(other.getRoomsName(false, ", "));
                conf.setStyle("b2b");
                for (Long studentId : backToBackConflict.getStudents()) {
                    for (ClassAssignmentInterface.Enrollment enrollment : ret) {
                        if (enrollment.getStudent().getId() != studentId.longValue()) continue;
                        enrollment.addConflict(conf);
                    }
                }
            }
            for (ExamAssignmentInfo.MoreThanTwoADayConflict moreThanTwoADayConflict : assignment.getMoreThanTwoADaysConflicts()) {
                String name = null;
                String date = null;
                String time = null;
                String room = null;
                for (ExamAssignment other2 : moreThanTwoADayConflict.getOtherExams()) {
                    if (name == null) {
                        name = other2.getExamName();
                        date = df.format(other2.getPeriod().getStartDate());
                        time = other2.getTime(false);
                        room = other2.getRoomsName(false, ", ");
                        continue;
                    }
                    name = name + "<br>" + other2.getExamName();
                    date = date + "<br>" + df.format(other2.getPeriod().getStartDate());
                    time = time + "<br>" + other2.getTime(false);
                    room = room + "<br>" + other2.getRoomsName(false, ", ");
                }
                ClassAssignmentInterface.Conflict conf2 = new ClassAssignmentInterface.Conflict();
                conf2.setName(name);
                conf2.setType("&gt;2 A Day");
                conf2.setDate(date);
                conf2.setTime(time);
                conf2.setRoom(room);
                conf2.setStyle("m2d");
                for (Long studentId : moreThanTwoADayConflict.getStudents()) {
                    for (ClassAssignmentInterface.Enrollment enrollment : ret) {
                        if (enrollment.getStudent().getId() != studentId.longValue()) continue;
                        enrollment.addConflict(conf2);
                    }
                }
            }
        }
        return ret;
    }

    static String where(int type, int idx) {
        switch (type) {
            case 3: {
                return " and o" + idx + ".ownerType = " + type + " and o" + idx + ".ownerId = s" + idx + ".clazz.uniqueId";
            }
            case 2: {
                return " and o" + idx + ".ownerType = " + type + " and o" + idx + ".ownerId = s" + idx + ".clazz.schedulingSubpart.instrOfferingConfig.uniqueId";
            }
            case 1: {
                return " and o" + idx + ".ownerType = " + type + " and o" + idx + ".ownerId = s" + idx + ".courseOffering.uniqueId";
            }
            case 0: {
                return " and o" + idx + ".ownerType = " + type + " and o" + idx + ".ownerId = s" + idx + ".courseOffering.instructionalOffering.uniqueId";
            }
        }
        return "";
    }

    private Map<Long, List<Meeting>> computeConflicts(Long examId, ExamPeriod period) {
        if (period == null) {
            return null;
        }
        HashMap<Long, List<Meeting>> conflicts = new HashMap<Long, List<Meeting>>();
        Session hibSession = EventDAO.getInstance().getSession();
        int nrTravelSlotsClassEvent = ApplicationProperty.ExaminationTravelTimeClass.intValue();
        int nrTravelSlotsCourseEvent = ApplicationProperty.ExaminationTravelTimeCourse.intValue();
        for (int t2 = 0; t2 < ExamOwner.sOwnerTypes.length; ++t2) {
            for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, ClassEvent e1 inner join e1.meetings m1, Exam e2 inner join e2.owners o2, StudentClassEnrollment s2 where e2.uniqueId = :examId and e1.clazz = s1.clazz and s1.student = s2.student" + ExaminationEnrollmentsBackend.where(t2, 2) + " and m1.meetingDate = :meetingDate and m1.startPeriod < :endSlot and :startSlot < m1.stopPeriod").setLong("examId", examId.longValue()).setDate("meetingDate", period.getStartDate()).setInteger("startSlot", period.getStartSlot() - nrTravelSlotsClassEvent).setInteger("endSlot", period.getEndSlot() + nrTravelSlotsClassEvent).list()) {
                Long studentId = (Long)o[0];
                Meeting meeting = (Meeting)o[1];
                ArrayList<Meeting> meetings = (ArrayList<Meeting>)conflicts.get(studentId);
                if (meetings == null) {
                    meetings = new ArrayList<Meeting>();
                    conflicts.put(studentId, meetings);
                }
                meetings.add(meeting);
            }
        }
        for (int t1 = 0; t1 < ExamOwner.sOwnerTypes.length; ++t1) {
            for (int t2 = 0; t2 < ExamOwner.sOwnerTypes.length; ++t2) {
                for (Object[] o : hibSession.createQuery("select s1.student.uniqueId, m1 from StudentClassEnrollment s1, CourseEvent e1 inner join e1.meetings m1 inner join e1.relatedCourses o1, Exam e2 inner join e2.owners o2, StudentClassEnrollment s2 where e2.uniqueId = :examId and s1.student = s2.student" + ExaminationEnrollmentsBackend.where(t1, 1) + ExaminationEnrollmentsBackend.where(t2, 2) + " and m1.meetingDate = :meetingDate and m1.startPeriod < :endSlot and :startSlot < m1.stopPeriod and e1.reqAttendance = true and m1.approvalStatus = 1").setLong("examId", examId.longValue()).setDate("meetingDate", period.getStartDate()).setInteger("startSlot", period.getStartSlot() - nrTravelSlotsCourseEvent).setInteger("endSlot", period.getEndSlot() + nrTravelSlotsCourseEvent).list()) {
                    Long studentId = (Long)o[0];
                    Meeting meeting = (Meeting)o[1];
                    ArrayList<Meeting> meetings = (ArrayList<Meeting>)conflicts.get(studentId);
                    if (meetings == null) {
                        meetings = new ArrayList<Meeting>();
                        conflicts.put(studentId, meetings);
                    }
                    meetings.add(meeting);
                }
            }
        }
        return conflicts;
    }
}

