/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.text.DecimalFormat;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.PositionType;
import org.unitime.timetable.model.dao.PositionTypeDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=position]")
public class PositionTypes
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pagePositionType(), MESSAGES.pagePositionTypes());
    }

    @PreAuthorize(value="checkPermission('PositionTypes')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 160, 20, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldName(), SimpleEditInterface.FieldType.text, 300, 60, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldSortOrder(), SimpleEditInterface.FieldType.number, 80, 10, SimpleEditInterface.Flag.UNIQUE));
        data.setSortBy(2, 0, 1);
        DecimalFormat df = new DecimalFormat("0000");
        for (PositionType position : PositionTypeDAO.getInstance().findAll()) {
            int used = ((Number)hibSession.createQuery("select count(f) from Staff f where f.positionType.uniqueId = :uniqueId").setLong("uniqueId", position.getUniqueId().longValue()).uniqueResult()).intValue() + ((Number)hibSession.createQuery("select count(f) from DepartmentalInstructor f where f.positionType.uniqueId = :uniqueId").setLong("uniqueId", position.getUniqueId().longValue()).uniqueResult()).intValue();
            SimpleEditInterface.Record r = data.addRecord(position.getUniqueId(), used == 0);
            r.setField(0, position.getReference());
            r.setField(1, position.getLabel());
            r.setField(2, df.format(position.getSortOrder()));
        }
        data.setEditable(context.hasPermission(Right.PositionTypeEdit));
        return data;
    }

    @PreAuthorize(value="checkPermission('PositionTypeEdit')")
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (PositionType position : PositionTypeDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.getRecord(position.getUniqueId());
            if (r == null) {
                this.delete(position, context, hibSession);
                continue;
            }
            this.update(position, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @PreAuthorize(value="checkPermission('PositionTypeEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        PositionType position = new PositionType();
        position.setReference(record.getField(0));
        position.setLabel(record.getField(1));
        position.setSortOrder(Integer.valueOf(record.getField(2)));
        record.setUniqueId((Long)hibSession.save((Object)position));
        ChangeLog.addChange(hibSession, context, position, position.getReference() + " " + position.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(PositionType position, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (position == null) {
            return;
        }
        DecimalFormat df = new DecimalFormat("0000");
        if (ToolBox.equals((Object)position.getReference(), (Object)record.getField(0)) && ToolBox.equals((Object)position.getLabel(), (Object)record.getField(1)) && ToolBox.equals((Object)df.format(position.getSortOrder()), (Object)record.getField(2))) {
            return;
        }
        position.setReference(record.getField(0));
        position.setLabel(record.getField(1));
        position.setSortOrder(Integer.valueOf(record.getField(2)));
        hibSession.saveOrUpdate((Object)position);
        ChangeLog.addChange(hibSession, context, position, position.getReference() + " " + position.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @PreAuthorize(value="checkPermission('PositionTypeEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((PositionType)PositionTypeDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(PositionType position, SessionContext context, Session hibSession) {
        if (position == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, position, position.getReference() + " " + position.getLabel(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.delete((Object)position);
    }

    @PreAuthorize(value="checkPermission('PositionTypeEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((PositionType)PositionTypeDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

