/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseExamPeriod;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleByRoomReport
extends PdfLegacyExamReport {
    protected static Logger sLog = Logger.getLogger(ScheduleByRoomReport.class);

    public ScheduleByRoomReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, "SCHEDULE BY ROOM", session, examType, subjectAreas, exams);
    }

    @Override
    public void printReport() throws DocumentException {
        Hashtable roomAssignments;
        sLog.info((Object)"  Computing room table...");
        Hashtable<ExamRoomInfo, Hashtable> table = new Hashtable<ExamRoomInfo, Hashtable>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            if (exam.getPeriod() == null || !this.hasSubjectArea(exam)) continue;
            for (ExamRoomInfo room : exam.getRooms()) {
                ArrayList<ExamAssignmentInfo> exams;
                roomAssignments = (Hashtable)table.get(room);
                if (roomAssignments == null) {
                    roomAssignments = new Hashtable();
                    table.put(room, roomAssignments);
                }
                if ((exams = (ArrayList<ExamAssignmentInfo>)roomAssignments.get(exam.getPeriod())) == null) {
                    exams = new ArrayList<ExamAssignmentInfo>();
                    roomAssignments.put(exam.getPeriod(), exams);
                }
                exams.add(exam);
            }
        }
        TreeSet<ExamRoomInfo> rooms = new TreeSet<ExamRoomInfo>(new Comparator<ExamRoomInfo>(){

            @Override
            public int compare(ExamRoomInfo r1, ExamRoomInfo r2) {
                int cmp = r1.getName().compareTo(r2.getName());
                if (cmp != 0) {
                    return cmp;
                }
                return r1.getLocationId().compareTo(r2.getLocationId());
            }
        });
        rooms.addAll(table.keySet());
        Vector periods = new Vector(ExamPeriod.findAll(this.getSession().getUniqueId(), this.getExamType()));
        sLog.info((Object)"  Printing report...");
        String[] stringArray = new String[2];
        stringArray[0] = "Bldg  Room  Capacity  ExCap Period Date And Time                          Subject Course   " + (this.iItype ? (this.iExternal ? "ExtnID " : "Type   ") : "") + "Section    Enrl";
        stringArray[1] = "----- ----- -------- ------ ------ -------------------------------------- ------- -------- " + (this.iItype ? "------ " : "") + "--------- -----";
        this.setHeader(stringArray);
        this.printHeader();
        Iterator<ExamRoomInfo> i = rooms.iterator();
        while (i.hasNext()) {
            ExamRoomInfo room;
            room = i.next();
            this.iPeriodPrinted = false;
            this.setPageName(room.getName());
            this.setCont(room.getName());
            roomAssignments = (Hashtable)table.get(room);
            BaseExamPeriod lastPeriod = null;
            boolean somethingPrinted = false;
            for (ExamPeriod period : periods) {
                this.iStudentPrinted = false;
                List exams = (List)roomAssignments.get(period);
                if (exams == null) continue;
                for (ExamAssignmentInfo exam : exams) {
                    ExamInfo.ExamSectionInfo lastSection = null;
                    this.iITypePrinted = false;
                    this.iCoursePrinted = false;
                    this.iSubjectPrinted = false;
                    for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                        if (!this.hasSubjectArea(section)) continue;
                        if (lastSection != null && this.iSubjectPrinted) {
                            this.iITypePrinted = false;
                            this.iCoursePrinted = false;
                            this.iSubjectPrinted = false;
                            if (section.getSubject().equals(lastSection.getSubject())) {
                                this.iSubjectPrinted = true;
                                if (section.getCourseNbr().equals(lastSection.getCourseNbr())) {
                                    this.iCoursePrinted = true;
                                    if (section.getItype().equals(lastSection.getItype())) {
                                        this.iITypePrinted = true;
                                    }
                                }
                            }
                        }
                        if (lastPeriod != null && !lastPeriod.getDateOffset().equals(period.getDateOffset()) && !this.iNewPage) {
                            this.println("");
                        }
                        lastPeriod = period;
                        this.println((this.iPeriodPrinted ? this.rpad("", 11) : this.formatRoom(room.getName())) + " " + this.lpad(this.iPeriodPrinted ? "" : String.valueOf(room.getCapacity()), 8) + " " + this.lpad(this.iPeriodPrinted ? "" : String.valueOf(room.getExamCapacity()), 6) + " " + this.lpad(this.iStudentPrinted ? "" : String.valueOf(periods.indexOf(period) + 1), 6) + " " + this.rpad(this.iStudentPrinted ? "" : this.formatPeriod(section.getExamAssignment()), 38) + " " + this.rpad(this.iSubjectPrinted ? "" : section.getSubject(), 7) + " " + this.rpad(this.iCoursePrinted ? "" : section.getCourseNbr(), 8) + " " + (this.iItype ? this.rpad(this.iITypePrinted ? "" : section.getItype(), 6) + " " : "") + this.lpad(section.getSection(), 9) + " " + this.lpad(String.valueOf(section.getNrStudents()), 5));
                        this.iITypePrinted = !this.iNewPage;
                        this.iCoursePrinted = this.iITypePrinted;
                        this.iSubjectPrinted = this.iITypePrinted;
                        this.iStudentPrinted = this.iITypePrinted;
                        this.iPeriodPrinted = this.iITypePrinted;
                        lastSection = section;
                        somethingPrinted = true;
                    }
                }
            }
            this.setCont(null);
            if (!somethingPrinted || !i.hasNext()) continue;
            this.newPage();
        }
        this.lastPage();
    }
}

