/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.reports.exam;

import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseExamPeriod;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.reports.exam.ScheduleByCourseReport;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamPeriodChartReport
extends PdfLegacyExamReport {
    protected static Logger sLog = Logger.getLogger(ScheduleByCourseReport.class);

    public ExamPeriodChartReport(int mode, File file, Session session, ExamType examType, Collection<SubjectArea> subjectAreas, Collection<ExamAssignmentInfo> exams) throws IOException, DocumentException {
        super(mode, file, "PERIOD ASSIGNMENT", session, examType, subjectAreas, exams);
    }

    @Override
    public void printReport() throws DocumentException {
        if (this.iRC != null && this.iRC.length() > 0) {
            this.setFooter(this.iRC + (this.iLimit >= 0 ? " (limit=" + this.iLimit + ")" : ""));
        } else if (this.iLimit >= 0) {
            this.setFooter("limit=" + this.iLimit);
        }
        Hashtable<ExamPeriod, TreeSet<ExamAssignmentInfo>> period2exams = new Hashtable<ExamPeriod, TreeSet<ExamAssignmentInfo>>();
        for (ExamAssignmentInfo exam : this.getExams()) {
            if (exam.getPeriod() == null || !this.hasSubjectArea(exam)) continue;
            TreeSet<ExamAssignmentInfo> exams = (TreeSet<ExamAssignmentInfo>)period2exams.get(exam.getPeriod());
            if (exams == null) {
                exams = new TreeSet<ExamAssignmentInfo>();
                period2exams.put(exam.getPeriod(), exams);
            }
            exams.add(exam);
        }
        HashMap<Integer, String> times = new HashMap<Integer, String>();
        HashMap<Integer, String> fixedTimes = new HashMap<Integer, String>();
        HashMap<Integer, String> days = new HashMap<Integer, String>();
        for (ExamPeriod period : ExamPeriod.findAll(this.getSession().getUniqueId(), this.getExamType())) {
            times.put(period.getStartSlot(), period.getStartTimeLabel());
            days.put(period.getDateOffset(), period.getStartDateLabel());
            fixedTimes.put(period.getStartSlot(), this.lpad(period.getStartTimeLabel(), '0', 6));
        }
        boolean headerPrinted = false;
        Hashtable<Integer, Integer> totalADay = new Hashtable<Integer, Integer>();
        String timesThisPage = null;
        int nrCols = 0;
        if (!this.iTotals) {
            if (this.iCompact) {
                this.setHeader(new String[]{"Start Time  Exam            Enrl  Exam            Enrl  Exam            Enrl  Exam            Enrl  Exam            Enrl", "----------  --------------- ----  --------------- ----  --------------- ----  --------------- ----  --------------- ----"});
            } else {
                this.setHeader(new String[]{"Start Time Exam                     Enrl  Exam                     Enrl  Exam                     Enrl  Exam                     Enrl", "---------- ------------------------ ----  ------------------------ ----  ------------------------ ----  ------------------------ ----"});
            }
            this.printHeader();
        }
        int lastDIdx = 0;
        boolean firstLine = true;
        for (int dIdx = 0; dIdx < days.size(); dIdx += nrCols) {
            Iterator iterator = new TreeSet(times.keySet()).iterator();
            while (iterator.hasNext()) {
                Vector linesThisPeriod;
                int time = (Integer)iterator.next();
                int offset = 0;
                String timeStr = (String)times.get(time);
                String header1 = "";
                String header2 = "";
                String header3 = "";
                Vector<Object> periods = new Vector<Object>();
                int idx = 0;
                String firstDay = null;
                int firstDayOffset = 0;
                String lastDay = null;
                nrCols = 0;
                Iterator f = new TreeSet(days.keySet()).iterator();
                while (f.hasNext()) {
                    int day = (Integer)f.next();
                    String dayStr = (String)days.get(day);
                    if (idx >= dIdx && (firstDay == null || !dayStr.startsWith("Mon") && day < firstDayOffset + 7)) {
                        if (nrCols != (this.iCompact ? (this.iTotals ? 6 : 5) : 4)) {
                            if (firstDay == null) {
                                firstDay = dayStr;
                                firstDayOffset = day;
                                Calendar c = Calendar.getInstance(Locale.US);
                                c.setTime(this.getSession().getExamBeginDate());
                                c.add(6, day);
                                if (!this.iTotals) {
                                    offset = (c.get(7) + 5) % 7;
                                    firstDayOffset -= offset;
                                }
                            }
                            lastDay = dayStr;
                            if (this.iCompact) {
                                header1 = header1 + this.mpad(dayStr, 20) + "  ";
                                header2 = header2 + "Exam            Enrl  ";
                                header3 = header3 + "=============== ====  ";
                            } else {
                                header1 = header1 + this.mpad(dayStr, 29) + "  ";
                                header2 = header2 + "Exam                     Enrl  ";
                                header3 = header3 + "======================== ====  ";
                            }
                            Object period = null;
                            ++nrCols;
                            for (Object p : ExamPeriod.findAll(this.getSession().getUniqueId(), this.getExamType())) {
                                if (time != ((BaseExamPeriod)p).getStartSlot() || day != ((BaseExamPeriod)p).getDateOffset()) continue;
                                period = p;
                                break;
                            }
                            periods.add(period);
                        }
                    }
                    ++idx;
                }
                if (this.iTotals) {
                    this.setHeader(new String[]{timeStr, header1, header2, header3});
                } else if (offset + periods.size() > (this.iCompact ? (this.iTotals ? 6 : 5) : 4)) {
                    offset = Math.max(0, (this.iCompact ? (this.iTotals ? 6 : 5) : 4) - periods.size());
                }
                int nextLines = 0;
                Enumeration f2 = periods.elements();
                while (f2.hasMoreElements()) {
                    TreeSet exams;
                    Object p;
                    ExamPeriod period = (ExamPeriod)f2.nextElement();
                    if (period == null || (exams = (TreeSet)period2exams.get(period)) == null) continue;
                    int linesThisSections = 6;
                    p = exams.iterator();
                    while (p.hasNext()) {
                        ExamAssignmentInfo exam = (ExamAssignmentInfo)p.next();
                        int size = 0;
                        for (ExamInfo.ExamSectionInfo examSectionInfo : exam.getSectionsIncludeCrosslistedDummies()) {
                            size += examSectionInfo.getNrStudents();
                        }
                        if (this.iLimit >= 0 && size < this.iLimit) continue;
                        for (ExamInfo.ExamSectionInfo examSectionInfo : exam.getSectionsIncludeCrosslistedDummies()) {
                            if (!this.hasSubjectArea(examSectionInfo)) continue;
                            ++linesThisSections;
                        }
                    }
                    nextLines = Math.max(nextLines, linesThisSections);
                }
                if (this.iTotals) {
                    if (!headerPrinted) {
                        this.printHeader();
                        this.setPageName(timeStr + (days.size() > nrCols ? " (" + firstDay + " - " + lastDay + ")" : ""));
                        this.setCont(timeStr + (days.size() > nrCols ? " (" + firstDay + " - " + lastDay + ")" : ""));
                        timesThisPage = timeStr;
                    } else if (timesThisPage != null && this.getLineNumber() + nextLines <= this.iNrLines) {
                        this.println("");
                        this.println(timeStr);
                        this.println(header1);
                        this.println(header2);
                        this.println(header3);
                        timesThisPage = timesThisPage + ", " + timeStr;
                        this.setPageName(timesThisPage + (days.size() > nrCols ? " (" + firstDay + " - " + lastDay + ")" : ""));
                        this.setCont(timesThisPage + (days.size() > nrCols ? " (" + firstDay + " - " + lastDay + ")" : ""));
                    } else {
                        this.newPage();
                        timesThisPage = timeStr;
                        this.setPageName(timeStr + (days.size() > nrCols ? " (" + firstDay + " - " + lastDay + ")" : ""));
                        this.setCont(timeStr + (days.size() > nrCols ? " (" + firstDay + " - " + lastDay + ")" : ""));
                    }
                } else {
                    if (nextLines == 0) continue;
                    if (!this.iNewPage && !firstLine) {
                        if (lastDIdx != dIdx) {
                            if (this.iCompact) {
                                this.println("----------  --------------- ----  --------------- ----  --------------- ----  --------------- ----  --------------- ----");
                            } else {
                                this.println("---------- ------------------------ ----  ------------------------ ----  ------------------------ ----  ------------------------ ----");
                            }
                            lastDIdx = dIdx;
                        } else if (this.iCompact) {
                            this.println("            --------------- ----  --------------- ----  --------------- ----  --------------- ----  --------------- ----");
                        } else {
                            this.println("           ------------------------ ----  ------------------------ ----  ------------------------ ----  ------------------------ ----");
                        }
                    }
                    firstLine = false;
                    this.setCont(firstDay + " - " + lastDay + " " + (String)fixedTimes.get(time));
                    this.setPageName(firstDay + " - " + lastDay + " " + (String)fixedTimes.get(time));
                }
                headerPrinted = true;
                int max = 0;
                Vector<Vector> lines = new Vector<Vector>();
                Enumeration f3 = periods.elements();
                while (f3.hasMoreElements()) {
                    ExamPeriod period = (ExamPeriod)f3.nextElement();
                    if (period == null) {
                        Vector<String> linesThisPeriod2 = new Vector<String>();
                        linesThisPeriod2.add(this.lpad("0", this.iCompact ? 20 : 29));
                        lines.add(linesThisPeriod2);
                        continue;
                    }
                    TreeSet exams = (TreeSet)period2exams.get(period);
                    if (exams == null) {
                        exams = new TreeSet();
                    }
                    linesThisPeriod = new Vector();
                    int total = 0;
                    int totalListed = 0;
                    for (ExamAssignmentInfo exam : exams) {
                        boolean sizePrinted = false;
                        int size = 0;
                        for (ExamInfo.ExamSectionInfo section2 : exam.getSectionsIncludeCrosslistedDummies()) {
                            size += section2.getNrStudents();
                        }
                        for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                            ExamRoomInfo room;
                            String c;
                            Iterator<ExamRoomInfo> iterator2;
                            if (!this.hasSubjectArea(section)) continue;
                            total += section.getNrStudents();
                            if (this.iLimit >= 0 && size < this.iLimit) continue;
                            totalListed += section.getNrStudents();
                            String code = null;
                            if (this.iRoomCodes != null && !this.iRoomCodes.isEmpty() && (iterator2 = section.getExamAssignment().getRooms().iterator()).hasNext() && (c = (String)this.iRoomCodes.get((room = iterator2.next()).getName())) != null) {
                                code = c;
                            }
                            if (this.iCompact) {
                                linesThisPeriod.add(this.rpad(section.getSubject(), 7) + this.rpad(section.getCourseNbr(), 8) + (sizePrinted || code == null || code.length() == 0 ? (char)' ' : code.charAt(0)) + this.lpad(sizePrinted ? "" : String.valueOf(size), 4));
                            } else if (this.iItype) {
                                if (this.iExternal) {
                                    linesThisPeriod.add(this.rpad(section.getSubject(), 7) + this.rpad(section.getCourseNbr(), 8) + this.rpad(section.getItype(), 9) + (sizePrinted || code == null || code.length() == 0 ? (char)' ' : code.charAt(0)) + this.lpad(sizePrinted ? "" : String.valueOf(size), 4));
                                } else {
                                    linesThisPeriod.add(this.rpad(section.getName(), 24) + (sizePrinted || code == null || code.length() == 0 ? (char)' ' : code.charAt(0)) + this.lpad(sizePrinted ? "" : String.valueOf(size), 4));
                                }
                            } else {
                                linesThisPeriod.add(this.rpad(section.getSubject(), 7) + this.rpad(section.getCourseNbr(), 8) + this.rpad(section.getSection(), 9) + (sizePrinted || code == null || code.length() == 0 ? (char)' ' : code.charAt(0)) + this.lpad(sizePrinted ? "" : String.valueOf(size), 4));
                            }
                            sizePrinted = true;
                        }
                    }
                    if (this.iCompact) {
                        if (this.iTotals) {
                            if (totalListed != total) {
                                linesThisPeriod.insertElementAt(this.mpad("(" + totalListed + ")", 13) + " " + this.lpad("" + total, 6), 0);
                            } else {
                                linesThisPeriod.insertElementAt(this.lpad("" + total, 20), 0);
                            }
                        } else {
                            linesThisPeriod.insertElementAt(this.rpad(period.getStartDateLabel(), 13) + " " + this.lpad(total == 0 ? "" : "" + total, 6), 0);
                        }
                    } else if (this.iTotals) {
                        if (totalListed != total) {
                            linesThisPeriod.insertElementAt(this.mpad("(" + totalListed + ")", 22) + " " + this.lpad("" + total, 6), 0);
                        } else {
                            linesThisPeriod.insertElementAt(this.lpad("" + total, 29), 0);
                        }
                    } else {
                        linesThisPeriod.insertElementAt(this.rpad(period.getStartDateLabel(), 22) + " " + this.lpad(total == 0 ? "" : "" + total, 6), 0);
                    }
                    max = Math.max(max, linesThisPeriod.size());
                    Integer n = (Integer)totalADay.get(period.getDateOffset());
                    totalADay.put(period.getDateOffset(), new Integer(total + (n == null ? 0 : n)));
                    lines.add(linesThisPeriod);
                }
                for (int i = 0; i < max; ++i) {
                    String line = "";
                    if (!this.iTotals) {
                        line = this.iCompact ? (i == 0 || this.iNewPage ? line + this.rpad((String)fixedTimes.get(time), 12) + this.rpad("", offset * 22) : line + this.rpad("", 12) + this.rpad("", offset * 22)) : (i == 0 || this.iNewPage ? line + this.rpad((String)fixedTimes.get(time), 11) + this.rpad("", offset * 31) : line + this.rpad("", 11) + this.rpad("", offset * 31));
                    }
                    Enumeration f4 = lines.elements();
                    while (f4.hasMoreElements()) {
                        linesThisPeriod = (Vector)f4.nextElement();
                        line = i < linesThisPeriod.size() ? line + (String)linesThisPeriod.elementAt(i) : line + this.rpad("", this.iCompact ? 20 : 29);
                        if (!f4.hasMoreElements()) continue;
                        line = line + "  ";
                    }
                    this.println(line);
                }
                this.setCont(null);
            }
            if (!this.iTotals) continue;
            if (this.getLineNumber() + 5 > this.iNrLines) {
                this.newPage();
                this.setPageName("Totals");
            } else {
                this.println("");
            }
            this.println("Total Student Exams");
            String line1 = "";
            String line2 = "";
            String line3 = "";
            int idx = 0;
            Iterator f = new TreeSet(days.keySet()).iterator();
            while (f.hasNext()) {
                int day = (Integer)f.next();
                if (idx >= dIdx && idx < dIdx + nrCols) {
                    if (this.iCompact) {
                        line1 = line1 + this.mpad((String)days.get(day), 20) + "  ";
                        line2 = line2 + "=============== ====  ";
                        line3 = line3 + this.lpad(totalADay.get(day) == null ? "" : totalADay.get(day).toString(), 20) + "  ";
                    } else {
                        line1 = line1 + this.mpad((String)days.get(day), 29) + "  ";
                        line2 = line2 + "======================== ====  ";
                        line3 = line3 + this.lpad(totalADay.get(day) == null ? "" : totalADay.get(day).toString(), 29) + "  ";
                    }
                }
                ++idx;
            }
            this.println(line1);
            this.println(line2);
            this.println(line3);
            timesThisPage = null;
        }
        this.lastPage();
    }
}

