/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status;

import com.google.protobuf.InvalidProtocolBufferException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningLog;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.model.XAcademicAreaCode;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.util.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindOnlineSectioningLogAction
implements OnlineSectioningAction<List<ClassAssignmentInterface.SectioningAction>> {
    private static final long serialVersionUID = 1L;
    private static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    private static StudentSectioningConstants CONST = Localization.create(StudentSectioningConstants.class);
    private Query iQuery;
    private Integer iLimit = 100;

    public FindOnlineSectioningLogAction forQuery(String query) {
        this.iQuery = new Query(query.isEmpty() ? "limit:100" : query);
        Matcher m = Pattern.compile("limit:[ ]?([0-9]*)", 2).matcher(query);
        if (m.find()) {
            this.iLimit = Integer.parseInt(m.group(1));
        }
        return this;
    }

    public Query getQuery() {
        return this.iQuery;
    }

    public Integer getLimit() {
        return this.iLimit;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<ClassAssignmentInterface.SectioningAction> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        helper.beginTransaction();
        try {
            ArrayList<ClassAssignmentInterface.SectioningAction> ret = new ArrayList<ClassAssignmentInterface.SectioningAction>();
            DateFormat df = Localization.getDateFormat(CONST.timeStampFormat());
            NumberFormat nf = Localization.getNumberFormat("0.00");
            AcademicSessionInfo session = server.getAcademicSession();
            org.hibernate.Query q = helper.getHibSession().createQuery("select l, s.uniqueId from OnlineSectioningLog l, Student s " + (this.getQuery().hasAttribute("area", "clasf", "classification") ? "left outer join s.academicAreaClassifications a " : "") + (this.getQuery().hasAttribute("major") ? "left outer join s.posMajors m " : "") + (this.getQuery().hasAttribute("minor") ? "left outer join s.posMinors n " : "") + (this.getQuery().hasAttribute("group") ? "left outer join s.groups g " : "") + (this.getQuery().hasAttribute("accommodation") ? "left outer join s.accomodations a " : "") + "where l.session.uniqueId = :sessionId and l.session = s.session and l.student = s.externalUniqueId " + "and (" + this.getQuery().toString(new SectioningLogQueryFormatter()) + ") " + "and (l.result is not null or l.operation not in ('reload-offering', 'check-offering')) order by l.timeStamp desc, l.uniqueId desc");
            q.setLong("sessionId", session.getUniqueId().longValue());
            if (this.getLimit() != null) {
                q.setMaxResults(this.getLimit().intValue());
            }
            for (Object[] o : q.list()) {
                try {
                    Iterator<OnlineSectioningLog.Property> s;
                    OnlineSectioningLog log = (OnlineSectioningLog)o[0];
                    XStudent student = server.getStudent((Long)o[1]);
                    if (student == null) continue;
                    ClassAssignmentInterface.Student st = new ClassAssignmentInterface.Student();
                    st.setId(student.getStudentId());
                    st.setSessionId(session.getUniqueId());
                    st.setExternalId(student.getExternalId());
                    st.setName(student.getName());
                    for (XAcademicAreaCode ac : student.getAcademicAreaClasiffications()) {
                        st.addArea(ac.getArea());
                        st.addClassification(ac.getCode());
                    }
                    for (XAcademicAreaCode ac : student.getMajors()) {
                        st.addMajor(ac.getCode());
                    }
                    for (String acc : student.getAccomodations()) {
                        st.addAccommodation(acc);
                    }
                    for (String gr : student.getGroups()) {
                        st.addGroup(gr);
                    }
                    ClassAssignmentInterface.SectioningAction a = new ClassAssignmentInterface.SectioningAction();
                    a.setStudent(st);
                    a.setTimeStamp(log.getTimeStamp());
                    a.setOperation(Constants.toInitialCase(log.getOperation().replace('-', ' ')));
                    OnlineSectioningLog.Action action = OnlineSectioningLog.Action.parseFrom(log.getAction());
                    if (action.hasCpuTime()) {
                        a.setCpuTime(action.getCpuTime());
                    }
                    if (action.hasUser()) {
                        a.setUser(action.getUser().getName());
                    }
                    if (action.hasResult()) {
                        a.setResult(Constants.toInitialCase(action.getResult().name()));
                    }
                    String html = "<table class='unitime-ChangeLog'>";
                    html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>General</td></tr>";
                    html = html + "<tr><td><b>" + MSG.colOperation() + ":</b></td><td>" + Constants.toInitialCase(log.getOperation().replace('-', ' ')) + "</td></tr>";
                    if (action.hasResult()) {
                        html = html + "<tr><td><b>" + MSG.colResult() + ":</b></td><td>" + Constants.toInitialCase(action.getResult().name()) + "</td></tr>";
                    }
                    if (action.hasStudent() && (s = server.getStudent(action.getStudent().getUniqueId())) != null) {
                        html = html + "<tr><td><b>" + MSG.colStudent() + ":</b></td><td>" + ((XStudentId)((Object)s)).getName() + "</td></tr>";
                    }
                    for (OnlineSectioningLog.Entity other : action.getOtherList()) {
                        html = html + "<tr><td><b>" + Constants.toInitialCase(other.getType().name()) + ":</b></td><td>" + other.getName() + "</td></tr>";
                    }
                    html = html + "<tr><td><b>Time Stamp:</b></td><td>" + df.format(log.getTimeStamp()) + "</td></tr>";
                    s = action.getOptionList().iterator();
                    while (s.hasNext()) {
                        OnlineSectioningLog.Property p = s.next();
                        html = html + "<tr><td><b>" + Constants.toInitialCase(p.getKey()) + ":</b></td><td><div class='property'>" + (p.hasValue() ? p.getValue() : "") + "</div></td></tr>";
                    }
                    if (action.hasCpuTime()) {
                        html = html + "<tr><td><b>" + MSG.colCpuTime() + ":</b></td><td>" + nf.format(1.0E-9 * (double)action.getCpuTime()) + "</td></tr>";
                    }
                    if (!action.getRequestList().isEmpty()) {
                        html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>" + MSG.courseRequestsCourses() + "</td></tr>";
                    }
                    String request = "";
                    String selected = "";
                    for (OnlineSectioningLog.Request r : action.getRequestList()) {
                        if (!request.isEmpty()) {
                            request = request + "<br>";
                        }
                        request = request + (r.getAlternative() ? "A" : "") + (1 + r.getPriority()) + ". ";
                        html = html + "<tr><td colspan='2'>" + (r.getAlternative() ? "A" : "") + (1 + r.getPriority()) + ". ";
                        int idx = 0;
                        for (OnlineSectioningLog.Time time : r.getFreeTimeList()) {
                            if (idx++ > 0) {
                                html = html + ", ";
                                request = request + ", ";
                            } else {
                                html = html + CONST.freePrefix() + " ";
                                request = request + CONST.freePrefix() + " ";
                            }
                            html = html + DayCode.toString(time.getDays()) + " " + this.time(time.getStart()) + " - " + this.time(time.getStart() + time.getLength());
                            request = request + DayCode.toString(time.getDays()) + " " + this.time(time.getStart()) + " - " + this.time(time.getStart() + time.getLength());
                        }
                        if (r.getFreeTimeList().isEmpty()) {
                            for (OnlineSectioningLog.Entity entity : r.getCourseList()) {
                                if (idx++ > 0) {
                                    html = html + ", ";
                                    request = request + ", ";
                                }
                                html = html + entity.getName();
                                request = request + entity.getName();
                            }
                        }
                        for (OnlineSectioningLog.Section section : r.getSectionList()) {
                            if (section.getPreference() != OnlineSectioningLog.Section.Preference.SELECTED) continue;
                            if (!selected.isEmpty()) {
                                selected = selected + "<br>";
                            }
                            String loc = "";
                            for (OnlineSectioningLog.Entity entity : section.getLocationList()) {
                                if (!loc.isEmpty()) {
                                    loc = loc + ", ";
                                }
                                loc = loc + entity.getName();
                            }
                            String instr = "";
                            for (OnlineSectioningLog.Entity e4 : section.getInstructorList()) {
                                if (!instr.isEmpty()) {
                                    instr = instr + ", ";
                                }
                                instr = instr + e4.getName();
                            }
                            selected = selected + section.getCourse().getName() + " " + section.getSubpart().getName() + " " + section.getClazz().getName() + " " + (section.hasTime() ? DayCode.toString(section.getTime().getDays()) + " " + this.time(section.getTime().getStart()) + " - " + this.time(section.getTime().getStart() + section.getTime().getLength()) : "") + " " + loc;
                        }
                    }
                    String enrollment = "";
                    HashMap<OnlineSectioningLog.Enrollment.EnrollmentType, String> enrollmentByType = new HashMap<OnlineSectioningLog.Enrollment.EnrollmentType, String>();
                    for (OnlineSectioningLog.Enrollment e5 : action.getEnrollmentList()) {
                        enrollment = "";
                        html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>" + (e5.hasType() ? Constants.toInitialCase(e5.getType().name()) + " " : "") + MSG.enrollmentsTable() + "</td></tr>";
                        html = html + "<tr><td colspan='2'><table cellspacing='0' cellpadding='2'><td class='unitime-TableHeader'>" + MSG.colCourse() + "</td>" + "<td class='unitime-TableHeader'>" + MSG.colSubject() + "</td>" + "<td class='unitime-TableHeader'>" + MSG.colClass() + "</td>" + "<td class='unitime-TableHeader'>" + MSG.colDays() + "</td>" + "<td class='unitime-TableHeader'>" + MSG.colStart() + "</td>" + "<td class='unitime-TableHeader'>" + MSG.colEnd() + "</td>" + "<td class='unitime-TableHeader'>" + MSG.colDate() + "</td>" + "<td class='unitime-TableHeader'>" + MSG.colRoom() + "</td>" + "<td class='unitime-TableHeader'>" + MSG.colInstructor() + "</td></tr>";
                        for (OnlineSectioningLog.Section s3 : e5.getSectionList()) {
                            void var25_40;
                            if (!s3.hasCourse()) continue;
                            if (!enrollment.isEmpty()) {
                                enrollment = enrollment + "<br>";
                            }
                            String loc = "";
                            for (OnlineSectioningLog.Entity r : s3.getLocationList()) {
                                if (!loc.isEmpty()) {
                                    loc = loc + ", ";
                                }
                                loc = loc + r.getName();
                            }
                            String string = "";
                            for (OnlineSectioningLog.Entity r : s3.getInstructorList()) {
                                void var25_42;
                                if (!var25_40.isEmpty()) {
                                    String string2 = (String)var25_40 + ", ";
                                }
                                String string3 = (String)var25_42 + r.getName();
                            }
                            html = html + "<tr><td>" + s3.getCourse().getName() + "</td>" + "<td>" + s3.getSubpart().getName() + "</td>" + "<td>" + s3.getClazz().getName() + "</td>" + "<td>" + (s3.hasTime() ? DayCode.toString(s3.getTime().getDays()) : "") + "</td>" + "<td>" + (s3.hasTime() ? this.time(s3.getTime().getStart()) : "") + "</td>" + "<td>" + (s3.hasTime() ? this.time(s3.getTime().getStart() + s3.getTime().getLength()) : "") + "</td>" + "<td>" + (s3.hasTime() && s3.getTime().hasPattern() ? s3.getTime().getPattern() : "") + "</td>" + "<td>" + loc + "</td>" + "<td>" + (String)var25_40 + "</td>" + "</tr>";
                            enrollment = enrollment + s3.getCourse().getName() + " " + s3.getSubpart().getName() + " " + s3.getClazz().getName() + " " + (s3.hasTime() ? DayCode.toString(s3.getTime().getDays()) + " " + this.time(s3.getTime().getStart()) : "") + " " + loc;
                        }
                        html = html + "</table></td></tr>";
                        enrollmentByType.put(e5.getType(), enrollment);
                    }
                    String message = "";
                    if (!action.getMessageList().isEmpty()) {
                        html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>" + MSG.tableMessages() + "</td></tr>";
                        for (OnlineSectioningLog.Message message2 : action.getMessageList()) {
                            if (message2.hasText()) {
                                html = html + "<tr><td><b>" + message2.getLevel().name() + ":</b></td><td>" + message2.getText() + "</td></tr>";
                                message = message2.getText();
                            }
                            if (!message2.hasException()) continue;
                            html = html + "<tr><td><b>Exception:</b></td><td>" + message2.getException() + "</td></tr>";
                            message = message2.getException();
                        }
                    }
                    html = html + "<tr><td class='unitime-MainTableHeader' colspan='2'>" + MSG.tableProto() + "</td></tr>";
                    html = html + "<tr><td colspan='2' class='proto'>" + action.toString().replace("<", "&lt;").replace(">", "&gt;").replace(" ", "&nbsp;").replace("\n", "<br>") + "</td></tr>";
                    html = html + "</table>";
                    if ("student-email".equals(log.getOperation())) {
                        for (OnlineSectioningLog.Property property : action.getOptionList()) {
                            if (!"email".equals(property.getKey()) || !property.hasValue()) continue;
                            html = property.getValue();
                        }
                    }
                    if (action.hasResult() && OnlineSectioningLog.Action.ResultType.FAILURE.equals((Object)action.getResult()) && !message.isEmpty()) {
                        a.setMessage(message);
                    } else if ("suggestions".equals(log.getOperation())) {
                        a.setMessage(selected.isEmpty() ? message : selected);
                    } else if ("section".equals(log.getOperation())) {
                        a.setMessage(request.isEmpty() ? message : request);
                    } else if (enrollmentByType.containsKey((Object)OnlineSectioningLog.Enrollment.EnrollmentType.REQUESTED)) {
                        a.setMessage((String)enrollmentByType.get((Object)OnlineSectioningLog.Enrollment.EnrollmentType.REQUESTED));
                    } else {
                        a.setMessage(enrollment.isEmpty() ? (request.isEmpty() ? message : request) : enrollment);
                    }
                    a.setProto(html);
                    ret.add(a);
                }
                catch (InvalidProtocolBufferException e) {}
            }
            helper.commitTransaction();
            return ret;
        }
        catch (Exception e) {
            helper.rollbackTransaction();
            if (e instanceof SectioningException) {
                throw (SectioningException)e;
            }
            throw new SectioningException(MSG.exceptionUnknown(e.getMessage()), e);
        }
    }

    private String time(int slot) {
        int h = slot / 12;
        int m = 5 * (slot % 12);
        if (CONST.useAmPm()) {
            return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
        }
        return h + ":" + (m < 10 ? "0" : "") + m;
    }

    @Override
    public String name() {
        return "sectioning-log";
    }

    public static class SectioningLogQueryFormatter
    implements Query.QueryFormatter {
        public String format(String attr, String body) {
            if ("id".equalsIgnoreCase(attr) || "student".equalsIgnoreCase(attr)) {
                return "s.externalUniqueId = '" + body + "'";
            }
            if ("operation".equalsIgnoreCase(attr) || "op".equalsIgnoreCase(attr)) {
                return "lower(l.operation) = '" + body.toLowerCase() + "'";
            }
            if ("max-age".equalsIgnoreCase(attr) || "age".equalsIgnoreCase(attr)) {
                return HibernateUtil.addDate("l.timeStamp", body) + " > current_date()";
            }
            if ("limit".equalsIgnoreCase(attr)) {
                return "1 = 1";
            }
            if ("area".equalsIgnoreCase(attr)) {
                return "lower(a.academicArea.academicAreaAbbreviation) = '" + body.toLowerCase() + "'";
            }
            if ("clasf".equalsIgnoreCase(attr) || "classification".equalsIgnoreCase(attr)) {
                return "lower(a.academicClassification.code) = '" + body.toLowerCase() + "'";
            }
            if ("major".equalsIgnoreCase(attr)) {
                return "lower(m.code) = '" + body.toLowerCase() + "'";
            }
            if ("minor".equalsIgnoreCase(attr)) {
                return "lower(n.code) = '" + body.toLowerCase() + "'";
            }
            if ("group".equalsIgnoreCase(attr)) {
                return "lower(g.groupAbbreviation) = '" + body.toLowerCase() + "'";
            }
            if ("accommodation".equalsIgnoreCase(attr)) {
                return "lower(a.abbreviation) = '" + body.toLowerCase() + "'";
            }
            if ("user".equalsIgnoreCase(attr)) {
                return "none".equalsIgnoreCase(body) ? "l.user is null" : "l.user = '" + body + "'";
            }
            if ("result".equalsIgnoreCase(attr)) {
                for (OnlineSectioningLog.Action.ResultType t : OnlineSectioningLog.Action.ResultType.values()) {
                    if (!t.name().equalsIgnoreCase(body)) continue;
                    return "l.result = " + t.getNumber();
                }
                if ("none".equalsIgnoreCase(body) || "unknown".equalsIgnoreCase(body)) {
                    return "l.result is null";
                }
                return "1 = 1";
            }
            if ("status".equalsIgnoreCase(attr)) {
                if ("Not Set".equalsIgnoreCase(body)) {
                    return "s.sectioningStatus is null";
                }
                return "s.sectioningStatus.reference = '" + body.toLowerCase() + "'";
            }
            if (!body.isEmpty()) {
                return "lower(s.firstName || ' ' || s.middleName || ' ' || s.lastName) like '%" + body.toLowerCase() + "%'";
            }
            return "1 = 1";
        }
    }
}

