/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.comparators;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassComparator
implements Comparator<Class_> {
    private Long subjectUID = null;
    public static final short COMPARE_BY_ID = 1;
    public static final short COMPARE_BY_LABEL = 2;
    public static final short COMPARE_BY_ITYPE = 3;
    public static final short COMPARE_BY_SUBJ_NBR_ITYP_SEC = 4;
    public static final short COMPARE_BY_HIERARCHY = 5;
    private short compareBy;

    public ClassComparator(Long subjectUID, short compareBy) {
        this.subjectUID = subjectUID;
        this.compareBy = compareBy;
    }

    public ClassComparator(short compareBy) {
        this(null, compareBy);
    }

    public static int compare(Comparable c1, Comparable c2) {
        return c1 == null ? (c2 == null ? 0 : -1) : (c2 == null ? 1 : c1.compareTo(c2));
    }

    public static int compareInstructors(List<DepartmentalInstructor> i1, List<DepartmentalInstructor> i2) {
        if (i1.isEmpty() || i2.isEmpty()) {
            return Double.compare(i1.size(), i2.size());
        }
        if (i1.size() > 1) {
            Collections.sort(i1);
        }
        if (i2.size() > 1) {
            Collections.sort(i2);
        }
        for (int i = 0; i < Math.min(i1.size(), i2.size()); ++i) {
            int cmp = ClassComparator.compare(i1.get(i), i2.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return Double.compare(i1.size(), i2.size());
    }

    public boolean isParentSameIType(SchedulingSubpart s1, SchedulingSubpart s2) {
        SchedulingSubpart p1 = s1.getParentSubpart();
        if (p1 == null) {
            return false;
        }
        if (p1.equals(s2)) {
            return true;
        }
        if (!p1.getItype().equals(s2.getItype())) {
            return false;
        }
        return this.isParentSameIType(p1, s2);
    }

    @Override
    public int compare(Class_ c1, Class_ c2) {
        int cmp = 0;
        switch (this.compareBy) {
            case 2: {
                cmp = c1.getSchedulingSubpart().getSchedulingSubpartLabel().compareTo(c1.getSchedulingSubpart().getSchedulingSubpartLabel());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = c1.getClassLabel().compareTo(c2.getClassLabel());
                if (cmp != 0) {
                    return cmp;
                }
            }
            case 3: {
                cmp = c1.getSchedulingSubpart().getItype().getItype().compareTo(c2.getSchedulingSubpart().getItype().getItype());
                if (cmp != 0) {
                    return cmp;
                }
            }
            case 5: {
                if (!c1.getSchedulingSubpart().equals(c2.getSchedulingSubpart())) {
                    SchedulingSubpartComparator comparator = new SchedulingSubpartComparator(this.subjectUID);
                    return comparator.compare(c1.getSchedulingSubpart(), c2.getSchedulingSubpart());
                }
                cmp = c1.getSectionNumber().compareTo(c2.getSectionNumber());
                if (cmp != 0) {
                    return cmp;
                }
            }
            case 4: {
                cmp = c1.getSchedulingSubpart().getControllingCourseOffering().getCourseName().compareTo(c2.getSchedulingSubpart().getControllingCourseOffering().getCourseName());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = c1.getSchedulingSubpart().getItype().getItype().compareTo(c2.getSchedulingSubpart().getItype().getItype());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = c1.getSectionNumber().compareTo(c2.getSectionNumber());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = c1.getSchedulingSubpart().getSchedulingSubpartSuffix().compareTo(c2.getSchedulingSubpart().getSchedulingSubpartSuffix());
                if (cmp == 0) break;
                return cmp;
            }
        }
        return c1.getUniqueId().compareTo(c2.getUniqueId());
    }

    public Long getSubjectUID() {
        return this.subjectUID;
    }

    public void setSubjectUID(Long subjectUID) {
        this.subjectUID = subjectUID;
    }
}

