/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.List;
import java.util.Properties;
import org.hibernate.Session;
import org.unitime.timetable.model.base.BaseSessionConfig;
import org.unitime.timetable.model.dao.SessionConfigDAO;
import org.unitime.timetable.model.dao._RootDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionConfig
extends BaseSessionConfig {
    private static final long serialVersionUID = 1L;

    public static SessionConfig getConfig(String key, Long sessionId) {
        if (sessionId == null) {
            return null;
        }
        return (SessionConfig)SessionConfigDAO.getInstance().getSession().createQuery("from SessionConfig where key = :key and session.uniqueId = :sessionId").setString("key", key).setLong("sessionId", sessionId.longValue()).setCacheable(true).uniqueResult();
    }

    public static List<SessionConfig> findAll(Long sessionId) {
        return SessionConfigDAO.getInstance().getSession().createQuery("from SessionConfig where session.uniqueId = :sessionId order by key").setLong("sessionId", sessionId.longValue()).setCacheable(true).list();
    }

    public static String getConfigValue(String key, Long sessionId, String defaultValue) {
        if (!_RootDAO.isConfigured() || sessionId == null) {
            return defaultValue;
        }
        String value = (String)SessionConfigDAO.getInstance().getSession().createQuery("select value from SessionConfig where key = :key and session.uniqueId = :sessionId").setString("key", key).setLong("sessionId", sessionId.longValue()).setCacheable(true).uniqueResult();
        return value == null ? defaultValue : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties toProperties(Long sessionId) {
        Properties properties = new Properties();
        if (!_RootDAO.isConfigured() || sessionId == null) {
            return properties;
        }
        Session hibSession = SessionConfigDAO.getInstance().createNewSession();
        try {
            for (SessionConfig config : hibSession.createQuery("from SessionConfig where session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).setCacheable(true).list()) {
                properties.setProperty(config.getKey(), config.getValue() == null ? "" : config.getValue());
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            hibSession.close();
            throw throwable;
        }
        hibSession.close();
        return properties;
    }
}

