/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.unitime.timetable.model.base.BasePosMajor;
import org.unitime.timetable.model.dao.PosMajorDAO;

public class PosMajor
extends BasePosMajor {
    private static final long serialVersionUID = 1L;
    public static String POSMAJOR_ATTR_NAME = "posMajorList";

    public PosMajor() {
    }

    public PosMajor(Long uniqueId) {
        super(uniqueId);
    }

    public static List getPosMajorList(Long sessionId) {
        Session hibSession = new PosMajorDAO().getSession();
        String query = "from PosMajor where academicArea.sessionId=:acadSessionId order by name";
        Query q = hibSession.createQuery(query);
        q.setLong("acadSessionId", sessionId.longValue());
        return q.list();
    }

    public String getLabelNameCode() {
        return this.getName() + " - " + this.getCode();
    }

    public String getLabelCodeName() {
        return this.getCode() + " - " + this.getName();
    }

    public static PosMajor findByCode(Long sessionId, String code) {
        return (PosMajor)new PosMajorDAO().getSession().createQuery("select a from PosMajor a where a.session.uniqueId=:sessionId and a.code=:code").setLong("sessionId", sessionId.longValue()).setString("code", code).setCacheable(true).uniqueResult();
    }

    public static PosMajor findByExternalIdAcadAreaExternalId(Long sessionId, String externalId, String academicArea) {
        return PosMajor.findByExternalIdAcadAreaExternalId(new PosMajorDAO().getSession(), sessionId, externalId, academicArea);
    }

    public static PosMajor findByExternalIdAcadAreaExternalId(Session hibSession, Long sessionId, String externalId, String academicArea) {
        return (PosMajor)hibSession.createQuery("select a from PosMajor a inner join a.academicAreas as areas where a.session.uniqueId=:sessionId and a.externalUniqueId=:externalUniqueId and areas.externalUniqueId = :academicArea").setLong("sessionId", sessionId.longValue()).setString("externalUniqueId", externalId).setString("academicArea", academicArea).setCacheable(true).uniqueResult();
    }

    public static PosMajor findByCodeAcadAreaId(Long sessionId, String code, Long areaId) {
        if (areaId == null) {
            return PosMajor.findByCode(sessionId, code);
        }
        return (PosMajor)new PosMajorDAO().getSession().createQuery("select p from PosMajor p inner join p.academicAreas a where p.session.uniqueId=:sessionId and a.uniqueId=:areaId and p.code=:code").setLong("sessionId", sessionId.longValue()).setLong("areaId", areaId.longValue()).setString("code", code).setCacheable(true).uniqueResult();
    }

    public static PosMajor findByCodeAcadAreaAbbv(Long sessionId, String code, String areaAbbv) {
        return PosMajor.findByCodeAcadAreaAbbv(new PosMajorDAO().getSession(), sessionId, code, areaAbbv);
    }

    public static PosMajor findByCodeAcadAreaAbbv(Session hibSession, Long sessionId, String code, String areaAbbv) {
        if (areaAbbv == null || areaAbbv.trim().length() == 0) {
            return PosMajor.findByCode(sessionId, code);
        }
        return (PosMajor)hibSession.createQuery("select p from PosMajor p inner join p.academicAreas a where p.session.uniqueId=:sessionId and a.academicAreaAbbreviation=:areaAbbv and p.code=:code").setLong("sessionId", sessionId.longValue()).setString("areaAbbv", areaAbbv).setString("code", code).setCacheable(true).uniqueResult();
    }

    public Object clone() {
        PosMajor m = new PosMajor();
        m.setExternalUniqueId(this.getExternalUniqueId());
        m.setCode(this.getCode());
        m.setName(this.getName());
        return m;
    }
}

