/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.base.BaseExamOwner;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.ExamOwnerDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamOwner
extends BaseExamOwner
implements Comparable<ExamOwner> {
    private static final long serialVersionUID = 1L;
    public static final int sOwnerTypeClass = 3;
    public static final int sOwnerTypeConfig = 2;
    public static final int sOwnerTypeCourse = 1;
    public static final int sOwnerTypeOffering = 0;
    public static String[] sOwnerTypes = new String[]{"Offering", "Course", "Config", "Class"};
    private Object iOwnerObject = null;

    public ExamOwner() {
    }

    public ExamOwner(Long uniqueId) {
        super(uniqueId);
    }

    public static ExamOwner findByOwnerIdType(Long ownerId, Integer ownerType) {
        return (ExamOwner)new ExamOwnerDAO().getSession().createQuery("select o from ExamOwner o where o.ownerId=:ownerId and o.ownerType=:ownerType").setLong("ownerId", ownerId.longValue()).setInteger("ownerType", ownerType.intValue()).setCacheable(true).uniqueResult();
    }

    public Object getOwnerObject() {
        if (this.iOwnerObject != null) {
            return this.iOwnerObject;
        }
        switch (this.getOwnerType()) {
            case 3: {
                this.iOwnerObject = new Class_DAO().get(this.getOwnerId());
                return this.iOwnerObject;
            }
            case 2: {
                this.iOwnerObject = new InstrOfferingConfigDAO().get(this.getOwnerId());
                return this.iOwnerObject;
            }
            case 1: {
                this.iOwnerObject = new CourseOfferingDAO().get(this.getOwnerId());
                return this.iOwnerObject;
            }
            case 0: {
                this.iOwnerObject = new InstructionalOfferingDAO().get(this.getOwnerId());
                return this.iOwnerObject;
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    public void setOwner(Class_ clazz) {
        this.setOwnerId(clazz.getUniqueId());
        this.setOwnerType(3);
        this.setCourse(clazz.getSchedulingSubpart().getInstrOfferingConfig().getControllingCourseOffering());
    }

    public void setOwner(InstrOfferingConfig config) {
        this.setOwnerId(config.getUniqueId());
        this.setOwnerType(2);
        this.setCourse(config.getControllingCourseOffering());
    }

    public void setOwner(CourseOffering course) {
        this.setOwnerId(course.getUniqueId());
        this.setOwnerType(1);
        this.setCourse(course);
    }

    public void setOwner(InstructionalOffering offering) {
        this.setOwnerId(offering.getUniqueId());
        this.setOwnerType(0);
        this.setCourse(offering.getControllingCourseOffering());
    }

    public CourseOffering computeCourse() {
        Object owner = this.getOwnerObject();
        switch (this.getOwnerType()) {
            case 3: {
                return ((Class_)owner).getSchedulingSubpart().getControllingCourseOffering();
            }
            case 2: {
                return ((InstrOfferingConfig)owner).getControllingCourseOffering();
            }
            case 1: {
                return (CourseOffering)owner;
            }
            case 0: {
                return ((InstructionalOffering)owner).getControllingCourseOffering();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    @Override
    public int compareTo(ExamOwner owner) {
        CourseOffering c1 = this.getCourse();
        CourseOffering c2 = owner.getCourse();
        int cmp = 0;
        cmp = c1.getSubjectAreaAbbv().compareTo(c2.getSubjectAreaAbbv());
        if (cmp != 0) {
            return cmp;
        }
        cmp = c1.getCourseNbr().compareTo(c2.getCourseNbr());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getOwnerType().compareTo(owner.getOwnerType());
        if (cmp != 0) {
            return cmp;
        }
        switch (this.getOwnerType()) {
            case 3: {
                return new ClassComparator(5).compare((Class_)this.getOwnerObject(), (Class_)owner.getOwnerObject());
            }
            case 2: {
                return new InstrOfferingConfigComparator(null).compare(this.getOwnerObject(), owner.getOwnerObject());
            }
        }
        return this.getOwnerId().compareTo(owner.getOwnerId());
    }

    public List getStudents() {
        switch (this.getOwnerType()) {
            case 3: {
                return new ExamOwnerDAO().getSession().createQuery("select distinct e.student from StudentClassEnrollment e inner join e.clazz c  where c.uniqueId = :examOwnerId").setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 2: {
                return new ExamOwnerDAO().getSession().createQuery("select distinct e.student from StudentClassEnrollment e inner join e.clazz c  where c.schedulingSubpart.instrOfferingConfig.uniqueId = :examOwnerId").setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 1: {
                return new ExamOwnerDAO().getSession().createQuery("select distinct e.student from StudentClassEnrollment e inner join e.courseOffering co  where co.uniqueId = :examOwnerId").setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 0: {
                return new ExamOwnerDAO().getSession().createQuery("select distinct e.student from StudentClassEnrollment e inner join e.courseOffering co  where co.instructionalOffering.uniqueId = :examOwnerId").setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    public Collection<StudentClassEnrollment> getStudentClassEnrollments() {
        switch (this.getOwnerType()) {
            case 3: {
                return new ExamOwnerDAO().getSession().createQuery("select distinct e from StudentClassEnrollment e, StudentClassEnrollment f where f.clazz.uniqueId = :classId and e.courseOffering.instructionalOffering = f.courseOffering.instructionalOffering and e.student = f.student").setLong("classId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 2: {
                return new ExamOwnerDAO().getSession().createQuery("select distinct e from StudentClassEnrollment e, StudentClassEnrollment f where f.clazz.schedulingSubpart.instrOfferingConfig.uniqueId = :configId and e.courseOffering.instructionalOffering = f.courseOffering.instructionalOffering and e.student = f.student").setLong("configId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 1: {
                return new ExamOwnerDAO().getSession().createQuery("select e from StudentClassEnrollment e where e.courseOffering.uniqueId = :courseId").setLong("courseId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 0: {
                return new ExamOwnerDAO().getSession().createQuery("select e from StudentClassEnrollment e where e.courseOffering.instructionalOffering.uniqueId = :offeringId").setLong("offeringId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    public List getStudentIds() {
        switch (this.getOwnerType()) {
            case 3: {
                return new ExamOwnerDAO().getSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e inner join e.clazz c  where c.uniqueId = :examOwnerId").setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 2: {
                return new ExamOwnerDAO().getSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e inner join e.clazz c  where c.schedulingSubpart.instrOfferingConfig.uniqueId = :examOwnerId").setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 1: {
                return new ExamOwnerDAO().getSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e inner join e.courseOffering co  where co.uniqueId = :examOwnerId").setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
            case 0: {
                return new ExamOwnerDAO().getSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e inner join e.courseOffering co  where co.instructionalOffering.uniqueId = :examOwnerId").setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    public List getStudentIds(CourseOffering co) {
        switch (this.getOwnerType()) {
            case 3: {
                return new ExamOwnerDAO().getSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e inner join e.clazz c  where c.uniqueId = :examOwnerId and e.courseOffering.uniqueId=:courseOfferingId").setLong("examOwnerId", this.getOwnerId().longValue()).setLong("courseOfferingId", co.getUniqueId().longValue()).setCacheable(true).list();
            }
            case 2: {
                return new ExamOwnerDAO().getSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e inner join e.clazz c  where c.schedulingSubpart.instrOfferingConfig.uniqueId = :examOwnerId and e.courseOffering.uniqueId=:courseOfferingId").setLong("examOwnerId", this.getOwnerId().longValue()).setLong("courseOfferingId", co.getUniqueId().longValue()).setCacheable(true).list();
            }
            case 1: {
                return new ExamOwnerDAO().getSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e inner join e.courseOffering co  where co.uniqueId = :examOwnerId and e.courseOffering.uniqueId=:courseOfferingId").setLong("examOwnerId", this.getOwnerId().longValue()).setLong("courseOfferingId", co.getUniqueId().longValue()).setCacheable(true).list();
            }
            case 0: {
                return new ExamOwnerDAO().getSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e inner join e.courseOffering co  where co.instructionalOffering.uniqueId = :examOwnerId and e.courseOffering.uniqueId=:courseOfferingId").setLong("examOwnerId", this.getOwnerId().longValue()).setLong("courseOfferingId", co.getUniqueId().longValue()).setCacheable(true).list();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    protected void computeStudentExams(Hashtable<Long, Set<Exam>> studentExams) {
        switch (this.getOwnerType()) {
            case 3: {
                Set<Exam> exams;
                Exam exam;
                Long studentId;
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, o.exam from ExamOwner o, StudentClassEnrollment f, StudentClassEnrollment e inner join e.clazz c where c.uniqueId = :examOwnerId and e.student=f.student and o.ownerType=:ownerType and o.ownerId=f.clazz.uniqueId and o.exam.examType.uniqueId=:examTypeId").setInteger("ownerType", 3).setLong("examTypeId", this.getExam().getExamType().getUniqueId().longValue()).setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    studentId = (Long)o[0];
                    exam = (Exam)o[1];
                    exams = studentExams.get(studentId);
                    if (exams == null) {
                        exams = new HashSet<Exam>();
                        studentExams.put(studentId, exams);
                    }
                    exams.add(exam);
                }
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, o.exam from ExamOwner o, StudentClassEnrollment f, StudentClassEnrollment e inner join e.clazz c where c.uniqueId = :examOwnerId and e.student=f.student and o.ownerType=:ownerType and o.ownerId=f.clazz.schedulingSubpart.instrOfferingConfig.uniqueId and o.exam.examType.uniqueId=:examTypeId").setInteger("ownerType", 2).setLong("examTypeId", this.getExam().getExamType().getUniqueId().longValue()).setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    studentId = (Long)o[0];
                    exam = (Exam)o[1];
                    exams = studentExams.get(studentId);
                    if (exams == null) {
                        exams = new HashSet<Exam>();
                        studentExams.put(studentId, exams);
                    }
                    exams.add(exam);
                }
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, o.exam from ExamOwner o, StudentClassEnrollment f, StudentClassEnrollment e inner join e.clazz c where c.uniqueId = :examOwnerId and e.student=f.student and o.ownerType=:ownerType and o.ownerId=f.courseOffering.uniqueId and o.exam.examType.uniqueId=:examTypeId").setInteger("ownerType", 1).setLong("examTypeId", this.getExam().getExamType().getUniqueId().longValue()).setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    studentId = (Long)o[0];
                    exam = (Exam)o[1];
                    exams = studentExams.get(studentId);
                    if (exams == null) {
                        exams = new HashSet<Exam>();
                        studentExams.put(studentId, exams);
                    }
                    exams.add(exam);
                }
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, o.exam from ExamOwner o, StudentClassEnrollment f, StudentClassEnrollment e inner join e.clazz c where c.uniqueId = :examOwnerId and e.student=f.student and o.ownerType=:ownerType and o.ownerId=f.courseOffering.instructionalOffering.uniqueId and o.exam.examType.uniqueId=:examTypeId").setInteger("ownerType", 0).setLong("examTypeId", this.getExam().getExamType().getUniqueId().longValue()).setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    studentId = (Long)o[0];
                    exam = (Exam)o[1];
                    exams = studentExams.get(studentId);
                    if (exams == null) {
                        exams = new HashSet<Exam>();
                        studentExams.put(studentId, exams);
                    }
                    exams.add(exam);
                }
                break;
            }
            case 2: {
                Set<Exam> exams;
                Exam exam;
                Long studentId;
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, o.exam from ExamOwner o, StudentClassEnrollment f, StudentClassEnrollment e inner join e.clazz c where c.schedulingSubpart.instrOfferingConfig.uniqueId = :examOwnerId and e.student=f.student and o.ownerType=:ownerType and o.ownerId=f.clazz.uniqueId and o.exam.examType.uniqueId=:examTypeId").setInteger("ownerType", 3).setLong("examTypeId", this.getExam().getExamType().getUniqueId().longValue()).setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    studentId = (Long)o[0];
                    exam = (Exam)o[1];
                    exams = studentExams.get(studentId);
                    if (exams == null) {
                        exams = new HashSet<Exam>();
                        studentExams.put(studentId, exams);
                    }
                    exams.add(exam);
                }
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, o.exam from ExamOwner o, StudentClassEnrollment f, StudentClassEnrollment e inner join e.clazz c where c.schedulingSubpart.instrOfferingConfig.uniqueId = :examOwnerId and e.student=f.student and o.ownerType=:ownerType and o.ownerId=f.clazz.schedulingSubpart.instrOfferingConfig.uniqueId and o.exam.examType.uniqueId=:examTypeId").setInteger("ownerType", 2).setLong("examTypeId", this.getExam().getExamType().getUniqueId().longValue()).setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    studentId = (Long)o[0];
                    exam = (Exam)o[1];
                    exams = studentExams.get(studentId);
                    if (exams == null) {
                        exams = new HashSet<Exam>();
                        studentExams.put(studentId, exams);
                    }
                    exams.add(exam);
                }
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, o.exam from ExamOwner o, StudentClassEnrollment f, StudentClassEnrollment e inner join e.clazz c where c.schedulingSubpart.instrOfferingConfig.uniqueId = :examOwnerId and e.student=f.student and o.ownerType=:ownerType and o.ownerId=f.courseOffering.uniqueId and o.exam.examType.uniqueId=:examTypeId").setInteger("ownerType", 1).setLong("examTypeId", this.getExam().getExamType().getUniqueId().longValue()).setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    studentId = (Long)o[0];
                    exam = (Exam)o[1];
                    exams = studentExams.get(studentId);
                    if (exams == null) {
                        exams = new HashSet<Exam>();
                        studentExams.put(studentId, exams);
                    }
                    exams.add(exam);
                }
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, o.exam from ExamOwner o, StudentClassEnrollment f, StudentClassEnrollment e inner join e.clazz c where c.schedulingSubpart.instrOfferingConfig.uniqueId = :examOwnerId and e.student=f.student and o.ownerType=:ownerType and o.ownerId=f.courseOffering.instructionalOffering.uniqueId and o.exam.examType.uniqueId=:examTypeId").setInteger("ownerType", 0).setLong("examTypeId", this.getExam().getExamType().getUniqueId().longValue()).setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    studentId = (Long)o[0];
                    exam = (Exam)o[1];
                    exams = studentExams.get(studentId);
                    if (exams == null) {
                        exams = new HashSet<Exam>();
                        studentExams.put(studentId, exams);
                    }
                    exams.add(exam);
                }
                break;
            }
            case 1: {
                Set<Exam> exams;
                Exam exam;
                Long studentId;
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, o.exam from ExamOwner o, StudentClassEnrollment f, StudentClassEnrollment e inner join e.courseOffering co where co.uniqueId = :examOwnerId and e.student=f.student and o.ownerType=:ownerType and o.ownerId=f.clazz.uniqueId and o.exam.examType.uniqueId=:examTypeId").setInteger("ownerType", 3).setLong("examTypeId", this.getExam().getExamType().getUniqueId().longValue()).setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    studentId = (Long)o[0];
                    exam = (Exam)o[1];
                    exams = studentExams.get(studentId);
                    if (exams == null) {
                        exams = new HashSet<Exam>();
                        studentExams.put(studentId, exams);
                    }
                    exams.add(exam);
                }
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, o.exam from ExamOwner o, StudentClassEnrollment f, StudentClassEnrollment e inner join e.courseOffering co where co.uniqueId = :examOwnerId and e.student=f.student and o.ownerType=:ownerType and o.ownerId=f.clazz.schedulingSubpart.instrOfferingConfig.uniqueId and o.exam.examType.uniqueId=:examTypeId").setInteger("ownerType", 2).setLong("examTypeId", this.getExam().getExamType().getUniqueId().longValue()).setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    studentId = (Long)o[0];
                    exam = (Exam)o[1];
                    exams = studentExams.get(studentId);
                    if (exams == null) {
                        exams = new HashSet<Exam>();
                        studentExams.put(studentId, exams);
                    }
                    exams.add(exam);
                }
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, o.exam from ExamOwner o, StudentClassEnrollment f, StudentClassEnrollment e inner join e.courseOffering co where co.uniqueId = :examOwnerId and e.student=f.student and  o.ownerType=:ownerType and o.ownerId=f.courseOffering.uniqueId and o.exam.examType.uniqueId=:examTypeId").setInteger("ownerType", 1).setLong("examTypeId", this.getExam().getExamType().getUniqueId().longValue()).setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    studentId = (Long)o[0];
                    exam = (Exam)o[1];
                    exams = studentExams.get(studentId);
                    if (exams == null) {
                        exams = new HashSet<Exam>();
                        studentExams.put(studentId, exams);
                    }
                    exams.add(exam);
                }
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, o.exam from ExamOwner o, StudentClassEnrollment f, StudentClassEnrollment e inner join e.courseOffering co where co.uniqueId = :examOwnerId and e.student=f.student and o.ownerType=:ownerType and o.ownerId=f.courseOffering.instructionalOffering.uniqueId and o.exam.examType.uniqueId=:examTypeId").setInteger("ownerType", 0).setLong("examTypeId", this.getExam().getExamType().getUniqueId().longValue()).setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    studentId = (Long)o[0];
                    exam = (Exam)o[1];
                    exams = studentExams.get(studentId);
                    if (exams == null) {
                        exams = new HashSet<Exam>();
                        studentExams.put(studentId, exams);
                    }
                    exams.add(exam);
                }
                break;
            }
            case 0: {
                Set<Exam> exams;
                Exam exam;
                Long studentId;
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, o.exam from ExamOwner o, StudentClassEnrollment f, StudentClassEnrollment e inner join e.courseOffering co where co.instructionalOffering.uniqueId = :examOwnerId and e.student=f.student and o.ownerType=:ownerType and o.ownerId=f.clazz.uniqueId and o.exam.examType.uniqueId=:examTypeId").setInteger("ownerType", 3).setLong("examTypeId", this.getExam().getExamType().getUniqueId().longValue()).setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    studentId = (Long)o[0];
                    exam = (Exam)o[1];
                    exams = studentExams.get(studentId);
                    if (exams == null) {
                        exams = new HashSet<Exam>();
                        studentExams.put(studentId, exams);
                    }
                    exams.add(exam);
                }
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, o.exam from ExamOwner o, StudentClassEnrollment f, StudentClassEnrollment e inner join e.courseOffering co where co.instructionalOffering.uniqueId = :examOwnerId and e.student=f.student and o.ownerType=:ownerType and o.ownerId=f.clazz.schedulingSubpart.instrOfferingConfig.uniqueId and o.exam.examType.uniqueId=:examTypeId").setInteger("ownerType", 2).setLong("examTypeId", this.getExam().getExamType().getUniqueId().longValue()).setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    studentId = (Long)o[0];
                    exam = (Exam)o[1];
                    exams = studentExams.get(studentId);
                    if (exams == null) {
                        exams = new HashSet<Exam>();
                        studentExams.put(studentId, exams);
                    }
                    exams.add(exam);
                }
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, o.exam from ExamOwner o, StudentClassEnrollment f, StudentClassEnrollment e inner join e.courseOffering co where co.instructionalOffering.uniqueId = :examOwnerId and e.student=f.student and o.ownerType=:ownerType and o.ownerId=f.courseOffering.uniqueId and o.exam.examType.uniqueId=:examTypeId").setInteger("ownerType", 1).setLong("examTypeId", this.getExam().getExamType().getUniqueId().longValue()).setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    studentId = (Long)o[0];
                    exam = (Exam)o[1];
                    exams = studentExams.get(studentId);
                    if (exams == null) {
                        exams = new HashSet<Exam>();
                        studentExams.put(studentId, exams);
                    }
                    exams.add(exam);
                }
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, o.exam from ExamOwner o, StudentClassEnrollment f, StudentClassEnrollment e inner join e.courseOffering co where co.instructionalOffering.uniqueId = :examOwnerId and e.student=f.student and o.ownerType=:ownerType and o.ownerId=f.courseOffering.instructionalOffering.uniqueId and o.exam.examType.uniqueId=:examTypeId").setInteger("ownerType", 0).setLong("examTypeId", this.getExam().getExamType().getUniqueId().longValue()).setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    studentId = (Long)o[0];
                    exam = (Exam)o[1];
                    exams = studentExams.get(studentId);
                    if (exams == null) {
                        exams = new HashSet<Exam>();
                        studentExams.put(studentId, exams);
                    }
                    exams.add(exam);
                }
                break;
            }
        }
    }

    protected void computeStudentAssignments(Hashtable<Assignment, Set<Long>> studentAssignments) {
        switch (this.getOwnerType()) {
            case 3: {
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, a from Assignment a, StudentClassEnrollment f, StudentClassEnrollment e inner join e.clazz c where c.uniqueId = :examOwnerId and e.student=f.student and f.clazz = a.clazz and a.solution.commited = true").setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    Long studentId = (Long)o[0];
                    Assignment assignment = (Assignment)o[1];
                    Set<Long> students = studentAssignments.get(assignment);
                    if (students == null) {
                        students = new HashSet<Long>();
                        studentAssignments.put(assignment, students);
                    }
                    students.add(studentId);
                }
                break;
            }
            case 2: {
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, a from Assignment a, StudentClassEnrollment f, StudentClassEnrollment e inner join e.clazz c where c.schedulingSubpart.instrOfferingConfig.uniqueId = :examOwnerId and e.student=f.student and f.clazz = a.clazz and a.solution.commited = true").setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    Long studentId = (Long)o[0];
                    Assignment assignment = (Assignment)o[1];
                    Set<Long> students = studentAssignments.get(assignment);
                    if (students == null) {
                        students = new HashSet<Long>();
                        studentAssignments.put(assignment, students);
                    }
                    students.add(studentId);
                }
                break;
            }
            case 1: {
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, a from Assignment a, StudentClassEnrollment f, StudentClassEnrollment e inner join e.courseOffering co where co.uniqueId = :examOwnerId and e.student=f.student and f.clazz = a.clazz and a.solution.commited = true").setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    Long studentId = (Long)o[0];
                    Assignment assignment = (Assignment)o[1];
                    Set<Long> students = studentAssignments.get(assignment);
                    if (students == null) {
                        students = new HashSet<Long>();
                        studentAssignments.put(assignment, students);
                    }
                    students.add(studentId);
                }
                break;
            }
            case 0: {
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, a from Assignment a, StudentClassEnrollment f, StudentClassEnrollment e inner join e.courseOffering co where co.instructionalOffering.uniqueId = :examOwnerId and e.student=f.student and f.clazz = a.clazz and a.solution.commited = true").setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).list()) {
                    Long studentId = (Long)o[0];
                    Assignment assignment = (Assignment)o[1];
                    Set<Long> students = studentAssignments.get(assignment);
                    if (students == null) {
                        students = new HashSet<Long>();
                        studentAssignments.put(assignment, students);
                    }
                    students.add(studentId);
                }
                break;
            }
        }
    }

    protected void computeOverlappingStudentMeetings(Hashtable<Meeting, Set<Long>> studentMeetings, Long periodId) {
        switch (this.getOwnerType()) {
            case 3: {
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, m from ClassEvent ce inner join ce.meetings m inner join ce.clazz.studentEnrollments f, StudentClassEnrollment e inner join e.clazz c, ExamPeriod p where c.uniqueId = :examOwnerId and e.student=f.student and p.uniqueId=:periodId and p.startSlot - :travelTime < m.stopPeriod and m.startPeriod < p.startSlot + p.length + :travelTime and " + HibernateUtil.addDate("p.session.examBeginDate", "p.dateOffset") + " = m.meetingDate").setLong("examOwnerId", this.getOwnerId().longValue()).setInteger("travelTime", ApplicationProperty.ExaminationTravelTimeClass.intValue().intValue()).setLong("periodId", periodId.longValue()).setCacheable(true).list()) {
                    Long studentId = (Long)o[0];
                    Meeting meeting = (Meeting)o[1];
                    Set<Long> students = studentMeetings.get(meeting);
                    if (students == null) {
                        students = new HashSet<Long>();
                        studentMeetings.put(meeting, students);
                    }
                    students.add(studentId);
                }
                break;
            }
            case 2: {
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, m from ClassEvent ce inner join ce.meetings m inner join ce.clazz.studentEnrollments f, StudentClassEnrollment e inner join e.clazz c, ExamPeriod p where c.schedulingSubpart.instrOfferingConfig.uniqueId = :examOwnerId and e.student=f.student and p.uniqueId=:periodId and p.startSlot - :travelTime < m.stopPeriod and m.startPeriod < p.startSlot + p.length + :travelTime and " + HibernateUtil.addDate("p.session.examBeginDate", "p.dateOffset") + " = m.meetingDate").setLong("examOwnerId", this.getOwnerId().longValue()).setInteger("travelTime", ApplicationProperty.ExaminationTravelTimeClass.intValue().intValue()).setLong("periodId", periodId.longValue()).setCacheable(true).list()) {
                    Long studentId = (Long)o[0];
                    Meeting meeting = (Meeting)o[1];
                    Set<Long> students = studentMeetings.get(meeting);
                    if (students == null) {
                        students = new HashSet<Long>();
                        studentMeetings.put(meeting, students);
                    }
                    students.add(studentId);
                }
                break;
            }
            case 1: {
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, m from ClassEvent ce inner join ce.meetings m inner join ce.clazz.studentEnrollments f, StudentClassEnrollment e inner join e.courseOffering co, ExamPeriod p where co.uniqueId = :examOwnerId and e.student=f.student and p.uniqueId=:periodId and p.startSlot - :travelTime < m.stopPeriod and m.startPeriod < p.startSlot + p.length + :travelTime and " + HibernateUtil.addDate("p.session.examBeginDate", "p.dateOffset") + " = m.meetingDate").setLong("examOwnerId", this.getOwnerId().longValue()).setInteger("travelTime", ApplicationProperty.ExaminationTravelTimeClass.intValue().intValue()).setLong("periodId", periodId.longValue()).setCacheable(true).list()) {
                    Long studentId = (Long)o[0];
                    Meeting meeting = (Meeting)o[1];
                    Set<Long> students = studentMeetings.get(meeting);
                    if (students == null) {
                        students = new HashSet<Long>();
                        studentMeetings.put(meeting, students);
                    }
                    students.add(studentId);
                }
                break;
            }
            case 0: {
                for (Object[] o : new ExamOwnerDAO().getSession().createQuery("select e.student.uniqueId, m from ClassEvent ce inner join ce.meetings m inner join ce.clazz.studentEnrollments f, StudentClassEnrollment e inner join e.courseOffering co, ExamPeriod p where co.instructionalOffering.uniqueId = :examOwnerId and e.student=f.student and p.uniqueId=:periodId and p.startSlot - :travelTime < m.stopPeriod and m.startPeriod < p.startSlot + p.length + :travelTime and " + HibernateUtil.addDate("p.session.examBeginDate", "p.dateOffset") + " = m.meetingDate").setLong("examOwnerId", this.getOwnerId().longValue()).setInteger("travelTime", ApplicationProperty.ExaminationTravelTimeClass.intValue().intValue()).setLong("periodId", periodId.longValue()).setCacheable(true).list()) {
                    Long studentId = (Long)o[0];
                    Meeting meeting = (Meeting)o[1];
                    Set<Long> students = studentMeetings.get(meeting);
                    if (students == null) {
                        students = new HashSet<Long>();
                        studentMeetings.put(meeting, students);
                    }
                    students.add(studentId);
                }
                break;
            }
        }
    }

    public int countStudents() {
        switch (this.getOwnerType()) {
            case 3: {
                return ((Number)new ExamOwnerDAO().getSession().createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.clazz c  where c.uniqueId = :examOwnerId").setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).uniqueResult()).intValue();
            }
            case 2: {
                return ((Number)new ExamOwnerDAO().getSession().createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.clazz c  where c.schedulingSubpart.instrOfferingConfig.uniqueId = :examOwnerId").setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).uniqueResult()).intValue();
            }
            case 1: {
                return ((Number)new ExamOwnerDAO().getSession().createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.courseOffering co  where co.uniqueId = :examOwnerId").setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).uniqueResult()).intValue();
            }
            case 0: {
                return ((Number)new ExamOwnerDAO().getSession().createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.courseOffering co  where co.instructionalOffering.uniqueId = :examOwnerId").setLong("examOwnerId", this.getOwnerId().longValue()).setCacheable(true).uniqueResult()).intValue();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    public int countStudents(CourseOffering co) {
        switch (this.getOwnerType()) {
            case 3: {
                return ((Number)new ExamOwnerDAO().getSession().createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.clazz c  where c.uniqueId = :examOwnerId and e.courseOffering.uniqueId=:courseOfferingId").setLong("examOwnerId", this.getOwnerId().longValue()).setLong("courseOfferingId", co.getUniqueId().longValue()).setCacheable(true).uniqueResult()).intValue();
            }
            case 2: {
                return ((Number)new ExamOwnerDAO().getSession().createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.clazz c  where c.schedulingSubpart.instrOfferingConfig.uniqueId = :examOwnerId and e.courseOffering.uniqueId=:courseOfferingId").setLong("examOwnerId", this.getOwnerId().longValue()).setLong("courseOfferingId", co.getUniqueId().longValue()).setCacheable(true).uniqueResult()).intValue();
            }
            case 1: {
                return ((Number)new ExamOwnerDAO().getSession().createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.courseOffering co  where co.uniqueId = :examOwnerId and e.courseOffering.uniqueId=:courseOfferingId").setLong("examOwnerId", this.getOwnerId().longValue()).setLong("courseOfferingId", co.getUniqueId().longValue()).setCacheable(true).uniqueResult()).intValue();
            }
            case 0: {
                return ((Number)new ExamOwnerDAO().getSession().createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.courseOffering co  where co.instructionalOffering.uniqueId = :examOwnerId and e.courseOffering.uniqueId=:courseOfferingId").setLong("examOwnerId", this.getOwnerId().longValue()).setLong("courseOfferingId", co.getUniqueId().longValue()).setCacheable(true).uniqueResult()).intValue();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    public int getLimit() {
        Object owner = this.getOwnerObject();
        switch (this.getOwnerType()) {
            case 3: {
                return ((Class_)owner).getClassLimit();
            }
            case 2: {
                return ((InstrOfferingConfig)owner).getLimit();
            }
            case 1: {
                CourseOffering course = (CourseOffering)owner;
                if (course.getReservation() != null) {
                    return course.getReservation();
                }
                return course.getInstructionalOffering().getLimit() == null ? 0 : course.getInstructionalOffering().getLimit();
            }
            case 0: {
                return ((InstructionalOffering)owner).getLimit() == null ? 0 : ((InstructionalOffering)owner).getLimit();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    public int getSize() {
        boolean considerLimit = ApplicationProperty.ExaminationSizeUseLimitInsteadOfEnrollment.isTrue(this.getExam().getExamType().getReference(), this.getExam().getExamType().getType() != 0);
        return considerLimit ? Math.max(this.countStudents(), this.getLimit()) : this.countStudents();
    }

    public int getSize(CourseOffering co) {
        boolean considerLimit = ApplicationProperty.ExaminationSizeUseLimitInsteadOfEnrollment.isTrue(this.getExam().getExamType().getReference(), this.getExam().getExamType().getType() != 0);
        return considerLimit ? Math.max(this.countStudents(), this.getLimit()) : this.countStudents(co);
    }

    public String getLabel() {
        return this.genName(ApplicationProperties.getProperty("tmtbl.exam.name." + sOwnerTypes[this.getOwnerType()]));
    }

    public String getSubject() {
        return this.getCourse().getSubjectAreaAbbv();
    }

    public String getCourseNbr() {
        return this.getCourse().getCourseNbr();
    }

    public String getItype() {
        switch (this.getOwnerType()) {
            case 3: {
                if (ApplicationProperty.ExaminationReportsExternalId.isTrue()) {
                    String ext = ((Class_)this.getOwnerObject()).getExternalId(this.getCourse());
                    return ext == null ? "" : ext;
                }
                return ((Class_)this.getOwnerObject()).getSchedulingSubpart().getItypeDesc();
            }
            case 2: {
                return "[" + ((InstrOfferingConfig)this.getOwnerObject()).getName() + "]";
            }
            case 0: 
            case 1: {
                return "";
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    public String getSection() {
        switch (this.getOwnerType()) {
            case 3: {
                Class_ clazz = (Class_)this.getOwnerObject();
                return ApplicationProperty.ExaminationReportsClassSufix.isTrue() && clazz.getClassSuffix(this.getCourse()) != null ? clazz.getClassSuffix(this.getCourse()) : clazz.getSectionNumberString();
            }
            case 2: {
                if (ApplicationProperty.ExaminationReportsShowInstructionalType.isFalse()) {
                    return "[" + ((InstrOfferingConfig)this.getOwnerObject()).getName() + "]";
                }
            }
            case 0: 
            case 1: {
                return "";
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    public String genName(String pattern) {
        String name = pattern;
        int idx = -1;
        while (name.indexOf(37, idx + 1) >= 0) {
            idx = name.indexOf(37, idx);
            char code = name.charAt(idx + 1);
            String name4code = this.genName(code);
            name = name.substring(0, idx) + (name4code == null ? "" : name4code) + name.substring(idx + 2);
        }
        return name;
    }

    protected String genName(char code) {
        switch (code) {
            case '_': {
                return " ";
            }
            case 's': {
                return this.getCourse().getSubjectArea().getSubjectAreaAbbreviation();
            }
            case 'c': {
                return this.getCourse().getCourseNbr();
            }
            case 'i': {
                switch (this.getOwnerType()) {
                    case 3: {
                        return ((Class_)this.getOwnerObject()).getSchedulingSubpart().getItypeDesc().trim();
                    }
                }
                return "";
            }
            case 'n': {
                switch (this.getOwnerType()) {
                    case 3: {
                        return ((Class_)this.getOwnerObject()).getSectionNumberString();
                    }
                }
                return "";
            }
            case 'x': {
                switch (this.getOwnerType()) {
                    case 3: {
                        return ((Class_)this.getOwnerObject()).getSchedulingSubpart().getInstrOfferingConfig().getName();
                    }
                    case 2: {
                        return ((InstrOfferingConfig)this.getOwnerObject()).getName();
                    }
                }
                return "";
            }
            case 'D': {
                return this.getCourse().getDepartment().getDeptCode();
            }
            case 'd': {
                Department d = this.getCourse().getDepartment();
                return d.getAbbreviation() == null || d.getAbbreviation().length() == 0 ? d.getDeptCode() : d.getAbbreviation();
            }
            case 'a': {
                switch (this.getOwnerType()) {
                    case 3: {
                        return ((Class_)this.getOwnerObject()).getClassSuffix(this.getCourse());
                    }
                }
                return "";
            }
            case 'y': {
                switch (this.getOwnerType()) {
                    case 3: {
                        return ((Class_)this.getOwnerObject()).getSchedulingSubpart().getSchedulingSubpartSuffix();
                    }
                }
                return "";
            }
            case 'e': {
                switch (this.getOwnerType()) {
                    case 3: {
                        return ((Class_)this.getOwnerObject()).getExternalId(this.getCourse());
                    }
                }
                return "";
            }
            case 'f': {
                return this.getCourse().getExternalUniqueId();
            }
            case 'o': {
                return this.getCourse().getInstructionalOffering().getExternalUniqueId();
            }
            case 't': {
                return ApplicationProperties.getProperty("tmtbl.exam.name.type." + this.getExam().getExamType().getReference());
            }
            case 'I': {
                switch (this.getOwnerType()) {
                    case 3: {
                        return ((Class_)this.getOwnerObject()).getSchedulingSubpart().getItype().getItype().toString();
                    }
                }
                return "";
            }
            case 'p': {
                switch (this.getOwnerType()) {
                    case 3: {
                        ItypeDesc itype = ((Class_)this.getOwnerObject()).getSchedulingSubpart().getItype();
                        while (itype.getParent() != null) {
                            itype = itype.getParent();
                        }
                        return itype.getAbbv();
                    }
                }
                return "";
            }
            case 'P': {
                switch (this.getOwnerType()) {
                    case 3: {
                        ItypeDesc itype = ((Class_)this.getOwnerObject()).getSchedulingSubpart().getItype();
                        while (itype.getParent() != null) {
                            itype = itype.getParent();
                        }
                        return itype.getItype().toString();
                    }
                }
                return "";
            }
        }
        return "";
    }
}

