/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.server;

import com.google.gwt.core.server.StackTraceDeobfuscator;
import com.google.gwt.logging.shared.RemoteLoggingService;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class UniTimeRemoteLoggingService
extends RemoteServiceServlet
implements RemoteLoggingService {
    private static Logger sLogger = Logger.getLogger(UniTimeRemoteLoggingService.class);
    private static final long serialVersionUID = 1L;
    private StackTraceDeobfuscator iDeobfuscator = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String path = config.getServletContext().getRealPath("/WEB-INF/deploy/unitime/symbolMaps/");
        if (path != null) {
            this.iDeobfuscator = StackTraceDeobfuscator.fromFileSystem((String)path);
        }
    }

    public String logOnServer(LogRecord record) {
        try {
            if (this.iDeobfuscator != null && record.getThrown() != null) {
                this.iDeobfuscator.deobfuscateStackTrace(record.getThrown(), this.getPermutationStrongName());
            }
            Logger logger = Logger.getLogger((String)record.getLoggerName());
            if (record.getLevel().intValue() >= Level.SEVERE.intValue()) {
                logger.error((Object)record.getMessage(), record.getThrown());
            } else if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
                logger.warn((Object)record.getMessage(), record.getThrown());
            } else if (record.getLevel().intValue() >= Level.INFO.intValue()) {
                logger.info((Object)record.getMessage(), record.getThrown());
            } else if (record.getLevel().intValue() >= Level.FINE.intValue()) {
                logger.debug((Object)record.getMessage(), record.getThrown());
            } else {
                logger.trace((Object)record.getMessage(), record.getThrown());
            }
            return null;
        }
        catch (Exception e) {
            sLogger.warn((Object)("Logging failed, reason: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }
}

