/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.services.ReservationService;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.gwt.shared.ReservationException;
import org.unitime.timetable.gwt.shared.ReservationInterface;
import org.unitime.timetable.interfaces.ExternalCourseOfferingReservationEditAction;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseReservation;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.CurriculumCourse;
import org.unitime.timetable.model.CurriculumProjectionRule;
import org.unitime.timetable.model.CurriculumReservation;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.OverrideReservation;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.StudentGroupReservation;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.AcademicAreaDAO;
import org.unitime.timetable.model.dao.AcademicClassificationDAO;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.CurriculumDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.PosMajorDAO;
import org.unitime.timetable.model.dao.ReservationDAO;
import org.unitime.timetable.model.dao.StudentGroupDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.reservation.ReservationFilterBackend;
import org.unitime.timetable.util.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="reservation.gwt")
public class ReservationServlet
implements ReservationService {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    private static Logger sLog = Logger.getLogger(ReservationServlet.class);
    @Autowired
    private SessionContext sessionContext;
    @Autowired
    Permission<InstructionalOffering> permissionOfferingLockNeeded;

    private SessionContext getSessionContext() {
        return this.sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('Reservations')")
    public List<ReservationInterface.Area> getAreas() throws ReservationException, PageAccessException {
        try {
            ArrayList<ReservationInterface.Area> results = new ArrayList<ReservationInterface.Area>();
            Session hibSession = ReservationDAO.getInstance().getSession();
            try {
                ArrayList<ReservationInterface.IdName> classifications = new ArrayList<ReservationInterface.IdName>();
                for (AcademicClassification classification : hibSession.createQuery("select c from AcademicClassification c where c.session.uniqueId = :sessionId order by c.code, c.name").setLong("sessionId", this.getAcademicSessionId().longValue()).setCacheable(true).list()) {
                    ReservationInterface.IdName clasf = new ReservationInterface.IdName();
                    clasf.setId(classification.getUniqueId());
                    clasf.setName(Constants.curriculaToInitialCase(classification.getName()));
                    clasf.setAbbv(classification.getCode());
                    classifications.add(clasf);
                }
                for (AcademicArea area : hibSession.createQuery("select a from AcademicArea a where a.session.uniqueId = :sessionId order by a.academicAreaAbbreviation, a.title").setLong("sessionId", this.getAcademicSessionId().longValue()).setCacheable(true).list()) {
                    ReservationInterface.Area curriculum = new ReservationInterface.Area();
                    curriculum.setAbbv(area.getAcademicAreaAbbreviation());
                    curriculum.setId(area.getUniqueId());
                    curriculum.setName(Constants.curriculaToInitialCase(area.getTitle()));
                    for (PosMajor major : area.getPosMajors()) {
                        ReservationInterface.IdName mj = new ReservationInterface.IdName();
                        mj.setId(major.getUniqueId());
                        mj.setAbbv(major.getCode());
                        mj.setName(Constants.curriculaToInitialCase(major.getName()));
                        curriculum.getMajors().add(mj);
                    }
                    Collections.sort(curriculum.getMajors());
                    curriculum.getClassifications().addAll(classifications);
                    results.add(curriculum);
                }
                Object var11_13 = null;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (ReservationException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ReservationException(e.getMessage());
        }
    }

    private ReservationInterface.Offering convert(InstructionalOffering io, Session hibSession) throws ReservationException, PageAccessException {
        ReservationInterface.Offering offering = new ReservationInterface.Offering();
        offering.setAbbv(io.getCourseName());
        offering.setName(io.getControllingCourseOffering().getTitle());
        offering.setId(io.getUniqueId());
        offering.setOffered(io.isNotOffered() == false);
        for (CourseOffering co : io.getCourseOfferings()) {
            ReservationInterface.Course course = new ReservationInterface.Course();
            course.setId(co.getUniqueId());
            course.setAbbv(co.getCourseName());
            course.setName(co.getTitle());
            course.setControl(co.isIsControl());
            course.setLimit(co.getReservation());
            offering.getCourses().add(course);
        }
        ArrayList<InstrOfferingConfig> configs = new ArrayList<InstrOfferingConfig>(io.getInstrOfferingConfigs());
        Collections.sort(configs, new InstrOfferingConfigComparator(null));
        for (InstrOfferingConfig ioc : configs) {
            ReservationInterface.Config config = new ReservationInterface.Config();
            config.setId(ioc.getUniqueId());
            config.setName(ioc.getName());
            config.setAbbv(ioc.getName());
            config.setLimit(ioc.isUnlimitedEnrollment() != false ? null : ioc.getLimit());
            offering.getConfigs().add(config);
            TreeSet<SchedulingSubpart> subparts = new TreeSet<SchedulingSubpart>(new SchedulingSubpartComparator());
            subparts.addAll(ioc.getSchedulingSubparts());
            for (SchedulingSubpart ss : subparts) {
                ReservationInterface.Subpart subpart = new ReservationInterface.Subpart();
                subpart.setId(ss.getUniqueId());
                String suffix = ss.getSchedulingSubpartSuffix(hibSession);
                subpart.setAbbv(ss.getItypeDesc() + (suffix == null || suffix.isEmpty() ? "" : " " + suffix));
                subpart.setName(ss.getSchedulingSubpartLabel());
                subpart.setConfig(config);
                config.getSubparts().add(subpart);
                if (ss.getParentSubpart() != null) {
                    subpart.setParentId(ss.getParentSubpart().getUniqueId());
                }
                ArrayList<Class_> classes = new ArrayList<Class_>(ss.getClasses());
                Collections.sort(classes, new ClassComparator(5));
                for (Class_ c : classes) {
                    ReservationInterface.Clazz clazz = new ReservationInterface.Clazz();
                    clazz.setId(c.getUniqueId());
                    clazz.setAbbv(ss.getItypeDesc() + " " + c.getSectionNumberString(hibSession));
                    clazz.setName(c.getClassLabel(hibSession));
                    subpart.getClasses().add(clazz);
                    clazz.setSubpart(subpart);
                    clazz.setLimit(c.getClassLimit());
                    if (c.getParentClass() == null) continue;
                    clazz.setParentId(c.getParentClass().getUniqueId());
                }
            }
        }
        return offering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @PreAuthorize(value="checkPermission('Reservations')")
    public ReservationInterface.Offering getOffering(Long offeringId) throws ReservationException, PageAccessException {
        try {
            ReservationInterface.Offering offering;
            Session hibSession = ReservationDAO.getInstance().getSession();
            try {
                InstructionalOffering io = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(offeringId, hibSession);
                if (io == null) {
                    String string;
                    if (offeringId == null) {
                        string = "null";
                        throw new ReservationException(MESSAGES.errorOfferingDoesNotExist(string));
                    }
                    string = offeringId.toString();
                    throw new ReservationException(MESSAGES.errorOfferingDoesNotExist(string));
                }
                offering = this.convert(io, hibSession);
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            return offering;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (ReservationException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ReservationException(e.getMessage());
        }
    }

    private CourseOffering getCourse(Session hibSession, String courseName) {
        Iterator iterator = hibSession.createQuery("select c from CourseOffering c where c.subjectArea.session.uniqueId = :sessionId and lower(c.subjectArea.subjectAreaAbbreviation || ' ' || c.courseNbr) = :course").setString("course", courseName.toLowerCase()).setLong("sessionId", this.getAcademicSessionId().longValue()).setCacheable(true).setMaxResults(1).list().iterator();
        if (iterator.hasNext()) {
            CourseOffering co = (CourseOffering)iterator.next();
            return co;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @PreAuthorize(value="checkPermission('Reservations')")
    public ReservationInterface.Offering getOfferingByCourseName(String courseName) throws ReservationException, PageAccessException {
        try {
            ReservationInterface.Offering offering;
            Session hibSession = ReservationDAO.getInstance().getSession();
            try {
                CourseOffering co = this.getCourse(hibSession, courseName);
                if (co == null) {
                    throw new ReservationException(MESSAGES.errorCourseDoesNotExist(courseName));
                }
                offering = this.convert(co.getInstructionalOffering(), hibSession);
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            return offering;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (ReservationException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ReservationException(e.getMessage());
        }
    }

    private Hashtable<String, HashMap<String, Float>> getRules(Session hibSession, Long acadAreaId) {
        Hashtable<String, HashMap<String, Float>> clasf2major2proj = new Hashtable<String, HashMap<String, Float>>();
        for (CurriculumProjectionRule rule : hibSession.createQuery("select r from CurriculumProjectionRule r where r.academicArea.uniqueId=:acadAreaId").setLong("acadAreaId", acadAreaId.longValue()).setCacheable(true).list()) {
            String majorCode = rule.getMajor() == null ? "" : rule.getMajor().getCode();
            String clasfCode = rule.getAcademicClassification().getCode();
            Float projection = rule.getProjection();
            HashMap<String, Float> major2proj = clasf2major2proj.get(clasfCode);
            if (major2proj == null) {
                major2proj = new HashMap();
                clasf2major2proj.put(clasfCode, major2proj);
            }
            major2proj.put(majorCode, projection);
        }
        return clasf2major2proj;
    }

    private float getProjection(Hashtable<String, HashMap<String, Float>> clasf2major2proj, String majorCode, String clasfCode) {
        if (clasf2major2proj == null || clasf2major2proj.isEmpty()) {
            return 1.0f;
        }
        HashMap<String, Float> major2proj = clasf2major2proj.get(clasfCode);
        if (major2proj == null) {
            return 1.0f;
        }
        Float projection = major2proj.get(majorCode);
        if (projection == null) {
            projection = major2proj.get("");
        }
        return projection == null ? 1.0f : projection.floatValue();
    }

    /*
     * WARNING - void declaration
     */
    private ReservationInterface convert(Reservation reservation, String nameFormat, Session hibSession) {
        ReservationInterface r = null;
        if (reservation instanceof CourseReservation) {
            CourseOffering co = ((CourseReservation)reservation).getCourse();
            ReservationInterface.Course course = new ReservationInterface.Course();
            course.setId(co.getUniqueId());
            course.setAbbv(co.getCourseName());
            course.setControl(co.isIsControl());
            course.setName(co.getTitle());
            course.setLimit(co.getReservation());
            r = new ReservationInterface.CourseReservation();
            ((ReservationInterface.CourseReservation)r).setCourse(course);
            r.setLastLike(co.getDemand());
            r.setEnrollment(co.getEnrollment());
            r.setProjection(co.getProjectedDemand());
        } else if (reservation instanceof IndividualReservation) {
            Number enrollment;
            r = new ReservationInterface.IndividualReservation();
            if (reservation instanceof OverrideReservation) {
                r = new ReservationInterface.OverrideReservation(((OverrideReservation)reservation).getOverrideType());
            }
            String sId = "";
            for (Student student : ((IndividualReservation)reservation).getStudents()) {
                ReservationInterface.IdName s = new ReservationInterface.IdName();
                s.setId(student.getUniqueId());
                s.setAbbv(student.getExternalUniqueId());
                s.setName(student.getName(nameFormat));
                ((ReservationInterface.IndividualReservation)r).getStudents().add(s);
                sId = sId + (sId.isEmpty() ? "" : ",") + student.getUniqueId();
            }
            Collections.sort(((ReservationInterface.IndividualReservation)r).getStudents(), new Comparator<ReservationInterface.IdName>(){

                @Override
                public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                    int cmp = s1.getName().compareTo(s2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getAbbv().compareTo(s2.getAbbv());
                }
            });
            if (!sId.isEmpty() && (enrollment = (Number)hibSession.createQuery("select count(distinct e.student) from StudentClassEnrollment e where e.courseOffering.instructionalOffering.uniqueId = :offeringId and e.student.uniqueId in (" + sId + ")").setLong("offeringId", reservation.getInstructionalOffering().getUniqueId().longValue()).setCacheable(true).uniqueResult()).intValue() > 0) {
                r.setEnrollment(enrollment.intValue());
            }
        } else if (reservation instanceof CurriculumReservation) {
            void var7_9;
            CurriculumReservation cr = (CurriculumReservation)reservation;
            r = new ReservationInterface.CurriculumReservation();
            ReservationInterface.Area curriculum = new ReservationInterface.Area();
            curriculum.setId(cr.getArea().getUniqueId());
            curriculum.setAbbv(cr.getArea().getAcademicAreaAbbreviation());
            curriculum.setName(Constants.curriculaToInitialCase(cr.getArea().getTitle()));
            String string = "";
            String cfIds = "";
            for (AcademicClassification classification : cr.getClassifications()) {
                ReservationInterface.IdName clasf = new ReservationInterface.IdName();
                clasf.setId(classification.getUniqueId());
                clasf.setName(Constants.curriculaToInitialCase(classification.getName()));
                clasf.setAbbv(classification.getCode());
                curriculum.getClassifications().add(clasf);
                String string2 = (String)var7_9 + (var7_9.isEmpty() ? "" : ",") + "'" + classification.getCode() + "'";
                cfIds = cfIds + (cfIds.isEmpty() ? "" : ",") + classification.getUniqueId();
            }
            String mjCodes = "";
            String mjIds = "";
            for (PosMajor major : cr.getMajors()) {
                ReservationInterface.IdName mj = new ReservationInterface.IdName();
                mj.setId(major.getUniqueId());
                mj.setAbbv(major.getCode());
                mj.setName(Constants.curriculaToInitialCase(major.getName()));
                curriculum.getMajors().add(mj);
                mjCodes = mjCodes + (mjCodes.isEmpty() ? "" : ",") + "'" + major.getCode() + "'";
                mjIds = mjIds + (mjIds.isEmpty() ? "" : ",") + major.getUniqueId();
            }
            Collections.sort(curriculum.getMajors(), new Comparator<ReservationInterface.IdName>(){

                @Override
                public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                    int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = s1.getName().compareTo(s2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getId().compareTo(s2.getId());
                }
            });
            Collections.sort(curriculum.getClassifications(), new Comparator<ReservationInterface.IdName>(){

                @Override
                public int compare(ReservationInterface.IdName s1, ReservationInterface.IdName s2) {
                    int cmp = s1.getAbbv().compareTo(s2.getAbbv());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = s1.getName().compareTo(s2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getId().compareTo(s2.getId());
                }
            });
            ((ReservationInterface.CurriculumReservation)r).setCurriculum(curriculum);
            Number enrollment = (Number)hibSession.createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.student.academicAreaClassifications a inner join e.student.posMajors m where e.courseOffering.instructionalOffering.uniqueId = :offeringId and a.academicArea.uniqueId = :areaId" + (mjIds.isEmpty() ? "" : " and m.uniqueId in (" + mjIds + ")") + (cfIds.isEmpty() ? "" : " and a.academicClassification.uniqueId in (" + cfIds + ")")).setLong("offeringId", reservation.getInstructionalOffering().getUniqueId().longValue()).setLong("areaId", cr.getArea().getUniqueId().longValue()).setCacheable(true).uniqueResult();
            if (enrollment.intValue() > 0) {
                r.setEnrollment(enrollment.intValue());
            }
            float projection = 0.0f;
            int lastLike = 0;
            Hashtable<String, HashMap<String, Float>> rules = this.getRules(hibSession, cr.getArea().getUniqueId());
            for (Object[] o : hibSession.createQuery("select count(distinct s), m.code, f.code from LastLikeCourseDemand x inner join x.student s inner join s.academicAreaClassifications a inner join s.posMajors m inner join a.academicClassification f inner join a.academicArea r, CourseOffering co where x.subjectArea.session.uniqueId = :sessionId and co.instructionalOffering.uniqueId = :offeringId and co.subjectArea.uniqueId = x.subjectArea.uniqueId and ((x.coursePermId is not null and co.permId=x.coursePermId) or (x.coursePermId is null and co.courseNbr=x.courseNbr)) and r.academicAreaAbbreviation = :areaAbbv" + (mjCodes.isEmpty() ? "" : " and m.code in (" + mjCodes + ")") + (var7_9.isEmpty() ? "" : " and f.code in (" + (String)var7_9 + ")") + " group by m.code, f.code").setLong("sessionId", this.getAcademicSessionId().longValue()).setLong("offeringId", reservation.getInstructionalOffering().getUniqueId().longValue()).setString("areaAbbv", cr.getArea().getAcademicAreaAbbreviation()).setCacheable(true).list()) {
                int nrStudents = ((Number)o[0]).intValue();
                lastLike += nrStudents;
                projection += this.getProjection(rules, (String)o[1], (String)o[2]) * (float)nrStudents;
            }
            if (lastLike > 0) {
                r.setLastLike(lastLike);
                r.setProjection(Math.round(projection));
            }
        } else if (reservation instanceof StudentGroupReservation) {
            r = new ReservationInterface.GroupReservation();
            StudentGroup sg = ((StudentGroupReservation)reservation).getGroup();
            ReservationInterface.IdName group = new ReservationInterface.IdName();
            group.setId(sg.getUniqueId());
            group.setName(sg.getGroupName());
            group.setAbbv(sg.getGroupAbbreviation());
            group.setLimit(sg.getStudents().size());
            ((ReservationInterface.GroupReservation)r).setGroup(group);
            Number number = (Number)hibSession.createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.student.groups g where e.courseOffering.instructionalOffering.uniqueId = :offeringId and g.uniqueId = :groupId").setLong("offeringId", reservation.getInstructionalOffering().getUniqueId().longValue()).setLong("groupId", sg.getUniqueId().longValue()).setCacheable(true).uniqueResult();
            if (number.intValue() > 0) {
                r.setEnrollment(number.intValue());
            }
        } else {
            throw new ReservationException(MESSAGES.errorUnknownReservationType(reservation.getClass().getName()));
        }
        ReservationInterface.Offering offering = new ReservationInterface.Offering();
        offering.setAbbv(reservation.getInstructionalOffering().getCourseName());
        offering.setName(reservation.getInstructionalOffering().getControllingCourseOffering().getTitle());
        offering.setId(reservation.getInstructionalOffering().getUniqueId());
        offering.setOffered(reservation.getInstructionalOffering().isNotOffered() == false);
        r.setOffering(offering);
        for (CourseOffering courseOffering : reservation.getInstructionalOffering().getCourseOfferings()) {
            ReservationInterface.Course course = new ReservationInterface.Course();
            course.setId(courseOffering.getUniqueId());
            course.setAbbv(courseOffering.getCourseName());
            course.setName(courseOffering.getTitle());
            course.setControl(courseOffering.isIsControl());
            course.setLimit(courseOffering.getReservation());
            offering.getCourses().add(course);
        }
        ArrayList<InstrOfferingConfig> configs = new ArrayList<InstrOfferingConfig>(reservation.getConfigurations());
        Collections.sort(configs, new InstrOfferingConfigComparator(null));
        for (InstrOfferingConfig ioc : configs) {
            ReservationInterface.Config config = new ReservationInterface.Config();
            config.setId(ioc.getUniqueId());
            config.setName(ioc.getName());
            config.setAbbv(ioc.getName());
            config.setLimit(ioc.isUnlimitedEnrollment() != false ? null : ioc.getLimit());
            r.getConfigs().add(config);
        }
        ArrayList<Class_> arrayList = new ArrayList<Class_>(reservation.getClasses());
        Collections.sort(arrayList, new ClassComparator(5));
        for (Class_ c : arrayList) {
            ReservationInterface.Clazz clazz = new ReservationInterface.Clazz();
            clazz.setId(c.getUniqueId());
            clazz.setAbbv(c.getSchedulingSubpart().getItypeDesc() + " " + c.getSectionNumberString(hibSession));
            clazz.setName(c.getClassLabel(hibSession));
            clazz.setLimit(c.getClassLimit());
            r.getClasses().add(clazz);
        }
        r.setExpirationDate(reservation.getExpirationDate());
        r.setExpired(reservation.isExpired());
        r.setLimit(reservation.getLimit());
        r.setId(reservation.getUniqueId());
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('Reservations')")
    public List<ReservationInterface> getReservations(Long offeringId) throws ReservationException, PageAccessException {
        try {
            ArrayList<ReservationInterface> results = new ArrayList<ReservationInterface>();
            Session hibSession = ReservationDAO.getInstance().getSession();
            String nameFormat = UserProperty.NameFormat.get(this.getSessionContext().getUser());
            try {
                for (Reservation reservation : hibSession.createQuery("select r from Reservation r where r.instructionalOffering.uniqueId = :offeringId").setLong("offeringId", offeringId.longValue()).setCacheable(true).list()) {
                    ReservationInterface r = this.convert(reservation, nameFormat, hibSession);
                    r.setEditable(this.getSessionContext().hasPermission(reservation, Right.ReservationEdit));
                    results.add(r);
                }
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            Collections.sort(results);
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (ReservationException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ReservationException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('Reservations')")
    public List<ReservationInterface.IdName> getStudentGroups() throws ReservationException, PageAccessException {
        try {
            ArrayList<ReservationInterface.IdName> results = new ArrayList<ReservationInterface.IdName>();
            Session hibSession = ReservationDAO.getInstance().getSession();
            try {
                for (StudentGroup sg : hibSession.createQuery("select g from StudentGroup g where g.session.uniqueId = :sessionId order by g.groupName").setLong("sessionId", this.getAcademicSessionId().longValue()).setCacheable(true).list()) {
                    ReservationInterface.IdName group = new ReservationInterface.IdName();
                    group.setId(sg.getUniqueId());
                    group.setName(sg.getGroupAbbreviation());
                    group.setAbbv(sg.getGroupName());
                    group.setLimit(sg.getStudents().size());
                    results.add(group);
                }
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (ReservationException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ReservationException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission(#reservationId, 'Reservation', 'ReservationEdit')")
    public ReservationInterface getReservation(Long reservationId) throws ReservationException, PageAccessException {
        try {
            ReservationInterface r;
            Session hibSession = ReservationDAO.getInstance().getSession();
            try {
                Reservation reservation = (Reservation)ReservationDAO.getInstance().get(reservationId, hibSession);
                if (reservation == null) {
                    throw new ReservationException("Reservation not found.");
                }
                r = this.convert(reservation, UserProperty.NameFormat.get(this.getSessionContext().getUser()), hibSession);
                r.setEditable(this.getSessionContext().hasPermission(reservation, Right.ReservationEdit));
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            return r;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (ReservationException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ReservationException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @PreAuthorize(value="(#reservation.id != null and checkPermission(#reservation.id, 'Reservation', 'ReservationEdit')) or (#reservation.id == null and checkPermission(#reservation.offering.id, 'InstructionalOffering', 'ReservationOffering') and checkPermission('ReservationAdd'))")
    public Long save(ReservationInterface reservation) throws ReservationException, PageAccessException {
        try {
            Long l;
            Session hibSession = ReservationDAO.getInstance().getSession();
            UserContext user = this.getSessionContext().getUser();
            try {
                InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(reservation.getOffering().getId(), hibSession);
                if (offering == null) {
                    throw new ReservationException(MESSAGES.errorOfferingDoesNotExist(reservation.getOffering().getName()));
                }
                Reservation r = null;
                if (reservation.getId() != null) {
                    r = (Reservation)ReservationDAO.getInstance().get(reservation.getId(), hibSession);
                }
                if (r == null) {
                    if (reservation instanceof ReservationInterface.OverrideReservation) {
                        r = new OverrideReservation();
                        ((OverrideReservation)r).setOverrideType(((ReservationInterface.OverrideReservation)reservation).getType());
                    } else if (reservation instanceof ReservationInterface.IndividualReservation) {
                        r = new IndividualReservation();
                    } else if (reservation instanceof ReservationInterface.GroupReservation) {
                        r = new StudentGroupReservation();
                    } else if (reservation instanceof ReservationInterface.CurriculumReservation) {
                        r = new CurriculumReservation();
                    } else {
                        if (!(reservation instanceof ReservationInterface.CourseReservation)) {
                            throw new ReservationException(MESSAGES.errorUnknownReservationType(reservation.getClass().getName()));
                        }
                        r = new CourseReservation();
                    }
                }
                r.setLimit(r instanceof IndividualReservation ? null : reservation.getLimit());
                r.setExpirationDate(reservation.getExpirationDate());
                r.setInstructionalOffering(offering);
                offering.getReservations().add(r);
                if (r.getClasses() == null) {
                    r.setClasses(new HashSet<Class_>());
                } else {
                    r.getClasses().clear();
                }
                for (ReservationInterface.Clazz clazz : reservation.getClasses()) {
                    r.getClasses().add((Class_)Class_DAO.getInstance().get(clazz.getId(), hibSession));
                }
                if (r.getConfigurations() == null) {
                    r.setConfigurations(new HashSet<InstrOfferingConfig>());
                } else {
                    r.getConfigurations().clear();
                }
                for (ReservationInterface.Config config : reservation.getConfigs()) {
                    r.getConfigurations().add((InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(config.getId(), hibSession));
                }
                if (r instanceof IndividualReservation) {
                    IndividualReservation ir = (IndividualReservation)r;
                    if (ir.getStudents() == null) {
                        ir.setStudents(new HashSet<Student>());
                    } else {
                        ir.getStudents().clear();
                    }
                    for (ReservationInterface.IdName student : ((ReservationInterface.IndividualReservation)reservation).getStudents()) {
                        Student s = Student.findByExternalId(offering.getSessionId(), student.getAbbv());
                        if (s == null) continue;
                        ir.getStudents().add(s);
                    }
                } else if (r instanceof CourseReservation) {
                    ((CourseReservation)r).setCourse((CourseOffering)CourseOfferingDAO.getInstance().get(((ReservationInterface.CourseReservation)reservation).getCourse().getId(), hibSession));
                } else if (r instanceof StudentGroupReservation) {
                    ((StudentGroupReservation)r).setGroup((StudentGroup)StudentGroupDAO.getInstance().get(((ReservationInterface.GroupReservation)reservation).getGroup().getId(), hibSession));
                } else if (r instanceof CurriculumReservation) {
                    ReservationInterface.Area curriculum = ((ReservationInterface.CurriculumReservation)reservation).getCurriculum();
                    CurriculumReservation curriculumReservation = (CurriculumReservation)r;
                    curriculumReservation.setArea((AcademicArea)AcademicAreaDAO.getInstance().get(curriculum.getId(), hibSession));
                    if (curriculumReservation.getMajors() == null) {
                        curriculumReservation.setMajors(new HashSet<PosMajor>());
                    } else {
                        curriculumReservation.getMajors().clear();
                    }
                    for (ReservationInterface.IdName mj : curriculum.getMajors()) {
                        curriculumReservation.getMajors().add((PosMajor)PosMajorDAO.getInstance().get(mj.getId(), hibSession));
                    }
                    if (curriculumReservation.getClassifications() == null) {
                        curriculumReservation.setClassifications(new HashSet<AcademicClassification>());
                    } else {
                        curriculumReservation.getClassifications().clear();
                    }
                    for (ReservationInterface.IdName clasf : curriculum.getClassifications()) {
                        curriculumReservation.getClassifications().add((AcademicClassification)AcademicClassificationDAO.getInstance().get(clasf.getId(), hibSession));
                    }
                }
                hibSession.saveOrUpdate((Object)r);
                hibSession.saveOrUpdate((Object)r.getInstructionalOffering());
                if (this.permissionOfferingLockNeeded.check(user, offering)) {
                    StudentSectioningQueue.offeringChanged(hibSession, user, offering.getSession().getUniqueId(), offering.getUniqueId());
                }
                hibSession.flush();
                String className = ApplicationProperty.ExternalActionCourseOfferingReservationEdit.value();
                if (className != null && !className.trim().isEmpty()) {
                    ExternalCourseOfferingReservationEditAction externalCourseOfferingReservationEditAction = (ExternalCourseOfferingReservationEditAction)Class.forName(className).newInstance();
                    externalCourseOfferingReservationEditAction.performExternalCourseOfferingReservationEditAction(r.getInstructionalOffering(), hibSession);
                }
                ChangeLog.addChange(hibSession, this.sessionContext, r.getInstructionalOffering(), ChangeLog.Source.RESERVATION, reservation.getId() == null ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, r.getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), r.getInstructionalOffering().getDepartment());
                hibSession.flush();
                l = r.getUniqueId();
                Object var11_23 = null;
            }
            catch (Throwable throwable) {
                Object var11_24 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            return l;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (ReservationException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ReservationException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @PreAuthorize(value="checkPermission(#reservationId, 'Reservation', 'ReservationDelete')")
    public Boolean delete(Long reservationId) throws ReservationException, PageAccessException {
        try {
            Session hibSession;
            block10: {
                Boolean bl;
                block9: {
                    hibSession = ReservationDAO.getInstance().getSession();
                    UserContext user = this.getSessionContext().getUser();
                    try {
                        Reservation reservation = (Reservation)ReservationDAO.getInstance().get(reservationId, hibSession);
                        if (reservation == null) {
                            bl = false;
                            Object var9_10 = null;
                            break block9;
                        }
                        InstructionalOffering offering = reservation.getInstructionalOffering();
                        offering.getReservations().remove(reservation);
                        hibSession.delete((Object)reservation);
                        hibSession.saveOrUpdate((Object)offering);
                        if (this.permissionOfferingLockNeeded.check(user, offering)) {
                            StudentSectioningQueue.offeringChanged(hibSession, user, offering.getSession().getUniqueId(), offering.getUniqueId());
                        }
                        hibSession.flush();
                        String className = ApplicationProperty.ExternalActionCourseOfferingReservationEdit.value();
                        if (className != null && !className.trim().isEmpty()) {
                            ExternalCourseOfferingReservationEditAction editAction = (ExternalCourseOfferingReservationEditAction)Class.forName(className).newInstance();
                            editAction.performExternalCourseOfferingReservationEditAction(offering, hibSession);
                        }
                        ChangeLog.addChange(hibSession, this.sessionContext, offering, ChangeLog.Source.RESERVATION, ChangeLog.Operation.DELETE, offering.getControllingCourseOffering().getSubjectArea(), offering.getDepartment());
                        hibSession.flush();
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        hibSession.close();
                        throw throwable;
                    }
                }
                hibSession.close();
                return bl;
            }
            Object var9_11 = null;
            hibSession.close();
            return true;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (ReservationException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ReservationException(e.getMessage());
        }
    }

    private Long getAcademicSessionId() throws PageAccessException {
        UserContext user = this.getSessionContext().getUser();
        if (user == null) {
            throw new PageAccessException(this.getSessionContext().isHttpSessionNew() ? "Your timetabling session has expired. Please log in again." : "Login is required to use this page.");
        }
        if (user.getCurrentAuthority() == null) {
            throw new PageAccessException("Insufficient user privileges.");
        }
        Long sessionId = user.getCurrentAcademicSessionId();
        if (sessionId == null) {
            throw new PageAccessException("No academic session is selecgted.");
        }
        return sessionId;
    }

    @Override
    @PreAuthorize(value="checkPermission('ReservationAdd')")
    public Boolean canAddReservation() throws ReservationException, PageAccessException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreAuthorize(value="checkPermission('Reservations')")
    public List<ReservationInterface> findReservations(ReservationInterface.ReservationFilterRpcRequest filter) throws ReservationException, PageAccessException {
        try {
            ArrayList<ReservationInterface> results = new ArrayList<ReservationInterface>();
            this.getSessionContext().setAttribute("Reservations.LastFilter", (Object)filter.toQueryString());
            Session hibSession = CurriculumDAO.getInstance().getSession();
            String nameFormat = UserProperty.NameFormat.get(this.getSessionContext().getUser());
            try {
                for (Reservation reservation : ReservationFilterBackend.reservations(filter, this.getSessionContext())) {
                    ReservationInterface r = this.convert(reservation, nameFormat, hibSession);
                    r.setEditable(this.getSessionContext().hasPermission(reservation, Right.ReservationEdit));
                    results.add(r);
                }
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            Collections.sort(results);
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (ReservationException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ReservationException(e.getMessage());
        }
    }

    @Override
    @PreAuthorize(value="checkPermission('Reservations')")
    public String lastReservationFilter() throws ReservationException, PageAccessException {
        String filter = (String)this.getSessionContext().getAttribute("Reservations.LastFilter");
        return filter == null ? "mode:\"Not Expired\"" : filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ReservationInterface.Curriculum> getCurricula(Long offeringId) throws ReservationException, PageAccessException {
        try {
            ArrayList<ReservationInterface.Curriculum> results = new ArrayList<ReservationInterface.Curriculum>();
            Session hibSession = ReservationDAO.getInstance().getSession();
            try {
                for (Curriculum c : hibSession.createQuery("select distinct c.classification.curriculum from CurriculumCourse c where c.course.instructionalOffering = :offeringId ").setLong("offeringId", offeringId.longValue()).setCacheable(true).list()) {
                    ReservationInterface.Curriculum curriculum = new ReservationInterface.Curriculum();
                    curriculum.setAbbv(c.getAbbv());
                    curriculum.setId(c.getUniqueId());
                    curriculum.setName(c.getName());
                    ReservationInterface.IdName area = new ReservationInterface.IdName();
                    area.setAbbv(c.getAcademicArea().getAcademicAreaAbbreviation());
                    area.setId(c.getAcademicArea().getUniqueId());
                    area.setName(Constants.curriculaToInitialCase(c.getAcademicArea().getTitle()));
                    curriculum.setArea(area);
                    int limit = 0;
                    for (CurriculumClassification cc : c.getClassifications()) {
                        AcademicClassification classification = cc.getAcademicClassification();
                        ReservationInterface.IdName clasf = new ReservationInterface.IdName();
                        clasf.setId(classification.getUniqueId());
                        clasf.setName(Constants.curriculaToInitialCase(classification.getName()));
                        clasf.setAbbv(classification.getCode());
                        clasf.setLimit(0);
                        curriculum.getClassifications().add(clasf);
                        for (CurriculumCourse cr : cc.getCourses()) {
                            if (!cr.getCourse().getInstructionalOffering().getUniqueId().equals(offeringId)) continue;
                            limit += Math.round(cr.getPercShare().floatValue() * (float)cc.getNrStudents().intValue());
                            clasf.setLimit(clasf.getLimit() + Math.round(cr.getPercShare().floatValue() * (float)cc.getNrStudents().intValue()));
                        }
                    }
                    curriculum.setLimit(limit);
                    Collections.sort(curriculum.getMajors());
                    for (PosMajor major : c.getMajors()) {
                        ReservationInterface.IdName mj = new ReservationInterface.IdName();
                        mj.setId(major.getUniqueId());
                        mj.setAbbv(major.getCode());
                        mj.setName(Constants.curriculaToInitialCase(major.getName()));
                        curriculum.getMajors().add(mj);
                    }
                    Collections.sort(curriculum.getMajors());
                    results.add(curriculum);
                }
                Object var16_18 = null;
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                hibSession.close();
                throw throwable;
            }
            hibSession.close();
            return results;
        }
        catch (PageAccessException e) {
            throw e;
        }
        catch (ReservationException e) {
            throw e;
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
            throw new ReservationException(e.getMessage());
        }
    }
}

