/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.widgets;

import com.google.gwt.aria.client.Id;
import com.google.gwt.aria.client.Roles;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.aria.HasAriaLabel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTextBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniTimeWidget<T extends Widget>
extends Composite
implements HasAriaLabel {
    private T iWidget;
    private HTML iReadOnly = null;
    private HTML iPrint = null;
    private HTML iHint;
    private VerticalPanel iPanel = new VerticalPanel();
    private Element iAriaLabel = null;

    public UniTimeWidget(T widget, String hint) {
        this.iWidget = widget;
        this.iPanel.add(this.iWidget);
        this.iHint = new HTML(hint == null ? "" : hint, false);
        this.iHint.setStyleName("unitime-NotClickableHint");
        if (hint == null || hint.isEmpty()) {
            this.iHint.setVisible(false);
        }
        this.iPanel.add((Widget)this.iHint);
        this.initWidget((Widget)this.iPanel);
    }

    @Override
    public void setAriaLabel(String text) {
        if (this.iWidget instanceof HasAriaLabel) {
            ((HasAriaLabel)this.iWidget).setAriaLabel(text);
        } else {
            if (this.iAriaLabel == null) {
                this.iAriaLabel = DOM.createLabel();
                this.iAriaLabel.setId(DOM.createUniqueId());
                this.iAriaLabel.setClassName("unitime-AriaHiddenLabel");
                DOM.appendChild((Element)this.getElement(), (Element)this.iAriaLabel);
                Roles.getCheckboxRole().setAriaLabelledbyProperty((Element)this.iWidget.getElement(), new Id[]{Id.of((Element)this.iAriaLabel)});
            }
            this.iAriaLabel.setInnerText(text);
        }
    }

    @Override
    public String getAriaLabel() {
        if (this.iWidget instanceof HasAriaLabel) {
            return ((HasAriaLabel)this.iWidget).getAriaLabel();
        }
        return this.iAriaLabel == null ? "" : this.iAriaLabel.getInnerText();
    }

    public void setText(String html) {
        if (this.iReadOnly == null) {
            this.iReadOnly = new HTML(html, false);
            this.iReadOnly.setStyleName("unitime-LabelInsteadEdit");
            this.iReadOnly.setVisible(!this.getWidget().isVisible());
            this.iReadOnly.addStyleName("unitime-NoPrint");
            this.iPanel.insert((Widget)this.iReadOnly, 1);
        } else {
            this.iReadOnly.setHTML(html);
        }
    }

    public void setPrintText(String html) {
        if (this.iPrint == null) {
            this.iPrint = new HTML(html, true);
            this.iPrint.setStyleName("unitime-LabelInsteadEdit");
            this.iPrint.addStyleName("unitime-Print");
            this.getWidget().addStyleName("unitime-NoPrint");
            this.iPanel.insert((Widget)this.iPrint, 1);
        } else {
            this.iPrint.setHTML(html);
        }
    }

    public boolean showReadOnly() {
        return this.iWidget instanceof ListBox;
    }

    public UniTimeWidget(T widget) {
        this(widget, null);
    }

    public T getWidget() {
        return this.iWidget;
    }

    public void clearHint() {
        this.iHint.setHTML("");
        this.iHint.setVisible(false);
        this.setAriaLabel("");
    }

    public void setErrorHint(String error) {
        if (error == null || error.isEmpty()) {
            this.clearHint();
        } else {
            this.iHint.setStyleName("unitime-ErrorHint");
            this.iHint.setHTML(error);
            this.iHint.setVisible(true);
            this.setAriaLabel(error);
        }
    }

    public void setHint(String hint) {
        if (hint == null || hint.isEmpty()) {
            this.clearHint();
        } else {
            this.iHint.setStyleName("unitime-NotClickableHint");
            this.iHint.setHTML(hint);
            this.iHint.setVisible(true);
            this.setAriaLabel(hint);
        }
    }

    @Deprecated
    public void setVisible(boolean visible) {
        this.getWidget().setVisible(visible);
        if (this.iReadOnly != null) {
            this.iReadOnly.setVisible(!visible);
        }
    }

    @Deprecated
    public void clear() {
        if (this.getWidget() instanceof ListBox) {
            ((ListBox)this.getWidget()).clear();
        }
        if (this.getWidget() instanceof Panel) {
            ((Panel)this.getWidget()).clear();
        }
    }

    public void setReadOnly(boolean readOnly) {
        if (this.getWidget() instanceof UniTimeTextBox) {
            ((UniTimeTextBox)this.getWidget()).setReadOnly(readOnly);
        } else {
            this.getWidget().setVisible(!readOnly);
            if (this.iReadOnly != null) {
                this.iReadOnly.setVisible(readOnly);
            }
        }
    }

    public boolean isReadOnly() {
        if (this.getWidget() instanceof UniTimeTextBox) {
            return ((UniTimeTextBox)this.getWidget()).isReadOnly();
        }
        return this.iReadOnly != null && this.iReadOnly.isVisible();
    }

    protected VerticalPanel getPanel() {
        return this.iPanel;
    }
}

