/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimePageHeader;
import org.unitime.timetable.gwt.client.sectioning.AcademicSessionSelector;
import org.unitime.timetable.gwt.client.sectioning.StudentSectioningWidget;
import org.unitime.timetable.gwt.client.sectioning.UserAuthentication;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.UniTimeFrameDialog;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;

public class StudentSectioningPage
extends Composite {
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    private final SectioningServiceAsync iSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);

    public StudentSectioningPage(final Mode mode) {
        final UserAuthentication userAuthentication = new UserAuthentication(UniTimePageHeader.getInstance().getMiddle(), mode.isSectioning() ? !CONSTANTS.isAuthenticationRequired() : false);
        if (Window.Location.getParameter((String)"student") == null) {
            this.iSectioningService.whoAmI(new AsyncCallback<String>(){

                public void onFailure(Throwable caught) {
                    if (!mode.isSectioning() || CONSTANTS.isAuthenticationRequired() || CONSTANTS.tryAuthenticationWhenGuest()) {
                        if (CONSTANTS.allowUserLogin()) {
                            userAuthentication.authenticate();
                        } else if (!mode.isSectioning() || CONSTANTS.isAuthenticationRequired()) {
                            ToolBox.open(GWT.getHostPageBaseURL() + "login.do?target=" + URL.encodeQueryString((String)Window.Location.getHref()));
                        } else {
                            userAuthentication.authenticated(null);
                        }
                    }
                }

                public void onSuccess(String result) {
                    if (result == null) {
                        if (!mode.isSectioning() || CONSTANTS.isAuthenticationRequired() || CONSTANTS.tryAuthenticationWhenGuest()) {
                            if (CONSTANTS.allowUserLogin()) {
                                userAuthentication.authenticate();
                            } else if (!mode.isSectioning() || CONSTANTS.isAuthenticationRequired()) {
                                ToolBox.open(GWT.getHostPageBaseURL() + "login.do?target=" + URL.encodeQueryString((String)Window.Location.getHref()));
                            } else {
                                userAuthentication.authenticated(result);
                            }
                        } else {
                            userAuthentication.authenticated(result);
                        }
                    } else {
                        userAuthentication.authenticated(result);
                    }
                }
            });
        }
        final AcademicSessionSelector sessionSelector = new AcademicSessionSelector(UniTimePageHeader.getInstance().getRight(), mode);
        this.iSectioningService.getProperties(null, new AsyncCallback<OnlineSectioningInterface.SectioningProperties>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(OnlineSectioningInterface.SectioningProperties result) {
                if (result.isAdmin()) {
                    userAuthentication.setAllowLookup(true);
                    if (Window.Location.getParameter((String)"session") != null) {
                        sessionSelector.selectSession(Long.valueOf(Window.Location.getParameter((String)"session")), new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                            }

                            public void onSuccess(Boolean result) {
                                if (Window.Location.getParameter((String)"student") != null) {
                                    UserAuthentication.personFound(Window.Location.getParameter((String)"student"));
                                }
                            }
                        });
                    }
                } else {
                    userAuthentication.setAllowLookup(false);
                }
            }
        });
        UniTimePageHeader.getInstance().getLeft().setVisible(false);
        UniTimePageHeader.getInstance().getLeft().setPreventDefault(true);
        final StudentSectioningWidget widget = new StudentSectioningWidget(true, sessionSelector, userAuthentication, mode, true);
        this.initWidget((Widget)widget);
        UniTimePageHeader.getInstance().getRight().setClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (widget.isChanged() && !Window.confirm((String)MESSAGES.queryLeaveChanges())) {
                    return;
                }
                sessionSelector.selectSession();
            }
        });
        UniTimePageHeader.getInstance().getMiddle().setClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (CONSTANTS.allowUserLogin()) {
                    if (widget.isChanged() && !Window.confirm((String)MESSAGES.queryLeaveChanges())) {
                        return;
                    }
                    if (userAuthentication.isLoggedIn()) {
                        userAuthentication.logOut();
                    } else {
                        userAuthentication.authenticate();
                    }
                } else if (userAuthentication.isAllowLookup()) {
                    userAuthentication.doLookup();
                } else if (userAuthentication.isLoggedIn()) {
                    ToolBox.open(GWT.getHostPageBaseURL() + "logOut.do");
                } else {
                    ToolBox.open(GWT.getHostPageBaseURL() + "login.do?target=" + URL.encodeQueryString((String)Window.Location.getHref()));
                }
            }
        });
        userAuthentication.addUserAuthenticatedHandler(new UserAuthentication.UserAuthenticatedHandler(){

            public void onLogIn(UserAuthentication.UserAuthenticatedEvent event) {
                if (!mode.isSectioning()) {
                    sessionSelector.selectSession(null, false);
                }
                sessionSelector.selectSession();
            }

            public void onLogOut(UserAuthentication.UserAuthenticatedEvent event) {
                if (!event.isGuest()) {
                    widget.clearMessage();
                    widget.clear();
                }
                userAuthentication.authenticate();
            }
        });
        sessionSelector.addAcademicSessionChangeHandler(new AcademicSessionProvider.AcademicSessionChangeHandler(){

            public void onAcademicSessionChange(AcademicSessionProvider.AcademicSessionChangeEvent event) {
                if (event.isChanged()) {
                    widget.clearMessage();
                    widget.clear();
                }
                widget.checkEligibility(event.getNewAcademicSessionId(), null, false, null);
                userAuthentication.setLookupOptions("mustHaveExternalId,source=students,session=" + event.getNewAcademicSessionId());
            }
        });
        if (Window.Location.getParameter((String)"session") == null) {
            this.iSectioningService.lastAcademicSession(mode.isSectioning(), new AsyncCallback<AcademicSessionProvider.AcademicSessionInfo>(){

                public void onFailure(Throwable caught) {
                    if (!userAuthentication.isShowing() && !UniTimeFrameDialog.hasDialog()) {
                        sessionSelector.selectSession();
                    }
                }

                public void onSuccess(AcademicSessionProvider.AcademicSessionInfo result) {
                    sessionSelector.selectSession(result, true);
                }
            });
        }
        Window.addWindowClosingHandler((Window.ClosingHandler)new Window.ClosingHandler(){

            public void onWindowClosing(Window.ClosingEvent event) {
                if (widget.isChanged()) {
                    if (LoadingWidget.getInstance().isShowing()) {
                        LoadingWidget.getInstance().hide();
                    }
                    event.setMessage(MESSAGES.queryLeaveChanges());
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        SECTIONING(true),
        REQUESTS(false);

        boolean iSectioning;

        private Mode(boolean isSectioning) {
            this.iSectioning = isSectioning;
        }

        public boolean isSectioning() {
            return this.iSectioning;
        }
    }
}

