/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.curricula;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTextBox;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.CurriculumInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurriculaClassifications
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private UniTimeTable iTable;
    private List<CurriculumInterface.AcademicClassificationInterface> iClassifications = null;
    private List<ExpectedChangedHandler> iExpectedChangedHandlers = new ArrayList<ExpectedChangedHandler>();
    private List<NameChangedHandler> iNameChangedHandlers = new ArrayList<NameChangedHandler>();

    public CurriculaClassifications() {
        this.iTable = new UniTimeTable();
        this.iTable.setCellPadding(2);
        this.iTable.setCellSpacing(0);
        this.initWidget((Widget)this.iTable);
    }

    public List<CurriculumInterface.AcademicClassificationInterface> getClassifications() {
        return this.iClassifications;
    }

    public void setup(List<CurriculumInterface.AcademicClassificationInterface> classifications) {
        this.iTable.clear(true);
        this.iClassifications = classifications;
        this.iTable.setText(0, 0, MESSAGES.propName());
        this.iTable.setText(1, 0, MESSAGES.propClassification());
        this.iTable.setText(2, 0, MESSAGES.propLastLikeEnrollment());
        this.iTable.getCellFormatter().setWordWrap(2, 0, false);
        this.iTable.setText(3, 0, MESSAGES.propProjectedByRule());
        this.iTable.getCellFormatter().setWordWrap(3, 0, false);
        this.iTable.setText(4, 0, MESSAGES.propRequestedEnrollment());
        this.iTable.getCellFormatter().setWordWrap(4, 0, false);
        this.iTable.setText(5, 0, MESSAGES.propCurrentEnrollment());
        this.iTable.getCellFormatter().setWordWrap(5, 0, false);
        this.iTable.setText(6, 0, MESSAGES.propCourseRequests());
        this.iTable.getCellFormatter().setWordWrap(6, 0, false);
        int col = 0;
        for (final CurriculumInterface.AcademicClassificationInterface clasf : this.iClassifications) {
            final UniTimeTextBox name = new UniTimeTextBox(6, ValueBoxBase.TextAlignment.RIGHT, true);
            name.setText(clasf.getCode());
            name.setWidth("60px");
            name.setMaxLength(20);
            final int xcol = ++col - 1;
            name.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    NameChangedEvent e = new NameChangedEvent(clasf, xcol, name.getText());
                    for (NameChangedHandler h : CurriculaClassifications.this.iNameChangedHandlers) {
                        h.nameChanged(e);
                    }
                }
            });
            this.iTable.setWidget(0, col, (Widget)name);
            this.iTable.getCellFormatter().setHorizontalAlignment(0, col, HasHorizontalAlignment.ALIGN_CENTER);
            this.iTable.setWidget(1, col, (Widget)new HTML(clasf.getName().replace(" ", "<br>")));
            this.iTable.getCellFormatter().setHorizontalAlignment(1, col, HasHorizontalAlignment.ALIGN_CENTER);
            UniTimeTextBox ll = new UniTimeTextBox(6, ValueBoxBase.TextAlignment.RIGHT, false);
            this.iTable.setWidget(2, col, (Widget)ll);
            this.iTable.getCellFormatter().setHorizontalAlignment(2, col, HasHorizontalAlignment.ALIGN_CENTER);
            UniTimeTextBox proj = new UniTimeTextBox(6, ValueBoxBase.TextAlignment.RIGHT, false);
            this.iTable.setWidget(3, col, (Widget)proj);
            this.iTable.getCellFormatter().setHorizontalAlignment(3, col, HasHorizontalAlignment.ALIGN_CENTER);
            final UniTimeTextBox expected = new UniTimeTextBox(6, ValueBoxBase.TextAlignment.RIGHT, true);
            this.iTable.setWidget(4, col, (Widget)expected);
            this.iTable.getCellFormatter().setHorizontalAlignment(4, col, HasHorizontalAlignment.ALIGN_CENTER);
            expected.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    Integer exp = null;
                    if (!expected.getText().isEmpty()) {
                        try {
                            exp = Integer.parseInt(expected.getText());
                            if (exp <= 0) {
                                exp = null;
                                expected.setText(null);
                            }
                        }
                        catch (Exception e) {
                            expected.setText(null);
                        }
                    }
                    ExpectedChangedEvent e = new ExpectedChangedEvent(clasf, xcol, exp);
                    for (ExpectedChangedHandler h : CurriculaClassifications.this.iExpectedChangedHandlers) {
                        h.expectedChanged(e);
                    }
                }
            });
            UniTimeTextBox enrl = new UniTimeTextBox(6, ValueBoxBase.TextAlignment.RIGHT, false);
            this.iTable.setWidget(5, col, (Widget)enrl);
            this.iTable.getCellFormatter().setHorizontalAlignment(5, col, HasHorizontalAlignment.ALIGN_CENTER);
            UniTimeTextBox req = new UniTimeTextBox(6, ValueBoxBase.TextAlignment.RIGHT, false);
            this.iTable.setWidget(6, col, (Widget)req);
            this.iTable.getCellFormatter().setHorizontalAlignment(6, col, HasHorizontalAlignment.ALIGN_CENTER);
        }
    }

    public void populate(TreeSet<CurriculumInterface.CurriculumClassificationInterface> classifications) {
        int col = 0;
        for (CurriculumInterface.AcademicClassificationInterface clasf : this.iClassifications) {
            CurriculumInterface.CurriculumClassificationInterface ci = null;
            if (classifications != null && !classifications.isEmpty()) {
                for (CurriculumInterface.CurriculumClassificationInterface x : classifications) {
                    if (!x.getAcademicClassification().getId().equals(clasf.getId())) continue;
                    ci = x;
                    break;
                }
            }
            if (ci == null) {
                this.setName(col, clasf.getCode());
                this.setExpected(col, null);
                this.setEnrollment(col, null);
                this.setLastLike(col, null);
                this.setProjection(col, null);
                this.setRequested(col, null);
            } else {
                this.setName(col, ci.getName());
                this.setExpected(col, ci.getExpected());
                this.setEnrollment(col, ci.getEnrollment());
                this.setLastLike(col, ci.getLastLike());
                this.setProjection(col, ci.getProjection());
                this.setRequested(col, ci.getRequested());
            }
            ++col;
        }
    }

    public boolean saveCurriculum(CurriculumInterface c) {
        if (c.hasClassifications()) {
            c.getClassifications().clear();
        }
        int col = 0;
        for (CurriculumInterface.AcademicClassificationInterface ac : this.iClassifications) {
            Integer exp = this.getExpected(col);
            if (exp != null) {
                CurriculumInterface.CurriculumClassificationInterface clasf = new CurriculumInterface.CurriculumClassificationInterface();
                clasf.setAcademicClassification(ac);
                clasf.setCurriculumId(c.getId());
                clasf.setExpected(exp);
                clasf.setLastLike(this.getLastLike(col));
                clasf.setProjection(this.getProjection(col));
                clasf.setName(this.getName(col));
                c.addClassification(clasf);
            }
            ++col;
        }
        return true;
    }

    public void setEnabled(boolean enabled) {
        for (int i = 0; i < this.iClassifications.size(); ++i) {
            ((UniTimeTextBox)this.iTable.getWidget(0, 1 + i)).setReadOnly(!enabled);
            ((UniTimeTextBox)this.iTable.getWidget(4, 1 + i)).setReadOnly(!enabled);
            boolean visible = enabled || this.getExpected(i) != null || this.getEnrollment(i) != null || this.getLastLike(i) != null || this.getProjection(i) != null || this.getRequested(i) != null;
            for (int j = 0; j < 6; ++j) {
                this.iTable.getWidget(j, 1 + i).setVisible(visible);
            }
        }
    }

    public int getColumn(CurriculumInterface.AcademicClassificationInterface classification) {
        for (int i = 0; i < this.iClassifications.size(); ++i) {
            if (!classification.getId().equals(this.iClassifications.get(i).getId())) continue;
            return i;
        }
        return -1;
    }

    public String getName(int column) {
        return ((TextBox)this.iTable.getWidget(0, 1 + column)).getText();
    }

    public void setName(int column, String name) {
        ((TextBox)this.iTable.getWidget(0, 1 + column)).setText(name);
    }

    public Integer getExpected(int column) {
        String text = ((TextBox)this.iTable.getWidget(4, 1 + column)).getText();
        if (text.isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setExpected(int column, Integer expected) {
        ((TextBox)this.iTable.getWidget(4, 1 + column)).setText(expected == null ? "" : expected.toString());
    }

    public Integer getEnrollment(int column) {
        String text = ((TextBox)this.iTable.getWidget(5, 1 + column)).getText();
        if (text.isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setEnrollment(int column, Integer enrollment) {
        ((TextBox)this.iTable.getWidget(5, 1 + column)).setText(enrollment == null || enrollment == 0 ? "" : enrollment.toString());
    }

    public Integer getLastLike(int column) {
        String text = ((TextBox)this.iTable.getWidget(2, 1 + column)).getText();
        if (text.isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setLastLike(int column, Integer lastLike) {
        ((TextBox)this.iTable.getWidget(2, 1 + column)).setText(lastLike == null || lastLike == 0 ? "" : lastLike.toString());
    }

    public Integer getProjection(int column) {
        String text = ((TextBox)this.iTable.getWidget(3, 1 + column)).getText();
        if (text.isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setProjection(int column, Integer projection) {
        ((TextBox)this.iTable.getWidget(3, 1 + column)).setText(projection == null || projection == 0 ? "" : projection.toString());
    }

    public Integer getRequested(int column) {
        String text = ((TextBox)this.iTable.getWidget(6, 1 + column)).getText();
        if (text.isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setRequested(int column, Integer requested) {
        ((TextBox)this.iTable.getWidget(6, 1 + column)).setText(requested == null || requested == 0 ? "" : requested.toString());
    }

    public void addExpectedChangedHandler(ExpectedChangedHandler h) {
        this.iExpectedChangedHandlers.add(h);
    }

    public void addNameChangedHandler(NameChangedHandler h) {
        this.iNameChangedHandlers.add(h);
    }

    public void setVisible(int col, boolean visible) {
        for (int row = 0; row < this.iTable.getRowCount(); ++row) {
            this.iTable.getCellFormatter().setVisible(row, 1 + col, visible);
        }
    }

    public void hideEmptyColumns() {
        for (int i = 0; i < this.iClassifications.size(); ++i) {
            this.setVisible(i, this.getExpected(i) != null || this.getLastLike(i) != null || this.getEnrollment(i) != null || this.getProjection(i) != null || this.getRequested(i) != null);
        }
    }

    public void hideEmptyRows() {
        boolean last = false;
        boolean proj = false;
        boolean enrl = false;
        boolean req = false;
        for (int i = 0; i < this.iClassifications.size(); ++i) {
            if (this.getLastLike(i) != null) {
                last = true;
            }
            if (this.getProjection(i) != null) {
                proj = true;
            }
            if (this.getEnrollment(i) != null) {
                enrl = true;
            }
            if (this.getRequested(i) == null) continue;
            req = true;
        }
        this.iTable.getRowFormatter().setVisible(2, last);
        this.iTable.getRowFormatter().setVisible(3, proj);
        this.iTable.getRowFormatter().setVisible(5, enrl);
        this.iTable.getRowFormatter().setVisible(6, req);
    }

    public void showAllColumns() {
        for (int i = 0; i < this.iClassifications.size(); ++i) {
            this.setVisible(i, true);
        }
    }

    public static interface NameChangedHandler {
        public void nameChanged(NameChangedEvent var1);
    }

    public static class NameChangedEvent {
        private CurriculumInterface.AcademicClassificationInterface iClassification;
        private int iColumn;
        private String iName;

        NameChangedEvent(CurriculumInterface.AcademicClassificationInterface classification, int column, String name) {
            this.iClassification = classification;
            this.iColumn = column;
            this.iName = name;
        }

        public CurriculumInterface.AcademicClassificationInterface getClassification() {
            return this.iClassification;
        }

        public int getColumn() {
            return this.iColumn;
        }

        public String getName() {
            return this.iName;
        }
    }

    public static interface ExpectedChangedHandler {
        public void expectedChanged(ExpectedChangedEvent var1);
    }

    public static class ExpectedChangedEvent {
        private CurriculumInterface.AcademicClassificationInterface iClassification;
        private int iColumn;
        private Integer iExpected;

        ExpectedChangedEvent(CurriculumInterface.AcademicClassificationInterface classification, int column, Integer expected) {
            this.iClassification = classification;
            this.iColumn = column;
            this.iExpected = expected;
        }

        public CurriculumInterface.AcademicClassificationInterface getClassification() {
            return this.iClassification;
        }

        public int getColumn() {
            return this.iColumn;
        }

        public Integer getExpected() {
            return this.iExpected;
        }
    }
}

