/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeatureType;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.security.context.HttpSessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomListForm
extends ActionForm {
    private static final long serialVersionUID = 3256728385592768053L;
    private Collection rooms;
    private String deptCode;
    private String iMinRoomSize = null;
    private String iMaxRoomSize = null;
    private Long[] iRoomFeatures = null;
    private Long[] iRoomTypes = null;
    private Long[] iRoomGroups = null;
    private String iFilter = null;
    private Long iSessionId = null;

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.rooms = new ArrayList();
        this.iSessionId = HttpSessionContext.getSessionContext(request.getSession().getServletContext()).getUser().getCurrentAcademicSessionId();
    }

    public void load(HttpSession session) {
        this.iMinRoomSize = (String)session.getAttribute("RoomList.MinRoomSize");
        this.iMaxRoomSize = (String)session.getAttribute("RoomList.MaxRoomSize");
        this.iFilter = (String)session.getAttribute("RoomList.Filter");
        this.iRoomTypes = (Long[])session.getAttribute("RoomList.RoomTypes");
        this.iRoomGroups = (Long[])session.getAttribute("RoomList.RoomGroups");
        this.iRoomFeatures = (Long[])session.getAttribute("RoomList.RoomFeatures");
    }

    public void save(HttpSession session) {
        if (this.iMinRoomSize == null) {
            session.removeAttribute("RoomList.MinRoomSize");
        } else {
            session.setAttribute("RoomList.MinRoomSize", (Object)this.iMinRoomSize);
        }
        if (this.iMaxRoomSize == null) {
            session.removeAttribute("RoomList.MaxRoomSize");
        } else {
            session.setAttribute("RoomList.MaxRoomSize", (Object)this.iMaxRoomSize);
        }
        if (this.iFilter == null) {
            session.removeAttribute("RoomList.Filter");
        } else {
            session.setAttribute("RoomList.Filter", (Object)this.iFilter);
        }
        if (this.iRoomTypes == null) {
            session.removeAttribute("RoomList.RoomTypes");
        } else {
            session.setAttribute("RoomList.RoomTypes", (Object)this.iRoomTypes);
        }
        if (this.iRoomGroups == null) {
            session.removeAttribute("RoomList.RoomGroups");
        } else {
            session.setAttribute("RoomList.RoomGroups", (Object)this.iRoomGroups);
        }
        if (this.iRoomFeatures == null) {
            session.removeAttribute("RoomList.RoomFeatures");
        } else {
            session.setAttribute("RoomList.RoomFeatures", (Object)this.iRoomFeatures);
        }
    }

    public Collection getRooms() {
        return this.rooms;
    }

    public void setRooms(Collection rooms) {
        this.rooms = rooms;
    }

    public String getDeptCodeX() {
        return this.deptCode;
    }

    public void setDeptCodeX(String deptCode) {
        this.deptCode = deptCode;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.deptCode == null || this.deptCode.equalsIgnoreCase("")) {
            errors.add("deptCode", new ActionMessage("errors.required", (Object)"Department"));
        }
        return errors;
    }

    public String getMinRoomSize() {
        return this.iMinRoomSize;
    }

    public void setMinRoomSize(String minRoomSize) {
        this.iMinRoomSize = minRoomSize;
    }

    public String getMaxRoomSize() {
        return this.iMaxRoomSize;
    }

    public void setMaxRoomSize(String maxRoomSize) {
        this.iMaxRoomSize = maxRoomSize;
    }

    public String getFilter() {
        return this.iFilter;
    }

    public void setFilter(String filter) {
        this.iFilter = filter;
    }

    public Long[] getRoomTypes() {
        return this.iRoomTypes;
    }

    public void setRoomTypes(Long[] rts) {
        this.iRoomTypes = rts;
    }

    public Long[] getRoomGroups() {
        return this.iRoomGroups;
    }

    public void setRoomGroups(Long[] rgs) {
        this.iRoomGroups = rgs;
    }

    public Long[] getRoomFeatures() {
        return this.iRoomFeatures;
    }

    public void setRoomFeatures(Long[] rfs) {
        this.iRoomFeatures = rfs;
    }

    public Collection<RoomFeatureType> getRoomFeatureTypes() {
        Set<RoomFeatureType> types = RoomFeatureType.getRoomFeatureTypes(this.iSessionId, false);
        if (RoomFeatureType.hasRoomFeatureWithNoType(this.iSessionId, false)) {
            RoomFeatureType f = new RoomFeatureType();
            f.setUniqueId(-1L);
            f.setReference("Features");
            f.setLabel("Room Features");
            types.add(f);
        }
        return types;
    }

    public Collection<GlobalRoomFeature> getAllRoomFeatures(String featureType) {
        return RoomFeature.getAllGlobalRoomFeatures(this.iSessionId, featureType == null || featureType.isEmpty() ? null : Long.valueOf(featureType));
    }

    public Collection<RoomGroup> getAllRoomGroups() {
        return RoomGroup.getAllGlobalRoomGroups(this.iSessionId);
    }

    public Collection<RoomType> getAllRoomTypes() {
        return RoomType.findAll(this.iSessionId);
    }
}

