/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.Collection;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.solver.exam.ExamSolverProxy;

public class ExamReportForm
extends ActionForm {
    private static final long serialVersionUID = -8009733200124355056L;
    private String iOp = null;
    private boolean iShowSections = false;
    private Long iSubjectArea = null;
    private Collection iSubjectAreas = null;
    private String iTable = null;
    private int iNrColumns;
    private int iNrRows;
    private Long iExamType;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.iOp = null;
        this.iShowSections = false;
        this.iTable = null;
        this.iNrColumns = 0;
        this.iNrRows = 0;
        this.iExamType = null;
        ExamSolverProxy solver = WebSolver.getExamSolver(request.getSession());
        try {
            if (solver != null) {
                this.iExamType = solver.getProperties().getPropertyLong("Exam.Type", this.iExamType);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public boolean getShowSections() {
        return this.iShowSections;
    }

    public void setShowSections(boolean showSections) {
        this.iShowSections = showSections;
    }

    public Long getSubjectArea() {
        return this.iSubjectArea;
    }

    public String getSubjectAreaAbbv() {
        return ((SubjectArea)new SubjectAreaDAO().get(this.iSubjectArea)).getSubjectAreaAbbreviation();
    }

    public void setSubjectArea(Long subjectArea) {
        this.iSubjectArea = subjectArea;
    }

    public Collection getSubjectAreas() {
        return this.iSubjectAreas;
    }

    public void setSubjectAreas(Collection subjectAreas) {
        this.iSubjectAreas = subjectAreas;
    }

    public void load(SessionContext session) {
        this.load(session, false);
    }

    public void load(SessionContext session, boolean allSubjects) {
        this.setShowSections("1".equals(session.getUser().getProperty("ExamReport.showSections", "1")));
        this.setSubjectArea(session.getAttribute("ExamReport.subjectArea") == null ? null : (Long)session.getAttribute("ExamReport.subjectArea"));
        try {
            this.iSubjectAreas = allSubjects ? new TreeSet(new SubjectAreaDAO().getSession().createQuery("from SubjectArea where session.uniqueId=:sessionId").setLong("sessionId", session.getUser().getCurrentAcademicSessionId().longValue()).setCacheable(true).list()) : new TreeSet(new SubjectAreaDAO().getSession().createQuery("select distinct o.course.subjectArea from Exam x inner join x.owners o where x.session.uniqueId=:sessionId").setLong("sessionId", session.getUser().getCurrentAcademicSessionId().longValue()).setCacheable(true).list());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setExamType(session.getAttribute("Exam.Type") == null ? this.iExamType : (Long)session.getAttribute("Exam.Type"));
    }

    public void save(SessionContext session) {
        session.getUser().setProperty("ExamReport.showSections", this.getShowSections() ? "1" : "0");
        if (this.getSubjectArea() == null) {
            session.removeAttribute("ExamReport.subjectArea");
        } else {
            session.setAttribute("ExamReport.subjectArea", (Object)this.getSubjectArea());
        }
        session.setAttribute("Exam.Type", (Object)this.getExamType());
    }

    public void setTable(String table, int cols, int rows) {
        this.iTable = table;
        this.iNrColumns = cols;
        this.iNrRows = rows;
    }

    public String getTable() {
        return this.iTable;
    }

    public int getNrRows() {
        return this.iNrRows;
    }

    public int getNrColumns() {
        return this.iNrColumns;
    }

    public Long getExamType() {
        return this.iExamType;
    }

    public void setExamType(Long type) {
        this.iExamType = type;
    }
}

