/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.ManageSolversForm;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.model.dao.SolverPredefinedSettingDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.basic.GetInfo;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.jgroups.SolverServer;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;
import org.unitime.timetable.solver.ui.PropertiesInfo;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.LookupTables;

@Service(value="/manageSolvers")
public class ManageSolversAction
extends Action {
    private static Formats.Format<Date> sDF = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;
    @Autowired
    SolverService<StudentSolverProxy> studentSectioningSolverService;
    @Autowired
    SolverServerService solverServerService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SolverServer server;
        SolverServer server2;
        String id;
        String puid;
        String op;
        ManageSolversForm myForm = (ManageSolversForm)form;
        this.sessionContext.checkPermission(Right.ManageSolvers);
        String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        if ("Select".equals(op) && request.getParameter("puid") != null) {
            String puid2 = request.getParameter("puid");
            this.sessionContext.setAttribute(SessionAttribute.CourseTimetablingUser, (Object)puid2);
            this.sessionContext.removeAttribute(SessionAttribute.CourseTimetablingSolver);
            return mapping.findForward("showSolver");
        }
        if ("Unload".equals(op) && request.getParameter("puid") != null) {
            puid = request.getParameter("puid");
            this.sessionContext.setAttribute(SessionAttribute.CourseTimetablingUser, (Object)puid);
            this.sessionContext.removeAttribute(SessionAttribute.CourseTimetablingSolver);
            this.courseTimetablingSolverService.removeSolver();
        }
        if ("Select".equals(op) && request.getParameter("examPuid") != null) {
            puid = request.getParameter("examPuid");
            this.sessionContext.setAttribute(SessionAttribute.ExaminationUser, (Object)puid);
            this.sessionContext.removeAttribute(SessionAttribute.ExaminationSolver);
            LookupTables.setupExamTypes(request, this.sessionContext.getUser().getCurrentAcademicSessionId());
            return mapping.findForward("showExamSolver");
        }
        if ("Unload".equals(op) && request.getParameter("examPuid") != null) {
            puid = request.getParameter("examPuid");
            this.sessionContext.setAttribute(SessionAttribute.ExaminationUser, (Object)puid);
            this.sessionContext.removeAttribute(SessionAttribute.ExaminationSolver);
            this.examinationSolverService.removeSolver();
        }
        if ("Select".equals(op) && request.getParameter("sectionPuid") != null) {
            puid = request.getParameter("sectionPuid");
            this.sessionContext.setAttribute(SessionAttribute.StudentSectioningUser, (Object)puid);
            this.sessionContext.removeAttribute(SessionAttribute.StudentSectioningSolver);
            return mapping.findForward("showStudentSolver");
        }
        if ("Unload".equals(op) && request.getParameter("sectionPuid") != null) {
            puid = request.getParameter("sectionPuid");
            this.sessionContext.setAttribute(SessionAttribute.StudentSectioningUser, (Object)puid);
            this.sessionContext.removeAttribute(SessionAttribute.StudentSectioningSolver);
            this.studentSectioningSolverService.removeSolver();
        }
        if ("Unload".equals(op) && request.getParameter("onlineId") != null) {
            id = request.getParameter("onlineId");
            if (request.getParameter("host") != null) {
                server2 = this.solverServerService.getServer(request.getParameter("host"));
                if (server2 != null) {
                    server2.getOnlineStudentSchedulingContainer().unloadSolver(id);
                } else {
                    this.solverServerService.getOnlineStudentSchedulingContainer().unloadSolver(id);
                }
            } else {
                this.solverServerService.getOnlineStudentSchedulingContainer().unloadSolver(id);
            }
        }
        if ("Unmaster".equals(op) && request.getParameter("onlineId") != null) {
            id = request.getParameter("onlineId");
            if (request.getParameter("host") != null) {
                OnlineSectioningServer solver;
                server2 = this.solverServerService.getServer(request.getParameter("host"));
                if (server2 != null && (solver = server2.getOnlineStudentSchedulingContainer().getSolver(id)) != null) {
                    solver.releaseMasterLockIfHeld();
                }
            } else {
                OnlineSectioningServer solver = this.solverServerService.getOnlineStudentSchedulingContainer().getSolver(id);
                if (solver != null) {
                    solver.releaseMasterLockIfHeld();
                }
            }
        }
        if ("Deselect".equals(op)) {
            this.sessionContext.removeAttribute(SessionAttribute.CourseTimetablingUser);
            this.sessionContext.removeAttribute(SessionAttribute.CourseTimetablingSolver);
            this.sessionContext.removeAttribute(SessionAttribute.ExaminationUser);
            this.sessionContext.removeAttribute(SessionAttribute.ExaminationSolver);
            this.sessionContext.removeAttribute(SessionAttribute.StudentSectioningUser);
            this.sessionContext.removeAttribute(SessionAttribute.StudentSectioningSolver);
        }
        if ("Shutdown".equals(op) && (server = this.solverServerService.getServer(request.getParameter("solver"))) != null) {
            server.shutdown();
        }
        if ("Reset".equals(op) && (server = this.solverServerService.getServer(request.getParameter("solver"))) != null) {
            server.reset();
        }
        if ("Start Using".equals(op) && (server = this.solverServerService.getServer(request.getParameter("solver"))) != null) {
            server.setUsageBase(0);
        }
        if ("Stop Using".equals(op) && (server = this.solverServerService.getServer(request.getParameter("solver"))) != null) {
            server.setUsageBase(1000);
        }
        this.getSolvers(request);
        if (this.sessionContext.hasPermission(Right.SessionIndependent)) {
            this.getServers(request);
        }
        this.getExamSolvers(request);
        this.getStudentSolvers(request);
        this.getOnlineSolvers(request);
        return mapping.findForward("showSolvers");
    }

    public static String getName(String puid) {
        TimetableManager mgr = TimetableManager.findByExternalId(puid);
        return mgr == null ? puid : mgr.getShortName();
    }

    public static String getName(SolverGroup sg) {
        if (sg == null) {
            return null;
        }
        return sg.getAbbv();
    }

    private void getSolvers(HttpServletRequest request) throws Exception {
        try {
            WebTable.setOrder(this.sessionContext, "manageSolvers.ord", request.getParameter("ord"), 1);
            WebTable webTable = new WebTable(21, "Manage Course Solvers", "manageSolvers.do?ord=%%", new String[]{"Created", "Last Used", "Session", "Host", "Config", "Status", "Owner", "Mem", "Cores", "Assign", "Total", "Time", "Stud", "Room", "Distr", "Instr", "TooBig", "Useless", "Pert", "Note", "Operation(s)"}, new String[]{"left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left"}, null);
            webTable.setRowStyle("white-space:nowrap");
            int nrLines = 0;
            Long currentSessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
            SolverProxy x = this.courseTimetablingSolverService.getSolverNoSessionCheck();
            String xId = x == null ? null : x.getProperties().getProperty("General.OwnerPuid");
            HashSet<SolverProxy> solvers = new HashSet<SolverProxy>(this.courseTimetablingSolverService.getSolvers().values());
            for (SolverProxy solver : solvers) {
                Session session;
                DataProperties properties;
                if (solver == null || (properties = solver.getProperties()) == null) continue;
                String runnerName = ManageSolversAction.getName(properties.getProperty("General.OwnerPuid", "N/A"));
                Long[] solverGroupId = properties.getPropertyLongArry("General.SolverGroupId", null);
                String ownerName = "";
                if (solverGroupId != null) {
                    for (int j = 0; j < solverGroupId.length; ++j) {
                        if (j > 0) {
                            ownerName = ownerName + " & ";
                        }
                        ownerName = ownerName + ManageSolversAction.getName((SolverGroup)new SolverGroupDAO().get(solverGroupId[j]));
                    }
                }
                if (ownerName == null || ownerName.length() == 0) {
                    ownerName = "N/A";
                }
                if (runnerName == null) {
                    runnerName = "N/A";
                }
                if (ownerName.equals("N/A")) {
                    ownerName = runnerName;
                }
                if (runnerName.equals("N/A")) {
                    runnerName = ownerName;
                }
                if (!ownerName.equals(runnerName)) {
                    ownerName = runnerName + " as " + ownerName;
                }
                if ((session = (Session)new SessionDAO().get(properties.getPropertyLong("General.SessionId", new Long(-1L)))) == null || this.sessionContext.getUser().getAuthorities(this.sessionContext.getUser().getCurrentAuthority().getRole(), session).isEmpty()) continue;
                String sessionLabel = "N/A";
                if (session != null) {
                    sessionLabel = session.getLabel();
                }
                SolverPredefinedSetting setting = (SolverPredefinedSetting)new SolverPredefinedSettingDAO().get(properties.getPropertyLong("General.SettingsId", new Long(-1L)));
                String settingLabel = properties.getProperty("Basic.Mode", "N/A");
                if (setting != null) {
                    settingLabel = setting.getDescription();
                }
                String onClick = null;
                if (session != null && session.getUniqueId().equals(currentSessionId) && properties.getProperty("General.OwnerPuid") != null) {
                    onClick = "onClick=\"document.location='manageSolvers.do?op=Select&puid=" + properties.getProperty("General.OwnerPuid") + "';\"";
                }
                String status = "N/A";
                try {
                    status = (String)solver.getProgress().get("STATUS");
                }
                catch (Exception e) {
                    // empty catch block
                }
                String note = null;
                try {
                    note = solver.getNote();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (note != null) {
                    note = note.replaceAll("\n", "<br>");
                }
                PropertiesInfo globalInfo = null;
                try {
                    globalInfo = solver.getGlobalInfo();
                }
                catch (Exception e) {
                    // empty catch block
                }
                String assigned = globalInfo == null ? "?" : globalInfo.getProperty("Assigned variables", "N/A");
                String totVal = globalInfo == null ? "?" : globalInfo.getProperty("Overall solution value", "N/A");
                String timePr = globalInfo == null ? "?" : globalInfo.getProperty("Time preferences", "N/A");
                String studConf = globalInfo == null ? "?" : globalInfo.getProperty("Student conflicts", "N/A");
                String roomPr = globalInfo == null ? "?" : globalInfo.getProperty("Room preferences", "N/A");
                String distPr = globalInfo == null ? "?" : globalInfo.getProperty("Distribution preferences", "N/A");
                String instrPr = globalInfo == null ? "?" : globalInfo.getProperty("Back-to-back instructor preferences", "N/A");
                String tooBig = globalInfo == null ? "?" : globalInfo.getProperty("Too big rooms", "N/A");
                String useless = globalInfo == null ? "?" : globalInfo.getProperty("Useless half-hours", "N/A");
                String pertPen = globalInfo == null ? "?" : globalInfo.getProperty("Perturbations: Total penalty", "N/A");
                assigned = assigned.replaceAll(" of ", "/");
                if (!"N/A".equals(timePr) && timePr.indexOf(47) >= 0) {
                    timePr = timePr.substring(0, timePr.indexOf(47)).trim();
                }
                if (!"N/A".equals(roomPr) && roomPr.indexOf(47) >= 0) {
                    roomPr = roomPr.substring(0, roomPr.indexOf(47)).trim();
                }
                if (!"N/A".equals(instrPr) && instrPr.indexOf(47) >= 0) {
                    instrPr = instrPr.substring(0, instrPr.indexOf(47)).trim();
                }
                if (!"N/A".equals(assigned) && assigned.indexOf(32) >= 0) {
                    assigned = assigned.substring(0, assigned.indexOf(32)).trim();
                }
                if (!"N/A".equals(timePr) && timePr.indexOf(32) >= 0) {
                    timePr = timePr.substring(0, timePr.indexOf(32)).trim();
                }
                if (!"N/A".equals(roomPr) && roomPr.indexOf(32) >= 0) {
                    roomPr = roomPr.substring(0, roomPr.indexOf(32)).trim();
                }
                if (!"N/A".equals(instrPr) && instrPr.indexOf(32) >= 0) {
                    instrPr = instrPr.substring(0, instrPr.indexOf(32)).trim();
                }
                if (!"N/A".equals(distPr) && distPr.indexOf(32) >= 0) {
                    distPr = distPr.substring(0, distPr.indexOf(32)).trim();
                }
                if (!"N/A".equals(tooBig) && tooBig.indexOf(32) >= 0) {
                    tooBig = tooBig.substring(0, tooBig.indexOf(32)).trim();
                }
                if (!"N/A".equals(useless) && useless.indexOf(32) >= 0) {
                    useless = useless.substring(0, useless.indexOf(32)).trim();
                }
                studConf = studConf.replaceAll(" \\[", "(").replaceAll("\\]", ")").replaceAll(", ", ",").replaceAll("hard:", "h").replaceAll("distance:", "d").replaceAll("commited:", "c").replaceAll("committed:", "c");
                Date loaded = solver.getLoadedDate();
                Date lastUsed = solver.getLastUsed();
                String bgColor = null;
                if (x != null && ToolBox.equals((Object)properties.getProperty("General.OwnerPuid"), (Object)xId)) {
                    bgColor = "rgb(168,187,225)";
                }
                String op = "";
                op = op + "<input type=\"button\" value=\"Unload\" onClick=\"if (confirm('Do you really want to unload this solver?')) document.location='manageSolvers.do?op=Unload&puid=" + properties.getProperty("General.OwnerPuid") + "';" + " event.cancelBubble=true;\">";
                int nrCores = Math.abs(properties.getPropertyInt("Parallel.NrSolvers", 4));
                webTable.addLine(onClick, new String[]{loaded == null ? "N/A" : sDF.format(loaded), lastUsed == null ? "N/A" : sDF.format(lastUsed), sessionLabel, solver.getHost(), settingLabel, status, ownerName, "<span name='UniTimeGWT:SolverAllocatedMem' style='display: none;'>C" + solver.getUser() + "</span>", String.valueOf(nrCores), assigned, totVal, timePr, studConf, roomPr, distPr, instrPr, tooBig, useless, pertPen, note, op}, new Comparable[]{loaded == null ? new Date() : loaded, lastUsed == null ? new Date() : lastUsed, sessionLabel, solver.getHost(), settingLabel, status, ownerName, null, Integer.valueOf(nrCores), assigned, totVal, timePr, studConf, roomPr, distPr, instrPr, tooBig, useless, pertPen, solver.getNote() == null ? "" : solver.getNote(), null}).setBgColor(bgColor);
                ++nrLines;
            }
            if (nrLines == 0) {
                webTable.addLine(null, new String[]{"<i>No solver is running.</i>"}, null, null);
            }
            request.setAttribute("ManageSolvers.table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "manageSolvers.ord")));
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private void getServers(HttpServletRequest request) throws Exception {
        try {
            WebTable.setOrder(this.sessionContext, "manageSolvers.ord2", request.getParameter("ord2"), 1);
            WebTable webTable = new WebTable(12, "Available Servers", "manageSolvers.do?ord2=%%", new String[]{"Host", "Version", "Started", "Available Memory", "NrCores", "Ping", "Usage", "NrInstances", "Active", "Working", "Passivated", "Operation(s)"}, new String[]{"left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left"}, null);
            webTable.setRowStyle("white-space:nowrap");
            DecimalFormat df = new DecimalFormat("0.00");
            int nrLines = 0;
            for (SolverServer server : this.solverServerService.getServers(false)) {
                Object solver;
                if (!server.isActive()) {
                    webTable.addLine(null, new String[]{server.getHost(), "<i>inactive</i>", "", "", "", "", "", "", "", "", "", ""}, new Comparable[]{server.getHost(), "", null, new Long(-1L), new Integer(-1), new Long(-1L), new Long(-1L), new Integer(-1), new Integer(-1), new Integer(-1), new Integer(-1), null});
                    continue;
                }
                int nrActive = 0;
                int nrPassivated = 0;
                int nrWorking = 0;
                long mem = server.getAvailableMemory();
                long t0 = System.currentTimeMillis();
                long usage = server.getUsage();
                long t1 = System.currentTimeMillis();
                for (String user : server.getCourseSolverContainer().getSolvers()) {
                    solver = server.getCourseSolverContainer().getSolver(user);
                    if (solver == null) continue;
                    if (solver.isPassivated()) {
                        ++nrPassivated;
                        continue;
                    }
                    ++nrActive;
                    if (!solver.isWorking()) continue;
                    ++nrWorking;
                }
                for (String user : server.getExamSolverContainer().getSolvers()) {
                    solver = server.getExamSolverContainer().getSolver(user);
                    if (solver == null) continue;
                    if (solver.isPassivated()) {
                        ++nrPassivated;
                        continue;
                    }
                    ++nrActive;
                    if (!solver.isWorking()) continue;
                    ++nrWorking;
                }
                String version = server.getVersion();
                Date startTime = server.getStartTime();
                boolean local = server.isLocal();
                int cores = server.getAvailableProcessors();
                String op = "";
                op = usage >= 1000L ? op + "<input type=\"button\" value=\"Enable\" onClick=\"if (confirm('Do you really want to enable server " + server.getHost() + " for the new solver instances?')) document.location='manageSolvers.do?op=Start%20Using&solver=" + server.getHost() + "';\">&nbsp;&nbsp;" : op + "<input type=\"button\" value=\"Disable\" onClick=\"if (confirm('Do you really want to disable server " + server.getHost() + " for the new solver instances?')) document.location='manageSolvers.do?op=Stop%20Using&solver=" + server.getHost() + "';\">&nbsp;&nbsp;";
                op = op + "<input type=\"button\" value=\"Reset\" onClick=\"if (confirm('Do you really want to reset server " + server.getHost() + "?')) document.location='manageSolvers.do?op=Reset&solver=" + server.getHost() + "';\">&nbsp;&nbsp;";
                if (!local) {
                    op = op + "<input type=\"button\" value=\"Shutdown\" onClick=\"if (confirm('Do you really want to shutdown server " + server.getHost() + "?')) document.location='manageSolvers.do?op=Shutdown&solver=" + server.getHost() + "';\">&nbsp;&nbsp;";
                }
                TreeSet<String> flags = new TreeSet<String>();
                if (local) {
                    flags.add("tomcat");
                }
                if (server.isCoordinator()) {
                    flags.add("coordinator");
                }
                if (!server.isAvailable()) {
                    flags.add("unavailable");
                }
                webTable.addLine(null, new String[]{server.getHost() + (flags.isEmpty() ? "" : " " + ((Object)flags).toString()), version == null || "-1".equals(version) ? "<i>N/A</i>" : version, startTime == null ? "<i>N/A</i>" : sDF.format(startTime), df.format((double)mem / 1024.0 / 1024.0) + " MB", String.valueOf(cores), t1 - t0 + " ms", String.valueOf(usage), String.valueOf(nrActive + nrPassivated), String.valueOf(nrActive), String.valueOf(nrWorking), String.valueOf(nrPassivated), op}, new Comparable[]{server.getHost(), version, startTime, new Long(t1 - t0), new Integer(cores), new Long(mem), new Long(usage), new Integer(nrActive + nrPassivated), new Integer(nrActive), new Integer(nrWorking), new Integer(nrPassivated), null});
                ++nrLines;
            }
            if (nrLines == 0) {
                webTable.addLine(null, new String[]{"<i>No solver server is running.</i>"}, null, null);
            }
            request.setAttribute("ManageSolvers.table2", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "manageSolvers.ord2")));
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private void getExamSolvers(HttpServletRequest request) throws Exception {
        try {
            WebTable.setOrder(this.sessionContext, "manageSolvers.ord3", request.getParameter("ord3"), 1);
            WebTable webTable = new WebTable(22, "Manage Examination Solvers", "manageSolvers.do?ord3=%%", new String[]{"Created", "Last Used", "Session", "Host", "Config", "Status", "Owner", "Mem", "Cores", "Type", "Assign", "Total", "StudConf", "InstConf", "Period", "Room", "RoomSplit", "RoomSize", "Distr", "Rot", "Pert", "Operation(s)"}, new String[]{"left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left"}, null);
            webTable.setRowStyle("white-space:nowrap");
            int nrLines = 0;
            Long currentSessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
            ExamSolverProxy x = this.examinationSolverService.getSolver();
            String xId = x == null ? null : x.getProperties().getProperty("General.OwnerPuid");
            for (ExamSolverProxy solver : this.examinationSolverService.getSolvers().values()) {
                Session session;
                DataProperties properties;
                if (solver == null || (properties = solver.getProperties()) == null) continue;
                String runnerName = ManageSolversAction.getName(properties.getProperty("General.OwnerPuid", "N/A"));
                Long examTypeId = solver.getExamTypeId();
                if (runnerName == null) {
                    runnerName = "N/A";
                }
                if ((session = (Session)new SessionDAO().get(properties.getPropertyLong("General.SessionId", new Long(-1L)))) == null || this.sessionContext.getUser().getAuthorities(this.sessionContext.getUser().getCurrentAuthority().getRole(), session).isEmpty()) continue;
                String sessionLabel = "N/A";
                if (session != null) {
                    sessionLabel = session.getLabel();
                }
                SolverPredefinedSetting setting = (SolverPredefinedSetting)new SolverPredefinedSettingDAO().get(properties.getPropertyLong("General.SettingsId", new Long(-1L)));
                String settingLabel = properties.getProperty("Basic.Mode", "N/A");
                if (setting != null) {
                    settingLabel = setting.getDescription();
                }
                String onClick = null;
                if (session.getUniqueId().equals(currentSessionId) && properties.getProperty("General.OwnerPuid") != null) {
                    onClick = "onClick=\"document.location='manageSolvers.do?op=Select&examPuid=" + properties.getProperty("General.OwnerPuid") + "';\"";
                }
                String status = (String)solver.getProgress().get("STATUS");
                Map<String, String> info = null;
                try {
                    info = solver.currentSolutionInfo();
                }
                catch (Exception e) {
                    // empty catch block
                }
                String assigned = info.get("Assigned variables");
                String totVal = info.get("Overall solution value");
                String dc = info.get("Direct Conflicts");
                String m2d = info.get("More Than 2 A Day Conflicts");
                String btb = info.get("Back-To-Back Conflicts");
                String conf = (dc == null ? "0" : dc) + ", " + (m2d == null ? "0" : m2d) + ", " + (btb == null ? "0" : btb);
                String idc = info.get("Instructor Direct Conflicts");
                String im2d = info.get("Instructor More Than 2 A Day Conflicts");
                String ibtb = info.get("Instructor Back-To-Back Conflicts");
                String iconf = (idc == null ? "0" : idc) + ", " + (im2d == null ? "0" : im2d) + ", " + (ibtb == null ? "0" : ibtb);
                String pp = info.get("Period Penalty");
                String rp = info.get("Room Penalty");
                String rsp = info.get("Room Split Penalty");
                String rsz = info.get("Room Size Penalty");
                String dp = info.get("Distribution Penalty");
                String erp = info.get("Exam Rotation Penalty");
                String pert = info.get("Perturbation Penalty");
                Date loaded = solver.getLoadedDate();
                Date lastUsed = solver.getLastUsed();
                String bgColor = null;
                if (x != null && ToolBox.equals((Object)properties.getProperty("General.OwnerPuid"), (Object)xId)) {
                    bgColor = "rgb(168,187,225)";
                }
                String op = "";
                op = op + "<input type=\"button\" value=\"Unload\" onClick=\"if (confirm('Do you really want to unload this solver?')) document.location='manageSolvers.do?op=Unload&examPuid=" + properties.getProperty("General.OwnerPuid") + "';" + " event.cancelBubble=true;\">";
                ExamType examType = examTypeId == null ? null : (ExamType)ExamTypeDAO.getInstance().get(examTypeId);
                int nrCores = Math.abs(properties.getPropertyInt("Parallel.NrSolvers", 4));
                String[] stringArray = new String[22];
                stringArray[0] = loaded == null ? "N/A" : sDF.format(loaded);
                stringArray[1] = lastUsed == null ? "N/A" : sDF.format(lastUsed);
                stringArray[2] = sessionLabel;
                stringArray[3] = solver.getHost();
                stringArray[4] = settingLabel;
                stringArray[5] = status;
                stringArray[6] = runnerName;
                stringArray[7] = "<span name='UniTimeGWT:SolverAllocatedMem' style='display: none;'>X" + solver.getUser() + "</span>";
                stringArray[8] = String.valueOf(nrCores);
                String string = stringArray[9] = examType == null ? "N/A?" : examType.getLabel();
                stringArray[10] = assigned == null ? "N/A" : (assigned.indexOf(32) >= 0 ? assigned.substring(0, assigned.indexOf(32)) : assigned);
                stringArray[11] = totVal == null ? "N/A" : totVal;
                stringArray[12] = conf == null ? "N/A" : conf;
                String string2 = stringArray[13] = iconf == null ? "N/A" : iconf;
                String string3 = pp == null ? "N/A" : (stringArray[14] = pp.indexOf(32) >= 0 ? pp.substring(0, pp.indexOf(32)) : pp);
                String string4 = rp == null ? "N/A" : (stringArray[15] = rp.indexOf(32) >= 0 ? rp.substring(0, rp.indexOf(32)) : rp);
                String string5 = rsp == null ? "N/A" : (stringArray[16] = rsp.indexOf(32) >= 0 ? rsp.substring(0, rsp.indexOf(32)) : rsp);
                String string6 = rsz == null ? "N/A" : (stringArray[17] = rsz.indexOf(32) >= 0 ? rsz.substring(0, rsz.indexOf(32)) : rsz);
                String string7 = dp == null ? "N/A" : (stringArray[18] = dp.indexOf(32) >= 0 ? dp.substring(0, dp.indexOf(32)) : dp);
                String string8 = erp == null ? "N/A" : (stringArray[19] = erp.indexOf(32) >= 0 ? erp.substring(0, erp.indexOf(32)) : erp);
                stringArray[20] = pert == null ? "N/A" : (pert.indexOf(32) >= 0 ? pert.substring(0, pert.indexOf(32)) : pert);
                stringArray[21] = op;
                webTable.addLine(onClick, stringArray, new Comparable[]{loaded == null ? new Date() : loaded, lastUsed == null ? new Date() : lastUsed, sessionLabel, solver.getHost(), settingLabel, status, runnerName, null, Integer.valueOf(nrCores), examTypeId, assigned == null ? "" : assigned, totVal == null ? "" : totVal, conf == null ? "" : conf, iconf == null ? "" : iconf, pp == null ? "" : pp, rp == null ? "" : rp, rsp == null ? "" : rsp, rsz == null ? "" : rsz, dp == null ? "" : dp, erp == null ? "" : erp, pert == null ? "" : pert, null}).setBgColor(bgColor);
                ++nrLines;
            }
            if (nrLines == 0) {
                webTable.addLine(null, new String[]{"<i>No solver is running.</i>"}, null, null);
            }
            request.setAttribute("ManageSolvers.xtable", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "manageSolvers.ord3")));
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private void getStudentSolvers(HttpServletRequest request) throws Exception {
        try {
            WebTable.setOrder(this.sessionContext, "manageSolvers.ord4", request.getParameter("ord4"), 1);
            WebTable webTable = new WebTable(15, "Manage Student Sectioning Solvers", "manageSolvers.do?ord4=%%", new String[]{"Created", "Last Used", "Session", "Host", "Config", "Status", "Owner", "Mem", "Cores", "Assign", "Total", "CompSched", "DistConf", "Pert", "Operation(s)"}, new String[]{"left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left"}, null);
            webTable.setRowStyle("white-space:nowrap");
            int nrLines = 0;
            Long currentSessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
            StudentSolverProxy x = this.studentSectioningSolverService.getSolver();
            String xId = x == null ? null : x.getProperties().getProperty("General.OwnerPuid");
            for (StudentSolverProxy solver : this.studentSectioningSolverService.getSolvers().values()) {
                Session session;
                DataProperties properties;
                if (solver == null || (properties = solver.getProperties()) == null) continue;
                String runnerName = ManageSolversAction.getName(properties.getProperty("General.OwnerPuid", "N/A"));
                if (runnerName == null) {
                    runnerName = "N/A";
                }
                if ((session = (Session)new SessionDAO().get(properties.getPropertyLong("General.SessionId", new Long(-1L)))) == null || this.sessionContext.getUser().getAuthorities(this.sessionContext.getUser().getCurrentAuthority().getRole(), session).isEmpty()) continue;
                String sessionLabel = session.getLabel();
                SolverPredefinedSetting setting = (SolverPredefinedSetting)new SolverPredefinedSettingDAO().get(properties.getPropertyLong("General.SettingsId", new Long(-1L)));
                String settingLabel = properties.getProperty("Basic.Mode", "N/A");
                if (setting != null) {
                    settingLabel = setting.getDescription();
                }
                String onClick = null;
                if (session.getUniqueId().equals(currentSessionId) && properties.getProperty("General.OwnerPuid") != null) {
                    onClick = "onClick=\"document.location='manageSolvers.do?op=Select&sectionPuid=" + properties.getProperty("General.OwnerPuid") + "';\"";
                }
                String status = (String)solver.getProgress().get("STATUS");
                Map<String, String> info = null;
                try {
                    info = solver.currentSolutionInfo();
                }
                catch (Exception e) {
                    // empty catch block
                }
                String assigned = info.get("Assigned variables");
                String totVal = info.get("Overall solution value");
                String compSch = info.get("Students with complete schedule");
                String distConf = info.get("Student distance conflicts");
                String pert = info.get("Perturbation Penalty");
                Date loaded = solver.getLoadedDate();
                Date lastUsed = solver.getLastUsed();
                String bgColor = null;
                if (x != null && ToolBox.equals((Object)properties.getProperty("General.OwnerPuid"), (Object)xId)) {
                    bgColor = "rgb(168,187,225)";
                }
                String op = "";
                op = op + "<input type=\"button\" value=\"Unload\" onClick=\"if (confirm('Do you really want to unload this solver?')) document.location='manageSolvers.do?op=Unload&sectionPuid=" + properties.getProperty("General.OwnerPuid") + "';" + " event.cancelBubble=true;\">";
                int nrCores = Math.abs(properties.getPropertyInt("Parallel.NrSolvers", 4));
                String[] stringArray = new String[15];
                stringArray[0] = loaded == null ? "N/A" : sDF.format(loaded);
                stringArray[1] = lastUsed == null ? "N/A" : sDF.format(lastUsed);
                stringArray[2] = sessionLabel;
                stringArray[3] = solver.getHost();
                stringArray[4] = settingLabel;
                stringArray[5] = status;
                stringArray[6] = runnerName;
                stringArray[7] = "<span name='UniTimeGWT:SolverAllocatedMem' style='display: none;'>S" + solver.getUser() + "</span>";
                stringArray[8] = String.valueOf(nrCores);
                stringArray[9] = assigned == null ? "N/A" : (assigned.indexOf(32) >= 0 ? assigned.substring(0, assigned.indexOf(32)) : assigned);
                stringArray[10] = totVal == null ? "N/A" : totVal;
                stringArray[11] = compSch == null ? "N/A" : compSch;
                String string = stringArray[12] = distConf == null ? "N/A" : distConf;
                stringArray[13] = pert == null ? "N/A" : (pert.indexOf(32) >= 0 ? pert.substring(0, pert.indexOf(32)) : pert);
                stringArray[14] = op;
                webTable.addLine(onClick, stringArray, new Comparable[]{loaded == null ? new Date() : loaded, lastUsed == null ? new Date() : lastUsed, sessionLabel, solver.getHost(), settingLabel, status, runnerName, null, Integer.valueOf(nrCores), assigned == null ? "" : assigned, totVal == null ? "" : totVal, compSch == null ? "" : compSch, distConf == null ? "" : distConf, pert == null ? "" : pert, null}).setBgColor(bgColor);
                ++nrLines;
            }
            if (nrLines == 0) {
                webTable.addLine(null, new String[]{"<i>No solver is running.</i>"}, null, null);
            }
            request.setAttribute("ManageSolvers.stable", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "manageSolvers.ord4")));
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private void getOnlineSolvers(HttpServletRequest request) throws Exception {
        try {
            WebTable.setOrder(this.sessionContext, "manageSolvers.ord5", request.getParameter("ord5"), 1);
            WebTable webTable = new WebTable(15, "Manage Online Scheduling Servers", "manageSolvers.do?ord5=%%", new String[]{"Created", "Session", "Host", "Mode", "Mem", "Assign", "Total", "CompSched", "DistConf", "TimeConf", "FreeConf", "AvgDisb", "Disb[>=10%]", "Operation(s)"}, new String[]{"left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left"}, null);
            webTable.setRowStyle("white-space:nowrap");
            int nrLines = 0;
            List<SolverServer> servers = this.solverServerService.getServers(true);
            for (SolverServer server : servers) {
                for (String sessionId : server.getOnlineStudentSchedulingContainer().getSolvers()) {
                    DataProperties properties;
                    OnlineSectioningServer solver = server.getOnlineStudentSchedulingContainer().getSolver(sessionId);
                    if (solver == null || (properties = solver.getConfig()) == null || this.sessionContext.getUser().getAuthorities(this.sessionContext.getUser().getCurrentAuthority().getRole(), new SimpleQualifier("Session", Long.valueOf(sessionId))).isEmpty()) continue;
                    String sessionLabel = solver.getAcademicSession().toString();
                    String mode = solver.getAcademicSession().isSectioningEnabled() ? "Online" : "Assistant";
                    Map<String, String> info = solver.isReady() ? solver.execute(solver.createAction(GetInfo.class), null) : null;
                    String assigned = info == null ? null : info.get("Assigned variables");
                    String totVal = info == null ? null : info.get("Overall solution value");
                    String compSch = info == null ? null : info.get("Students with complete schedule");
                    String distConf = info == null ? null : info.get("Student distance conflicts");
                    String time = info == null ? null : info.get("Time overlapping conflicts");
                    String free = info == null ? null : info.get("Free time overlapping conflicts");
                    String disb = info == null ? null : info.get("Average disbalance");
                    String disb10 = info == null ? null : info.get("Sections disbalanced by 10% or more");
                    Date loaded = new Date(solver.getConfig().getPropertyLong("General.StartUpDate", 0L));
                    String op = "";
                    if (solver.isMaster() && servers.size() > 1) {
                        op = op + "<input type=\"button\" value=\"Shutdown All\" onClick=\"if (confirm('Do you really want to shutdown this server?')) document.location='manageSolvers.do?op=Unload&onlineId=" + sessionId + "';" + " event.cancelBubble=true;\">&nbsp;&nbsp;";
                        op = op + "<input type=\"button\" value=\"Un-Master\" onClick=\"if (confirm('Do you really want to un-master this server?')) document.location='manageSolvers.do?op=Unmaster&onlineId=" + sessionId + "&host=" + server.getHost() + "';" + " event.cancelBubble=true;\">";
                    } else {
                        op = op + "<input type=\"button\" value=\"Shutdown\" onClick=\"if (confirm('Do you really want to shutdown this server?')) document.location='manageSolvers.do?op=Unload&onlineId=" + sessionId + "&host=" + server.getHost() + "';" + " event.cancelBubble=true;\">";
                    }
                    webTable.addLine(null, new String[]{loaded.getTime() <= 0L ? "N/A" : sDF.format(loaded), sessionLabel, solver.getHost() + (solver.isMaster() ? " (master)" : ""), mode, "<span name='UniTimeGWT:SolverAllocatedMem' style='display: none;'>O" + server.getHost() + ":" + sessionId + "</span>", assigned == null ? "N/A" : assigned, totVal == null ? "N/A" : totVal, compSch == null ? "N/A" : compSch, distConf == null ? "N/A" : distConf, time == null ? "N/A" : time, free == null ? "N/A" : free, disb == null ? "N/A" : disb, disb10 == null ? "N/A" : disb10, op}, new Comparable[]{loaded, sessionLabel, solver.getHost(), mode, null, assigned == null ? "" : assigned, totVal == null ? "" : totVal, compSch == null ? "" : compSch, distConf == null ? "" : distConf, time == null ? "" : time, free == null ? "" : free, disb == null ? "" : disb, disb10 == null ? "" : disb10, null});
                    ++nrLines;
                }
            }
            if (nrLines == 0) {
                webTable.addLine(null, new String[]{"<i>There is no online student scheduling server running at the moment.</i>"}, null, null);
            }
            request.setAttribute("ManageSolvers.otable", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "manageSolvers.ord5")));
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }
}

