/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.ListSolutionsForm;
import org.unitime.timetable.form.SolverForm;
import org.unitime.timetable.interfaces.ExternalSolutionCommitAction;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SolverParameter;
import org.unitime.timetable.model.SolverPredefinedSetting;
import org.unitime.timetable.model.dao.SolutionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.model.dao.SolverPredefinedSettingDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.jgroups.SolverServer;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.solver.ui.PropertiesInfo;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.Formats;

@Service(value="/listSolutions")
public class ListSolutionsAction
extends Action {
    private static Formats.Format<Date> sDF = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverServerService solverServerService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SolverProxy solver;
        ExternalSolutionCommitAction commitAction;
        String className;
        String note;
        Solution solution;
        Session hibSession;
        SolutionDAO dao;
        Transaction tx;
        ListSolutionsForm.SolutionBean solutionBean;
        ActionErrors errors;
        String op;
        ListSolutionsForm myForm = (ListSolutionsForm)form;
        this.sessionContext.checkPermission(Right.Timetables);
        String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        if ("n".equals(request.getParameter("confirm"))) {
            op = null;
        }
        if (request.getSession().getAttribute("Solver.selectedSolutionId") != null) {
            StringTokenizer s = new StringTokenizer((String)request.getSession().getAttribute("Solver.selectedSolutionId"), ",");
            while (s.hasMoreTokens()) {
                Long solutionId = Long.valueOf(s.nextToken());
                Solution solution2 = (Solution)new SolutionDAO().get(solutionId);
                if (solution2 == null) continue;
                myForm.addSolution(solution2);
            }
        }
        if (this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.CanSelectSolverServer)) {
            ArrayList<String> hosts = new ArrayList<String>();
            for (SolverServer server : this.solverServerService.getServers(true)) {
                hosts.add(server.getHost());
            }
            Collections.sort(hosts);
            if (ApplicationProperty.SolverLocalEnabled.isTrue()) {
                hosts.add(0, "local");
            }
            hosts.add(0, "auto");
            request.setAttribute("hosts", hosts);
        }
        ArrayList<SolverForm.LongIdValue> owners = new ArrayList<SolverForm.LongIdValue>();
        for (SolverGroup owner : SolverGroup.getUserSolverGroups(this.sessionContext.getUser())) {
            if (!this.sessionContext.hasPermission(owner, Right.TimetablesSolutionLoadEmpty)) continue;
            owners.add(new SolverForm.LongIdValue(owner.getUniqueId(), owner.getName()));
        }
        if (owners.size() == 1) {
            myForm.setOwnerId(((SolverForm.LongIdValue)owners.get(0)).getId());
        } else if (!owners.isEmpty()) {
            request.setAttribute("owners", owners);
        }
        if ("Update Note".equals(op)) {
            errors = myForm.validate(mapping, request);
            if (errors.size() > 0) {
                this.saveErrors(request, (ActionMessages)errors);
                mapping.findForward("showSolutions");
            } else {
                solutionBean = myForm.getSolutionBean();
                if (solutionBean != null) {
                    tx = null;
                    try {
                        dao = new SolutionDAO();
                        hibSession = dao.getSession();
                        if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                            tx = hibSession.beginTransaction();
                        }
                        solution = (Solution)dao.get(solutionBean.getUniqueId(), hibSession);
                        this.sessionContext.checkPermission(solution, Right.TimetablesSolutionChangeNote);
                        note = myForm.getNote();
                        if (note != null && note.length() > 1000) {
                            note = note.substring(0, 1000);
                        }
                        solutionBean.setNote(note);
                        solution.setNote(note);
                        dao.saveOrUpdate(solution, hibSession);
                        if (tx != null) {
                            tx.commit();
                        }
                    }
                    catch (Exception e) {
                        if (tx != null) {
                            tx.rollback();
                        }
                        Debug.error(e);
                    }
                }
            }
        }
        if ("Commit".equals(op) || "Uncommit".equals(op)) {
            errors = myForm.validate(mapping, request);
            if (errors.size() > 0) {
                this.saveErrors(request, (ActionMessages)errors);
                mapping.findForward("showSolutions");
            } else {
                solutionBean = myForm.getSolutionBean();
                if (solutionBean != null) {
                    tx = null;
                    try {
                        dao = new SolutionDAO();
                        hibSession = dao.getSession();
                        if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                            tx = hibSession.beginTransaction();
                        }
                        solution = (Solution)dao.get(solutionBean.getUniqueId(), hibSession);
                        this.sessionContext.checkPermission(solution.getOwner(), Right.TimetablesSolutionCommit);
                        if ("Commit".equals(op)) {
                            List solutions = hibSession.createCriteria(Solution.class).add((Criterion)Restrictions.eq((String)"owner", (Object)solution.getOwner())).list();
                            HashSet<Solution> touchedSolutionSet = new HashSet<Solution>();
                            for (Solution s : solutions) {
                                if (s.equals(solution) || !s.isCommited().booleanValue()) continue;
                                touchedSolutionSet.add(s);
                            }
                            touchedSolutionSet.add(solution);
                            boolean committed = solution.commitSolution(myForm.getMessages(), hibSession, this.sessionContext.getUser().getExternalUserId());
                            hibSession.update((Object)solution);
                            String className2 = ApplicationProperty.ExternalActionSolutionCommit.value();
                            if (className2 != null && className2.trim().length() > 0) {
                                ExternalSolutionCommitAction commitAction2 = (ExternalSolutionCommitAction)Class.forName(className2).newInstance();
                                commitAction2.performExternalSolutionCommitAction(touchedSolutionSet, hibSession);
                            }
                            solutionBean.setCommited(committed ? sDF.format(solution.getCommitDate()) : null);
                        } else {
                            solution.uncommitSolution(hibSession, this.sessionContext.getUser().getExternalUserId());
                            className = ApplicationProperty.ExternalActionSolutionCommit.value();
                            if (className != null && className.trim().length() > 0) {
                                commitAction = (ExternalSolutionCommitAction)Class.forName(className).newInstance();
                                HashSet<Solution> solutions = new HashSet<Solution>();
                                solutions.add(solution);
                                commitAction.performExternalSolutionCommitAction(solutions, hibSession);
                            }
                            solutionBean.setCommited(null);
                        }
                        note = solutionBean.getNote();
                        if (note != null && note.length() > 1000) {
                            note = note.substring(0, 1000);
                        }
                        solution.setNote(note);
                        dao.saveOrUpdate(solution, hibSession);
                        if (tx != null) {
                            tx.commit();
                        }
                    }
                    catch (Exception e) {
                        if (tx != null) {
                            tx.rollback();
                        }
                        Debug.error(e);
                    }
                }
            }
        }
        if ("Delete".equals(op)) {
            errors = myForm.validate(mapping, request);
            if (errors.size() > 0) {
                this.saveErrors(request, (ActionMessages)errors);
                mapping.findForward("showSolutions");
            } else {
                solutionBean = myForm.getSolutionBean();
                if (solutionBean != null) {
                    tx = null;
                    try {
                        dao = new SolutionDAO();
                        hibSession = dao.getSession();
                        if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                            tx = hibSession.beginTransaction();
                        }
                        if ((solution = (Solution)dao.get(solutionBean.getUniqueId())) != null) {
                            if (solution.isCommited().booleanValue()) {
                                this.sessionContext.checkPermission(solution.getOwner(), Right.TimetablesSolutionCommit);
                                solution.uncommitSolution(hibSession, this.sessionContext.getUser().getExternalUserId());
                                className = ApplicationProperty.ExternalActionSolutionCommit.value();
                                if (className != null && className.trim().length() > 0) {
                                    commitAction = (ExternalSolutionCommitAction)Class.forName(className).newInstance();
                                    HashSet<Solution> solutions = new HashSet<Solution>();
                                    solutions.add(solution);
                                    commitAction.performExternalSolutionCommitAction(solutions, hibSession);
                                }
                            }
                            this.sessionContext.checkPermission(solution, Right.TimetablesSolutionDelete);
                            solution.delete(hibSession);
                        }
                        if (tx != null) {
                            tx.commit();
                        }
                    }
                    catch (Exception e) {
                        if (tx != null) {
                            tx.rollback();
                        }
                        Debug.error(e);
                    }
                    myForm.removeSolution(solutionBean.getUniqueId());
                    request.getSession().setAttribute("Solver.selectedSolutionId", (Object)myForm.getSolutionId());
                }
            }
        }
        if ("Load".equals(op) || "Load Empty Solution".equals(op)) {
            solver = this.courseTimetablingSolverService.getSolver();
            if (solver != null && solver.isWorking()) {
                throw new Exception("Solver is working, stop it first.");
            }
            Object[] ownerId = null;
            if ("Load".equals(op)) {
                this.sessionContext.checkPermission((Serializable)myForm.getSolutionId().split(","), "Solution", Right.TimetablesSolutionLoad);
                ownerId = myForm.getOwnerIds();
            } else {
                this.sessionContext.checkPermission(myForm.getOwnerId(), "SolverGroup", Right.TimetablesSolutionLoadEmpty);
                ownerId = new Long[]{myForm.getOwnerId()};
            }
            String host = myForm.getHost();
            Long settingsId = myForm.getSetting();
            if ("Load Empty Solution".equals(op)) {
                host = myForm.getHostEmpty();
                settingsId = myForm.getEmptySetting();
            }
            DataProperties config = this.courseTimetablingSolverService.createConfig(settingsId, null);
            if ("Load".equals(op)) {
                config.setProperty("General.SolutionId", myForm.getSolutionId());
            }
            if (host != null) {
                config.setProperty("General.Host", host);
            }
            config.setProperty("General.SolverGroupId", ownerId);
            this.courseTimetablingSolverService.createSolver(config);
        }
        if ("Select".equals(op)) {
            String id = request.getParameter("id");
            ActionMessages errors2 = new ActionMessages();
            if (id == null || id.trim().length() == 0) {
                errors2.add("uniqueId", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                this.saveErrors(request, errors2);
                mapping.findForward("showSolutions");
            } else {
                tx = null;
                try {
                    dao = new SolutionDAO();
                    hibSession = dao.getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    if ((solution = (Solution)new SolutionDAO().get(new Long(id))) == null) {
                        errors2.add("uniqueId", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                        this.saveErrors(request, errors2);
                        mapping.findForward("showSolutions");
                    } else {
                        myForm.addSolution(solution);
                    }
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    Debug.error(e);
                }
                request.getSession().setAttribute("Solver.selectedSolutionId", (Object)myForm.getSolutionId());
            }
        }
        if ("Deselect".equals(op)) {
            ListSolutionsForm.SolutionBean solutionBean2 = myForm.getSolutionBean();
            if (solutionBean2 != null) {
                myForm.removeSolution(solutionBean2.getUniqueId());
            }
            request.getSession().setAttribute("Solver.selectedSolutionId", (Object)myForm.getSolutionId());
        }
        if ("Unload".equals(op)) {
            solver = this.courseTimetablingSolverService.getSolver();
            if (solver == null) {
                throw new Exception("Solver is not started.");
            }
            if (solver.isWorking()) {
                throw new Exception("Solver is working, stop it first.");
            }
            this.courseTimetablingSolverService.removeSolver();
        }
        if ("Reload Input Data".equals(op)) {
            solver = this.courseTimetablingSolverService.getSolver();
            if (solver == null) {
                throw new Exception("Solver is not started.");
            }
            if (solver.isWorking()) {
                throw new Exception("Solver is working, stop it first.");
            }
            this.courseTimetablingSolverService.reload(this.courseTimetablingSolverService.createConfig(solver.getProperties().getPropertyLong("General.SettingsId", null), null));
        }
        if ("Save".equals(op) || "Save As New".equals(op) || "Save & Commit".equals(op) || "Save As New & Commit".equals(op)) {
            solver = this.courseTimetablingSolverService.getSolver();
            if (solver == null) {
                throw new Exception("Solver is not started.");
            }
            if (solver.isWorking()) {
                throw new Exception("Solver is working, stop it first.");
            }
            solver.setNote(myForm.getSolverNote());
            this.courseTimetablingSolverService.getSolver().save(op.indexOf("As New") >= 0, op.indexOf("Commit") >= 0);
        }
        if ("Export Solution".equals(op)) {
            String solutionIds = "";
            CSVFile csvFile = new CSVFile();
            Enumeration e = myForm.getSolutionBeans().elements();
            while (e.hasMoreElements()) {
                ListSolutionsForm.SolutionBean sb = (ListSolutionsForm.SolutionBean)e.nextElement();
                Solution solution3 = (Solution)new SolutionDAO().get(sb.getUniqueId());
                if (solution3 == null) continue;
                this.sessionContext.checkPermission(solution3, Right.TimetablesSolutionExportCsv);
                solution3.export(csvFile, UserProperty.NameFormat.get(this.sessionContext.getUser()));
                if (solutionIds.length() > 0) {
                    solutionIds = solutionIds + "-";
                }
                solutionIds = solutionIds + solution3.getUniqueId().toString();
            }
            ExportUtils.exportCSV(csvFile, response, "solution");
            return null;
        }
        this.getSolutions(request, myForm);
        myForm.setSolver(this.courseTimetablingSolverService.getSolver());
        return mapping.findForward("showSolutions");
    }

    private void getSolutions(HttpServletRequest request, ListSolutionsForm myForm) throws Exception {
        try {
            WebTable.setOrder(this.sessionContext, "listSolutions.ord", request.getParameter("ord"), 1);
            boolean committedOnly = !this.sessionContext.hasPermission(Right.Solver);
            boolean listAll = this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent);
            WebTable webTable = new WebTable(16, committedOnly ? "Committed Timetables" : "Saved Timetables", "listSolutions.do?ord=%%", new String[]{"Created", "Settings", "Valid", "Commited", "Owner", "Assign", "Total", "Time", "Stud", "Room", "Distr", "Instr", "TooBig", "Useless", "Pert", "Note"}, new String[]{"left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left", "left"}, null);
            webTable.setRowStyle("white-space:nowrap");
            SolutionDAO dao = new SolutionDAO();
            Session hibSession = dao.getSession();
            Collection<Solution> solutions = null;
            if (listAll) {
                solutions = Solution.findBySessionId(this.sessionContext.getUser().getCurrentAcademicSessionId());
            } else {
                solutions = new ArrayList();
                for (Qualifiable qualifiable : this.sessionContext.getUser().getCurrentAuthority().getQualifiers("SolverGroup")) {
                    SolverGroup sg = (SolverGroup)SolverGroupDAO.getInstance().get((Long)qualifiable.getQualifierId());
                    solutions.addAll(sg.getSolutions());
                }
            }
            int nrLines = 0;
            if (solutions == null || solutions.isEmpty()) {
                webTable.addLine(null, new String[]{committedOnly ? "<i>No solution committed so far.</i>" : "<i>No solution saved so far.</i>"}, null, null);
            } else {
                for (Solution solution : solutions) {
                    PropertiesInfo globalInfo;
                    if (committedOnly && !solution.isCommited().booleanValue()) continue;
                    String ownerName = solution.getOwner().getAbbv();
                    String onClick = "onClick=\"document.location='listSolutions.do?op=Select&id=" + solution.getUniqueId() + "';\"";
                    String note = solution.getNote();
                    if (note != null) {
                        note = note.replaceAll("\n", "<br>");
                    }
                    String assigned = (globalInfo = (PropertiesInfo)solution.getInfo("GlobalInfo")) == null ? "?" : globalInfo.getProperty("Assigned variables", "N/A");
                    String totVal = globalInfo == null ? "?" : globalInfo.getProperty("Overall solution value", "N/A");
                    String timePr = globalInfo == null ? "?" : globalInfo.getProperty("Time preferences", "N/A");
                    String studConf = globalInfo == null ? "?" : globalInfo.getProperty("Student conflicts", "N/A");
                    String roomPr = globalInfo == null ? "?" : globalInfo.getProperty("Room preferences", "N/A");
                    String distPr = globalInfo == null ? "?" : globalInfo.getProperty("Distribution preferences", "N/A");
                    String instrPr = globalInfo == null ? "?" : globalInfo.getProperty("Back-to-back instructor preferences", "N/A");
                    String tooBig = globalInfo == null ? "?" : globalInfo.getProperty("Too big rooms", "N/A");
                    String useless = globalInfo == null ? "?" : globalInfo.getProperty("Useless half-hours", "N/A");
                    String pertPen = globalInfo == null ? "?" : globalInfo.getProperty("Perturbations: Total penalty", "N/A");
                    assigned = assigned.replaceAll(" of ", "/");
                    if (!"N/A".equals(timePr) && timePr.indexOf(47) >= 0) {
                        timePr = timePr.substring(0, timePr.indexOf(47)).trim();
                    }
                    if (!"N/A".equals(roomPr) && roomPr.indexOf(47) >= 0) {
                        roomPr = roomPr.substring(0, roomPr.indexOf(47)).trim();
                    }
                    if (!"N/A".equals(instrPr) && instrPr.indexOf(47) >= 0) {
                        instrPr = instrPr.substring(0, instrPr.indexOf(47)).trim();
                    }
                    if (!"N/A".equals(assigned) && assigned.indexOf(32) >= 0) {
                        assigned = assigned.substring(0, assigned.indexOf(32)).trim();
                    }
                    if (!"N/A".equals(timePr) && timePr.indexOf(32) >= 0) {
                        timePr = timePr.substring(0, timePr.indexOf(32)).trim();
                    }
                    if (!"N/A".equals(roomPr) && roomPr.indexOf(32) >= 0) {
                        roomPr = roomPr.substring(0, roomPr.indexOf(32)).trim();
                    }
                    if (!"N/A".equals(instrPr) && instrPr.indexOf(32) >= 0) {
                        instrPr = instrPr.substring(0, instrPr.indexOf(32)).trim();
                    }
                    if (!"N/A".equals(distPr) && distPr.indexOf(32) >= 0) {
                        distPr = distPr.substring(0, distPr.indexOf(32)).trim();
                    }
                    if (!"N/A".equals(tooBig) && tooBig.indexOf(32) >= 0) {
                        tooBig = tooBig.substring(0, tooBig.indexOf(32)).trim();
                    }
                    if (!"N/A".equals(useless) && useless.indexOf(32) >= 0) {
                        useless = useless.substring(0, useless.indexOf(32)).trim();
                    }
                    studConf = studConf.replaceAll(" \\[", "(").replaceAll("\\]", ")").replaceAll(", ", ",").replaceAll("hard:", "h").replaceAll("distance:", "d").replaceAll("commited:", "c").replaceAll("committed:", "c");
                    String settings = null;
                    String type = null;
                    for (SolverParameter p : solution.getParameters()) {
                        SolverPredefinedSetting set;
                        if ("General.SettingsId".equals(p.getDefinition().getName()) && (set = (SolverPredefinedSetting)new SolverPredefinedSettingDAO().get(Long.valueOf(p.getValue()), hibSession)) != null) {
                            settings = set.getDescription();
                        }
                        if (!"Basic.Mode".equals(p.getDefinition().getName())) continue;
                        type = p.getValue();
                    }
                    type = settings == null ? (type == null ? "?" : type) : settings;
                    String bgColor = null;
                    if (myForm.getSolutionBean(solution.getUniqueId()) != null) {
                        bgColor = "rgb(168,187,225)";
                    }
                    webTable.addLine(onClick, new String[]{sDF.format(new Date(solution.getCreated().getTime())), type, solution.isValid() != false ? "<IMG border='0' align='absmiddle' src='images/accept.png'>" : "", solution.isCommited() != false ? sDF.format(new Date(solution.getCommitDate().getTime())) : "", ownerName, assigned, totVal, timePr, studConf, roomPr, distPr, instrPr, tooBig, useless, pertPen, note}, new Comparable[]{solution.getCreated(), type, solution.isValid() != false ? new Integer(1) : new Integer(0), solution.isCommited() != false ? new Long(solution.getCommitDate().getTime()) : new Long(0L), ownerName, assigned, totVal, timePr, studConf, roomPr, distPr, instrPr, tooBig, useless, pertPen, solution.getNote() == null ? "" : solution.getNote()}).setBgColor(bgColor);
                    ++nrLines;
                }
                if (nrLines == 0) {
                    webTable.addLine(null, new String[]{"<i>No solution saved by " + this.sessionContext.getUser().getName() + " so far.</i>"}, null, null);
                }
            }
            request.setAttribute("ListSolutions.table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "listSolutions.ord")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

