/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.util.MessageResources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.PreferencesAction;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.InstructorEditForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;

@Service(value="/instructorPrefEdit")
public class InstructorPrefEditAction
extends PreferencesAction {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            super.execute(mapping, form, request, response);
            InstructorEditForm frm = (InstructorEditForm)form;
            MessageResources rsc = this.getResources(request);
            ActionMessages errors = new ActionMessages();
            String instructorId = request.getParameter("instructorId");
            String op = frm.getOp();
            String reloadCause = request.getParameter("reloadCause");
            if (op.equals(rsc.getMessage("button.reload")) || op.equals(MSG.actionAddTimePreference()) || op.equals(MSG.actionAddRoomPreference()) || op.equals(MSG.actionAddBuildingPreference()) || op.equals(MSG.actionAddRoomFeaturePreference()) || op.equals(MSG.actionAddDistributionPreference()) || op.equals(MSG.actionAddRoomGroupPreference()) || op.equals(MSG.actionUpdatePreferences()) || op.equals(MSG.actionClearInstructorPreferences()) || op.equals(MSG.actionBackToDetail()) || op.equals(MSG.actionNextInstructor()) || op.equals(MSG.actionPreviousInstructor())) {
                instructorId = frm.getInstructorId();
            }
            if (op == null || op.trim().length() == 0 || op.equals(rsc.getMessage("button.reload")) && (reloadCause == null || reloadCause.trim().length() == 0)) {
                op = "init";
            }
            if (op == null || op.trim() == "") {
                throw new Exception(MSG.exceptionNullOperationNotSupported());
            }
            if (instructorId == null || instructorId.trim() == "") {
                throw new Exception(MSG.exceptionInstructorInfoNotSupplied());
            }
            this.sessionContext.checkPermission((Serializable)((Object)instructorId), "DepartmentalInstructor", Right.InstructorPreferences);
            boolean timeVertical = CommonValues.VerticalGrid.eq(this.sessionContext.getUser().getProperty(UserProperty.GridOrientation));
            frm.setScreenName("instructorPref");
            DepartmentalInstructorDAO idao = new DepartmentalInstructorDAO();
            DepartmentalInstructor inst = (DepartmentalInstructor)idao.get(new Long(instructorId));
            if (op.equals(MSG.actionBackToDetail()) && instructorId != null && instructorId.trim() != "") {
                ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("showDetail"));
                redirect.addParameter("instructorId", (Object)frm.getInstructorId());
                return redirect;
            }
            if (op.equals(MSG.actionClearInstructorPreferences())) {
                Set<Preference> s = inst.getPreferences();
                s.clear();
                inst.setPreferences(s);
                idao.update(inst);
                op = "init";
                ChangeLog.addChange(null, this.sessionContext, inst, ChangeLog.Source.INSTRUCTOR_PREF_EDIT, ChangeLog.Operation.CLEAR_PREF, null, inst.getDepartment());
                ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("showDetail"));
                redirect.addParameter("instructorId", (Object)instructorId);
                return redirect;
            }
            if (op.equals("init")) {
                frm.reset(mapping, request);
            }
            this.doLoad(request, frm, inst, instructorId);
            if (op.equals(MSG.actionUpdatePreferences()) || op.equals(MSG.actionNextInstructor()) || op.equals(MSG.actionPreviousInstructor())) {
                errors = frm.validate(mapping, request);
                if (errors.size() == 0) {
                    Set<Preference> s = inst.getPreferences();
                    s.clear();
                    super.doUpdate(request, frm, inst, s, timeVertical);
                    ChangeLog.addChange(null, this.sessionContext, inst, ChangeLog.Source.INSTRUCTOR_PREF_EDIT, ChangeLog.Operation.UPDATE, null, inst.getDepartment());
                    idao.saveOrUpdate(inst);
                    if (op.equals(MSG.actionNextInstructor())) {
                        response.sendRedirect(response.encodeURL("instructorPrefEdit.do?instructorId=" + frm.getNextId()));
                        return null;
                    }
                    if (op.equals(MSG.actionPreviousInstructor())) {
                        response.sendRedirect(response.encodeURL("instructorPrefEdit.do?instructorId=" + frm.getPreviousId()));
                        return null;
                    }
                    ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("showDetail"));
                    redirect.addParameter("instructorId", (Object)frm.getInstructorId());
                    redirect.addParameter("showPrefs", (Object)"true");
                    return redirect;
                }
                this.saveErrors(request, errors);
            }
            HashSet<TimePattern> timePatterns = new HashSet<TimePattern>();
            frm.setAvailableTimePatterns(null);
            if (op.equals("init")) {
                this.initPrefs(frm, inst, null, true);
                timePatterns.add(new TimePattern(new Long(-1L)));
            }
            if (!inst.getClasses().isEmpty()) {
                WebTable classTable = new WebTable(3, null, new String[]{"class", "Type", "Limit"}, new String[]{"left", "left", "left"}, null);
                for (ClassInstructor ci : inst.getClasses()) {
                    Class_ c = ci.getClassInstructing();
                    classTable.addLine(null, new String[]{c.getClassLabel(), c.getItypeDesc(), c.getExpectedCapacity().toString()}, null, null);
                }
                String tblData = classTable.printTable();
                request.setAttribute("classTable", (Object)tblData);
            }
            this.processPrefAction(request, frm, errors);
            for (Preference pref : inst.getPreferences()) {
                if (!(pref instanceof TimePref)) continue;
                frm.setAvailability(((TimePref)pref).getPreference());
                break;
            }
            LookupTables.setupRooms(request, inst);
            LookupTables.setupBldgs(request, inst);
            LookupTables.setupRoomFeatures(request, inst);
            LookupTables.setupRoomGroups(request, inst);
            BackTracker.markForBack(request, "instructorDetail.do?instructorId=" + frm.getInstructorId(), MSG.backInstructor(frm.getName() == null ? "null" : frm.getName().trim()), true, false);
            return mapping.findForward("showEdit");
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    private void doLoad(HttpServletRequest request, InstructorEditForm frm, DepartmentalInstructor inst, String instructorId) {
        frm.setInstructorId(instructorId);
        frm.setName(Constants.toInitialCase(inst.getFirstName(), "-".toCharArray()) + " " + (inst.getMiddleName() == null ? "" : Constants.toInitialCase(inst.getMiddleName(), "-".toCharArray())) + " " + Constants.toInitialCase(inst.getLastName(), "-".toCharArray()));
        if (inst.getExternalUniqueId() != null) {
            frm.setPuId(inst.getExternalUniqueId());
        }
        frm.setDeptName(inst.getDepartment().getName().trim());
        if (inst.getPositionType() != null) {
            frm.setPosType(inst.getPositionType().getUniqueId().toString());
        }
        if (inst.getCareerAcct() != null) {
            frm.setCareerAcct(inst.getCareerAcct().trim());
        }
        frm.setEmail(inst.getEmail());
        if (inst.getNote() != null) {
            frm.setNote(inst.getNote().trim());
        }
        try {
            DepartmentalInstructor previous = inst.getPreviousDepartmentalInstructor(this.sessionContext, Right.InstructorPreferences);
            frm.setPreviousId(previous == null ? null : previous.getUniqueId().toString());
            DepartmentalInstructor next = inst.getNextDepartmentalInstructor(this.sessionContext, Right.InstructorPreferences);
            frm.setNextId(next == null ? null : next.getUniqueId().toString());
        }
        catch (Exception e) {
            Debug.error(e);
        }
    }
}

