/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.ExamPdfReportForm;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.queue.PdfExamReportQueueItem;
import org.unitime.timetable.util.queue.QueueItem;
import org.unitime.timetable.util.queue.QueueProcessor;

@Service(value="/examPdfReport")
public class ExamPdfReportAction
extends Action {
    protected static Logger sLog = Logger.getLogger(ExamPdfReportAction.class);
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebTable table;
        String op;
        ExamPdfReportForm myForm = (ExamPdfReportForm)form;
        this.sessionContext.checkPermission(Right.ExaminationPdfReports);
        ExamSolverProxy examSolver = this.examinationSolverService.getSolver();
        if (examSolver != null) {
            if (ApplicationProperty.ExaminationPdfReportsCanUseSolution.isTrue()) {
                request.setAttribute("RqWarn", (Object)"Examination PDF reports are generated from the current solution (in-memory solution taken from the solver).");
            } else {
                request.setAttribute("RqWarn", (Object)"Examination PDF reports are generated from the saved solution (solver assignments are ignored).");
            }
        }
        String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        if ("Generate".equals(op)) {
            myForm.save(this.sessionContext);
        }
        myForm.load(this.sessionContext);
        myForm.setSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser(), false));
        if (myForm.getAddress() == null) {
            myForm.setAddress(this.sessionContext.getUser().getEmail());
        }
        if ("Generate".equals(op)) {
            ActionErrors errors = myForm.validate(mapping, request);
            if (!errors.isEmpty()) {
                this.saveErrors(request, (ActionMessages)errors);
            } else {
                QueueProcessor.getInstance().add(new PdfExamReportQueueItem((Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId()), this.sessionContext.getUser(), (ExamPdfReportForm)((Object)myForm.clone()), request, examSolver));
            }
        }
        if (request.getParameter("remove") != null) {
            QueueProcessor.getInstance().remove(Long.valueOf(request.getParameter("remove")));
        }
        if ((table = this.getQueueTable(request)) != null) {
            request.setAttribute("table", (Object)table.printTable(WebTable.getOrder(this.sessionContext, "examPdfReport.ord")));
        }
        LookupTables.setupExamTypes(request, this.sessionContext.getUser().getCurrentAcademicSessionId());
        return mapping.findForward("show");
    }

    private WebTable getQueueTable(HttpServletRequest request) {
        List<QueueItem> queue;
        WebTable.setOrder(this.sessionContext, "examPdfReport.ord", request.getParameter("ord"), 1);
        String log = request.getParameter("log");
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.TIME_SHORT);
        String ownerId = null;
        if (!this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
            ownerId = this.sessionContext.getUser().getExternalUserId();
        }
        if ((queue = QueueProcessor.getInstance().getItems(ownerId, null, PdfExamReportQueueItem.TYPE)).isEmpty()) {
            return null;
        }
        WebTable table = new WebTable(9, "Reports in progress", "examPdfReport.do?ord=%%", new String[]{"Name", "Status", "Progress", "Owner", "Session", "Created", "Started", "Finished", "Output"}, new String[]{"left", "left", "right", "left", "left", "left", "left", "left", "center"}, new boolean[]{true, true, true, true, true, true, true, true, true});
        Date now = new Date();
        long timeToShow = 3600000L;
        for (QueueItem item : queue) {
            if (item.finished() != null && now.getTime() - item.finished().getTime() > timeToShow || item.getSession() == null) continue;
            String name = item.name();
            if (name.length() > 60) {
                name = name.substring(0, 57) + "...";
            }
            String delete = null;
            if (this.sessionContext.getUser().getExternalUserId().equals(item.getOwnerId()) && (item.started() == null || item.finished() != null)) {
                delete = "<img src='images/action_delete.png' border='0' onClick=\"if (confirm('Do you really want to remove this report?')) document.location='examPdfReport.do?remove=" + item.getId() + "'; event.cancelBubble=true;\">";
            }
            WebTable.WebTableLine line = table.addLine(item.log().isEmpty() ? null : "onClick=\"document.location='examPdfReport.do?log=" + item.getId() + "';\"", new String[]{name + (delete == null ? "" : " " + delete), item.status(), item.progress() <= 0.0 || item.progress() >= 1.0 ? "" : String.valueOf(Math.round(100.0 * item.progress())) + "%", item.getOwnerName(), item.getSession().getLabel(), df.format(item.created()), item.started() == null ? "" : df.format(item.started()), item.finished() == null ? "" : df.format(item.finished()), item.output() == null ? "" : "<A href='temp/" + item.output().getName() + "'>" + item.output().getName().substring(item.output().getName().lastIndexOf(46) + 1).toUpperCase() + "</A>"}, new Comparable[]{item.getId(), item.status(), Double.valueOf(item.progress()), item.getOwnerName(), item.getSession(), Long.valueOf(item.created().getTime()), Long.valueOf(item.started() == null ? Long.MAX_VALUE : item.started().getTime()), Long.valueOf(item.finished() == null ? Long.MAX_VALUE : item.finished().getTime()), null});
            if (log != null && log.equals(item.getId().toString())) {
                request.setAttribute("logname", (Object)name);
                request.setAttribute("logid", (Object)item.getId().toString());
                request.setAttribute("log", (Object)item.log());
                line.setBgColor("rgb(168,187,225)");
            }
            if (log != null || item.started() == null || item.finished() != null || !this.sessionContext.getUser().getExternalUserId().equals(item.getOwnerId())) continue;
            request.setAttribute("logname", (Object)name);
            request.setAttribute("logid", (Object)item.getId().toString());
            request.setAttribute("log", (Object)item.log());
            line.setBgColor("rgb(168,187,225)");
        }
        return table;
    }
}

