/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.form.ExamCbsForm;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamConflictStatisticsInfo;
import org.unitime.timetable.solver.service.SolverService;

@Service(value="/ecbs")
public class ExamCbsAction
extends Action {
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op;
        ExamCbsForm myForm = (ExamCbsForm)form;
        this.sessionContext.checkPermission(Right.ExaminationConflictStatistics);
        String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        if (op == null) {
            op = "Refresh";
        }
        if ("Change".equals(op)) {
            this.sessionContext.getUser().setProperty("Ecbs.limit", String.valueOf(myForm.getLimit()));
            this.sessionContext.getUser().setProperty("Ecbs.type", String.valueOf(myForm.getTypeInt()));
        } else {
            myForm.reset(mapping, request);
            myForm.setTypeInt(Integer.parseInt(this.sessionContext.getUser().getProperty("Ecbs.type", String.valueOf(ExamCbsForm.sDefaultType))));
            myForm.setLimit(Double.parseDouble(this.sessionContext.getUser().getProperty("Ecbs.limit", String.valueOf(ExamCbsForm.sDefaultLimit))));
        }
        ExamConflictStatisticsInfo cbs = null;
        if (this.examinationSolverService.getSolver() != null) {
            cbs = this.examinationSolverService.getSolver().getCbsInfo();
        }
        if (cbs != null) {
            request.setAttribute("cbs", (Object)cbs);
        } else if (this.examinationSolverService.getSolver() == null) {
            request.setAttribute("warning", (Object)"No examination data are loaded into the solver, conflict-based statistics is not available.");
        } else {
            request.setAttribute("warning", (Object)"Conflict-based statistics is not available at the moment.");
        }
        return mapping.findForward("show");
    }
}

