/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.hibernate.HibernateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/distributionTypeList")
public class DistributionTypeListAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws HibernateException {
        this.sessionContext.checkPermission(Right.DistributionTypes);
        ArrayList<DistributionType> distTypes = new ArrayList<DistributionType>();
        distTypes.addAll(DistributionType.findAll(false, false));
        distTypes.addAll(DistributionType.findAll(false, true));
        WebTable webTable = new WebTable(10, "Distribution Types", "distributionTypeList.do?ord=%%", new String[]{"Id", "Reference", "Abbreviation", "Name", "Type", "Allow Instructor Preference", "Sequencing Required", "Allow Preferences", "Departments", "Description"}, new String[]{"left", "left", "left", "left", "center", "center", "center", "center", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true, true, true});
        WebTable.setOrder(this.sessionContext, "DistributionTypeList.ord", request.getParameter("ord"), 1);
        boolean edit = this.sessionContext.hasPermission(Right.DistributionTypeEdit);
        for (DistributionType d : distTypes) {
            String allowPref = null;
            if ("".equals(d.getAllowedPref())) {
                allowPref = "<i>None</i>";
            } else if ("P43210R".equals(d.getAllowedPref())) {
                allowPref = "<i>All</i>";
            } else {
                for (PreferenceLevel p : PreferenceLevel.getPreferenceLevelList()) {
                    if (d.getAllowedPref().indexOf(PreferenceLevel.prolog2char(p.getPrefProlog())) < 0) continue;
                    allowPref = allowPref == null ? "" : allowPref + "<br>";
                    if (PreferenceLevel.sNeutral.equals(p.getPrefProlog())) {
                        allowPref = allowPref + p.getPrefName();
                        continue;
                    }
                    allowPref = allowPref + "<span style='color:" + p.prefcolor() + ";'>" + p.getPrefName().replaceAll(" ", "&nbsp;") + "</span>";
                }
            }
            String deptStr = "";
            String deptCmp = "";
            Iterator<Department> i = d.getDepartments(this.sessionContext.getUser().getCurrentAcademicSessionId()).iterator();
            while (i.hasNext()) {
                Department x = i.next();
                deptStr = deptStr + x.getManagingDeptAbbv().trim();
                deptCmp = deptCmp + x.getDeptCode();
                if (!i.hasNext()) continue;
                deptStr = deptStr + ", ";
                deptCmp = deptCmp + ",";
            }
            String[] stringArray = new String[10];
            stringArray[0] = d.getRequirementId().toString();
            stringArray[1] = d.getReference();
            stringArray[2] = d.getAbbreviation();
            stringArray[3] = d.getLabel();
            String string = stringArray[4] = d.isExamPref() != false ? "Examination" : "Course";
            stringArray[5] = d.isExamPref() != false ? "N/A" : (d.isInstructorPref() != false ? "Yes" : "No");
            stringArray[6] = d.isSequencingRequired() != false ? "Yes" : "No";
            stringArray[7] = allowPref;
            stringArray[8] = deptStr.length() == 0 ? "<i>All</i>" : deptStr;
            stringArray[9] = d.getDescr();
            webTable.addLine(edit ? "onClick=\"document.location='distributionTypeEdit.do?id=" + d.getUniqueId() + "';\"" : null, stringArray, new Comparable[]{d.getRequirementId(), d.getReference(), d.getAbbreviation(), d.getLabel(), new Integer(d.isExamPref() != false ? 1 : 0), new Integer(d.isInstructorPref() != false ? 1 : 0), new Integer(d.isSequencingRequired() != false ? 1 : 0), null, deptCmp, d.getDescr()}, null);
        }
        request.setAttribute("table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "DistributionTypeList.ord")));
        return mapping.findForward("showDistributionTypeList");
    }
}

