/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.LabelValueBean;
import org.cpsolver.ifs.util.CSVFile;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.form.DatePatternEditForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.base.BaseDatePattern;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.Formats;

@Service(value="/datePatternEdit")
public class DatePatternEditAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    private int diff(Set x, Set y) {
        int diff = 0;
        for (Object o : x) {
            if (y.contains(o)) continue;
            ++diff;
        }
        for (Object o : y) {
            if (x.contains(o)) continue;
            ++diff;
        }
        return diff;
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AbstractCollection allClasses;
            List subparts;
            SequencedCollection<DatePattern> allDatePatterns;
            File file;
            Transaction tx;
            Session hibSession;
            ActionErrors errors;
            int i;
            String op;
            DatePatternEditForm myForm = (DatePatternEditForm)form;
            this.sessionContext.checkPermission(Right.DatePatterns);
            String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
            if (request.getParameterValues("depts") != null) {
                String[] depts = request.getParameterValues("depts");
                for (i = 0; i < depts.length; ++i) {
                    myForm.getDepartmentIds().add(new Long(depts[i]));
                }
            }
            if (request.getParameterValues("prnts") != null) {
                String[] prnts = request.getParameterValues("prnts");
                for (i = 0; i < prnts.length; ++i) {
                    myForm.getParentIds().add(new Long(prnts[i]));
                }
            }
            if (op == null) {
                myForm.load(null);
                myForm.setOp("List");
            }
            request.setAttribute(DatePattern.DATE_PATTERN_PARENT_LIST_ATTR, DatePattern.findAllParents(this.sessionContext.getUser().getCurrentAcademicSessionId()));
            List list = new DepartmentDAO().getSession().createCriteria(Department.class).add((Criterion)Restrictions.eq((String)"session.uniqueId", (Object)this.sessionContext.getUser().getCurrentAcademicSessionId())).addOrder(Order.asc((String)"deptCode")).list();
            Vector<LabelValueBean> availableDepts = new Vector<LabelValueBean>();
            for (Department d : list) {
                availableDepts.add(new LabelValueBean(d.getDeptCode() + "-" + d.getName(), d.getUniqueId().toString()));
            }
            request.setAttribute(Department.DEPT_ATTR_NAME, availableDepts);
            if ("Back".equals(op)) {
                if (myForm.getUniqueId() != null) {
                    request.setAttribute("hash", (Object)myForm.getUniqueId());
                }
                myForm.load(null);
                myForm.setOp("List");
            }
            if ("Add Date Pattern".equals(op)) {
                myForm.load(null);
                myForm.setSessionId(this.sessionContext.getUser().getCurrentAcademicSessionId());
                myForm.setOp("Save");
            }
            if ("Add Department".equals(op)) {
                errors = new ActionErrors();
                if (myForm.getDepartmentId() == null || myForm.getDepartmentId() < 0L) {
                    errors.add("department", new ActionMessage("errors.generic", (Object)"No department selected."));
                } else {
                    boolean contains = myForm.getDepartmentIds().contains(myForm.getDepartmentId());
                    if (contains) {
                        errors.add("department", new ActionMessage("errors.generic", (Object)"Department already present in the list of departments."));
                    }
                }
                if (errors.size() > 0) {
                    this.saveErrors(request, (ActionMessages)errors);
                } else {
                    myForm.getDepartmentIds().add(myForm.getDepartmentId());
                }
                myForm.setOp(myForm.getUniqueId() < 0L ? "Save" : "Update");
            }
            if ("Add Pattern Set".equals(op)) {
                errors = new ActionErrors();
                if (myForm.getParentId() == null || myForm.getParentId() < 0L) {
                    errors.add("parent", new ActionMessage("errors.generic", (Object)"No date pattern selected."));
                } else {
                    boolean contains = myForm.getParentIds().contains(myForm.getParentId());
                    if (contains) {
                        errors.add("parent", new ActionMessage("errors.generic", (Object)"Date pattern already present in the list of alternative pattern sets."));
                    }
                }
                if (errors.size() > 0) {
                    this.saveErrors(request, (ActionMessages)errors);
                } else {
                    myForm.getParentIds().add(myForm.getParentId());
                }
                myForm.setOp(myForm.getUniqueId() < 0L ? "Save" : "Update");
            }
            if ("Remove Department".equals(op)) {
                errors = new ActionErrors();
                if (myForm.getDepartmentId() == null || myForm.getDepartmentId() < 0L) {
                    errors.add("department", new ActionMessage("errors.generic", (Object)"No department selected."));
                } else {
                    boolean contains = myForm.getDepartmentIds().contains(myForm.getDepartmentId());
                    if (!contains) {
                        errors.add("department", new ActionMessage("errors.generic", (Object)"Department not present in the list of departments."));
                    }
                }
                if (errors.size() > 0) {
                    this.saveErrors(request, (ActionMessages)errors);
                } else {
                    myForm.getDepartmentIds().remove(myForm.getDepartmentId());
                }
                myForm.setOp(myForm.getUniqueId() < 0L ? "Save" : "Update");
            }
            if ("Remove Pattern Set".equals(op)) {
                errors = new ActionErrors();
                if (myForm.getParentId() == null || myForm.getParentId() < 0L) {
                    errors.add("parent", new ActionMessage("errors.generic", (Object)"No date pattern selected."));
                } else {
                    boolean contains = myForm.getParentIds().contains(myForm.getParentId());
                    if (!contains) {
                        errors.add("parent", new ActionMessage("errors.generic", (Object)"Date pattern not present in the list of alternative pattern sets."));
                    }
                }
                if (errors.size() > 0) {
                    this.saveErrors(request, (ActionMessages)errors);
                } else {
                    myForm.getParentIds().remove(myForm.getParentId());
                }
                myForm.setOp(myForm.getUniqueId() < 0L ? "Save" : "Update");
            }
            if ("Update".equals(op) || "Save".equals(op) || "Make Default".equals(op)) {
                errors = myForm.validate(mapping, request);
                if (errors.size() > 0) {
                    this.saveErrors(request, (ActionMessages)errors);
                    myForm.setOp(myForm.getUniqueId() < 0L ? "Save" : "Update");
                } else {
                    Transaction tx2 = null;
                    try {
                        hibSession = new TimePatternDAO().getSession();
                        if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                            tx2 = hibSession.beginTransaction();
                        }
                        DatePattern dp = myForm.saveOrUpdate(request, hibSession);
                        if ("Make Default".equals(op)) {
                            dp.getSession().setDefaultDatePattern(dp);
                            hibSession.saveOrUpdate((Object)dp.getSession());
                            myForm.setIsDefault(true);
                        }
                        ChangeLog.addChange(hibSession, this.sessionContext, dp, ChangeLog.Source.DATE_PATTERN_EDIT, "Save".equals(op) ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, null, null);
                        if (tx2 != null) {
                            tx2.commit();
                        }
                    }
                    catch (Exception e) {
                        if (tx2 != null) {
                            tx2.rollback();
                        }
                        throw e;
                    }
                    myForm.setOp("List");
                    if (myForm.getUniqueId() != null) {
                        request.setAttribute("hash", (Object)myForm.getUniqueId());
                    }
                }
            }
            if ("Edit".equals(op)) {
                String id = request.getParameter("id");
                ActionMessages errors2 = new ActionMessages();
                if (id == null || id.trim().length() == 0) {
                    errors2.add("key", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                    this.saveErrors(request, errors2);
                    request.setAttribute("DatePatterns.pattern", (Object)myForm.getDatePattern(request).getPatternHtml(true, myForm.getUniqueId()));
                    return mapping.findForward("list");
                }
                DatePattern pattern = (DatePattern)new DatePatternDAO().get(new Long(id));
                if (pattern == null) {
                    errors2.add("name", new ActionMessage("errors.invalid", (Object)("Unique Id : " + id)));
                    this.saveErrors(request, errors2);
                    request.setAttribute("DatePatterns.pattern", (Object)myForm.getDatePattern(request).getPatternHtml(true, myForm.getUniqueId()));
                    return mapping.findForward("list");
                }
                myForm.load(pattern);
            }
            if ("Delete".equals(op)) {
                tx = null;
                try {
                    Session hibSession2 = new TimePatternDAO().getSession();
                    if (hibSession2.getTransaction() == null || !hibSession2.getTransaction().isActive()) {
                        tx = hibSession2.beginTransaction();
                    }
                    DatePattern dp = (DatePattern)new DatePatternDAO().get(myForm.getUniqueId(), hibSession2);
                    ChangeLog.addChange(hibSession2, this.sessionContext, dp, ChangeLog.Source.DATE_PATTERN_EDIT, ChangeLog.Operation.DELETE, null, null);
                    myForm.delete(hibSession2);
                    tx.commit();
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                myForm.load(null);
                myForm.setOp("List");
            }
            if ("Fix Generated".equals(op)) {
                tx = null;
                PrintWriter out = null;
                try {
                    try {
                        hibSession = new TimePatternDAO().getSession();
                        if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                            tx = hibSession.beginTransaction();
                        }
                        file = ApplicationProperties.getTempFile("fix", "txt");
                        out = new PrintWriter(new FileWriter(file));
                        allDatePatterns = DatePattern.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId(), true, null, null);
                        for (DatePattern dp : allDatePatterns) {
                            if (!dp.getName().startsWith("generated")) continue;
                            out.println("Checking " + dp.getName() + " ...");
                            List classes = hibSession.createQuery("select distinct c from Class_ as c inner join c.datePattern as dp where dp.uniqueId=:uniqueId").setLong("uniqueId", dp.getUniqueId().longValue()).list();
                            subparts = hibSession.createQuery("select distinct s from SchedulingSubpart as s inner join s.datePattern as dp where dp.uniqueId=:uniqueId").setLong("uniqueId", dp.getUniqueId().longValue()).list();
                            allClasses = new Vector<Class_>(classes);
                            for (SchedulingSubpart s : subparts) {
                                for (Class_ c : s.getClasses()) {
                                    if (c.getDatePattern() != null) continue;
                                    ((Vector)allClasses).add(c);
                                }
                            }
                            if (((Vector)allClasses).isEmpty()) {
                                out.println("  -- date pattern is not used -> delete");
                                for (Department d : dp.getDepartments()) {
                                    d.getDatePatterns().remove(dp);
                                    hibSession.saveOrUpdate((Object)d);
                                }
                                ChangeLog.addChange(hibSession, this.sessionContext, dp, ChangeLog.Source.DATE_PATTERN_EDIT, ChangeLog.Operation.DELETE, null, null);
                                hibSession.delete((Object)dp);
                                continue;
                            }
                            for (Class_ clazz : allClasses) {
                                out.println("  -- used by " + clazz.getClassLabel());
                            }
                            TreeSet days = dp.getUsage(allClasses);
                            out.println("    -- " + days);
                            if (days.isEmpty()) {
                                int offset = dp.getPatternOffset();
                                for (int x = 0; x < dp.getPattern().length(); ++x) {
                                    if (dp.getPattern().charAt(x) != '1') continue;
                                    days.add(new Integer(x + offset));
                                }
                            }
                            BaseDatePattern likeDp = null;
                            int likeDiff = 0;
                            for (DatePattern xdp : allDatePatterns) {
                                if (xdp.getName().startsWith("generated")) continue;
                                TreeSet xdays = xdp.getUsage(allClasses);
                                if (xdays.isEmpty()) {
                                    int offset = xdp.getPatternOffset();
                                    for (int x = 0; x < xdp.getPattern().length(); ++x) {
                                        if (xdp.getPattern().charAt(x) != '1') continue;
                                        xdays.add(new Integer(x + offset));
                                    }
                                }
                                int diff = this.diff(days, xdays);
                                if (likeDp != null && likeDiff <= diff && (likeDiff != diff || !xdp.isDefault())) continue;
                                likeDp = xdp;
                                likeDiff = diff;
                            }
                            if (likeDp == null) continue;
                            if (likeDiff <= 5) {
                                out.println("      -- like " + likeDp.getName() + ", diff=" + likeDiff);
                                out.println("      -- " + ((DatePattern)likeDp).getUsage(allClasses));
                                out.println("    -- transfering all classes and subparts from " + dp.getName() + " to " + likeDp.getName());
                                for (Class_ clazz : classes) {
                                    clazz.setDatePattern((DatePattern)(((DatePattern)likeDp).isDefault() ? null : likeDp));
                                    hibSession.saveOrUpdate((Object)clazz);
                                }
                                for (SchedulingSubpart subpart : subparts) {
                                    subpart.setDatePattern((DatePattern)(((DatePattern)likeDp).isDefault() ? null : likeDp));
                                    hibSession.saveOrUpdate((Object)subpart);
                                }
                                out.println("    -- deleting date pattern " + dp.getName());
                                for (Department d : dp.getDepartments()) {
                                    d.getDatePatterns().remove(dp);
                                    hibSession.saveOrUpdate((Object)d);
                                }
                                ChangeLog.addChange(hibSession, this.sessionContext, dp, ChangeLog.Source.DATE_PATTERN_EDIT, ChangeLog.Operation.DELETE, null, null);
                                hibSession.delete((Object)dp);
                                continue;
                            }
                            out.println("      -- like " + likeDp.getName() + ", diff=" + likeDiff);
                            out.println("      -- " + ((DatePattern)likeDp).getUsage(allClasses));
                            Formats.Format<Date> sdf = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
                            dp.setName("generated " + sdf.format(dp.getStartDate()) + " - " + sdf.format(dp.getEndDate()));
                            hibSession.saveOrUpdate((Object)dp);
                        }
                        out.flush();
                        out.close();
                        out = null;
                        request.setAttribute("RqOpenUrl", (Object)("temp/" + file.getName()));
                        tx.commit();
                    }
                    catch (Exception e) {
                        if (tx != null) {
                            tx.rollback();
                        }
                        throw e;
                    }
                    Object var28_62 = null;
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Throwable throwable) {
                    Object var28_63 = null;
                    if (out != null) {
                        out.close();
                    }
                    throw throwable;
                }
                myForm.load(null);
                myForm.setOp("List");
            }
            if ("Generate SQL".equals(op)) {
                PrintWriter out = ExportUtils.getPlainTextWriter(response, "tp.sql");
                try {
                    TreeSet<DatePattern> patterns = new TreeSet<DatePattern>(DatePattern.findAll(this.sessionContext.getUser(), null, null));
                    boolean mysql = false;
                    int line = 0;
                    if (mysql) {
                        out.println("INSERT INTO `timetable`.`date_pattern`(`uniqueid`, `name`, `pattern`, `offset`, `type`, `visible`, `session_id`)");
                    } else {
                        out.println("prompt Loading DATE_PATTERN...");
                    }
                    for (DatePattern dp : patterns) {
                        if (dp.getType() == 3 || !dp.isVisible().booleanValue()) continue;
                        if (mysql) {
                            if (line == 0) {
                                out.print("VALUES");
                            } else {
                                out.println(",");
                            }
                            out.print(" (" + dp.getUniqueId() + ", '" + dp.getName() + "', '" + dp.getPattern() + "', " + dp.getOffset() + ", " + dp.getType() + ", " + (dp.isVisible() != false ? "1" : "0") + ", " + this.sessionContext.getUser().getCurrentAcademicSessionId() + ")");
                        } else {
                            out.println("insert into DATE_PATTERN (UNIQUEID, NAME, PATTERN, OFFSET, TYPE, VISIBLE, SESSION_ID)");
                            out.println("values (" + dp.getUniqueId() + ", '" + dp.getName() + "', '" + dp.getPattern() + "', " + dp.getOffset() + ", " + dp.getType() + ", " + (dp.isVisible() != false ? "1" : "0") + ", " + this.sessionContext.getUser().getCurrentAcademicSessionId() + ");");
                        }
                        ++line;
                    }
                    if (mysql) {
                        out.println(";");
                    } else {
                        out.println("commit;");
                        out.println("prompt " + line + " records loaded");
                    }
                    out.println();
                    out.flush();
                    out.close();
                    out = null;
                    Object var30_65 = null;
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Throwable throwable) {
                    Object var30_66 = null;
                    if (out != null) {
                        out.close();
                    }
                    throw throwable;
                }
                return null;
            }
            if ("Push Up".equals(op)) {
                tx = null;
                PrintWriter out = null;
                try {
                    try {
                        hibSession = new TimePatternDAO().getSession();
                        if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                            tx = hibSession.beginTransaction();
                        }
                        file = ApplicationProperties.getTempFile("push", "txt");
                        out = new PrintWriter(new FileWriter(file));
                        List subparts2 = hibSession.createQuery("select distinct c.schedulingSubpart from Class_ as c inner join c.datePattern as dp where dp.session.uniqueId=:sessionId").setLong("sessionId", this.sessionContext.getUser().getCurrentAcademicSessionId().longValue()).list();
                        for (SchedulingSubpart subpart : subparts2) {
                            out.println("Checking " + subpart.getSchedulingSubpartLabel() + " ...");
                            boolean sameDatePattern = true;
                            BaseDatePattern dp = null;
                            for (Class_ clazz : subpart.getClasses()) {
                                if (clazz.getDatePattern() == null) {
                                    sameDatePattern = false;
                                    break;
                                }
                                if (dp == null) {
                                    dp = clazz.getDatePattern();
                                    continue;
                                }
                                if (dp.equals(clazz.getDatePattern())) continue;
                                sameDatePattern = false;
                                break;
                            }
                            if (!sameDatePattern) continue;
                            out.println("  -- all classes share same date pattern " + dp.getName() + " --> pushing it to subpart");
                            for (Class_ clazz : subpart.getClasses()) {
                                clazz.setDatePattern(null);
                                hibSession.saveOrUpdate((Object)clazz);
                            }
                            subpart.setDatePattern((DatePattern)(((DatePattern)dp).isDefault() ? null : dp));
                            hibSession.saveOrUpdate((Object)subpart);
                        }
                        out.flush();
                        out.close();
                        out = null;
                        request.setAttribute("RqOpenUrl", (Object)("temp/" + file.getName()));
                        tx.commit();
                    }
                    catch (Exception e) {
                        if (tx != null) {
                            tx.rollback();
                        }
                        throw e;
                    }
                    Object var32_68 = null;
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Throwable throwable) {
                    Object var32_69 = null;
                    if (out != null) {
                        out.close();
                    }
                    throw throwable;
                }
                myForm.load(null);
                myForm.setOp("List");
            }
            if ("Assign Departments".equals(op)) {
                tx = null;
                PrintWriter out = null;
                HashSet<DatePattern> refresh = new HashSet<DatePattern>();
                try {
                    try {
                        Session hibSession3 = new TimePatternDAO().getSession();
                        if (hibSession3.getTransaction() == null || !hibSession3.getTransaction().isActive()) {
                            tx = hibSession3.beginTransaction();
                        }
                        File file2 = ApplicationProperties.getTempFile("assigndept", "txt");
                        out = new PrintWriter(new FileWriter(file2));
                        TreeSet<DatePattern> allDatePatterns2 = new TreeSet<DatePattern>(DatePattern.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId(), true, null, null));
                        for (DatePattern dp : allDatePatterns2) {
                            if (dp.getType() != 3) continue;
                            out.println("Checking " + dp.getName() + " ...");
                            List classes = hibSession3.createQuery("select distinct c from Class_ as c inner join c.datePattern as dp where dp.uniqueId=:uniqueId").setLong("uniqueId", dp.getUniqueId().longValue()).list();
                            List subparts3 = hibSession3.createQuery("select distinct s from SchedulingSubpart as s inner join s.datePattern as dp where dp.uniqueId=:uniqueId").setLong("uniqueId", dp.getUniqueId().longValue()).list();
                            HashSet<Department> depts = new HashSet<Department>();
                            for (Class_ c : classes) {
                                depts.add(c.getManagingDept());
                            }
                            for (SchedulingSubpart s : subparts3) {
                                depts.add(s.getManagingDept());
                            }
                            out.println("  -- departments: " + depts);
                            boolean added = false;
                            for (Department d : depts) {
                                if (d.isExternalManager().booleanValue() || dp.getDepartments().contains(d)) continue;
                                dp.getDepartments().add(d);
                                d.getDatePatterns().add(dp);
                                hibSession3.saveOrUpdate((Object)d);
                                out.println("    -- department " + d + " added to " + dp.getName());
                                added = true;
                            }
                            if (!added) continue;
                            hibSession3.saveOrUpdate((Object)dp);
                            ChangeLog.addChange(hibSession3, this.sessionContext, dp, ChangeLog.Source.DATE_PATTERN_EDIT, ChangeLog.Operation.UPDATE, null, null);
                            refresh.add(dp);
                        }
                        out.flush();
                        out.close();
                        out = null;
                        request.setAttribute("RqOpenUrl", (Object)("temp/" + file2.getName()));
                        tx.commit();
                        Iterator<DatePattern> i2 = refresh.iterator();
                        while (i2.hasNext()) {
                            hibSession3.refresh((Object)i2.next());
                        }
                        Object var34_71 = null;
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Exception e) {
                        if (tx != null) {
                            tx.rollback();
                        }
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var34_72 = null;
                    if (out != null) {
                        out.close();
                    }
                    throw throwable;
                }
                myForm.load(null);
                myForm.setOp("List");
            }
            if ("Export CSV".equals(op)) {
                tx = null;
                try {
                    Session hibSession4 = new TimePatternDAO().getSession();
                    if (hibSession4.getTransaction() == null || !hibSession4.getTransaction().isActive()) {
                        tx = hibSession4.beginTransaction();
                    }
                    CSVFile csv = new CSVFile();
                    csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"Name"), new CSVFile.CSVField((Object)"Type"), new CSVFile.CSVField((Object)"NrDays"), new CSVFile.CSVField((Object)"From"), new CSVFile.CSVField((Object)"To"), new CSVFile.CSVField((Object)"Dates"), new CSVFile.CSVField((Object)"Parent"), new CSVFile.CSVField((Object)"Departments"), new CSVFile.CSVField((Object)"Classes")});
                    Formats.Format<Date> sdf = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
                    allDatePatterns = new TreeSet<DatePattern>(DatePattern.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId(), true, null, null));
                    for (DatePattern dp : allDatePatterns) {
                        List classes = hibSession4.createQuery("select distinct c from Class_ as c inner join c.datePattern as dp where dp.uniqueId=:uniqueId").setLong("uniqueId", dp.getUniqueId().longValue()).list();
                        subparts = hibSession4.createQuery("select distinct s from SchedulingSubpart as s inner join s.datePattern as dp where dp.uniqueId=:uniqueId").setLong("uniqueId", dp.getUniqueId().longValue()).list();
                        allClasses = new TreeSet<Class_>(new ClassComparator(5));
                        ((TreeSet)allClasses).addAll(classes);
                        for (SchedulingSubpart s : subparts) {
                            for (Class_ c : s.getClasses()) {
                                if (c.getDatePattern() != null) continue;
                                ((TreeSet)allClasses).add(c);
                            }
                        }
                        String deptStr = "";
                        TreeSet<Department> depts = new TreeSet<Department>(dp.getDepartments());
                        Iterator<Department> j = depts.iterator();
                        while (j.hasNext()) {
                            Department d;
                            d = j.next();
                            deptStr = deptStr + d.getShortLabel().trim();
                            if (!j.hasNext()) continue;
                            deptStr = deptStr + ", ";
                        }
                        String classStr = "";
                        Iterator<Object> j2 = ((TreeSet)allClasses).iterator();
                        while (j2.hasNext()) {
                            Class_ clazz;
                            clazz = (Class_)j2.next();
                            classStr = classStr + clazz.getClassLabel();
                            if (!j2.hasNext()) continue;
                            classStr = classStr + ", ";
                        }
                        String datePattStr = "";
                        Iterator<DatePattern> j3 = dp.getParents().iterator();
                        while (j3.hasNext()) {
                            DatePattern d = j3.next();
                            datePattStr = datePattStr + d.getName();
                            if (!j3.hasNext()) continue;
                            datePattStr = datePattStr + ", ";
                        }
                        csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)dp.getName()), new CSVFile.CSVField((Object)DatePattern.sTypes[dp.getType()]), new CSVFile.CSVField((Object)String.valueOf(dp.size())), new CSVFile.CSVField((Object)sdf.format(dp.getStartDate())), new CSVFile.CSVField((Object)sdf.format(dp.getEndDate())), new CSVFile.CSVField((Object)dp.getPatternString()), new CSVFile.CSVField((Object)datePattStr), new CSVFile.CSVField((Object)deptStr), new CSVFile.CSVField((Object)classStr)});
                    }
                    ExportUtils.exportCSV(csv, response, "datePatterns");
                    tx.commit();
                    return null;
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
            }
            if ("List".equals(myForm.getOp())) {
                this.getDatePatterns(request);
                return mapping.findForward("list");
            }
            request.setAttribute("DatePatterns.pattern", (Object)myForm.getDatePattern(request).getPatternHtml(true, myForm.getUniqueId()));
            return mapping.findForward(myForm.getUniqueId() < 0L ? "add" : "edit");
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    private void getDatePatterns(HttpServletRequest request) throws Exception {
        Set used = DatePattern.findAllUsed(this.sessionContext.getUser().getCurrentAcademicSessionId());
        boolean hasSet = !DatePattern.findAllParents(this.sessionContext.getUser().getCurrentAcademicSessionId()).isEmpty();
        Formats.Format<Date> sdf = Formats.getDateFormat(Formats.Pattern.DATE_EXAM_PERIOD);
        WebTable.setOrder(this.sessionContext, "datePatterns.ord", request.getParameter("ord"), 1);
        WebTable webTable = hasSet ? new WebTable(6, null, "datePatternEdit.do?ord=%%", new String[]{"Name", "Type", "Used", "Dates / Patterns", "Pattern Sets", "Departments"}, new String[]{"left", "left", "left", "left", "left", "left"}, null) : new WebTable(5, null, "datePatternEdit.do?ord=%%", new String[]{"Name", "Type", "Used", "Dates", "Departments"}, new String[]{"left", "left", "left", "left", "left"}, null);
        List<DatePattern> patterns = DatePattern.findAll(this.sessionContext.getUser(), null, null);
        if (patterns.isEmpty()) {
            webTable.addLine(null, new String[]{"No date pattern defined for this session."}, null, null);
        }
        for (DatePattern pattern : patterns) {
            boolean isUsed;
            String onClick = "onClick=\"document.location='datePatternEdit.do?op=Edit&id=" + pattern.getUniqueId() + "';\"";
            String deptStr = "";
            String deptCmp = "";
            TreeSet<Department> depts = new TreeSet<Department>(pattern.getDepartments());
            Iterator<Department> i = depts.iterator();
            while (i.hasNext()) {
                Department d = i.next();
                deptStr = deptStr + d.getManagingDeptAbbv().trim();
                deptCmp = deptCmp + d.getDeptCode();
                if (!i.hasNext()) continue;
                deptStr = deptStr + ", ";
                deptCmp = deptCmp + ",";
            }
            String datePatternStr = "";
            ArrayList<DatePattern> dps = new ArrayList<DatePattern>(pattern.getParents());
            Collections.sort(dps);
            Iterator i2 = dps.iterator();
            while (i2.hasNext()) {
                DatePattern d = (DatePattern)i2.next();
                datePatternStr = datePatternStr + d.getName();
                if (!i2.hasNext()) continue;
                datePatternStr = datePatternStr + ", ";
            }
            String pattStr = pattern.getPatternString();
            if (pattern.getName().startsWith("generated")) {
                int first = pattern.getPattern().indexOf(49) - pattern.getOffset();
                int last = pattern.getPattern().lastIndexOf(49) - pattern.getOffset();
                BaseDatePattern likeDp = null;
                int likeDiff = 0;
                for (DatePattern xdp : patterns) {
                    if (xdp.getName().startsWith("generated")) continue;
                    int xfirst = xdp.getPattern().indexOf(49) - xdp.getOffset();
                    int xlast = xdp.getPattern().lastIndexOf(49) - xdp.getOffset();
                    int diff = Math.abs(first - xfirst) + Math.abs(last - xlast);
                    if (likeDp != null && likeDiff <= diff && (likeDiff != diff || !xdp.isDefault())) continue;
                    likeDp = xdp;
                    likeDiff = diff;
                }
                if (likeDp != null) {
                    int xfirst = likeDp.getPattern().indexOf(49) - likeDp.getOffset();
                    int xlast = likeDp.getPattern().lastIndexOf(49) - likeDp.getOffset();
                    int firstDiff = first - xfirst;
                    int lastDiff = last - xlast;
                    if (Math.abs(lastDiff) > 3 || Math.abs(firstDiff) > 3) {
                        pattStr = pattStr + "<b>";
                    }
                    pattStr = pattStr + "<br>Similar to " + likeDp.getName() + " (offset " + firstDiff + " and " + lastDiff + " days)";
                    pattStr = pattStr + "<br>" + sdf.format(pattern.getStartDate()) + "-" + sdf.format(pattern.getEndDate()) + " versus " + sdf.format(((DatePattern)likeDp).getStartDate()) + "-" + sdf.format(((DatePattern)likeDp).getEndDate());
                    if (Math.abs(lastDiff) > 3 || Math.abs(firstDiff) > 3) {
                        pattStr = pattStr + "</b>";
                    }
                }
            }
            if (pattern.getType() == 4) {
                for (DatePattern child : new TreeSet<DatePattern>(pattern.findChildren())) {
                    pattStr = pattStr + (pattStr.isEmpty() ? "" : ", ") + child.getName();
                }
            }
            boolean bl = isUsed = used.contains(pattern) || pattern.isDefault();
            if (hasSet) {
                webTable.addLine(onClick, new String[]{(pattern.isDefault() ? "<B>" : "") + (pattern.isVisible() != false ? "" : "<font color='gray'>") + "<a name='" + pattern.getUniqueId() + "'>" + pattern.getName().replaceAll(" ", "&nbsp;") + "</a>" + (pattern.isVisible() != false ? "" : "</font>") + (pattern.isDefault() ? "</B>" : ""), (pattern.isVisible() != false ? "" : "<font color='gray'>") + DatePattern.sTypes[pattern.getType()].replaceAll(" ", "&nbsp;") + (pattern.isVisible() != false ? "" : "</font>"), isUsed ? "<IMG border='0' title='This date pattern is being used.' alt='Default' align='absmiddle' src='images/accept.png'>" : "", (pattern.isVisible() != false ? "" : "<font color='gray'>") + pattStr + (pattern.isVisible() != false ? "" : "</font>"), (pattern.isVisible() != false ? "" : "<font color='gray'>") + datePatternStr + (pattern.isVisible() != false ? "" : "</font>"), (pattern.isVisible() != false ? "" : "<font color='gray'>") + deptStr + (pattern.isVisible() != false ? "" : "</font>")}, new Comparable[]{pattern.getName(), pattern.getType(), isUsed ? "0" : "1", pattStr, datePatternStr, deptCmp});
                continue;
            }
            webTable.addLine(onClick, new String[]{(pattern.isDefault() ? "<B>" : "") + (pattern.isVisible() != false ? "" : "<font color='gray'>") + "<a name='" + pattern.getUniqueId() + "'>" + pattern.getName().replaceAll(" ", "&nbsp;") + "</a>" + (pattern.isVisible() != false ? "" : "</font>") + (pattern.isDefault() ? "</B>" : ""), (pattern.isVisible() != false ? "" : "<font color='gray'>") + DatePattern.sTypes[pattern.getType()].replaceAll(" ", "&nbsp;") + (pattern.isVisible() != false ? "" : "</font>"), isUsed ? "<IMG border='0' title='This date pattern is being used.' alt='Default' align='absmiddle' src='images/accept.png'>" : "", (pattern.isVisible() != false ? "" : "<font color='gray'>") + pattStr + (pattern.isVisible() != false ? "" : "</font>"), (pattern.isVisible() != false ? "" : "<font color='gray'>") + deptStr + (pattern.isVisible() != false ? "" : "</font>")}, new Comparable[]{pattern.getName(), pattern.getType(), isUsed ? "0" : "1", pattStr, deptCmp});
        }
        request.setAttribute("DatePatterns.table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "datePatterns.ord")));
    }
}

