/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.cpsolver.coursett.model.RoomLocation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.InstructionalOfferingSearchAction;
import org.unitime.timetable.action.PreferencesAction;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.ClassEditForm;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.comparators.InstructorComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.TimetableDatabaseLoader;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.DistributionPrefsTableBuilder;

@Service(value="/classDetail")
public class ClassDetailAction
extends PreferencesAction {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;
    public final String HASH_INSTR_PREF = "InstructorPref";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            super.execute(mapping, form, request, response);
            ClassEditForm frm = (ClassEditForm)form;
            ActionMessages errors = new ActionMessages();
            String classId = request.getParameter("cid") == null ? (request.getAttribute("cid") != null ? request.getAttribute("cid").toString() : null) : request.getParameter("cid");
            String op = frm.getOp();
            if (op.equals(MSG.actionEditClass()) || op.equals(MSG.actionAddDistributionPreference()) || op.equals(MSG.actionNextClass()) || op.equals(MSG.actionPreviousClass())) {
                classId = frm.getClassId().toString();
            } else {
                frm.reset(mapping, request);
            }
            Debug.debug("op: " + op);
            Debug.debug("class: " + classId);
            if (classId == null || classId.trim().length() == 0) {
                throw new Exception("Class Info not supplied.");
            }
            this.sessionContext.checkPermission((Serializable)((Object)classId), "Class_", Right.ClassDetail);
            boolean timeVertical = CommonValues.VerticalGrid.eq(this.sessionContext.getUser().getProperty(UserProperty.GridOrientation));
            Class_DAO cdao = new Class_DAO();
            Class_ c = (Class_)cdao.get(new Long(classId));
            if (op.equals(MSG.actionEditClass()) && classId != null && classId.trim() != "") {
                response.sendRedirect(response.encodeURL("classEdit.do?cid=" + c.getUniqueId().toString() + "&sec=" + c.getSectionNumberString()));
                return null;
            }
            if (op.equals(MSG.actionNextClass())) {
                response.sendRedirect(response.encodeURL("classDetail.do?cid=" + frm.getNextId()));
                return null;
            }
            if (op.equals(MSG.actionPreviousClass())) {
                response.sendRedirect(response.encodeURL("classDetail.do?cid=" + frm.getPreviousId()));
                return null;
            }
            if (op.equals(MSG.actionAddDistributionPreference())) {
                SchedulingSubpart ss = c.getSchedulingSubpart();
                CourseOffering cco = ss.getInstrOfferingConfig().getControllingCourseOffering();
                request.setAttribute("subjectAreaId", (Object)cco.getSubjectArea().getUniqueId().toString());
                request.setAttribute("schedSubpartId", (Object)ss.getUniqueId().toString());
                request.setAttribute("courseOffrId", (Object)cco.getUniqueId().toString());
                request.setAttribute("classId", (Object)c.getUniqueId().toString());
                return mapping.findForward("addDistributionPrefs");
            }
            this.doLoad(request, frm, c, op);
            frm.setAvailableTimePatterns(TimePattern.findApplicable(this.sessionContext.getUser(), c.getSchedulingSubpart().getMinutesPerWk(), true, c.getManagingDept()));
            Set timePatterns = null;
            this.initPrefs(frm, c, null, false);
            timePatterns = c.effectiveTimePatterns();
            DistributionPrefsTableBuilder tbl = new DistributionPrefsTableBuilder();
            String html = tbl.getDistPrefsTableForClass(request, this.sessionContext, c);
            if (html != null) {
                request.setAttribute("distPrefs", (Object)html);
            }
            this.processPrefAction(request, frm, errors);
            super.generateTimePatternGrids(request, frm, c, timePatterns, "init", timeVertical, false, null);
            this.setupInstructors(request, frm, c);
            this.setupDatePatterns(request, frm, c);
            LookupTables.setupDatePatterns(request, this.sessionContext.getUser(), "Default", c.getSchedulingSubpart().effectiveDatePattern(), c.getManagingDept(), c.effectiveDatePattern());
            LookupTables.setupRooms(request, c);
            LookupTables.setupBldgs(request, c);
            LookupTables.setupRoomFeatures(request, c);
            LookupTables.setupRoomGroups(request, c);
            BackTracker.markForBack(request, "classDetail.do?cid=" + frm.getClassId(), MSG.backClass(frm.getClassName()), true, false);
            return mapping.findForward("displayClass");
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    private void doLoad(HttpServletRequest request, ClassEditForm frm, Class_ c, String op) {
        String parentClassName = "-";
        Long parentClassId = null;
        if (c.getParentClass() != null) {
            parentClassName = c.getParentClass().toString();
            if (this.sessionContext.hasPermission(c.getParentClass(), Right.ClassDetail)) {
                parentClassId = c.getParentClass().getUniqueId();
            }
        }
        CourseOffering cco = c.getSchedulingSubpart().getControllingCourseOffering();
        InstructionalOfferingSearchAction.setLastInstructionalOffering(this.sessionContext, c.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering());
        frm.setClassId(c.getUniqueId());
        frm.setSection(c.getSectionNumberString());
        frm.setClassName(c.getClassLabel());
        SchedulingSubpart ss = c.getSchedulingSubpart();
        String itypeDesc = c.getItypeDesc();
        if (ss.getInstrOfferingConfig().getInstructionalOffering().hasMultipleConfigurations()) {
            itypeDesc = itypeDesc + " [" + ss.getInstrOfferingConfig().getName() + "]";
        }
        frm.setItypeDesc(itypeDesc);
        frm.setParentClassName(parentClassName);
        frm.setParentClassId(parentClassId);
        frm.setSubjectAreaId(cco.getSubjectArea().getUniqueId().toString());
        frm.setInstrOfferingId(cco.getInstructionalOffering().getUniqueId().toString());
        if (this.sessionContext.hasPermission(c.getSchedulingSubpart(), Right.SchedulingSubpartDetail)) {
            frm.setSubpart(c.getSchedulingSubpart().getUniqueId());
        } else {
            frm.setSubpart(null);
        }
        frm.setCourseName(cco.getInstructionalOffering().getCourseName());
        frm.setCourseTitle(cco.getTitle());
        frm.setIsCrosslisted(new Boolean(cco.getInstructionalOffering().getCourseOfferings().size() > 1));
        frm.setAccommodation(StudentAccomodation.toHtml(StudentAccomodation.getAccommodations(c)));
        frm.setExpectedCapacity(c.getExpectedCapacity());
        frm.setEnrollment(c.getEnrollment());
        frm.setDatePattern(c.getDatePattern() == null ? new Long(-1L) : c.getDatePattern().getUniqueId());
        frm.setNbrRooms(c.getNbrRooms());
        if (c.getNotes() == null) {
            frm.setNotes("");
        } else {
            frm.setNotes(c.getNotes().replaceAll("\n", "<BR>"));
        }
        frm.setManagingDept(c.getManagingDept().getUniqueId());
        frm.setManagingDeptLabel(c.getManagingDept().getManagingDeptLabel());
        frm.setSchedulePrintNote(c.getSchedulePrintNote());
        frm.setClassSuffix(c.getDivSecNumber());
        frm.setMaxExpectedCapacity(c.getMaxExpectedCapacity());
        frm.setRoomRatio(c.getRoomRatio());
        frm.setEnabledForStudentScheduling(c.isEnabledForStudentScheduling());
        frm.setDisplayInstructor(c.isDisplayInstructor());
        frm.setMinRoomLimit(c.getMinRoomLimit());
        Class_ next = c.getNextClass(this.sessionContext, Right.ClassDetail);
        frm.setNextId(next == null ? null : next.getUniqueId().toString());
        Class_ previous = c.getPreviousClass(this.sessionContext, Right.ClassDetail);
        frm.setPreviousId(previous == null ? null : previous.getUniqueId().toString());
        ArrayList<ClassInstructor> instructors = new ArrayList<ClassInstructor>(c.getClassInstructors());
        InstructorComparator ic = new InstructorComparator();
        ic.setCompareBy(ic.COMPARE_BY_LEAD);
        Collections.sort(instructors, ic);
        for (ClassInstructor classInstr : instructors) {
            frm.addToInstructors(classInstr);
        }
        if (c.getNbrRooms() > 0) {
            List<RoomLocation> roomLocations = TimetableDatabaseLoader.computeRoomLocations(c);
            StringBuffer rooms = new StringBuffer();
            if (roomLocations.isEmpty()) {
                request.setAttribute("availableLocations", (Object)"<font color='red'><b>No rooms are available.</b></font>");
            } else {
                int idx = 0;
                for (RoomLocation rl : roomLocations) {
                    if (idx > 0) {
                        rooms.append(", ");
                    }
                    if (idx == 4) {
                        rooms.append("<span id='room_dots' onMouseOver=\"this.style.cursor='hand';this.style.cursor='pointer';\" style='display:inline'><a onClick=\"document.getElementById('room_dots').style.display='none';document.getElementById('room_rest').style.display='inline';\">...</a></span><span id='room_rest' style='display:none'>");
                    }
                    rooms.append("<span style='color:" + PreferenceLevel.int2color(rl.getPreference()) + ";' " + "onmouseover=\"showGwtRoomHint(this, '" + rl.getId() + "', '" + PreferenceLevel.int2string(rl.getPreference()) + "');\" onmouseout=\"hideGwtRoomHint();\">" + rl.getName() + "</span>");
                    ++idx;
                }
                if (idx >= 4) {
                    rooms.append("</span>");
                }
                if (roomLocations.size() < c.getNbrRooms()) {
                    request.setAttribute("availableLocations", (Object)("<font color='red'><b>Not enough rooms are available:</b></font> " + rooms));
                } else {
                    request.setAttribute("availableLocations", (Object)(roomLocations.size() + " (" + rooms + ")"));
                }
            }
        }
    }

    protected void setupInstructors(HttpServletRequest request, ClassEditForm frm, Class_ c) throws Exception {
        List instructors = frm.getInstructors();
        if (instructors.size() == 0) {
            return;
        }
        LookupTables.setupInstructors(request, this.sessionContext, c.getDepartmentForSubjectArea().getUniqueId());
        Vector deptInstrList = (Vector)request.getAttribute(DepartmentalInstructor.INSTR_LIST_ATTR_NAME);
        for (int i = 0; i < instructors.size(); ++i) {
            request.setAttribute(DepartmentalInstructor.INSTR_LIST_ATTR_NAME + i, (Object)deptInstrList);
        }
    }

    private void setupDatePatterns(HttpServletRequest request, ClassEditForm frm, Class_ c) throws Exception {
        DatePattern selectedDatePattern = c.effectiveDatePattern();
        if (selectedDatePattern != null) {
            List<DatePattern> children = selectedDatePattern.findChildren();
            for (DatePattern dp : children) {
                if (frm.getDatePatternPrefs().contains(dp.getUniqueId().toString())) continue;
                frm.addToDatePatternPrefs(dp.getUniqueId().toString(), PreferenceLevel.PREF_LEVEL_NEUTRAL);
            }
            frm.sortDatePatternPrefs(frm.getDatePatternPrefs(), frm.getDatePatternPrefLevels(), children);
        }
    }
}

