/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.jgroups;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.UUID;
import org.unitime.timetable.model.ClusterDiscovery;
import org.unitime.timetable.model.dao.ClusterDiscoveryDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniTimeClusterDiscovery
extends Discovery {
    @Property(description="Number of additional ports to be probed for membership. A port_range of 0 does not probe additional ports. Example: initial_hosts=A[7800] port_range=0 probes A:7800, port_range=1 probes A:7800 and A:7801")
    protected int port_range = 1;
    @Property(name="initial_hosts", description="Comma delimited list of hosts to be contacted for initial membership", converter=PropertyConverters.InitialHosts.class, dependsUpon="port_range", systemProperty={"jgroups.tcpping.initial_hosts"})
    protected List<IpAddress> initial_hosts = Collections.EMPTY_LIST;
    @Property(description="Interval (in milliseconds) at which the own Address is written. 0 disables it.")
    protected long interval = 60000L;
    @Property(description="Interval (in milliseconds) after which an old record is deleted from the cluster discovery table.")
    protected long time_to_live = 600000L;
    private Future<?> writer_future;

    public void stop() {
        Future<?> wf = this.writer_future;
        if (wf != null) {
            wf.cancel(false);
            this.writer_future = null;
        }
        try {
            this.deleteSelf();
        }
        catch (Exception e) {
            this.log.error("Failed to remove my address from the " + this.group_addr + " cluster database.");
        }
        super.stop();
    }

    public void start() throws Exception {
        super.start();
        if (this.interval > 0L) {
            this.writer_future = this.timer.scheduleWithFixedDelay((Runnable)new WriterTask(), this.interval, this.interval, TimeUnit.MILLISECONDS);
        }
    }

    public Collection<PhysicalAddress> fetchClusterMembers(String cluster_name) {
        HashSet<IpAddress> retval = new HashSet<IpAddress>(this.initial_hosts);
        if (!ClusterDiscoveryDAO.isConfigured()) {
            this.log.info("Hibernate not configured yet, returning initial hosts for " + this.group_addr + " cluster members.");
            return retval;
        }
        List<PingData> members = this.readAllMembers();
        if (members.isEmpty()) {
            return retval;
        }
        for (PingData tmp : members) {
            Collection dests;
            Collection collection = dests = tmp != null ? tmp.getPhysicalAddrs() : null;
            if (dests == null) continue;
            for (PhysicalAddress dest : dests) {
                if (dest == null) continue;
                retval.add((IpAddress)dest);
            }
        }
        PhysicalAddress my_addr = this.getAndSavePhysicalAddress();
        this.log.debug("Cluster " + cluster_name + " has members " + retval + " (I am " + my_addr + ")");
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized List<PingData> readAllMembers() {
        ArrayList<PingData> members = new ArrayList<PingData>();
        Session hibSession = ClusterDiscoveryDAO.getInstance().createNewSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            long deadline = new Date().getTime() - this.time_to_live;
            for (ClusterDiscovery cluster : hibSession.createQuery("from ClusterDiscovery where clusterName = :clusterName").setString("clusterName", this.group_addr).list()) {
                if (cluster.getTimeStamp().getTime() < deadline) continue;
                members.add(this.deserialize(cluster.getPingData()));
            }
            if (tx != null) {
                tx.commit();
            }
        }
        catch (IllegalStateException e) {
            this.log.info("Failed to read  all members of cluster " + this.group_addr + ": " + e.getMessage());
            if (tx != null) {
                tx.rollback();
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
        }
        finally {
            hibSession.close();
        }
        return members;
    }

    protected static String addressAsString(Address address) {
        if (address == null) {
            return "";
        }
        if (address instanceof UUID) {
            return ((UUID)address).toStringLong();
        }
        return address.toString();
    }

    protected PhysicalAddress getAndSavePhysicalAddress() {
        PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, (Object)this.local_addr));
        if (!ClusterDiscoveryDAO.isConfigured()) {
            this.log.info("Hibernate not configured yet, skiping save of physical address for cluster " + this.group_addr + ".");
            return physical_addr;
        }
        List<PhysicalAddress> physical_addrs = Arrays.asList(physical_addr);
        PingData data = new PingData(this.local_addr, null, false, UUID.get((Address)this.local_addr), physical_addrs);
        this.updateMyData(data);
        return physical_addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void updateMyData(PingData data) {
        Session hibSession = ClusterDiscoveryDAO.getInstance().createNewSession();
        String own_address = UniTimeClusterDiscovery.addressAsString(data.getAddress());
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            ClusterDiscovery cluster = (ClusterDiscovery)ClusterDiscoveryDAO.getInstance().get(new ClusterDiscovery(own_address, this.group_addr), hibSession);
            if (cluster == null) {
                cluster = new ClusterDiscovery(own_address, this.group_addr);
            }
            cluster.setPingData(this.serializeWithoutView(data));
            cluster.setTimeStamp(new Date());
            hibSession.saveOrUpdate((Object)cluster);
            hibSession.flush();
            if (tx != null) {
                tx.commit();
            }
        }
        catch (IllegalStateException e) {
            if (tx != null) {
                tx.rollback();
            }
            this.log.info("Failed to update my data for cluster " + this.group_addr + ": " + e.getMessage());
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
        }
        finally {
            hibSession.close();
        }
    }

    public Object down(Event evt) {
        Object retval = super.down(evt);
        if (evt.getType() == 6) {
            this.handleView((View)evt.getArg());
        }
        return retval;
    }

    protected void handleView(View view) {
        boolean is_coordinator;
        if (!ClusterDiscoveryDAO.isConfigured()) {
            this.log.info("Hibernate not configured yet, ignoring view change for cluster " + this.group_addr + ".");
            return;
        }
        List mbrs = view.getMembers();
        boolean bl = is_coordinator = !mbrs.isEmpty() && ((Address)mbrs.iterator().next()).equals(this.local_addr);
        if (is_coordinator) {
            this.purgeOtherAddresses(mbrs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void purgeOtherAddresses(Collection<Address> members) {
        Session hibSession = ClusterDiscoveryDAO.getInstance().createNewSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            long deadline = new Date().getTime() - this.time_to_live;
            block5: for (ClusterDiscovery cluster : hibSession.createQuery("from ClusterDiscovery where clusterName = :clusterName").setString("clusterName", this.group_addr).list()) {
                for (Address address : members) {
                    if (!cluster.getOwnAddress().equals(UniTimeClusterDiscovery.addressAsString(address))) continue;
                    continue block5;
                }
                PingData pd = this.deserialize(cluster.getPingData());
                if (pd == null || cluster.getTimeStamp().getTime() >= deadline) continue;
                this.log.debug("Purging " + pd.getPhysicalAddrs() + " from cluster " + this.group_addr + ".");
                hibSession.delete((Object)cluster);
            }
            hibSession.flush();
            if (tx != null) {
                tx.commit();
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
        }
        finally {
            hibSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void deleteSelf() {
        String ownAddress = UniTimeClusterDiscovery.addressAsString(this.local_addr);
        Session hibSession = ClusterDiscoveryDAO.getInstance().createNewSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            ClusterDiscovery cluster = (ClusterDiscovery)ClusterDiscoveryDAO.getInstance().get(new ClusterDiscovery(ownAddress, this.group_addr), hibSession);
            if (cluster != null) {
                hibSession.delete((Object)cluster);
            }
            hibSession.flush();
            if (tx != null) {
                tx.commit();
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
        }
        finally {
            hibSession.close();
        }
    }

    public boolean sendDiscoveryRequestsInParallel() {
        return true;
    }

    public boolean isDynamic() {
        return true;
    }

    static {
        ClassConfigurator.addProtocol((short)666, UniTimeClusterDiscovery.class);
    }

    protected final class WriterTask
    implements Runnable {
        protected WriterTask() {
        }

        public void run() {
            UniTimeClusterDiscovery.this.getAndSavePhysicalAddress();
        }
    }
}

