/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.NamingManager;

public class LocalContext
implements Context,
NameParser,
InitialContextFactory,
InitialContextFactoryBuilder {
    protected Hashtable iEnv;
    protected Hashtable iBindings = new Hashtable();
    protected LocalContext iParent = null;
    protected String iName = null;
    private static final Properties sSyntax = new Properties();

    public LocalContext(Hashtable env) {
        this.iEnv = env != null ? (Hashtable)env.clone() : null;
    }

    protected LocalContext(LocalContext parent, String name, Hashtable env, Hashtable bindings) {
        this(env);
        this.iParent = parent;
        this.iName = name;
        this.iBindings = (Hashtable)bindings.clone();
    }

    protected Context createCtx(LocalContext parent, String name, Hashtable env) {
        return new LocalContext(parent, name, env, new Hashtable());
    }

    protected Context cloneCtx() {
        return new LocalContext(this.iParent, this.iName, this.iEnv, this.iBindings);
    }

    protected Name getMyComponents(Name name) throws NamingException {
        if (name instanceof CompositeName) {
            if (name.size() > 1) {
                throw new InvalidNameException(name.toString() + " has more components than namespace can handle");
            }
            return this.parse(name.get(0));
        }
        return name;
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this.cloneCtx();
        }
        Name nm = this.getMyComponents(name);
        String atom = nm.get(0);
        Object inter = this.iBindings.get(atom);
        if (nm.size() == 1) {
            if (inter == null) {
                throw new NameNotFoundException(name + " not found");
            }
            try {
                return NamingManager.getObjectInstance(inter, new CompositeName().add(atom), this, this.iEnv);
            }
            catch (Exception e) {
                NamingException ne = new NamingException("getObjectInstance failed");
                ne.setRootCause(e);
                throw ne;
            }
        }
        if (!(inter instanceof Context)) {
            throw new NotContextException(atom + " does not name a context");
        }
        return ((Context)inter).lookup(nm.getSuffix(1));
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    public void bind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        Name nm = this.getMyComponents(name);
        String atom = nm.get(0);
        Object inter = this.iBindings.get(atom);
        if (nm.size() == 1) {
            if (inter != null) {
                throw new NameAlreadyBoundException("Use rebind to override");
            }
            obj = NamingManager.getStateToBind(obj, new CompositeName().add(atom), this, this.iEnv);
            this.iBindings.put(atom, obj);
        } else {
            if (!(inter instanceof Context)) {
                throw new NotContextException(atom + " does not name a context");
            }
            ((Context)inter).bind(nm.getSuffix(1), obj);
        }
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        Name nm = this.getMyComponents(name);
        String atom = nm.get(0);
        if (nm.size() == 1) {
            obj = NamingManager.getStateToBind(obj, new CompositeName().add(atom), this, this.iEnv);
            this.iBindings.put(atom, obj);
        } else {
            Object inter = this.iBindings.get(atom);
            if (!(inter instanceof Context)) {
                throw new NotContextException(atom + " does not name a context");
            }
            ((Context)inter).rebind(nm.getSuffix(1), obj);
        }
    }

    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        Name nm = this.getMyComponents(name);
        String atom = nm.get(0);
        if (nm.size() == 1) {
            this.iBindings.remove(atom);
        } else {
            Object inter = this.iBindings.get(atom);
            if (!(inter instanceof Context)) {
                throw new NotContextException(atom + " does not name a context");
            }
            ((Context)inter).unbind(nm.getSuffix(1));
        }
    }

    public void rename(String oldname, String newname) throws NamingException {
        this.rename(new CompositeName(oldname), new CompositeName(newname));
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        if (oldname.isEmpty() || newname.isEmpty()) {
            throw new InvalidNameException("Cannot rename empty name");
        }
        Name oldnm = this.getMyComponents(oldname);
        Name newnm = this.getMyComponents(newname);
        if (oldnm.size() != newnm.size()) {
            throw new OperationNotSupportedException("Do not support rename across different contexts");
        }
        String oldatom = oldnm.get(0);
        String newatom = newnm.get(0);
        if (oldnm.size() == 1) {
            if (this.iBindings.get(newatom) != null) {
                throw new NameAlreadyBoundException(newname.toString() + " is already bound");
            }
            Object oldBinding = this.iBindings.remove(oldatom);
            if (oldBinding == null) {
                throw new NameNotFoundException(oldname.toString() + " not bound");
            }
            this.iBindings.put(newatom, oldBinding);
        } else {
            if (!oldatom.equals(newatom)) {
                throw new OperationNotSupportedException("Do not support rename across different contexts");
            }
            Object inter = this.iBindings.get(oldatom);
            if (!(inter instanceof Context)) {
                throw new NotContextException(oldatom + " does not name a context");
            }
            ((Context)inter).rename(oldnm.getSuffix(1), newnm.getSuffix(1));
        }
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new ListOfNames(this.iBindings.keys());
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).list("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new ListOfBindings(this.iBindings.keys());
        }
        Object target = this.lookup(name);
        if (target instanceof Context) {
            return ((Context)target).listBindings("");
        }
        throw new NotContextException(name + " cannot be listed");
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot destroy context using empty name");
        }
        this.unbind(name);
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        Name nm = this.getMyComponents(name);
        String atom = nm.get(0);
        Object inter = this.iBindings.get(atom);
        if (nm.size() == 1) {
            if (inter != null) {
                throw new NameAlreadyBoundException("Use rebind to override");
            }
            Context child = this.createCtx(this, atom, this.iEnv);
            this.iBindings.put(atom, child);
            return child;
        }
        if (!(inter instanceof Context)) {
            throw new NotContextException(atom + " does not name a context");
        }
        return ((Context)inter).createSubcontext(nm.getSuffix(1));
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(new CompositeName(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(new CompositeName(name));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        Object obj = this.lookup(name);
        if (obj instanceof Context) {
            ((Context)obj).close();
        }
        return this;
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        if (!(name instanceof CompositeName) && !(prefix instanceof CompositeName)) {
            Name result = (Name)prefix.clone();
            result.addAll(name);
            return new CompositeName().add(result.toString());
        }
        throw new OperationNotSupportedException("Do not support composing composite names");
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.iEnv == null) {
            this.iEnv = new Hashtable(5, 0.75f);
        }
        return this.iEnv.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.iEnv == null) {
            return null;
        }
        return this.iEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.iEnv == null) {
            return new Hashtable(3, 0.75f);
        }
        return (Hashtable)this.iEnv.clone();
    }

    public String getNameInNamespace() throws NamingException {
        LocalContext ancestor = this.iParent;
        if (ancestor == null) {
            return "";
        }
        Name name = this.parse("");
        name.add(this.iName);
        while (ancestor != null && ancestor.iName != null) {
            name.add(0, ancestor.iName);
            ancestor = ancestor.iParent;
        }
        return name.toString();
    }

    public String toString() {
        if (this.iName != null) {
            return this.iName;
        }
        return "ROOT CONTEXT";
    }

    public void close() throws NamingException {
    }

    public Name parse(String name) throws NamingException {
        return new CompoundName(name, sSyntax);
    }

    public InitialContextFactory createInitialContextFactory(Hashtable env) throws NamingException {
        return new LocalContext(env);
    }

    public Context getInitialContext(Hashtable env) throws NamingException {
        return new LocalContext(env);
    }

    static {
        sSyntax.put("jndi.syntax.direction", "right_to_left");
        sSyntax.put("jndi.syntax.separator", ".");
        sSyntax.put("jndi.syntax.ignorecase", "false");
        sSyntax.put("jndi.syntax.escape", "\\");
        sSyntax.put("jndi.syntax.beginquote", "'");
    }

    class ListOfBindings
    extends ListOfNames {
        ListOfBindings(Enumeration names) {
            super(names);
        }

        public Object next() throws NamingException {
            String name = (String)this.iNames.nextElement();
            Object obj = LocalContext.this.iBindings.get(name);
            try {
                obj = NamingManager.getObjectInstance(obj, new CompositeName().add(name), LocalContext.this, LocalContext.this.iEnv);
            }
            catch (Exception e) {
                NamingException ne = new NamingException("getObjectInstance failed");
                ne.setRootCause(e);
                throw ne;
            }
            return new Binding(name, obj);
        }
    }

    class ListOfNames
    implements NamingEnumeration {
        protected Enumeration iNames;

        ListOfNames(Enumeration names) {
            this.iNames = names;
        }

        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException e) {
                return false;
            }
        }

        public boolean hasMore() throws NamingException {
            return this.iNames.hasMoreElements();
        }

        public Object next() throws NamingException {
            String name = (String)this.iNames.nextElement();
            String className = LocalContext.this.iBindings.get(name).getClass().getName();
            return new NameClassPair(name, className);
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException e) {
                throw new NoSuchElementException(e.toString());
            }
        }

        public void close() {
        }
    }
}

