/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.constraint;

import java.util.ArrayList;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.reservation.Reservation;

public class ReservationLimit
extends GlobalConstraint<Request, Enrollment> {
    private static double sNominalWeight = 1.0E-5;
    private boolean iPreferDummyStudents = false;

    public ReservationLimit(DataProperties cfg) {
        this.iPreferDummyStudents = cfg.getPropertyBoolean("ReservationLimit.PreferDummyStudents", false);
    }

    public static double getUnreservedSpace(Assignment<Request, Enrollment> assignment, Config config, Request request, boolean hasReservation) {
        if (hasReservation) {
            return config.getUnreservedSpace(assignment, request) - request.getWeight() + Math.max(config.getMaxEnrollmentWeight(assignment), request.getWeight()) - sNominalWeight;
        }
        return Math.min(config.getUnreservedSpace(assignment, request), config.getOffering().getUnreservedSpace(assignment, request)) - request.getWeight() + Math.max(config.getMaxEnrollmentWeight(assignment), request.getWeight()) - sNominalWeight;
    }

    @Override
    public void computeConflicts(Assignment<Request, Enrollment> assignment, Enrollment enrollment, Set<Enrollment> conflicts) {
        block33: {
            Config config;
            block32: {
                config = enrollment.getConfig();
                if (config == null) {
                    return;
                }
                if (!config.getOffering().hasReservations()) {
                    return;
                }
                Reservation reservation = enrollment.getReservation();
                if (reservation == null) break block32;
                double reserved = reservation.getReservedAvailableSpace(assignment, enrollment.getRequest());
                if (reservation.getLimit() >= 0.0 && reserved < enrollment.getRequest().getWeight()) {
                    ArrayList<Enrollment> adepts = new ArrayList<Enrollment>(config.getEnrollments(assignment).size());
                    for (Enrollment e : config.getEnrollments(assignment)) {
                        if (e.getRequest().equals(enrollment.getRequest()) || !reservation.equals(e.getReservation())) continue;
                        if (conflicts.contains(e)) {
                            reserved += e.getRequest().getWeight();
                            continue;
                        }
                        adepts.add(e);
                    }
                    while (reserved < enrollment.getRequest().getWeight()) {
                        if (adepts.isEmpty()) {
                            conflicts.add(enrollment);
                            return;
                        }
                        ArrayList<Enrollment> best = new ArrayList<Enrollment>();
                        boolean bestDummy = false;
                        double bestValue = 0.0;
                        for (Enrollment adept : adepts) {
                            boolean dummy = adept.getStudent().isDummy();
                            double value = adept.toDouble(assignment, false);
                            if (this.iPreferDummyStudents && dummy != bestDummy) {
                                if (!dummy) continue;
                                best.clear();
                                best.add(adept);
                                bestDummy = dummy;
                                bestValue = value;
                                continue;
                            }
                            if (best.isEmpty() || value > bestValue) {
                                if (best.isEmpty()) {
                                    best.clear();
                                }
                                best.add(adept);
                                bestDummy = dummy;
                                bestValue = value;
                                continue;
                            }
                            if (bestValue != value) continue;
                            best.add(adept);
                        }
                        Enrollment conflict = (Enrollment)ToolBox.random(best);
                        adepts.remove(conflict);
                        reserved += conflict.getRequest().getWeight();
                        conflicts.add(conflict);
                    }
                }
                if (this.hasConfigReservation(enrollment)) break block33;
                if (reservation.canBatchAssignOverLimit()) {
                    return;
                }
                if (config.getTotalUnreservedSpace() < enrollment.getRequest().getWeight()) {
                    conflicts.add(enrollment);
                    return;
                }
                double unreserved = ReservationLimit.getUnreservedSpace(assignment, config, enrollment.getRequest(), true);
                if (unreserved < 0.0) {
                    ArrayList<Enrollment> adepts = new ArrayList<Enrollment>(config.getEnrollments(assignment).size());
                    for (Enrollment e : config.getEnrollments(assignment)) {
                        if (e.getRequest().equals(enrollment.getRequest()) || this.hasConfigReservation(e)) continue;
                        if (conflicts.contains(e)) {
                            unreserved += e.getRequest().getWeight();
                            continue;
                        }
                        adepts.add(e);
                    }
                    while (unreserved < 0.0) {
                        if (adepts.isEmpty()) {
                            conflicts.add(enrollment);
                            return;
                        }
                        ArrayList<Enrollment> best = new ArrayList<Enrollment>();
                        boolean bestDummy = false;
                        double bestValue = 0.0;
                        for (Enrollment adept : adepts) {
                            boolean dummy = adept.getStudent().isDummy();
                            double value = adept.toDouble(assignment, false);
                            if (this.iPreferDummyStudents && dummy != bestDummy) {
                                if (!dummy) continue;
                                best.clear();
                                best.add(adept);
                                bestDummy = dummy;
                                bestValue = value;
                                continue;
                            }
                            if (best.isEmpty() || value > bestValue) {
                                if (best.isEmpty()) {
                                    best.clear();
                                }
                                best.add(adept);
                                bestDummy = dummy;
                                bestValue = value;
                                continue;
                            }
                            if (bestValue != value) continue;
                            best.add(adept);
                        }
                        Enrollment conflict = (Enrollment)ToolBox.random(best);
                        adepts.remove(conflict);
                        unreserved += conflict.getRequest().getWeight();
                        conflicts.add(conflict);
                    }
                }
                break block33;
            }
            if (config.getOffering().getTotalUnreservedSpace() < enrollment.getRequest().getWeight() || config.getTotalUnreservedSpace() < enrollment.getRequest().getWeight()) {
                conflicts.add(enrollment);
                return;
            }
            double unreserved = ReservationLimit.getUnreservedSpace(assignment, config, enrollment.getRequest(), false);
            if (unreserved < 0.0) {
                ArrayList<Enrollment> adepts = new ArrayList<Enrollment>(config.getEnrollments(assignment).size());
                for (Enrollment e : config.getEnrollments(assignment)) {
                    if (e.getRequest().equals(enrollment.getRequest()) || e.getReservation() != null) continue;
                    if (conflicts.contains(e)) {
                        unreserved += e.getRequest().getWeight();
                        continue;
                    }
                    adepts.add(e);
                }
                while (unreserved < 0.0) {
                    if (adepts.isEmpty()) {
                        conflicts.add(enrollment);
                        return;
                    }
                    ArrayList<Enrollment> best = new ArrayList<Enrollment>();
                    boolean bestDummy = false;
                    double bestValue = 0.0;
                    for (Enrollment adept : adepts) {
                        boolean dummy = adept.getStudent().isDummy();
                        double value = adept.toDouble(assignment, false);
                        if (this.iPreferDummyStudents && dummy != bestDummy) {
                            if (!dummy) continue;
                            best.clear();
                            best.add(adept);
                            bestDummy = dummy;
                            bestValue = value;
                            continue;
                        }
                        if (best.isEmpty() || value > bestValue) {
                            if (best.isEmpty()) {
                                best.clear();
                            }
                            best.add(adept);
                            bestDummy = dummy;
                            bestValue = value;
                            continue;
                        }
                        if (bestValue != value) continue;
                        best.add(adept);
                    }
                    Enrollment conflict = (Enrollment)ToolBox.random(best);
                    adepts.remove(conflict);
                    unreserved += conflict.getRequest().getWeight();
                    conflicts.add(conflict);
                }
            }
        }
    }

    private boolean hasConfigReservation(Enrollment enrollment) {
        if (enrollment.getConfig() == null) {
            return false;
        }
        Reservation reservation = enrollment.getReservation();
        if (reservation == null) {
            return false;
        }
        return reservation.getConfigs().contains(enrollment.getConfig());
    }

    @Override
    public boolean inConflict(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        Config config = enrollment.getConfig();
        if (config == null) {
            return false;
        }
        Reservation reservation = enrollment.getReservation();
        if (reservation != null) {
            if (reservation.getLimit() < 0.0) {
                return false;
            }
            if (reservation.getReservedAvailableSpace(assignment, enrollment.getRequest()) < enrollment.getRequest().getWeight()) {
                return true;
            }
            if (reservation.canBatchAssignOverLimit()) {
                return false;
            }
            return !this.hasConfigReservation(enrollment) && ReservationLimit.getUnreservedSpace(assignment, config, enrollment.getRequest(), true) < 0.0;
        }
        return config.getOffering().getTotalUnreservedSpace() < enrollment.getRequest().getWeight() || config.getTotalUnreservedSpace() < enrollment.getRequest().getWeight() || ReservationLimit.getUnreservedSpace(assignment, config, enrollment.getRequest(), false) < 0.0;
    }

    public String toString() {
        return "ReservationLimit";
    }
}

