/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct;

import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.Callback;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;

public abstract class StudentSectioningSaver
implements Runnable {
    private Solver<Request, Enrollment> iSolver = null;
    private Callback iCallback = null;

    public StudentSectioningSaver(Solver<Request, Enrollment> solver) {
        this.iSolver = solver;
    }

    public Solver<Request, Enrollment> getSolver() {
        return this.iSolver;
    }

    protected Solution<Request, Enrollment> getSolution() {
        return this.iSolver.currentSolution();
    }

    protected StudentSectioningModel getModel() {
        return (StudentSectioningModel)this.iSolver.currentSolution().getModel();
    }

    protected Assignment<Request, Enrollment> getAssignment() {
        return this.iSolver.currentSolution().getAssignment();
    }

    public abstract void save() throws Exception;

    public void setCallback(Callback callback) {
        this.iCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.save();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error(e.getMessage(), e);
        }
        finally {
            if (this.iCallback != null) {
                this.iCallback.execute();
            }
        }
    }
}

