/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.assignment.context;

import java.util.Arrays;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.AssignmentContextHolder;
import org.cpsolver.ifs.assignment.context.AssignmentContextReference;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;

public class AssignmentContextHolderArray<V extends Variable<V, T>, T extends Value<V, T>>
implements AssignmentContextHolder<V, T> {
    private AssignmentContext[] iContexts = new AssignmentContext[1000];

    @Override
    public <U extends AssignmentContext> U getAssignmentContext(Assignment<V, T> assignment, AssignmentContextReference<V, T, U> reference) {
        AssignmentContext context;
        try {
            context = this.iContexts[reference.getIndex()];
            if (context != null) {
                return (U)context;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        context = reference.getParent().createAssignmentContext(assignment);
        if (this.iContexts.length <= reference.getIndex()) {
            this.iContexts = Arrays.copyOf(this.iContexts, reference.getIndex() + 1000);
        }
        this.iContexts[reference.getIndex()] = context;
        return (U)context;
    }

    @Override
    public <C extends AssignmentContext> void clearContext(AssignmentContextReference<V, T, C> reference) {
        try {
            this.iContexts[reference.getIndex()] = null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

