/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util;

import biweekly.util.ListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Recurrence {
    private final Frequency frequency;
    private final Integer interval;
    private final Integer count;
    private final Date until;
    private final boolean untilHasTime;
    private final List<Integer> bySecond;
    private final List<Integer> byMinute;
    private final List<Integer> byHour;
    private final List<Integer> byMonthDay;
    private final List<Integer> byYearDay;
    private final List<Integer> byWeekNo;
    private final List<Integer> byMonth;
    private final List<Integer> bySetPos;
    private final List<DayOfWeek> byDay;
    private final List<Integer> byDayPrefixes;
    private final DayOfWeek workweekStarts;
    private final Map<String, List<String>> xrules;

    private Recurrence(Builder builder) {
        this.frequency = builder.frequency;
        this.interval = builder.interval;
        this.count = builder.count;
        this.until = builder.until;
        this.untilHasTime = builder.untilHasTime;
        this.bySecond = Collections.unmodifiableList(builder.bySecond);
        this.byMinute = Collections.unmodifiableList(builder.byMinute);
        this.byHour = Collections.unmodifiableList(builder.byHour);
        this.byMonthDay = Collections.unmodifiableList(builder.byMonthDay);
        this.byYearDay = Collections.unmodifiableList(builder.byYearDay);
        this.byWeekNo = Collections.unmodifiableList(builder.byWeekNo);
        this.byMonth = Collections.unmodifiableList(builder.byMonth);
        this.bySetPos = Collections.unmodifiableList(builder.bySetPos);
        this.byDay = Collections.unmodifiableList(builder.byDay);
        this.byDayPrefixes = Collections.unmodifiableList(builder.byDayPrefixes);
        this.workweekStarts = builder.workweekStarts;
        Map map = builder.xrules.getMap();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            List value = entry.getValue();
            map.put(key, Collections.unmodifiableList(value));
        }
        this.xrules = Collections.unmodifiableMap(map);
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public Date getUntil() {
        return this.until == null ? null : new Date(this.until.getTime());
    }

    public boolean hasTimeUntilDate() {
        return this.untilHasTime;
    }

    public Integer getCount() {
        return this.count;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public List<Integer> getBySecond() {
        return this.bySecond;
    }

    public List<Integer> getByMinute() {
        return this.byMinute;
    }

    public List<Integer> getByHour() {
        return this.byHour;
    }

    public List<DayOfWeek> getByDay() {
        return this.byDay;
    }

    public List<Integer> getByDayPrefixes() {
        return this.byDayPrefixes;
    }

    public List<Integer> getByMonthDay() {
        return this.byMonthDay;
    }

    public List<Integer> getByYearDay() {
        return this.byYearDay;
    }

    public List<Integer> getByWeekNo() {
        return this.byWeekNo;
    }

    public List<Integer> getByMonth() {
        return this.byMonth;
    }

    public List<Integer> getBySetPos() {
        return this.bySetPos;
    }

    public DayOfWeek getWorkweekStarts() {
        return this.workweekStarts;
    }

    public Map<String, List<String>> getXRules() {
        return this.xrules;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.byDay == null ? 0 : this.byDay.hashCode());
        result = 31 * result + (this.byDayPrefixes == null ? 0 : this.byDayPrefixes.hashCode());
        result = 31 * result + (this.byHour == null ? 0 : this.byHour.hashCode());
        result = 31 * result + (this.byMinute == null ? 0 : this.byMinute.hashCode());
        result = 31 * result + (this.byMonth == null ? 0 : this.byMonth.hashCode());
        result = 31 * result + (this.byMonthDay == null ? 0 : this.byMonthDay.hashCode());
        result = 31 * result + (this.bySecond == null ? 0 : this.bySecond.hashCode());
        result = 31 * result + (this.bySetPos == null ? 0 : this.bySetPos.hashCode());
        result = 31 * result + (this.byWeekNo == null ? 0 : this.byWeekNo.hashCode());
        result = 31 * result + (this.byYearDay == null ? 0 : this.byYearDay.hashCode());
        result = 31 * result + (this.count == null ? 0 : this.count.hashCode());
        result = 31 * result + (this.xrules == null ? 0 : this.xrules.hashCode());
        result = 31 * result + (this.frequency == null ? 0 : this.frequency.hashCode());
        result = 31 * result + (this.interval == null ? 0 : this.interval.hashCode());
        result = 31 * result + (this.until == null ? 0 : this.until.hashCode());
        result = 31 * result + (this.untilHasTime ? 1231 : 1237);
        result = 31 * result + (this.workweekStarts == null ? 0 : this.workweekStarts.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Recurrence other = (Recurrence)obj;
        if (this.byDay == null ? other.byDay != null : !this.byDay.equals(other.byDay)) {
            return false;
        }
        if (this.byDayPrefixes == null ? other.byDayPrefixes != null : !this.byDayPrefixes.equals(other.byDayPrefixes)) {
            return false;
        }
        if (this.byHour == null ? other.byHour != null : !this.byHour.equals(other.byHour)) {
            return false;
        }
        if (this.byMinute == null ? other.byMinute != null : !this.byMinute.equals(other.byMinute)) {
            return false;
        }
        if (this.byMonth == null ? other.byMonth != null : !this.byMonth.equals(other.byMonth)) {
            return false;
        }
        if (this.byMonthDay == null ? other.byMonthDay != null : !this.byMonthDay.equals(other.byMonthDay)) {
            return false;
        }
        if (this.bySecond == null ? other.bySecond != null : !this.bySecond.equals(other.bySecond)) {
            return false;
        }
        if (this.bySetPos == null ? other.bySetPos != null : !this.bySetPos.equals(other.bySetPos)) {
            return false;
        }
        if (this.byWeekNo == null ? other.byWeekNo != null : !this.byWeekNo.equals(other.byWeekNo)) {
            return false;
        }
        if (this.byYearDay == null ? other.byYearDay != null : !this.byYearDay.equals(other.byYearDay)) {
            return false;
        }
        if (this.count == null ? other.count != null : !this.count.equals(other.count)) {
            return false;
        }
        if (this.xrules == null ? other.xrules != null : !this.xrules.equals(other.xrules)) {
            return false;
        }
        if (this.frequency != other.frequency) {
            return false;
        }
        if (this.interval == null ? other.interval != null : !this.interval.equals(other.interval)) {
            return false;
        }
        if (this.until == null ? other.until != null : !this.until.equals(other.until)) {
            return false;
        }
        if (this.untilHasTime != other.untilHasTime) {
            return false;
        }
        return this.workweekStarts == other.workweekStarts;
    }

    public static class Builder {
        private Frequency frequency;
        private Integer interval;
        private Integer count;
        private Date until;
        private boolean untilHasTime;
        private List<Integer> bySecond;
        private List<Integer> byMinute;
        private List<Integer> byHour;
        private List<DayOfWeek> byDay;
        private List<Integer> byDayPrefixes;
        private List<Integer> byMonthDay;
        private List<Integer> byYearDay;
        private List<Integer> byWeekNo;
        private List<Integer> byMonth;
        private List<Integer> bySetPos;
        private DayOfWeek workweekStarts;
        private ListMultimap<String, String> xrules;

        public Builder(Frequency frequency) {
            this.frequency = frequency;
            this.bySecond = new ArrayList<Integer>(0);
            this.byMinute = new ArrayList<Integer>(0);
            this.byHour = new ArrayList<Integer>(0);
            this.byDay = new ArrayList<DayOfWeek>(0);
            this.byDayPrefixes = new ArrayList<Integer>(0);
            this.byMonthDay = new ArrayList<Integer>(0);
            this.byYearDay = new ArrayList<Integer>(0);
            this.byWeekNo = new ArrayList<Integer>(0);
            this.byMonth = new ArrayList<Integer>(0);
            this.bySetPos = new ArrayList<Integer>(0);
            this.xrules = new ListMultimap(0);
        }

        public Builder(Recurrence recur) {
            this.frequency = recur.frequency;
            this.interval = recur.interval;
            this.count = recur.count;
            this.until = recur.until;
            this.untilHasTime = recur.untilHasTime;
            this.bySecond = new ArrayList<Integer>(recur.bySecond);
            this.byMinute = new ArrayList<Integer>(recur.byMinute);
            this.byHour = new ArrayList<Integer>(recur.byHour);
            this.byDay = new ArrayList<DayOfWeek>(recur.byDay);
            this.byDayPrefixes = new ArrayList<Integer>(recur.byDayPrefixes);
            this.byMonthDay = new ArrayList<Integer>(recur.byMonthDay);
            this.byYearDay = new ArrayList<Integer>(recur.byYearDay);
            this.byWeekNo = new ArrayList<Integer>(recur.byWeekNo);
            this.byMonth = new ArrayList<Integer>(recur.byMonth);
            this.bySetPos = new ArrayList<Integer>(recur.bySetPos);
            this.workweekStarts = recur.workweekStarts;
            this.xrules = new ListMultimap(recur.xrules);
        }

        public Builder frequency(Frequency frequency) {
            this.frequency = frequency;
            return this;
        }

        public Builder until(Date until) {
            return this.until(until, true);
        }

        public Builder until(Date until, boolean hasTime) {
            if (until == null) {
                this.until = null;
                this.untilHasTime = false;
            } else {
                this.until = new Date(until.getTime());
                this.untilHasTime = hasTime;
            }
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public Builder bySecond(Integer bySecond) {
            this.bySecond.add(bySecond);
            return this;
        }

        public Builder byMinute(Integer byMinute) {
            this.byMinute.add(byMinute);
            return this;
        }

        public Builder byHour(Integer byHour) {
            this.byHour.add(byHour);
            return this;
        }

        public Builder byMonthDay(Integer byMonthDay) {
            this.byMonthDay.add(byMonthDay);
            return this;
        }

        public Builder byYearDay(Integer byYearDay) {
            this.byYearDay.add(byYearDay);
            return this;
        }

        public Builder byWeekNo(Integer byWeekNo) {
            this.byWeekNo.add(byWeekNo);
            return this;
        }

        public Builder byMonth(Integer byMonth) {
            this.byMonth.add(byMonth);
            return this;
        }

        public Builder bySetPos(Integer bySetPos) {
            this.bySetPos.add(bySetPos);
            return this;
        }

        public Builder byDay(DayOfWeek byDay) {
            return this.byDay(null, byDay);
        }

        public Builder byDay(Integer prefix, DayOfWeek byDay) {
            this.byDayPrefixes.add(prefix);
            this.byDay.add(byDay);
            return this;
        }

        public Builder workweekStarts(DayOfWeek workweekStarts) {
            this.workweekStarts = workweekStarts;
            return this;
        }

        public Builder xrule(String name, String value) {
            name = name.toUpperCase();
            if (value == null) {
                this.xrules.removeAll(name);
            } else {
                this.xrules.put(name, value);
            }
            return this;
        }

        public Recurrence build() {
            return new Recurrence(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DayOfWeek {
        MONDAY("MO"),
        TUESDAY("TU"),
        WEDNESDAY("WE"),
        THURSDAY("TH"),
        FRIDAY("FR"),
        SATURDAY("SA"),
        SUNDAY("SU");

        private final String abbr;

        private DayOfWeek(String abbr) {
            this.abbr = abbr;
        }

        public String getAbbr() {
            return this.abbr;
        }

        public static DayOfWeek valueOfAbbr(String abbr) {
            for (DayOfWeek day : DayOfWeek.values()) {
                if (!day.abbr.equalsIgnoreCase(abbr)) continue;
                return day;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Frequency {
        SECONDLY,
        MINUTELY,
        HOURLY,
        DAILY,
        WEEKLY,
        MONTHLY,
        YEARLY;

    }
}

