/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.Warning;
import biweekly.io.CannotParseException;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.Xml;
import biweekly.util.XmlUtils;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlScribe
extends ICalPropertyScribe<Xml> {
    public XmlScribe() {
        super(Xml.class, "XML", ICalDataType.TEXT);
    }

    @Override
    protected String _writeText(Xml property) {
        Document value = (Document)property.getValue();
        if (value != null) {
            String xml = this.valueToString(value);
            return XmlScribe.escape(xml);
        }
        return "";
    }

    @Override
    protected Xml _parseText(String value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        value = XmlScribe.unescape(value);
        try {
            return new Xml(value);
        }
        catch (SAXException e) {
            throw new CannotParseException(29, new Object[0]);
        }
    }

    @Override
    protected void _writeXml(Xml property, XCalElement element) {
        super._writeXml(property, element);
    }

    @Override
    protected Xml _parseXml(XCalElement element, ICalParameters parameters, List<Warning> warnings) {
        Xml xml = new Xml(element.getElement());
        Element root = XmlUtils.getRootElement((Document)xml.getValue());
        for (Element child : XmlUtils.toElementList(root.getChildNodes())) {
            if (!"parameters".equals(child.getLocalName()) || !"urn:ietf:params:xml:ns:icalendar-2.0".equals(child.getNamespaceURI())) continue;
            root.removeChild(child);
        }
        return xml;
    }

    @Override
    protected JCalValue _writeJson(Xml property) {
        Document value = (Document)property.getValue();
        if (value != null) {
            String xml = this.valueToString(value);
            return JCalValue.single(xml);
        }
        return JCalValue.single("");
    }

    @Override
    protected Xml _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        try {
            String xml = value.asSingle();
            return new Xml(xml);
        }
        catch (SAXException e) {
            throw new CannotParseException(29, new Object[0]);
        }
    }

    private String valueToString(Document document) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("omit-xml-declaration", "yes");
        return XmlUtils.toString(document, props);
    }
}

