/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.Warning;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.TextProperty;
import biweekly.property.ValuedProperty;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextPropertyScribe<T extends TextProperty>
extends ICalPropertyScribe<T> {
    public TextPropertyScribe(Class<T> clazz, String propertyName) {
        this(clazz, propertyName, ICalDataType.TEXT);
    }

    public TextPropertyScribe(Class<T> clazz, String propertyName, ICalDataType dataType) {
        super(clazz, propertyName, dataType);
    }

    @Override
    protected String _writeText(T property) {
        String value = (String)((ValuedProperty)property).getValue();
        if (value != null) {
            return TextPropertyScribe.escape(value);
        }
        return "";
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        value = TextPropertyScribe.unescape(value);
        return this.newInstance(value);
    }

    @Override
    protected void _writeXml(T property, XCalElement element) {
        element.append(this.dataType(property), (String)((ValuedProperty)property).getValue());
    }

    @Override
    protected T _parseXml(XCalElement element, ICalParameters parameters, List<Warning> warnings) {
        String value = element.first(this.defaultDataType);
        if (value != null) {
            return this.newInstance(value);
        }
        throw TextPropertyScribe.missingXmlElements(this.defaultDataType);
    }

    @Override
    protected JCalValue _writeJson(T property) {
        return JCalValue.single(((ValuedProperty)property).getValue());
    }

    @Override
    protected T _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        return this.newInstance(value.asSingle());
    }

    protected abstract T newInstance(String var1);
}

