/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.Warning;
import biweekly.io.CannotParseException;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.IntegerProperty;
import biweekly.property.ValuedProperty;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IntegerPropertyScribe<T extends IntegerProperty>
extends ICalPropertyScribe<T> {
    public IntegerPropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName, ICalDataType.INTEGER);
    }

    @Override
    protected String _writeText(T property) {
        Integer value = (Integer)((ValuedProperty)property).getValue();
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        value = IntegerPropertyScribe.unescape(value);
        return this.parse(value);
    }

    @Override
    protected void _writeXml(T property, XCalElement element) {
        String valueStr = null;
        Integer value = (Integer)((ValuedProperty)property).getValue();
        if (value != null) {
            valueStr = value.toString();
        }
        element.append(this.dataType(property), valueStr);
    }

    @Override
    protected T _parseXml(XCalElement element, ICalParameters parameters, List<Warning> warnings) {
        String value = element.first(this.defaultDataType);
        if (value != null) {
            return this.parse(value);
        }
        throw IntegerPropertyScribe.missingXmlElements(this.defaultDataType);
    }

    @Override
    protected JCalValue _writeJson(T property) {
        return JCalValue.single(((ValuedProperty)property).getValue());
    }

    @Override
    protected T _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        return this.parse(value.asSingle());
    }

    private T parse(String value) {
        if (value == null || value.length() == 0) {
            return this.newInstance(null);
        }
        try {
            Integer intValue = Integer.valueOf(value);
            return this.newInstance(intValue);
        }
        catch (NumberFormatException e) {
            throw new CannotParseException(24, new Object[0]);
        }
    }

    protected abstract T newInstance(Integer var1);
}

