/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.Warning;
import biweekly.io.CannotParseException;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.DateTimeProperty;
import biweekly.property.ValuedProperty;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DateTimePropertyScribe<T extends DateTimeProperty>
extends ICalPropertyScribe<T> {
    public DateTimePropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName, ICalDataType.DATE_TIME);
    }

    @Override
    protected String _writeText(T property) {
        Date value = (Date)((ValuedProperty)property).getValue();
        if (value != null) {
            return DateTimePropertyScribe.date(value).write();
        }
        return "";
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        value = DateTimePropertyScribe.unescape(value);
        return this.parse(value, parameters, warnings);
    }

    @Override
    protected void _writeXml(T property, XCalElement element) {
        String dateStr = null;
        Date value = (Date)((ValuedProperty)property).getValue();
        if (value != null) {
            dateStr = DateTimePropertyScribe.date(value).extended(true).write();
        }
        element.append(this.dataType(property), dateStr);
    }

    @Override
    protected T _parseXml(XCalElement element, ICalParameters parameters, List<Warning> warnings) {
        String value = element.first(this.defaultDataType);
        if (value != null) {
            return this.parse(value, parameters, warnings);
        }
        throw DateTimePropertyScribe.missingXmlElements(this.defaultDataType);
    }

    @Override
    protected JCalValue _writeJson(T property) {
        Date value = (Date)((ValuedProperty)property).getValue();
        if (value != null) {
            return JCalValue.single(DateTimePropertyScribe.date(value).extended(true).write());
        }
        return JCalValue.single("");
    }

    @Override
    protected T _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, List<Warning> warnings) {
        String valueStr = value.asSingle();
        return this.parse(valueStr, parameters, warnings);
    }

    private T parse(String value, ICalParameters parameters, List<Warning> warnings) {
        try {
            Date date = DateTimePropertyScribe.date(value).tzid(parameters.getTimezoneId(), warnings).parse();
            return this.newInstance(date);
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException(17, new Object[0]);
        }
    }

    protected abstract T newInstance(Date var1);
}

