/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.extension.ConflictStatistics;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.extension.MacPropagation;
import org.cpsolver.ifs.extension.ViolatedInitials;
import org.cpsolver.ifs.heuristics.ValueSelection;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.heuristics.AssignmentCheck;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;

public class EnrollmentSelection
implements ValueSelection<Request, Enrollment> {
    private double iRandomWalkProb = 0.0;
    private double iInitialSelectionProb = 0.0;
    private double iGoodSelectionProb = 0.0;
    private int iMPPLimit = -1;
    private double iWeightDeltaInitialAssignment = 0.0;
    private double iWeightPotentialConflicts = 0.0;
    private double iWeightWeightedCoflicts = 0.0;
    private double iWeightCoflicts = 1.0;
    private double iWeightValue = 0.0;
    protected int iTabuSize = 0;
    protected List<Enrollment> iTabu = null;
    protected int iTabuPos = 0;
    private boolean iMPP = false;
    private ConflictStatistics<Request, Enrollment> iStat = null;
    private MacPropagation<Request, Enrollment> iProp = null;
    private ViolatedInitials<Request, Enrollment> iViolatedInitials = null;

    public EnrollmentSelection() {
    }

    public EnrollmentSelection(DataProperties properties) {
        this.iMPP = properties.getPropertyBoolean("General.MPP", false);
        if (this.iMPP) {
            this.iMPPLimit = properties.getPropertyInt("Value.MPPLimit", -1);
            this.iInitialSelectionProb = properties.getPropertyDouble("Value.InitialSelectionProb", 0.75);
            this.iWeightDeltaInitialAssignment = properties.getPropertyDouble("Value.WeightDeltaInitialAssignments", 0.0);
        }
        this.iGoodSelectionProb = properties.getPropertyDouble("Value.GoodSelectionProb", 0.0);
        this.iWeightWeightedCoflicts = properties.getPropertyDouble("Value.WeightWeightedConflicts", 0.0);
        this.iWeightPotentialConflicts = properties.getPropertyDouble("Value.WeightPotentialConflicts", 0.0);
        this.iRandomWalkProb = properties.getPropertyDouble("Value.RandomWalkProb", 0.0);
        this.iWeightCoflicts = properties.getPropertyDouble("Value.WeightConflicts", 1.0);
        this.iWeightValue = properties.getPropertyDouble("Value.WeightValue", 0.0);
        this.iTabuSize = properties.getPropertyInt("Value.Tabu", 0);
        if (this.iTabuSize > 0) {
            this.iTabu = new ArrayList<Enrollment>(this.iTabuSize);
        }
    }

    public void init(Solver<Request, Enrollment> solver) {
        for (Extension extension : solver.getExtensions()) {
            if (ConflictStatistics.class.isInstance(extension)) {
                this.iStat = (ConflictStatistics)extension;
            }
            if (MacPropagation.class.isInstance(extension)) {
                this.iProp = (MacPropagation)extension;
            }
            if (!ViolatedInitials.class.isInstance(extension)) continue;
            this.iViolatedInitials = (ViolatedInitials)extension;
        }
    }

    public boolean isAllowed(Assignment<Request, Enrollment> assignment, Enrollment value, AssignmentCheck<Request, Enrollment> test) {
        return this.isAllowed(assignment, value, null, test);
    }

    public boolean isAllowed(Assignment<Request, Enrollment> assignment, Enrollment value, Set<Enrollment> conflicts, AssignmentCheck<Request, Enrollment> test) {
        if (value == null) {
            return true;
        }
        StudentSectioningModel model = (StudentSectioningModel)((Request)value.variable()).getModel();
        if (model.getNrLastLikeRequests(false) == 0 || model.getNrRealRequests(false) == 0) {
            if (test != null) {
                if (conflicts == null) {
                    conflicts = ((Request)value.variable()).getModel().conflictValues(assignment, (Value)value);
                }
                for (Enrollment conflict : conflicts) {
                    if (test.canUnassign(value, conflict, assignment)) continue;
                    return false;
                }
            }
            return true;
        }
        Request request = (Request)value.variable();
        if (request.getStudent().isDummy()) {
            if (conflicts == null) {
                conflicts = ((Request)value.variable()).getModel().conflictValues(assignment, (Value)value);
            }
            for (Enrollment conflict : conflicts) {
                if (!conflict.getRequest().getStudent().isDummy()) {
                    return false;
                }
                if (test == null || test.canUnassign(value, conflict, assignment)) continue;
                return false;
            }
        } else {
            if (conflicts == null) {
                conflicts = ((Request)value.variable()).getModel().conflictValues(assignment, (Value)value);
            }
            if (test == null) {
                if (conflicts.size() > (assignment.getValue((Variable)request) == null ? 1 : 0)) {
                    return false;
                }
            } else {
                for (Enrollment conflict : conflicts) {
                    if (test.canUnassign(value, conflict, assignment)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Enrollment selectValue(Solution<Request, Enrollment> solution, Request selectedVariable) {
        return this.selectValue(solution, selectedVariable, null);
    }

    public Enrollment selectValue(Solution<Request, Enrollment> solution, Request selectedVariable, AssignmentCheck<Request, Enrollment> test) {
        Enrollment selectedValue;
        Set goodValues;
        Enrollment value;
        Assignment assignment = solution.getAssignment();
        if (this.iMPP && selectedVariable.getInitialAssignment() != null) {
            if (solution.getModel().unassignedVariables(assignment).isEmpty() && solution.getModel().perturbVariables(assignment).size() <= this.iMPPLimit) {
                this.iMPPLimit = solution.getModel().perturbVariables(assignment).size() - 1;
            }
            if (this.iMPPLimit >= 0 && solution.getModel().perturbVariables(assignment).size() > this.iMPPLimit && this.isAllowed((Assignment<Request, Enrollment>)assignment, (Enrollment)selectedVariable.getInitialAssignment(), test)) {
                return (Enrollment)selectedVariable.getInitialAssignment();
            }
            if (selectedVariable.getInitialAssignment() != null && ToolBox.random() <= this.iInitialSelectionProb && this.isAllowed((Assignment<Request, Enrollment>)assignment, (Enrollment)selectedVariable.getInitialAssignment(), test)) {
                return (Enrollment)selectedVariable.getInitialAssignment();
            }
        }
        List<Enrollment> values = selectedVariable.values((Assignment<Request, Enrollment>)assignment);
        if (ToolBox.random() <= this.iRandomWalkProb && this.isAllowed((Assignment<Request, Enrollment>)assignment, value = (Enrollment)((Object)ToolBox.random(values)), test)) {
            return value;
        }
        if (this.iProp != null && assignment.getValue((Variable)selectedVariable) == null && ToolBox.random() <= this.iGoodSelectionProb && !(goodValues = this.iProp.goodValues(assignment, (Variable)selectedVariable)).isEmpty()) {
            values = new ArrayList<Enrollment>(goodValues);
        }
        if (values.size() == 1) {
            value = values.get(0);
            if (this.isAllowed((Assignment<Request, Enrollment>)assignment, value, test)) {
                return value;
            }
            return null;
        }
        ArrayList<Enrollment> bestValues = null;
        double bestWeightedSum = 0.0;
        for (Enrollment value2 : values) {
            Set conf;
            if (this.iTabu != null && this.iTabu.contains((Object)value2) || assignment.getValue((Variable)selectedVariable) != null && ((Enrollment)assignment.getValue((Variable)selectedVariable)).equals((Object)value2) || (conf = solution.getModel().conflictValues(assignment, (Value)value2)).contains((Object)value2) || !this.isAllowed((Assignment<Request, Enrollment>)assignment, value2, conf, test)) continue;
            double weightedConflicts = this.iStat == null || this.iWeightWeightedCoflicts == 0.0 ? 0.0 : this.iStat.countRemovals(solution.getIteration(), (Collection)conf, (Value)value2);
            double potentialConflicts = this.iStat == null || this.iWeightPotentialConflicts == 0.0 ? 0.0 : (double)this.iStat.countPotentialConflicts(assignment, solution.getIteration(), (Value)value2, 3);
            long deltaInitialAssignments = 0L;
            if (this.iMPP && this.iWeightDeltaInitialAssignment != 0.0) {
                Object violations;
                if (this.iViolatedInitials != null && (violations = this.iViolatedInitials.getViolatedInitials((Value)value2)) != null) {
                    Iterator iterator = violations.iterator();
                    while (iterator.hasNext()) {
                        Object aValue = (Enrollment)((Object)iterator.next());
                        if (assignment.getValue(aValue.variable()) != null && !((Enrollment)assignment.getValue(aValue.variable())).equals(aValue)) continue;
                        deltaInitialAssignments += 2L;
                    }
                }
                violations = conf.iterator();
                while (violations.hasNext()) {
                    Enrollment aValue = (Enrollment)((Object)violations.next());
                    if (((Request)aValue.variable()).getInitialAssignment() == null) continue;
                    --deltaInitialAssignments;
                }
                if (selectedVariable.getInitialAssignment() != null && !((Enrollment)selectedVariable.getInitialAssignment()).equals((Object)value2)) {
                    ++deltaInitialAssignments;
                }
                if (this.iMPPLimit >= 0 && (long)solution.getModel().perturbVariables(assignment).size() + deltaInitialAssignments > (long)this.iMPPLimit) continue;
            }
            double val = value2.toDouble((Assignment<Request, Enrollment>)assignment);
            for (Enrollment c : conf) {
                val -= c.toDouble((Assignment<Request, Enrollment>)assignment);
            }
            double weightedSum = this.iWeightDeltaInitialAssignment * (double)deltaInitialAssignments + this.iWeightPotentialConflicts * potentialConflicts + this.iWeightWeightedCoflicts * weightedConflicts + this.iWeightCoflicts * (double)conf.size() + this.iWeightValue * val;
            if (bestValues == null || bestWeightedSum > weightedSum) {
                bestWeightedSum = weightedSum;
                if (bestValues == null) {
                    bestValues = new ArrayList<Enrollment>();
                } else {
                    bestValues.clear();
                }
                bestValues.add(value2);
                continue;
            }
            if (bestWeightedSum != weightedSum) continue;
            bestValues.add(value2);
        }
        Enrollment enrollment = selectedValue = bestValues == null ? null : (Enrollment)((Object)ToolBox.random(bestValues));
        if (selectedValue == null) {
            selectedValue = (Enrollment)((Object)ToolBox.random(values));
        }
        if (this.iTabu != null) {
            if (this.iTabu.size() == this.iTabuPos) {
                this.iTabu.add(selectedValue);
            } else {
                this.iTabu.set(this.iTabuPos, selectedValue);
            }
            this.iTabuPos = (this.iTabuPos + 1) % this.iTabuSize;
        }
        return bestValues == null ? null : selectedValue;
    }
}

