/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett;

import java.io.File;
import org.cpsolver.coursett.TimetableXMLLoader;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class DomainChart {
    protected int iSizeX = 60;
    protected int iSizeY = 100;
    protected TimetableModel iModel;
    protected Assignment<Lecture, Placement> iAssignment;
    protected double[][] iTable = null;
    protected boolean iShowZero = false;
    protected String iName = null;
    protected String[] iHeader = null;
    protected String[] iTitle = null;

    public DomainChart(String name, TimetableModel model, int sizeX, int sizeY) {
        this.iModel = model;
        this.iAssignment = new DefaultSingleAssignment();
        this.iName = name;
        this.iSizeX = sizeX;
        this.iSizeY = sizeY;
    }

    public DomainChart(File xmlFile, int sizeX, int sizeY) throws Exception {
        this(xmlFile.getName().substring(0, xmlFile.getName().lastIndexOf(46)), new TimetableModel(new DataProperties()), sizeX, sizeY);
        TimetableXMLLoader loader = new TimetableXMLLoader(this.iModel, this.iAssignment);
        loader.setInputFile(xmlFile);
        loader.load();
    }

    protected void clearTable() {
        int i;
        this.iTable = new double[2 + this.iSizeX][2 + this.iSizeY];
        for (i = 0; i < this.iTable.length; ++i) {
            for (int j = 0; j < this.iTable[i].length; ++j) {
                this.iTable[i][j] = 0.0;
            }
        }
        this.iHeader = new String[this.iSizeX + 2];
        for (i = 0; i <= this.iSizeX; ++i) {
            this.iHeader[i] = String.valueOf(i);
        }
        this.iHeader[this.iSizeX + 1] = this.iSizeX + 1 + "+";
        this.iTitle = new String[this.iSizeY + 2];
        for (i = 0; i <= this.iSizeY; ++i) {
            this.iTitle[i] = String.valueOf(i);
        }
        this.iTitle[this.iSizeY + 1] = this.iSizeY + 1 + "+";
    }

    protected void add(int x, int y, double val) {
        double[] dArray = this.iTable[x <= this.iSizeX ? x : 1 + this.iSizeX];
        int n = y <= this.iSizeY ? y : 1 + this.iSizeY;
        dArray[n] = dArray[n] + val;
    }

    protected void computeTable() {
        this.clearTable();
        for (Lecture lecture : this.iModel.variables()) {
            if (lecture.getNrRooms() > 1) {
                this.add(lecture.nrTimeLocations(), (int)Math.round(Math.pow(lecture.nrRoomLocations(), 1.0 / (double)lecture.getNrRooms())), 1.0);
                continue;
            }
            this.add(lecture.nrTimeLocations(), lecture.nrRoomLocations(), 1.0);
        }
    }

    public CSVFile createTable() {
        int y;
        int i;
        this.computeTable();
        CSVFile csv = new CSVFile();
        CSVFile.CSVField[] header = new CSVFile.CSVField[2 + this.iSizeX + (this.iShowZero ? 1 : 0)];
        header[0] = new CSVFile.CSVField((Object)this.iName);
        int n = i = this.iShowZero ? 0 : 1;
        while (i <= this.iSizeX + 1) {
            header[(this.iShowZero ? 1 : 0) + i] = new CSVFile.CSVField((Object)this.iHeader[i]);
            ++i;
        }
        csv.setHeader(header);
        int n2 = y = this.iShowZero ? 0 : 1;
        while (y <= 1 + this.iSizeY) {
            int x;
            CSVFile.CSVField[] line = new CSVFile.CSVField[2 + this.iSizeX + (this.iShowZero ? 1 : 0)];
            line[0] = new CSVFile.CSVField((Object)this.iTitle[y]);
            if (y == 1 + this.iSizeY) {
                line[0] = new CSVFile.CSVField((Object)(1 + this.iSizeY + "+"));
            }
            int n3 = x = this.iShowZero ? 0 : 1;
            while (x <= 1 + this.iSizeX) {
                line[(this.iShowZero ? 1 : 0) + x] = new CSVFile.CSVField(this.iTable[x][y]);
                ++x;
            }
            csv.addLine(line);
            ++y;
        }
        return csv;
    }

    public static void main(String[] args) {
        try {
            ToolBox.configureLogging();
            File input = new File(args[0]);
            int sizeX = Integer.parseInt(args[1]);
            int sizeY = Integer.parseInt(args[2]);
            File output = null;
            if (args.length > 3) {
                output = new File(args[3]);
                if (output.exists() && output.isDirectory()) {
                    output = new File(output, input.getName().substring(0, input.getName().lastIndexOf(46)) + "_domain.csv");
                }
            } else {
                output = new File(input.getParentFile(), input.getName().substring(0, input.getName().lastIndexOf(46)) + "_domain.csv");
            }
            new DomainChart(input, sizeX, sizeY).createTable().save(output);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

