/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.split;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.criteria.StudentBackToBackConflicts;
import org.cpsolver.exam.criteria.StudentDirectConflicts;
import org.cpsolver.exam.criteria.StudentMoreThan2ADayConflicts;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;

public class ExamSplitter
extends ExamCriterion {
    private long iLastSplitId = 0L;
    private Map<Exam, List<Exam>> iChildren = new HashMap<Exam, List<Exam>>();
    private Map<Exam, Exam> iParent = new HashMap<Exam, Exam>();
    private Criterion<Exam, ExamPlacement> iStudentDirectConflicts;
    private Criterion<Exam, ExamPlacement> iStudentMoreThan2ADayConflicts;
    private Criterion<Exam, ExamPlacement> iStudentBackToBackConflicts;
    private double iValue = 0.0;
    private Map<Exam, List<ExamPlacement>> iBestSplit = null;

    public ExamSplitter() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.NoUpdate);
    }

    public boolean init(Solver<Exam, ExamPlacement> solver) {
        boolean ret = super.init(solver);
        this.iStudentDirectConflicts = solver.currentSolution().getModel().getCriterion(StudentDirectConflicts.class);
        this.iStudentMoreThan2ADayConflicts = solver.currentSolution().getModel().getCriterion(StudentMoreThan2ADayConflicts.class);
        this.iStudentBackToBackConflicts = solver.currentSolution().getModel().getCriterion(StudentBackToBackConflicts.class);
        return ret;
    }

    @Override
    public String getWeightName() {
        return "Exams.ExamSplitWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "examSplitWeight";
    }

    public double getWeightDefault(DataProperties config) {
        return this.iStudentDirectConflicts != null ? this.iStudentDirectConflicts.getWeight() / 2.0 : 500.0;
    }

    private boolean isDayBreakBackToBack() {
        return ((StudentBackToBackConflicts)this.iStudentBackToBackConflicts).isDayBreakBackToBack();
    }

    public boolean canSplit(Exam exam) {
        return !this.iParent.containsKey((Object)exam);
    }

    public Exam parent(Exam exam) {
        return this.iParent.containsKey((Object)exam) ? this.iParent.get((Object)exam) : exam;
    }

    public List<Exam> children(Exam parent) {
        return this.iChildren.get((Object)parent);
    }

    public Exam split(Assignment<Exam, ExamPlacement> assignment, Exam parent, long iteration, ExamPlacement placement) {
        if (!this.canSplit(parent)) {
            return null;
        }
        Exam child = new Exam(--this.iLastSplitId, parent.getName(), parent.getLength(), parent.hasAltSeating(), parent.getMaxRooms(), parent.getMinSize(), parent.getPeriodPlacements(), parent.getRoomPlacements());
        child.setSizeOverride(parent.getSizeOverride());
        child.setPrintOffset(parent.getPrintOffset());
        child.setAveragePeriod(parent.getAveragePeriod());
        child.getOwners().addAll(parent.getOwners());
        this.iParent.put(child, parent);
        List<Exam> children = this.iChildren.get((Object)parent);
        if (children == null) {
            children = new ArrayList<Exam>();
            this.iChildren.put(parent, children);
        }
        children.add(child);
        this.iValue += 1.0;
        parent.getModel().addVariable((Variable)child);
        for (ExamRoomPlacement room : child.getRoomPlacements()) {
            room.getRoom().addVariable(child);
        }
        if (placement != null) {
            assignment.assign(iteration, (Value)new ExamPlacement(child, placement.getPeriodPlacement(), placement.getRoomPlacements()));
        }
        this.shuffle(assignment, parent, iteration);
        return child;
    }

    public boolean canMerge(Exam exam) {
        return this.iParent.containsKey((Object)exam);
    }

    public Exam merge(Assignment<Exam, ExamPlacement> assignment, Exam child, long iteration) {
        if (!this.canMerge(child)) {
            return null;
        }
        Exam parent = this.iParent.get((Object)child);
        this.iParent.remove((Object)child);
        List<Exam> children = this.iChildren.get((Object)parent);
        children.remove((Object)child);
        this.iValue -= 1.0;
        ExamPlacement parentPlacement = (ExamPlacement)assignment.getValue((Variable)parent);
        if (parentPlacement != null) {
            assignment.unassign(iteration, (Variable)parent);
        }
        if (assignment.getValue((Variable)child) != null) {
            assignment.unassign(iteration, (Variable)child);
        }
        for (ExamStudent student : new ArrayList<ExamStudent>(child.getStudents())) {
            student.removeVariable(child);
            student.addVariable(parent);
        }
        for (ExamRoomPlacement room : child.getRoomPlacements()) {
            room.getRoom().removeVariable(child);
        }
        parent.getModel().removeVariable((Variable)child);
        if (parentPlacement != null) {
            assignment.assign(iteration, (Value)parentPlacement);
        }
        this.shuffle(assignment, parent, iteration);
        return parent;
    }

    public double delta(Assignment<Exam, ExamPlacement> assignment, ExamStudent student, ExamPlacement oldPlacement, ExamPlacement newPlacement) {
        Set<Exam> examsInADay;
        Set<Exam> examsNextPeriod;
        ExamPeriod next;
        Set<Exam> examsPrevPeriod;
        ExamPeriod prev;
        Set<Exam> examsThisPeriod;
        ExamPeriod period;
        Exam exam;
        double delta = 0.0;
        if (oldPlacement != null) {
            exam = (Exam)oldPlacement.variable();
            period = oldPlacement.getPeriod();
            examsThisPeriod = student.getExams(assignment, period);
            if (examsThisPeriod.size() > (examsThisPeriod.contains((Object)exam) ? 1 : 0)) {
                delta -= this.iStudentDirectConflicts.getWeight();
            }
            if ((prev = period.prev()) != null && (prev.getDay() == period.getDay() || this.isDayBreakBackToBack()) && (examsPrevPeriod = student.getExams(assignment, prev)).size() > (examsPrevPeriod.contains((Object)exam) ? 1 : 0)) {
                delta -= this.iStudentBackToBackConflicts.getWeight();
            }
            if ((next = period.next()) != null && (next.getDay() == period.getDay() || this.isDayBreakBackToBack()) && (examsNextPeriod = student.getExams(assignment, next)).size() > (examsNextPeriod.contains((Object)exam) ? 1 : 0)) {
                delta -= this.iStudentBackToBackConflicts.getWeight();
            }
            if ((examsInADay = student.getExamsADay(assignment, period)).size() > (examsInADay.contains((Object)exam) ? 3 : 2)) {
                delta -= this.iStudentMoreThan2ADayConflicts.getWeight();
            }
        }
        if (newPlacement != null) {
            exam = (Exam)newPlacement.variable();
            period = newPlacement.getPeriod();
            examsThisPeriod = student.getExams(assignment, period);
            if (examsThisPeriod.size() > (examsThisPeriod.contains((Object)exam) ? 1 : 0)) {
                delta += this.iStudentDirectConflicts.getWeight();
            }
            if ((prev = period.prev()) != null && (prev.getDay() == period.getDay() || this.isDayBreakBackToBack()) && (examsPrevPeriod = student.getExams(assignment, prev)).size() > (examsPrevPeriod.contains((Object)exam) ? 1 : 0)) {
                delta += this.iStudentBackToBackConflicts.getWeight();
            }
            if ((next = period.next()) != null && (next.getDay() == period.getDay() || this.isDayBreakBackToBack()) && (examsNextPeriod = student.getExams(assignment, next)).size() > (examsNextPeriod.contains((Object)exam) ? 1 : 0)) {
                delta += this.iStudentBackToBackConflicts.getWeight();
            }
            if ((examsInADay = student.getExamsADay(assignment, period)).size() > (examsInADay.contains((Object)exam) ? 3 : 2)) {
                delta += this.iStudentMoreThan2ADayConflicts.getWeight();
            }
        }
        return delta;
    }

    /*
     * WARNING - void declaration
     */
    public void shuffle(Assignment<Exam, ExamPlacement> assignment, Exam exam, long iteration) {
        Exam parent = this.iParent.containsKey((Object)exam) ? this.iParent.get((Object)exam) : exam;
        List<Exam> children = this.iChildren.get((Object)parent);
        if (children != null && !children.isEmpty()) {
            HashMap<Exam, Value> assignments = new HashMap<Exam, Value>();
            if (assignment.getValue((Variable)parent) != null) {
                assignments.put(parent, assignment.getValue((Variable)parent));
                assignment.unassign(iteration, (Variable)parent);
            }
            for (Exam child : children) {
                if (assignment.getValue((Variable)child) == null) continue;
                assignments.put(child, assignment.getValue((Variable)child));
                assignment.unassign(iteration, (Variable)child);
            }
            for (ExamStudent student : new ArrayList<ExamStudent>(parent.getStudents())) {
                void var10_9;
                Object var10_10 = null;
                double delta = 0.0;
                for (Exam x : children) {
                    double d = this.delta(assignment, student, (ExamPlacement)((Object)assignments.get((Object)parent)), (ExamPlacement)((Object)assignments.get((Object)x)));
                    if (var10_9 != null && !(d < delta)) continue;
                    delta = d;
                    Exam exam2 = x;
                }
                if (var10_9 == null || !(delta < 0.0)) continue;
                student.removeVariable(parent);
                student.addVariable((Variable)var10_9);
            }
            for (Exam child : children) {
                for (ExamStudent student : new ArrayList<ExamStudent>(child.getStudents())) {
                    Exam other = parent;
                    double delta = this.delta(assignment, student, (ExamPlacement)((Object)assignments.get((Object)child)), (ExamPlacement)((Object)assignments.get((Object)parent)));
                    for (Exam x : children) {
                        double d;
                        if (x.equals((Object)child) || !((d = this.delta(assignment, student, (ExamPlacement)((Object)assignments.get((Object)child)), (ExamPlacement)((Object)assignments.get((Object)x)))) < delta)) continue;
                        delta = d;
                        other = x;
                    }
                    if (other == null || !(delta < 0.0)) continue;
                    student.removeVariable(child);
                    student.addVariable(other);
                }
            }
            ExamPlacement parentPlacement = (ExamPlacement)((Object)assignments.get((Object)parent));
            if (parentPlacement != null) {
                assignment.assign(iteration, (Value)parentPlacement);
            }
            for (Exam exam3 : children) {
                ExamPlacement placement = (ExamPlacement)((Object)assignments.get((Object)exam3));
                if (placement == null) continue;
                assignment.assign(iteration, (Value)placement);
            }
        }
    }

    public double getValue(Assignment<Exam, ExamPlacement> assignment) {
        return this.iValue;
    }

    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        return 0.0;
    }

    @Override
    public double[] getBounds(Assignment<Exam, ExamPlacement> assignment, Collection<Exam> exams) {
        return new double[]{0.0, 0.0};
    }

    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return "XX:" + sDoubleFormat.format(this.getValue(assignment));
    }

    @Override
    public void getInfo(Assignment<Exam, ExamPlacement> assignment, Map<String, String> info) {
        if (!this.iChildren.isEmpty()) {
            int parents = 0;
            String split = "";
            for (Exam parent : new TreeSet<Exam>(this.iChildren.keySet())) {
                List<Exam> children = this.iChildren.get((Object)parent);
                if (children.isEmpty()) continue;
                split = split + "\n  ";
                ++parents;
                split = split + parent.getName() + ": " + parent.getStudents().size() + " (" + (assignment.getValue((Variable)parent) == null ? "N/A" : ((ExamPlacement)assignment.getValue((Variable)parent)).getPeriod()) + ")";
                for (Exam child : children) {
                    split = split + " + " + child.getStudents().size() + " (" + (assignment.getValue((Variable)child) == null ? "N/A" : ((ExamPlacement)assignment.getValue((Variable)child)).getPeriod()) + ")";
                }
            }
            if (parents > 0) {
                info.put("Examination Splits", parents + split);
            }
        }
    }

    public void bestSaved(Assignment<Exam, ExamPlacement> assignment) {
        super.bestSaved(assignment);
        if (this.iBestSplit == null) {
            this.iBestSplit = new Hashtable<Exam, List<ExamPlacement>>();
        } else {
            this.iBestSplit.clear();
        }
        for (Map.Entry<Exam, List<Exam>> entry : this.iChildren.entrySet()) {
            Exam parent = entry.getKey();
            ArrayList<Value> placements = new ArrayList<Value>();
            for (Exam child : entry.getValue()) {
                if (assignment.getValue((Variable)child) == null) continue;
                placements.add(assignment.getValue((Variable)child));
            }
            if (placements.isEmpty()) continue;
            this.iBestSplit.put(parent, placements);
        }
    }

    public void bestRestored(Assignment<Exam, ExamPlacement> assignment) {
        super.bestRestored(assignment);
        for (Exam parent : new ArrayList<Exam>(this.iChildren.keySet())) {
            int i;
            ArrayList children = new ArrayList(this.iChildren.get((Object)parent));
            List<ExamPlacement> placements = this.iBestSplit.get((Object)parent);
            int n = i = placements == null ? 0 : placements.size();
            while (i < children.size()) {
                this.merge(assignment, (Exam)((Object)children.get(i)), 0L);
                ++i;
            }
        }
        this.iValue = 0.0;
        for (Exam parent : this.iBestSplit.keySet()) {
            List<ExamPlacement> placements = this.iBestSplit.get((Object)parent);
            for (int i = 0; i < placements.size(); ++i) {
                List<Exam> children = this.iChildren.get((Object)parent);
                if (children == null || children.size() <= i) {
                    this.split(assignment, parent, 0L, placements.get(i));
                    continue;
                }
                assignment.assign(0L, (Value)new ExamPlacement(children.get(i), placements.get(i).getPeriodPlacement(), placements.get(i).getRoomPlacements()));
            }
            this.iValue += (double)placements.size();
        }
    }
}

