/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.neighbours;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.DistributionPenalty;
import org.cpsolver.exam.criteria.RoomPenalty;
import org.cpsolver.exam.criteria.RoomSizePenalty;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamDistributionConstraint;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriodPlacement;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoom;
import org.cpsolver.exam.model.ExamRoomPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.LazySwap;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class ExamPeriodSwapMove
implements NeighbourSelection<Exam, ExamPlacement> {
    private boolean iCheckStudentConflicts = false;
    private boolean iCheckDistributionConstraints = true;

    public ExamPeriodSwapMove(DataProperties properties) {
        this.iCheckStudentConflicts = properties.getPropertyBoolean("ExamPeriodSwapMove.CheckStudentConflicts", this.iCheckStudentConflicts);
        this.iCheckDistributionConstraints = properties.getPropertyBoolean("ExamPeriodSwapMove.CheckDistributionConstraints", this.iCheckDistributionConstraints);
    }

    public void init(Solver<Exam, ExamPlacement> solver) {
    }

    public Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        Exam x1;
        ExamModel model = (ExamModel)solution.getModel();
        Assignment assignment = solution.getAssignment();
        ExamPlacement v1 = (ExamPlacement)assignment.getValue((Variable)(x1 = (Exam)((Object)ToolBox.random((Collection)model.variables()))));
        if (v1 == null) {
            return null;
        }
        int x = ToolBox.random((int)model.variables().size());
        for (int v = 0; v < model.variables().size(); ++v) {
            Exam x2 = (Exam)((Object)model.variables().get((v + x) % model.variables().size()));
            ExamPlacement v2 = (ExamPlacement)assignment.getValue((Variable)x2);
            if (x1.equals((Object)x2) || v2 == null) continue;
            ExamPeriodPlacement p1 = x1.getPeriodPlacement(v2.getPeriod());
            ExamPeriodPlacement p2 = x2.getPeriodPlacement(v1.getPeriod());
            if (p1 == null || p2 == null || p1.equals(p2) || this.iCheckStudentConflicts && (x1.countStudentConflicts((Assignment<Exam, ExamPlacement>)assignment, p1) > 0 || x2.countStudentConflicts((Assignment<Exam, ExamPlacement>)assignment, p2) > 0)) continue;
            if (this.iCheckDistributionConstraints) {
                HashMap<Exam, ExamPlacement> placements = new HashMap<Exam, ExamPlacement>();
                placements.put(x1, new ExamPlacement(x1, p1, new HashSet<ExamRoomPlacement>()));
                placements.put(x2, new ExamPlacement(x2, p2, new HashSet<ExamRoomPlacement>()));
                if (!this.checkDistributionConstraints((Assignment<Exam, ExamPlacement>)assignment, x1, p1, placements) || !this.checkDistributionConstraints((Assignment<Exam, ExamPlacement>)assignment, x2, p2, placements)) continue;
            }
            HashSet<ExamPlacement> conflicts = new HashSet<ExamPlacement>();
            conflicts.add(v1);
            conflicts.add(v2);
            HashMap<Exam, ExamPlacement> placements = new HashMap<Exam, ExamPlacement>();
            Set<ExamRoomPlacement> r1 = this.findBestAvailableRooms((Assignment<Exam, ExamPlacement>)assignment, x1, p1, conflicts, placements);
            if (r1 == null) continue;
            placements.put(x1, new ExamPlacement(x1, p1, r1));
            Set<ExamRoomPlacement> r2 = this.findBestAvailableRooms((Assignment<Exam, ExamPlacement>)assignment, x2, p2, conflicts, placements);
            if (r2 == null) continue;
            return new LazySwap((Value)new ExamPlacement(x1, p1, r1), (Value)new ExamPlacement(x2, p2, r2));
        }
        return null;
    }

    public boolean checkDistributionConstraints(Assignment<Exam, ExamPlacement> assignment, Exam exam, ExamPeriodPlacement period, Map<Exam, ExamPlacement> placements) {
        for (ExamDistributionConstraint dc : exam.getDistributionConstraints()) {
            if (!dc.isHard()) continue;
            boolean before = true;
            for (Exam other : dc.variables()) {
                if (other.equals(this)) {
                    before = false;
                    continue;
                }
                ExamPlacement placement = placements.containsKey((Object)other) ? placements.get((Object)other) : (ExamPlacement)assignment.getValue((Variable)other);
                if (placement == null || !(before ? !dc.getDistributionType().isSatisfied(placement.getPeriod(), period.getPeriod()) : !dc.getDistributionType().isSatisfied(period.getPeriod(), placement.getPeriod()))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean checkDistributionConstraints(Assignment<Exam, ExamPlacement> assignment, Exam exam, ExamRoomPlacement room, Set<ExamPlacement> conflictsToIgnore, Map<Exam, ExamPlacement> placements) {
        for (ExamDistributionConstraint dc : exam.getDistributionConstraints()) {
            if (!dc.isHard()) continue;
            for (Exam other : dc.variables()) {
                ExamPlacement placement;
                if (other.equals((Object)exam) || (placement = placements.containsKey((Object)other) ? placements.get((Object)other) : (ExamPlacement)assignment.getValue((Variable)other)) == null || conflictsToIgnore.contains((Object)placement) || dc.getDistributionType().isSatisfied(placement, room)) continue;
                return false;
            }
        }
        return true;
    }

    public int getDistributionConstraintPenalty(Assignment<Exam, ExamPlacement> assignment, Exam exam, ExamRoomPlacement room, Set<ExamPlacement> conflictsToIgnore, Map<Exam, ExamPlacement> placements) {
        int penalty = 0;
        for (ExamDistributionConstraint dc : exam.getDistributionConstraints()) {
            if (dc.isHard()) continue;
            for (Exam other : dc.variables()) {
                ExamPlacement placement;
                if (other.equals(this) || (placement = placements.containsKey((Object)other) ? placements.get((Object)other) : (ExamPlacement)assignment.getValue((Variable)other)) == null || conflictsToIgnore.contains((Object)placement) || dc.getDistributionType().isSatisfied(placement, room)) continue;
                penalty += dc.getWeight();
            }
        }
        return penalty;
    }

    public Set<ExamRoomPlacement> findBestAvailableRooms(Assignment<Exam, ExamPlacement> assignment, Exam exam, ExamPeriodPlacement period, Set<ExamPlacement> conflictsToIgnore, Map<Exam, ExamPlacement> placements) {
        if (exam.getMaxRooms() == 0) {
            return new HashSet<ExamRoomPlacement>();
        }
        double sw = exam.getModel().getCriterion(RoomSizePenalty.class).getWeight();
        double pw = exam.getModel().getCriterion(RoomPenalty.class).getWeight();
        double cw = exam.getModel().getCriterion(DistributionPenalty.class).getWeight();
        block0: for (int nrRooms = 1; nrRooms <= exam.getMaxRooms(); ++nrRooms) {
            int size;
            int bestSize;
            HashSet<ExamRoomPlacement> rooms = new HashSet<ExamRoomPlacement>();
            for (size = 0; rooms.size() < nrRooms && size < exam.getSize(); size += bestSize) {
                int minSize = (exam.getSize() - size) / (nrRooms - rooms.size());
                ExamRoomPlacement best = null;
                double bestWeight = 0.0;
                bestSize = 0;
                for (ExamRoomPlacement room : exam.getRoomPlacements()) {
                    if (!room.isAvailable(period.getPeriod()) || rooms.contains(room) || !ExamRoom.checkParents(rooms, room)) continue;
                    HashSet<ExamPlacement> conflicts = new HashSet<ExamPlacement>(conflictsToIgnore);
                    room.getRoom().computeConflicts(assignment, exam, period.getPeriod(), conflicts);
                    if (conflicts.size() > conflictsToIgnore.size() || this.iCheckDistributionConstraints && !this.checkDistributionConstraints(assignment, exam, room, conflictsToIgnore, placements)) continue;
                    int s = room.getSize(exam.hasAltSeating());
                    if (s < minSize) break;
                    int p = room.getPenalty(period.getPeriod());
                    double w = pw * (double)p + sw * (double)(s - minSize) + cw * (double)this.getDistributionConstraintPenalty(assignment, exam, room, conflictsToIgnore, placements);
                    double d = 0.0;
                    if (!rooms.isEmpty()) {
                        for (ExamRoomPlacement r : rooms) {
                            d += r.getDistanceInMeters(room);
                        }
                        w += d / (double)rooms.size();
                    }
                    if (best != null && !(bestWeight > w)) continue;
                    best = room;
                    bestSize = s;
                    bestWeight = w;
                }
                if (best == null) continue block0;
                rooms.add(best);
            }
            if (size < exam.getSize()) continue;
            return rooms;
        }
        return null;
    }
}

