/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.neighbourhoods;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.algorithms.neighbourhoods.RandomSwapMove;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.SimpleNeighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.ToolBox;

public class TimeSwap
extends RandomSwapMove<Lecture, Placement> {
    public TimeSwap(DataProperties config) {
        super(config);
    }

    @Override
    public void init(Solver<Lecture, Placement> solver) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Neighbour<Lecture, Placement> selectNeighbour(Solution<Lecture, Placement> solution) {
        TimetableModel model = (TimetableModel)solution.getModel();
        Assignment<Lecture, Placement> assignment = solution.getAssignment();
        double total = model.getTotalValue(assignment);
        int varIdx = ToolBox.random(model.variables().size());
        block5: for (int i = 0; i < model.variables().size(); ++i) {
            List<TimeLocation> values;
            Lecture lecture = (Lecture)model.variables().get((i + varIdx) % model.variables().size());
            Placement old = lecture.getAssignment(assignment);
            if (old == null || (values = lecture.timeLocations()).isEmpty()) continue;
            Lock lock = solution.getLock().writeLock();
            lock.lock();
            try {
                int attempts = 0;
                long startTime = JProf.currentTimeMillis();
                int valIdx = ToolBox.random(values.size());
                for (int j = 0; j < values.size(); ++j) {
                    Set<Placement> conflicts;
                    TimeLocation time = values.get((j + valIdx) % values.size());
                    if (time.getPreference() > 50 || time.equals(old.getTimeLocation())) continue;
                    Placement placement = null;
                    placement = lecture.getNrRooms() == 0 ? new Placement(lecture, time, (RoomLocation)null) : (lecture.getNrRooms() == 1 ? new Placement(lecture, time, old.getRoomLocation()) : new Placement(lecture, time, old.getRoomLocations()));
                    if (!placement.isValid() || (conflicts = model.conflictValues(assignment, placement)).contains(placement)) continue;
                    if (conflicts.isEmpty()) {
                        SimpleNeighbour<Lecture, Placement> n = new SimpleNeighbour<Lecture, Placement>(lecture, placement);
                        if (this.iHC && !(n.value(assignment) <= 0.0)) continue;
                        SimpleNeighbour<Lecture, Placement> simpleNeighbour = n;
                        return simpleNeighbour;
                    }
                    HashMap<Lecture, Placement> assignments = new HashMap<Lecture, Placement>();
                    assignments.put(lecture, placement);
                    for (Placement conflict : conflicts) {
                        assignment.unassign(solution.getIteration(), (Lecture)conflict.variable());
                    }
                    assignment.assign(solution.getIteration(), placement);
                    Double v = this.resolve(solution, total, startTime, (Map<Lecture, Placement>)assignments, (List<Placement>)new ArrayList<Placement>(conflicts), 0);
                    if (!conflicts.isEmpty()) {
                        ++attempts;
                    }
                    assignment.unassign(solution.getIteration(), lecture);
                    for (Placement conflict : conflicts) {
                        assignment.assign(solution.getIteration(), conflict);
                    }
                    assignment.assign(solution.getIteration(), old);
                    if (v != null) {
                        RandomSwapMove.SwapNeighbour swapNeighbour = new RandomSwapMove.SwapNeighbour(this, assignments.values(), v);
                        return swapNeighbour;
                    }
                    if (attempts < this.iMaxAttempts) continue;
                    continue block5;
                }
                continue;
            }
            finally {
                lock.unlock();
            }
        }
        return null;
    }

    @Override
    public Double resolve(Solution<Lecture, Placement> solution, double total, long startTime, Map<Lecture, Placement> assignments, List<Placement> conflicts, int index) {
        Assignment<Lecture, Placement> assignment = solution.getAssignment();
        if (index == conflicts.size()) {
            return solution.getModel().getTotalValue(assignment) - total;
        }
        Placement conflict = conflicts.get(index);
        Lecture variable = (Lecture)conflict.variable();
        List<TimeLocation> values = variable.timeLocations();
        if (values.isEmpty()) {
            return null;
        }
        int valIdx = ToolBox.random(values.size());
        int attempts = 0;
        for (int i = 0; i < values.size(); ++i) {
            TimeLocation time = values.get((i + valIdx) % values.size());
            if (time.getPreference() > 50 || time.equals(conflict.getTimeLocation())) continue;
            Placement value = null;
            value = variable.getNrRooms() == 0 ? new Placement(variable, time, (RoomLocation)null) : (variable.getNrRooms() == 1 ? new Placement(variable, time, conflict.getRoomLocation()) : new Placement(variable, time, conflict.getRoomLocations()));
            if (!value.isValid() || solution.getModel().inConflict(assignment, value)) continue;
            assignment.assign(solution.getIteration(), value);
            Double v = this.resolve(solution, total, startTime, assignments, conflicts, 1 + index);
            assignment.unassign(solution.getIteration(), variable);
            ++attempts;
            if (v != null && (!this.iHC || v <= 0.0)) {
                assignments.put(variable, value);
                return v;
            }
            if (attempts >= this.iMaxAttempts || this.isTimeLimitReached(startTime)) break;
        }
        return null;
    }
}

