/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.heuristics;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.cpsolver.ifs.util.ToolBox;

public class RouletteWheelSelection<E>
implements Enumeration<E> {
    private List<E> iAdepts = new ArrayList();
    private List<Double> iPoints = new ArrayList<Double>();
    private double iTotalPoints = 0.0;
    private double iUsedPoints = 0.0;
    private int iFirst = 0;

    public void add(E adept, double points) {
        this.iAdepts.add(adept);
        this.iPoints.add(points);
        this.iTotalPoints += points;
    }

    public void addExisting(E adept, double points) {
        int idx = this.iAdepts.indexOf(adept);
        if (idx < 0) {
            this.iAdepts.add(adept);
            this.iPoints.add(points);
        } else {
            this.iPoints.set(idx, this.iPoints.get(idx) + points);
        }
        this.iTotalPoints += points;
    }

    private void swap(int idx1, int idx2) {
        E a1 = this.iAdepts.get(idx1);
        E a2 = this.iAdepts.get(idx2);
        this.iAdepts.set(idx1, a2);
        this.iAdepts.set(idx2, a1);
        Double p1 = this.iPoints.get(idx1);
        Double p2 = this.iPoints.get(idx2);
        this.iPoints.set(idx1, p2);
        this.iPoints.set(idx2, p1);
    }

    @Override
    public boolean hasMoreElements() {
        return this.iFirst < this.iAdepts.size();
    }

    @Override
    public E nextElement() {
        if (!this.hasMoreElements()) {
            return null;
        }
        double rx = ToolBox.random() * this.iTotalPoints;
        int iIdx = this.iFirst;
        rx -= this.iPoints.get(iIdx).doubleValue();
        while (rx > 0.0 && iIdx + 1 < this.iAdepts.size()) {
            rx -= this.iPoints.get(++iIdx).doubleValue();
        }
        E selectedObject = this.iAdepts.get(iIdx);
        double points = this.iPoints.get(iIdx);
        this.iTotalPoints -= points;
        this.iUsedPoints += points;
        this.swap(this.iFirst, iIdx);
        ++this.iFirst;
        return selectedObject;
    }

    public int size() {
        return this.iAdepts.size();
    }

    public double getUsedPoints() {
        return this.iUsedPoints;
    }

    public double getRemainingPoints() {
        return this.iTotalPoints;
    }

    public double getTotalPoints() {
        return this.iTotalPoints + this.iUsedPoints;
    }
}

