/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.reports;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamRoom;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.CSVFile;

public class ExamRoomSchedule {
    ExamModel iModel = null;

    public ExamRoomSchedule(ExamModel model) {
        this.iModel = model;
    }

    public CSVFile report(Assignment<Exam, ExamPlacement> assignment) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField("Room"), new CSVFile.CSVField("Cap"), new CSVFile.CSVField("AltCap"), new CSVFile.CSVField("Period"), new CSVFile.CSVField("Date"), new CSVFile.CSVField("Time"), new CSVFile.CSVField("Exam"), new CSVFile.CSVField("Enrl")});
        ArrayList<ExamRoom> rooms = new ArrayList<ExamRoom>(this.iModel.getRooms());
        Collections.sort(rooms, new Comparator<ExamRoom>(){

            @Override
            public int compare(ExamRoom r1, ExamRoom r2) {
                int cmp = -Double.compare(r1.getSize(), r2.getSize());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = -Double.compare(r1.getAltSize(), r2.getAltSize());
                if (cmp != 0) {
                    return cmp;
                }
                return r1.compareTo(r2);
            }
        });
        for (ExamRoom room : rooms) {
            boolean first = true;
            int day = -1;
            for (ExamPeriod period : this.iModel.getPeriods()) {
                for (ExamPlacement placement : room.getPlacements(assignment, period)) {
                    Exam exam = (Exam)placement.variable();
                    csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(first ? room.getName() : ""), new CSVFile.CSVField(first ? "" + room.getSize() : ""), new CSVFile.CSVField(first ? "" + room.getAltSize() : ""), new CSVFile.CSVField(period.getIndex() + 1), new CSVFile.CSVField(day == period.getDay() ? "" : period.getDayStr()), new CSVFile.CSVField(period.getTimeStr()), new CSVFile.CSVField(exam.getName()), new CSVFile.CSVField(exam.getStudents().size())});
                    first = false;
                    day = period.getDay();
                }
            }
        }
        return csv;
    }
}

