/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.report;

import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.TreeSet;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.report.AbstractStudentSectioningReport;

public class UnbalancedSectionsTable
extends AbstractStudentSectioningReport {
    private static DecimalFormat sDF1 = new DecimalFormat("0.####");
    private static DecimalFormat sDF2 = new DecimalFormat("0.0000");

    public UnbalancedSectionsTable(StudentSectioningModel model) {
        super(model);
    }

    @Override
    public CSVFile createTable(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)"Course"), new CSVFile.CSVField((Object)"Class"), new CSVFile.CSVField((Object)"Meeting Time"), new CSVFile.CSVField((Object)"Enrollment"), new CSVFile.CSVField((Object)"Target"), new CSVFile.CSVField((Object)"Limit"), new CSVFile.CSVField((Object)"Disbalance [%]")});
        TreeSet<Offering> offerings = new TreeSet<Offering>(new Comparator<Offering>(){

            @Override
            public int compare(Offering o1, Offering o2) {
                int cmp = o1.getName().compareToIgnoreCase(o2.getName());
                if (cmp != 0) {
                    return cmp;
                }
                return o1.getId() < o2.getId() ? -1 : (o2.getId() == o2.getId() ? 0 : 1);
            }
        });
        offerings.addAll(this.getModel().getOfferings());
        Offering last = null;
        for (Offering offering : offerings) {
            if (offering.isDummy()) continue;
            for (Config config : offering.getConfigs()) {
                double configEnrl = 0.0;
                for (Enrollment e : config.getEnrollments(assignment)) {
                    if (!this.matches(e.getRequest(), e)) continue;
                    configEnrl += e.getRequest().getWeight();
                }
                for (Subpart subpart : config.getSubparts()) {
                    if (subpart.getSections().size() <= 1) continue;
                    if (subpart.getLimit() > 0) {
                        double ratio = configEnrl / (double)subpart.getLimit();
                        for (Section section : subpart.getSections()) {
                            double enrl = 0.0;
                            for (Enrollment e : section.getEnrollments(assignment)) {
                                if (!this.matches(e.getRequest(), e)) continue;
                                enrl += e.getRequest().getWeight();
                            }
                            double desired = ratio * (double)section.getLimit();
                            if (!(Math.abs(desired - enrl) >= Math.max(1.0, 0.1 * (double)section.getLimit()))) continue;
                            if (last != null && !offering.equals(last)) {
                                csv.addLine();
                            }
                            csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)(offering.equals(last) ? "" : offering.getName())), new CSVFile.CSVField((Object)(section.getSubpart().getName() + " " + section.getName())), new CSVFile.CSVField((Object)(section.getTime() == null ? "" : section.getTime().getDayHeader() + " " + section.getTime().getStartTimeHeader(this.isUseAmPm()) + " - " + section.getTime().getEndTimeHeader(this.isUseAmPm()))), new CSVFile.CSVField((Object)sDF1.format(enrl)), new CSVFile.CSVField((Object)sDF2.format(desired)), new CSVFile.CSVField((Object)sDF1.format(section.getLimit())), new CSVFile.CSVField((Object)sDF2.format(Math.min(1.0, Math.max(-1.0, (enrl - desired) / (double)section.getLimit()))))});
                            last = offering;
                        }
                        continue;
                    }
                    for (Section section : subpart.getSections()) {
                        double enrl = 0.0;
                        for (Enrollment e : section.getEnrollments(assignment)) {
                            if (!this.matches(e.getRequest(), e)) continue;
                            enrl += e.getRequest().getWeight();
                        }
                        double desired = configEnrl / (double)subpart.getSections().size();
                        if (!(Math.abs(desired - enrl) >= Math.max(1.0, 0.1 * desired))) continue;
                        if (last != null && !offering.equals(last)) {
                            csv.addLine();
                        }
                        csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField((Object)(offering.equals(last) ? "" : offering.getName())), new CSVFile.CSVField((Object)(section.getSubpart().getName() + " " + section.getName())), new CSVFile.CSVField((Object)(section.getTime() == null ? "" : section.getTime().getDayHeader() + " " + section.getTime().getStartTimeHeader(this.isUseAmPm()) + " - " + section.getTime().getEndTimeHeader(this.isUseAmPm()))), new CSVFile.CSVField((Object)sDF1.format(enrl)), new CSVFile.CSVField((Object)sDF2.format(desired)), new CSVFile.CSVField((Object)""), new CSVFile.CSVField((Object)sDF2.format(Math.min(1.0, Math.max(-1.0, (enrl - desired) / desired))))});
                        last = offering;
                    }
                }
            }
        }
        return csv;
    }
}

