/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Query;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.report.StudentSectioningReport;
import org.cpsolver.studentsct.reservation.UniversalOverride;

public abstract class AbstractStudentSectioningReport
implements StudentSectioningReport,
StudentSectioningReport.Filter {
    private StudentSectioningModel iModel = null;
    private Query iFilter = null;
    private String iUser = null;
    private Assignment<Request, Enrollment> iAssignment;
    private boolean iIncludeLastLike = false;
    private boolean iIncludeReal = true;
    private boolean iUseAmPm = true;

    public AbstractStudentSectioningReport(StudentSectioningModel model) {
        this.iModel = model;
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    @Override
    public CSVFile create(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        String filter = properties.getProperty("filter");
        if (filter != null && !filter.isEmpty()) {
            this.iFilter = new Query(filter);
        }
        this.iUser = properties.getProperty("user");
        this.iIncludeLastLike = properties.getPropertyBoolean("lastlike", false);
        this.iIncludeReal = properties.getPropertyBoolean("real", true);
        this.iUseAmPm = properties.getPropertyBoolean("useAmPm", true);
        this.iAssignment = assignment;
        return this.createTable(assignment, properties);
    }

    @Override
    public boolean matches(Request r, Enrollment e) {
        if (this.iFilter == null) {
            return true;
        }
        if (r.getStudent().isDummy() && !this.iIncludeLastLike) {
            return false;
        }
        if (!r.getStudent().isDummy() && !this.iIncludeReal) {
            return false;
        }
        return this.iFilter.match((Query.TermMatcher)new RequestMatcher(r, e, this.iAssignment, this.iUser));
    }

    @Override
    public boolean matches(Request r) {
        if (this.iFilter == null) {
            return true;
        }
        if (r.getStudent().isDummy() && !this.iIncludeLastLike) {
            return false;
        }
        if (!r.getStudent().isDummy() && !this.iIncludeReal) {
            return false;
        }
        return this.iFilter.match((Query.TermMatcher)new RequestMatcher(r, (Enrollment)this.iAssignment.getValue((Variable)r), this.iAssignment, this.iUser));
    }

    @Override
    public boolean matches(Course c) {
        if (this.iFilter == null) {
            return true;
        }
        return this.iFilter.match((Query.TermMatcher)new CourseMatcher(c));
    }

    @Override
    public boolean matches(Student student) {
        for (Request r : student.getRequests()) {
            if (!this.matches(r)) continue;
            return true;
        }
        return false;
    }

    public boolean isUseAmPm() {
        return this.iUseAmPm;
    }

    public abstract CSVFile createTable(Assignment<Request, Enrollment> var1, DataProperties var2);

    public static class CourseMatcher
    implements Query.TermMatcher {
        private Course iCourse;

        public CourseMatcher(Course course) {
            this.iCourse = course;
        }

        public Course course() {
            return this.iCourse;
        }

        public boolean match(String attr, String term) {
            if (attr == null || "name".equals(attr) || "course".equals(attr)) {
                return this.course() != null && (this.course().getSubjectArea().equalsIgnoreCase(term) || this.course().getCourseNumber().equalsIgnoreCase(term) || (this.course().getSubjectArea() + " " + this.course().getCourseNumber()).equalsIgnoreCase(term));
            }
            if ("title".equals(attr)) {
                return this.course() != null && this.course().getTitle().toLowerCase().contains(term.toLowerCase());
            }
            if ("subject".equals(attr)) {
                return this.course() != null && this.course().getSubjectArea().equalsIgnoreCase(term);
            }
            if ("number".equals(attr)) {
                return this.course() != null && this.course().getCourseNumber().equalsIgnoreCase(term);
            }
            return true;
        }
    }

    public static class RequestMatcher
    extends UniversalOverride.StudentMatcher {
        private Request iRequest;
        private Enrollment iEnrollment;
        private String iUser;
        private Assignment<Request, Enrollment> iAssignment;
        public static String[] DAY_NAMES_CHARS = new String[]{"M", "T", "W", "R", "F", "S", "X"};

        public RequestMatcher(Request request, Enrollment enrollment, Assignment<Request, Enrollment> assignment, String user) {
            super(request.getStudent(), enrollment == null ? null : enrollment.getCourse());
            this.iRequest = request;
            this.iEnrollment = enrollment;
            this.iAssignment = assignment;
            this.iUser = user;
        }

        public boolean isAssigned() {
            return this.iEnrollment != null;
        }

        public Enrollment enrollment() {
            return this.iEnrollment;
        }

        public Request request() {
            return this.iRequest;
        }

        public CourseRequest cr() {
            return this.iRequest instanceof CourseRequest ? (CourseRequest)this.iRequest : null;
        }

        public Course course() {
            if (this.enrollment() != null) {
                return this.enrollment().getCourse();
            }
            if (this.request() instanceof CourseRequest) {
                return ((CourseRequest)this.request()).getCourses().get(0);
            }
            return null;
        }

        @Override
        public boolean match(String attr, String term) {
            if (super.match(attr, term)) {
                return true;
            }
            if ("assignment".equals(attr)) {
                if (this.eq("Assigned", term)) {
                    return this.isAssigned();
                }
                if (this.eq("Reserved", term)) {
                    return this.isAssigned() && this.enrollment().getReservation() != null;
                }
                if (this.eq("Not Assigned", term)) {
                    return !this.isAssigned() && !this.request().isAlternative();
                }
                if (this.eq("Wait-Listed", term)) {
                    if (this.enrollment() == null) {
                        return this.cr() != null && this.cr().isWaitlist();
                    }
                    return this.enrollment().isWaitlisted();
                }
                if (this.eq("Critical", term)) {
                    return this.request().getRequestPriority() == Request.RequestPriority.Critical;
                }
                if (this.eq("Assigned Critical", term)) {
                    return this.request().getRequestPriority() == Request.RequestPriority.Critical && this.isAssigned();
                }
                if (this.eq("Not Assigned Critical", term)) {
                    return this.request().getRequestPriority() == Request.RequestPriority.Critical && !this.isAssigned();
                }
                if (this.eq("Vital", term)) {
                    return this.request().getRequestPriority() == Request.RequestPriority.Vital;
                }
                if (this.eq("Assigned Vital", term)) {
                    return this.request().getRequestPriority() == Request.RequestPriority.Vital && this.isAssigned();
                }
                if (this.eq("Not Assigned Vital", term)) {
                    return this.request().getRequestPriority() == Request.RequestPriority.Vital && !this.isAssigned();
                }
                if (this.eq("Visiting F2F", term)) {
                    return this.request().getRequestPriority() == Request.RequestPriority.VisitingF2F;
                }
                if (this.eq("Assigned Visiting F2F", term)) {
                    return this.request().getRequestPriority() == Request.RequestPriority.VisitingF2F && this.isAssigned();
                }
                if (this.eq("Not Assigned Visiting F2F", term)) {
                    return this.request().getRequestPriority() == Request.RequestPriority.VisitingF2F && !this.isAssigned();
                }
                if (this.eq("LC", term)) {
                    return this.request().getRequestPriority() == Request.RequestPriority.LC;
                }
                if (this.eq("Assigned LC", term)) {
                    return this.request().getRequestPriority() == Request.RequestPriority.LC && this.isAssigned();
                }
                if (this.eq("Not Assigned LC", term)) {
                    return this.request().getRequestPriority() == Request.RequestPriority.LC && !this.isAssigned();
                }
                if (this.eq("Important", term)) {
                    return this.request().getRequestPriority() == Request.RequestPriority.Important;
                }
                if (this.eq("Assigned Important", term)) {
                    return this.request().getRequestPriority() == Request.RequestPriority.Important && this.isAssigned();
                }
                if (this.eq("Not Assigned Important", term)) {
                    return this.request().getRequestPriority() == Request.RequestPriority.Important && !this.isAssigned();
                }
                if (this.eq("No-Subs", term) || this.eq("No-Substitutes", term)) {
                    return this.cr() != null && this.cr().isWaitlist();
                }
                if (this.eq("Assigned No-Subs", term) || this.eq("Assigned  No-Substitutes", term)) {
                    return this.cr() != null && this.cr().isWaitlist() && this.isAssigned();
                }
                if (this.eq("Not Assigned No-Subs", term) || this.eq("Not Assigned No-Substitutes", term)) {
                    return this.cr() != null && this.cr().isWaitlist() && !this.isAssigned();
                }
            }
            if ("assigned".equals(attr) || "scheduled".equals(attr)) {
                if (this.eq("true", term) || this.eq("1", term)) {
                    return this.isAssigned();
                }
                return !this.isAssigned();
            }
            if ("waitlisted".equals(attr) || "waitlist".equals(attr)) {
                if (this.eq("true", term) || this.eq("1", term)) {
                    return !this.isAssigned() && this.cr() != null && this.cr().isWaitlist();
                }
                return this.isAssigned() && this.cr() != null && this.cr().isWaitlist();
            }
            if ("no-substitutes".equals(attr) || "no-subs".equals(attr)) {
                if (this.eq("true", term) || this.eq("1", term)) {
                    return !this.isAssigned() && this.cr() != null && this.cr().isWaitlist();
                }
                return this.isAssigned() && this.cr() != null && this.cr().isWaitlist();
            }
            if ("reservation".equals(attr) || "reserved".equals(attr)) {
                if (this.eq("true", term) || this.eq("1", term)) {
                    return this.isAssigned() && this.enrollment().getReservation() != null;
                }
                return this.isAssigned() && this.enrollment().getReservation() == null;
            }
            if ("mode".equals(attr)) {
                if (this.eq("My Students", term)) {
                    if (this.iUser == null) {
                        return false;
                    }
                    for (Instructor a : this.student().getAdvisors()) {
                        if (!this.eq(a.getExternalId(), this.iUser)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
            if ("status".equals(attr)) {
                if ("default".equalsIgnoreCase(term) || "Not Set".equalsIgnoreCase(term)) {
                    return this.student().getStatus() == null;
                }
                return this.like(this.student().getStatus(), term);
            }
            if ("credit".equals(attr)) {
                String im;
                float max;
                float min;
                block286: {
                    Object m;
                    block285: {
                        min = 0.0f;
                        max = Float.MAX_VALUE;
                        Credit prefix = Credit.eq;
                        String number = term;
                        if (number.startsWith("<=")) {
                            prefix = Credit.le;
                            number = number.substring(2);
                        } else if (number.startsWith(">=")) {
                            prefix = Credit.ge;
                            number = number.substring(2);
                        } else if (number.startsWith("<")) {
                            prefix = Credit.lt;
                            number = number.substring(1);
                        } else if (number.startsWith(">")) {
                            prefix = Credit.gt;
                            number = number.substring(1);
                        } else if (number.startsWith("=")) {
                            prefix = Credit.eq;
                            number = number.substring(1);
                        }
                        im = null;
                        try {
                            float a = Float.parseFloat(number);
                            switch (prefix) {
                                case eq: {
                                    min = max = a;
                                    break;
                                }
                                case le: {
                                    max = a;
                                    break;
                                }
                                case ge: {
                                    min = a;
                                    break;
                                }
                                case lt: {
                                    max = a - 1.0f;
                                    break;
                                }
                                case gt: {
                                    min = a + 1.0f;
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            m = Pattern.compile("([0-9]+\\.?[0-9]*)([^0-9\\.].*)").matcher(number);
                            if (!((Matcher)m).matches()) break block285;
                            float a = Float.parseFloat(((Matcher)m).group(1));
                            im = ((Matcher)m).group(2).trim();
                            switch (prefix) {
                                case eq: {
                                    min = max = a;
                                    break;
                                }
                                case le: {
                                    max = a;
                                    break;
                                }
                                case ge: {
                                    min = a;
                                    break;
                                }
                                case lt: {
                                    max = a - 1.0f;
                                    break;
                                }
                                case gt: {
                                    min = a + 1.0f;
                                }
                            }
                        }
                    }
                    if (term.contains("..")) {
                        try {
                            String a = term.substring(0, term.indexOf(46));
                            String b = term.substring(term.indexOf("..") + 2);
                            min = Float.parseFloat(a);
                            max = Float.parseFloat(b);
                        }
                        catch (NumberFormatException e) {
                            m = Pattern.compile("([0-9]+\\.?[0-9]*)\\.\\.([0-9]+\\.?[0-9]*)([^0-9].*)").matcher(term);
                            if (!((Matcher)m).matches()) break block286;
                            min = Float.parseFloat(((Matcher)m).group(1));
                            max = Float.parseFloat(((Matcher)m).group(2));
                            im = ((Matcher)m).group(3).trim();
                        }
                    }
                }
                float credit = 0.0f;
                for (Request r : this.student().getRequests()) {
                    Config g;
                    CourseRequest cr;
                    Enrollment e;
                    if (!(r instanceof CourseRequest) || (e = (Enrollment)this.iAssignment.getValue((Variable)(cr = (CourseRequest)r))) == null || (g = e.getConfig()) == null || "!".equals(im) && g.getInstructionalMethodReference() != null || im != null && !"!".equals(im) && !im.equalsIgnoreCase(g.getInstructionalMethodReference())) continue;
                    if (g.hasCreditValue()) {
                        credit += g.getCreditValue().floatValue();
                        continue;
                    }
                    if (!e.getCourse().hasCreditValue()) continue;
                    credit += e.getCourse().getCreditValue().floatValue();
                }
                return min <= credit && credit <= max;
            }
            if ("rc".equals(attr) || "requested-credit".equals(attr)) {
                int min = 0;
                int max = Integer.MAX_VALUE;
                Credit prefix = Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = Credit.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            min = max = a;
                            break;
                        }
                        case le: {
                            max = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            max = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        max = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                if (min == 0 && max == Integer.MAX_VALUE) {
                    return true;
                }
                float studentMinTot = 0.0f;
                float studentMaxTot = 0.0f;
                int nrCoursesTot = 0;
                ArrayList<Float> minsTot = new ArrayList<Float>();
                ArrayList<Float> maxsTot = new ArrayList<Float>();
                for (Request r : this.student().getRequests()) {
                    if (!(r instanceof CourseRequest)) continue;
                    CourseRequest cr = (CourseRequest)r;
                    Float minTot = null;
                    Float maxTot = null;
                    for (Course c : cr.getCourses()) {
                        if (!c.hasCreditValue()) continue;
                        if (minTot == null || minTot.floatValue() > c.getCreditValue().floatValue()) {
                            minTot = c.getCreditValue();
                        }
                        if (maxTot != null && !(maxTot.floatValue() < c.getCreditValue().floatValue())) continue;
                        maxTot = c.getCreditValue();
                    }
                    if (cr.isWaitlist()) {
                        if (minTot == null) continue;
                        studentMinTot += minTot.floatValue();
                        studentMaxTot += maxTot.floatValue();
                        continue;
                    }
                    if (minTot == null) continue;
                    minsTot.add(minTot);
                    maxsTot.add(maxTot);
                    if (r.isAlternative()) continue;
                    ++nrCoursesTot;
                }
                Collections.sort(minsTot);
                Collections.sort(maxsTot);
                for (int i = 0; i < nrCoursesTot; ++i) {
                    studentMinTot += ((Float)minsTot.get(i)).floatValue();
                    studentMaxTot += ((Float)maxsTot.get(maxsTot.size() - i - 1)).floatValue();
                }
                return (float)min <= studentMaxTot && studentMinTot <= (float)max;
            }
            if ("fc".equals(attr) || "first-choice-credit".equals(attr)) {
                int min = 0;
                int max = Integer.MAX_VALUE;
                Credit prefix = Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = Credit.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            min = max = a;
                            break;
                        }
                        case le: {
                            max = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            max = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        max = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                if (min == 0 && max == Integer.MAX_VALUE) {
                    return true;
                }
                float credit = 0.0f;
                block89: for (Request r : this.student().getRequests()) {
                    if (!(r instanceof CourseRequest)) continue;
                    CourseRequest cr = (CourseRequest)r;
                    for (Course c : cr.getCourses()) {
                        if (c == null || !c.hasCreditValue()) continue;
                        credit += c.getCreditValue().floatValue();
                        continue block89;
                    }
                }
                return (float)min <= credit && credit <= (float)max;
            }
            if ("rp".equals(attr)) {
                if ("subst".equalsIgnoreCase(term)) {
                    return this.request().isAlternative();
                }
                int min = 0;
                int max = Integer.MAX_VALUE;
                Credit prefix = Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = Credit.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            min = max = a;
                            break;
                        }
                        case le: {
                            max = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            max = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        max = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                if (min == 0 && max == Integer.MAX_VALUE) {
                    return true;
                }
                return !this.request().isAlternative() && min <= this.request().getPriority() + 1 && this.request().getPriority() + 1 <= max;
            }
            if ("choice".equals(attr) || "ch".equals(attr)) {
                if (this.cr() == null) {
                    return false;
                }
                int min = 0;
                int max = Integer.MAX_VALUE;
                Credit prefix = Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = Credit.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            min = max = a;
                            break;
                        }
                        case le: {
                            max = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            max = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        max = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                if (min == 0 && max == Integer.MAX_VALUE) {
                    return true;
                }
                if (this.enrollment() != null) {
                    int choice = 1;
                    for (Course course : this.cr().getCourses()) {
                        if (course.equals((Object)this.enrollment().getCourse())) {
                            return min <= choice && choice <= max;
                        }
                        ++choice;
                    }
                    return false;
                }
                if (!this.request().isAlternative()) {
                    int choice = this.cr().getCourses().size();
                    return min <= choice && choice <= max;
                }
                return false;
            }
            if ("btb".equals(attr)) {
                if ("prefer".equalsIgnoreCase(term) || "preferred".equalsIgnoreCase(term)) {
                    return this.student().getBackToBackPreference() == Student.BackToBackPreference.BTB_PREFERRED;
                }
                if ("disc".equalsIgnoreCase(term) || "discouraged".equalsIgnoreCase(term)) {
                    return this.student().getBackToBackPreference() == Student.BackToBackPreference.BTB_DISCOURAGED;
                }
                return this.student().getBackToBackPreference() == Student.BackToBackPreference.NO_PREFERENCE;
            }
            if ("online".equals(attr)) {
                if ("prefer".equalsIgnoreCase(term) || "preferred".equalsIgnoreCase(term)) {
                    return this.student().getModalityPreference() == Student.ModalityPreference.ONLINE_PREFERRED;
                }
                if ("require".equalsIgnoreCase(term) || "required".equalsIgnoreCase(term)) {
                    return this.student().getModalityPreference() == Student.ModalityPreference.ONLINE_REQUIRED;
                }
                if ("disc".equalsIgnoreCase(term) || "discouraged".equalsIgnoreCase(term)) {
                    return this.student().getModalityPreference() == Student.ModalityPreference.ONILNE_DISCOURAGED;
                }
                if ("no".equalsIgnoreCase(term) || "no-preference".equalsIgnoreCase(term)) {
                    return this.student().getModalityPreference() == Student.ModalityPreference.NO_PREFERENCE;
                }
            }
            if ("online".equals(attr) || "face-to-face".equals(attr) || "f2f".equals(attr) || "no-time".equals(attr) || "has-time".equals(attr)) {
                int min = 0;
                int max = Integer.MAX_VALUE;
                Credit prefix = Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = Credit.eq;
                    number = number.substring(1);
                }
                boolean perc = false;
                if (number.endsWith("%")) {
                    perc = true;
                    number = number.substring(0, number.length() - 1).trim();
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            min = max = a;
                            break;
                        }
                        case le: {
                            max = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            max = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        max = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                if (min == 0 && max == Integer.MAX_VALUE) {
                    return true;
                }
                int match = 0;
                int total = 0;
                for (Request r : this.student().getRequests()) {
                    CourseRequest cr;
                    Enrollment e;
                    if (!(r instanceof CourseRequest) || (e = (Enrollment)this.iAssignment.getValue((Variable)(cr = (CourseRequest)r))) == null) continue;
                    for (Section section : this.enrollment().getSections()) {
                        if ("online".equals(attr) && section.isOnline()) {
                            ++match;
                        } else if (("face-to-face".equals(attr) || "f2f".equals(attr)) && !section.isOnline()) {
                            ++match;
                        } else if ("no-time".equals(attr) && (section.getTime() == null || section.getTime().getDayCode() == 0)) {
                            ++match;
                        } else if ("has-time".equals(attr) && section.getTime() != null && section.getTime().getDayCode() != 0) {
                            ++match;
                        }
                        ++total;
                    }
                }
                if (total == 0) {
                    return false;
                }
                if (perc) {
                    double percentage = 100.0 * (double)match / (double)total;
                    return (double)min <= percentage && percentage <= (double)max;
                }
                return min <= match && match <= max;
            }
            if ("overlap".equals(attr)) {
                int min = 0;
                int max = Integer.MAX_VALUE;
                Credit prefix = Credit.eq;
                String number = term;
                if (number.startsWith("<=")) {
                    prefix = Credit.le;
                    number = number.substring(2);
                } else if (number.startsWith(">=")) {
                    prefix = Credit.ge;
                    number = number.substring(2);
                } else if (number.startsWith("<")) {
                    prefix = Credit.lt;
                    number = number.substring(1);
                } else if (number.startsWith(">")) {
                    prefix = Credit.gt;
                    number = number.substring(1);
                } else if (number.startsWith("=")) {
                    prefix = Credit.eq;
                    number = number.substring(1);
                }
                try {
                    int a = Integer.parseInt(number);
                    switch (prefix) {
                        case eq: {
                            min = max = a;
                            break;
                        }
                        case le: {
                            max = a;
                            break;
                        }
                        case ge: {
                            min = a;
                            break;
                        }
                        case lt: {
                            max = a - 1;
                            break;
                        }
                        case gt: {
                            min = a + 1;
                        }
                    }
                }
                catch (NumberFormatException a) {
                    // empty catch block
                }
                if (term.contains("..")) {
                    try {
                        String a = term.substring(0, term.indexOf(46));
                        String b = term.substring(term.indexOf("..") + 2);
                        min = Integer.parseInt(a);
                        max = Integer.parseInt(b);
                    }
                    catch (NumberFormatException a) {
                        // empty catch block
                    }
                }
                int share = 0;
                for (Request r : this.student().getRequests()) {
                    CourseRequest cr;
                    Enrollment e;
                    if (!(r instanceof CourseRequest) || (e = (Enrollment)this.iAssignment.getValue((Variable)(cr = (CourseRequest)r))) == null) continue;
                    for (Section section : e.getSections()) {
                        if (section.getTime() == null) continue;
                        for (Request q : this.student().getRequests()) {
                            Enrollment otherEnrollment;
                            if (q.equals((Object)this.request()) || (otherEnrollment = (Enrollment)this.iAssignment.getValue((Variable)q)) == null || otherEnrollment.getCourse() == null) continue;
                            for (Section otherSection : otherEnrollment.getSections()) {
                                if (otherSection.getTime() == null || !otherSection.getTime().hasIntersection(section.getTime())) continue;
                                share += 5 * section.getTime().nrSharedHours(otherSection.getTime()) * section.getTime().nrSharedDays(otherSection.getTime());
                            }
                        }
                    }
                }
                return min <= share && share <= max;
            }
            if ("prefer".equals(attr)) {
                if (this.cr() == null) {
                    return false;
                }
                if (this.eq("Any Preference", term)) {
                    return !this.cr().getSelectedChoices().isEmpty() || !this.cr().getRequiredChoices().isEmpty();
                }
                if (this.eq("Met Preference", term) || this.eq("Unmet Preference", term)) {
                    if (this.enrollment() == null) {
                        if (this.eq("Unmet Preference", term)) {
                            return !this.cr().getSelectedChoices().isEmpty() || !this.cr().getRequiredChoices().isEmpty();
                        }
                        return false;
                    }
                    if (this.eq("Met Preference", term)) {
                        return this.enrollment().isSelected();
                    }
                    return !this.enrollment().isSelected();
                }
                return false;
            }
            if ("require".equals(attr)) {
                if (this.cr() == null) {
                    return false;
                }
                if (this.eq("Any Requirement", term)) {
                    return !this.cr().getRequiredChoices().isEmpty();
                }
                if (this.eq("Met Requirement", term)) {
                    return this.enrollment() != null && this.enrollment().isRequired();
                }
                if (this.eq("Unmet Requirement", term)) {
                    return this.enrollment() != null && !this.enrollment().isRequired();
                }
                return false;
            }
            if ("im".equals(attr)) {
                if (this.cr() == null) {
                    return false;
                }
                if (this.enrollment() == null) {
                    Iterator<Course> min = this.cr().getCourses().iterator();
                    if (min.hasNext()) {
                        Course course = min.next();
                        for (Config config : course.getOffering().getConfigs()) {
                            if (!term.equals(config.getInstructionalMethodReference())) continue;
                            return true;
                        }
                    }
                    return false;
                }
                Config config = this.enrollment().getConfig();
                if (config == null) {
                    return false;
                }
                return term.equals(config.getInstructionalMethodReference());
            }
            if (this.enrollment() != null && this.enrollment().getCourse() != null) {
                for (Section section : this.enrollment().getSections()) {
                    int start;
                    int end;
                    if ((attr == null || attr.equals("crn") || attr.equals("id") || attr.equals("externalId") || attr.equals("exid") || attr.equals("name")) && section.getName(this.enrollment().getCourse().getId()) != null && section.getName(this.enrollment().getCourse().getId()).toLowerCase().startsWith(term.toLowerCase())) {
                        return true;
                    }
                    if (attr == null || attr.equals("day")) {
                        int day;
                        if (section.getTime() == null && term.equalsIgnoreCase("none")) {
                            return true;
                        }
                        if (section.getTime() != null && (day = this.parseDay(term)) > 0 && (section.getTime().getDayCode() & day) == day) {
                            return true;
                        }
                    }
                    if (attr == null || attr.equals("time")) {
                        int start2;
                        if (section.getTime() == null && term.equalsIgnoreCase("none")) {
                            return true;
                        }
                        if (section.getTime() != null && (start2 = this.parseStart(term)) >= 0 && section.getTime().getStartSlot() == start2) {
                            return true;
                        }
                    }
                    if (attr != null && attr.equals("before") && section.getTime() != null && (end = this.parseStart(term)) >= 0 && section.getTime().getStartSlot() + section.getTime().getLength() - section.getTime().getBreakTime() / 5 <= end) {
                        return true;
                    }
                    if (attr != null && attr.equals("after") && section.getTime() != null && (start = this.parseStart(term)) >= 0 && section.getTime().getStartSlot() >= start) {
                        return true;
                    }
                    if (attr == null || attr.equals("room")) {
                        if ((section.getRooms() == null || section.getRooms().isEmpty()) && term.equalsIgnoreCase("none")) {
                            return true;
                        }
                        if (section.getRooms() != null) {
                            for (RoomLocation r : section.getRooms()) {
                                if (!this.has(r.getName(), term)) continue;
                                return true;
                            }
                        }
                    }
                    if (attr != null && !attr.equals("instr") && !attr.equals("instructor")) continue;
                    if (attr != null && section.getInstructors().isEmpty() && term.equalsIgnoreCase("none")) {
                        return true;
                    }
                    for (Instructor instuctor : section.getInstructors()) {
                        if (this.has(instuctor.getName(), term) || this.eq(instuctor.getExternalId(), term)) {
                            return true;
                        }
                        if (instuctor.getEmail() == null) continue;
                        String email = instuctor.getEmail();
                        if (email.indexOf(64) >= 0) {
                            email = email.substring(0, email.indexOf(64));
                        }
                        if (!this.eq(email, term)) continue;
                        return true;
                    }
                }
            }
            if (attr == null || "name".equals(attr) || "course".equals(attr)) {
                return this.course() != null && (this.course().getSubjectArea().equalsIgnoreCase(term) || this.course().getCourseNumber().equalsIgnoreCase(term) || (this.course().getSubjectArea() + " " + this.course().getCourseNumber()).equalsIgnoreCase(term));
            }
            if ("title".equals(attr)) {
                return this.course() != null && this.course().getTitle().toLowerCase().contains(term.toLowerCase());
            }
            if ("subject".equals(attr)) {
                return this.course() != null && this.course().getSubjectArea().equalsIgnoreCase(term);
            }
            if ("number".equals(attr)) {
                return this.course() != null && this.course().getCourseNumber().equalsIgnoreCase(term);
            }
            return false;
        }

        private boolean eq(String name, String term) {
            if (name == null) {
                return false;
            }
            return name.equalsIgnoreCase(term);
        }

        private boolean has(String name, String term) {
            if (name == null) {
                return false;
            }
            if (this.eq(name, term)) {
                return true;
            }
            for (String t : name.split(" |,")) {
                if (!t.equalsIgnoreCase(term)) continue;
                return true;
            }
            return false;
        }

        private boolean like(String name, String term) {
            if (name == null) {
                return false;
            }
            if (term.indexOf(37) >= 0) {
                return name.matches("(?i)" + term.replaceAll("%", ".*"));
            }
            return name.equalsIgnoreCase(term);
        }

        private int parseDay(String token) {
            int days = 0;
            boolean found = false;
            do {
                int i;
                found = false;
                for (i = 0; i < Constants.DAY_NAMES_SHORT.length; ++i) {
                    if (!token.toLowerCase().startsWith(Constants.DAY_NAMES_SHORT[i].toLowerCase())) continue;
                    days |= Constants.DAY_CODES[i];
                    token = token.substring(Constants.DAY_NAMES_SHORT[i].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
                for (i = 0; i < DAY_NAMES_CHARS.length; ++i) {
                    if (!token.toLowerCase().startsWith(DAY_NAMES_CHARS[i].toLowerCase())) continue;
                    days |= Constants.DAY_CODES[i];
                    token = token.substring(DAY_NAMES_CHARS[i].length());
                    while (token.startsWith(" ")) {
                        token = token.substring(1);
                    }
                    found = true;
                }
            } while (found);
            return token.isEmpty() ? days : 0;
        }

        private int parseStart(String token) {
            int startHour = 0;
            int startMin = 0;
            String number = "";
            while (!token.isEmpty() && token.charAt(0) >= '0' && token.charAt(0) <= '9') {
                number = number + token.substring(0, 1);
                token = token.substring(1);
            }
            if (number.isEmpty()) {
                return -1;
            }
            if (number.length() > 2) {
                startHour = Integer.parseInt(number) / 100;
                startMin = Integer.parseInt(number) % 100;
            } else {
                startHour = Integer.parseInt(number);
            }
            while (token.startsWith(" ")) {
                token = token.substring(1);
            }
            if (token.startsWith(":")) {
                token = token.substring(1);
                while (token.startsWith(" ")) {
                    token = token.substring(1);
                }
                number = "";
                while (!token.isEmpty() && token.charAt(0) >= '0' && token.charAt(0) <= '9') {
                    number = number + token.substring(0, 1);
                    token = token.substring(1);
                }
                if (number.isEmpty()) {
                    return -1;
                }
                startMin = Integer.parseInt(number);
            }
            while (token.startsWith(" ")) {
                token = token.substring(1);
            }
            boolean hasAmOrPm = false;
            if (token.toLowerCase().startsWith("am")) {
                token = token.substring(2);
                hasAmOrPm = true;
            }
            if (token.toLowerCase().startsWith("a")) {
                token = token.substring(1);
                hasAmOrPm = true;
            }
            if (token.toLowerCase().startsWith("pm")) {
                token = token.substring(2);
                hasAmOrPm = true;
                if (startHour < 12) {
                    startHour += 12;
                }
            }
            if (token.toLowerCase().startsWith("p")) {
                token = token.substring(1);
                hasAmOrPm = true;
                if (startHour < 12) {
                    startHour += 12;
                }
            }
            if (startHour < 7 && !hasAmOrPm) {
                startHour += 12;
            }
            if (startMin % 5 != 0) {
                startMin = 5 * ((startMin + 2) / 5);
            }
            if (startHour == 7 && startMin == 0 && !hasAmOrPm) {
                startHour += 12;
            }
            return (60 * startHour + startMin) / 5;
        }

        public static enum Credit {
            eq,
            lt,
            gt,
            le,
            ge;

        }
    }
}

