/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.filter;

import org.cpsolver.studentsct.filter.StudentFilter;
import org.cpsolver.studentsct.model.Student;

public class PriortyStudentFilter
implements StudentFilter {
    Student.StudentPriority iPriority = Student.StudentPriority.Priority;
    boolean iIncludeHigherPriority = true;

    public PriortyStudentFilter(Student.StudentPriority priority, boolean includeHigherPriority) {
        this.iPriority = priority;
        this.iIncludeHigherPriority = includeHigherPriority;
    }

    @Override
    public boolean accept(Student student) {
        if (student.isDummy()) {
            return false;
        }
        if (this.iIncludeHigherPriority) {
            return this.iPriority.isSameOrHigher(student);
        }
        return this.iPriority.isSame(student);
    }

    @Override
    public String getName() {
        return this.iPriority.name() + (this.iIncludeHigherPriority ? "+" : "");
    }
}

