/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.heuristics;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.cpsolver.coursett.criteria.TimetablingCriterion;
import org.cpsolver.coursett.heuristics.HeuristicSelector;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.extension.MacPropagation;
import org.cpsolver.ifs.heuristics.ValueSelection;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class PlacementSelection
implements ValueSelection<Lecture, Placement> {
    static final int NR_LEVELS = 3;
    private static final double PRECISION = 1.0;
    private static boolean USE_THRESHOLD = true;
    private boolean iUseThreshold = USE_THRESHOLD;
    private double iGoodSelectionProb;
    public static final String GOOD_SELECTION_PROB = "Placement.GoodSelectionProb";
    private double iRandomWalkProb;
    public static final String RW_SELECTION_PROB = "Placement.RandomWalkProb";
    private double iInitialSelectionProb;
    public static final String INITIAL_SELECTION_PROB = "Placement.MPP_InitialProb";
    private int iMPPLimit;
    public static final String NR_MPP_LIMIT = "Placement.MPP_Limit";
    private double iMPPPenaltyLimit;
    public static final String NR_MPP_PENALTY_LIMIT = "Placement.MPP_PenaltyLimit";
    private double[] iThresholdKoef = new double[3];
    public static final String NR_THRESHOLD_KOEF = "Placement.ThresholdKoef";
    private int iTabuSize = 0;
    private ArrayList<Placement> iTabu = null;
    private int iTabuPos = 0;
    public static final String TABU_LENGTH = "Placement.TabuLength";
    private MacPropagation<Lecture, Placement> iProp = null;
    private boolean iRW = false;
    private boolean iMPP = false;
    private boolean iCanUnassingSingleton = false;

    public void init(Solver<Lecture, Placement> solver) {
        for (Extension extension : solver.getExtensions()) {
            if (!MacPropagation.class.isInstance(extension)) continue;
            this.iProp = (MacPropagation)extension;
        }
    }

    public PlacementSelection(DataProperties properties) {
        this.iMPP = properties.getPropertyBoolean("General.MPP", false);
        this.iRW = properties.getPropertyBoolean("General.RandomWalk", true);
        this.iCanUnassingSingleton = properties.getPropertyBoolean("Placement.CanUnassingSingleton", this.iCanUnassingSingleton);
        this.iRandomWalkProb = this.iRW ? properties.getPropertyDouble(RW_SELECTION_PROB, 0.0) : 0.0;
        this.iGoodSelectionProb = properties.getPropertyDouble(GOOD_SELECTION_PROB, 1.0);
        this.iInitialSelectionProb = this.iMPP ? properties.getPropertyDouble(INITIAL_SELECTION_PROB, 0.75) : 0.0;
        this.iMPPLimit = this.iMPP ? properties.getPropertyInt(NR_MPP_LIMIT, -1) : -1;
        this.iMPPPenaltyLimit = this.iMPP ? properties.getPropertyDouble(NR_MPP_PENALTY_LIMIT, -1.0) : -1.0;
        this.iTabuSize = properties.getPropertyInt(TABU_LENGTH, -1);
        if (this.iTabuSize > 0) {
            this.iTabu = new ArrayList(this.iTabuSize);
        }
        this.iUseThreshold = properties.getPropertyBoolean("Placement.UseThreshold", USE_THRESHOLD);
        for (int level = 0; level < 3; ++level) {
            this.iThresholdKoef[level] = USE_THRESHOLD ? properties.getPropertyDouble(NR_THRESHOLD_KOEF + (level + 1), level == 0 ? 0.1 : 0.0) : 0.0;
        }
    }

    public Placement selectValue(Solution<Lecture, Placement> solution, Lecture var) {
        Set goodValues;
        Placement ret;
        if (var == null) {
            return null;
        }
        Lecture selectedVariable = var;
        TimetableModel model = (TimetableModel)solution.getModel();
        Assignment assignment = solution.getAssignment();
        if (selectedVariable.getInitialAssignment() != null && (this.iMPPLimit >= 0 && model.perturbVariables(assignment).size() >= this.iMPPLimit ? !this.containsItselfSingletonOrCommited(model, model.conflictValues(assignment, selectedVariable.getInitialAssignment()), (Placement)selectedVariable.getInitialAssignment()) : (this.iMPPPenaltyLimit >= 0.0 && solution.getPerturbationsCounter() != null && solution.getPerturbationsCounter().getPerturbationPenalty(assignment, (Model)model) > this.iMPPPenaltyLimit ? !this.containsItselfSingletonOrCommited(model, model.conflictValues(assignment, selectedVariable.getInitialAssignment()), (Placement)selectedVariable.getInitialAssignment()) : selectedVariable.getInitialAssignment() != null && ToolBox.random() <= this.iInitialSelectionProb && !this.containsItselfSingletonOrCommited(model, model.conflictValues(assignment, selectedVariable.getInitialAssignment()), (Placement)selectedVariable.getInitialAssignment())))) {
            return (Placement)selectedVariable.getInitialAssignment();
        }
        List<Placement> values = selectedVariable.values((Assignment<Lecture, Placement>)solution.getAssignment());
        if (this.iRW && ToolBox.random() <= this.iRandomWalkProb) {
            for (int i = 0; i < 5; ++i) {
                ret = (Placement)((Object)ToolBox.random(values));
                if (this.containsItselfSingletonOrCommited(model, model.conflictValues(assignment, ret), ret)) continue;
                return ret;
            }
        }
        Placement current = (Placement)assignment.getValue((Variable)selectedVariable);
        if (this.iProp != null && current == null && ToolBox.random() <= this.iGoodSelectionProb && !(goodValues = this.iProp.goodValues(assignment, (Variable)selectedVariable)).isEmpty()) {
            values = new ArrayList<Placement>(goodValues);
        }
        if (values.size() == 1 && !this.containsItselfSingletonOrCommited(model, model.conflictValues(assignment, ret = values.get(0)), ret)) {
            return ret;
        }
        long[] bestCost = new long[3];
        ArrayList<Placement> selectionValues = null;
        HeuristicSelector<Placement> selector = this.iUseThreshold ? new HeuristicSelector<Placement>(this.iThresholdKoef) : null;
        for (Placement value : values) {
            int level;
            Object conflicts;
            if (this.iTabu != null && this.iTabu.contains((Object)value) || current != null && current.equals((Object)value) || this.containsItselfSingletonOrCommited(model, (Set<Placement>)(conflicts = ((Lecture)value.variable()).getModel().conflictValues(assignment, (Value)value)), value)) continue;
            if (this.iUseThreshold) {
                Double flt = selector.firstLevelThreshold();
                double[] costs = new double[3];
                for (level = 0; level < 3; ++level) {
                    costs[level] = this.getCost((Assignment<Lecture, Placement>)assignment, level, value, (Set<Placement>)conflicts);
                    if (level == 0 && flt != null && costs[0] > flt) break;
                }
                if (flt != null && costs[0] > flt) continue;
                selector.add(costs, value);
                continue;
            }
            boolean fail = false;
            boolean best = false;
            for (level = 0; !fail && level < 1; ++level) {
                double val = this.getCost((Assignment<Lecture, Placement>)assignment, level, value, (Set<Placement>)conflicts);
                long cost = Math.round(1.0 * val);
                if (selectionValues != null && !best) {
                    if (cost > bestCost[level]) {
                        fail = true;
                    }
                    if (cost >= bestCost[level]) continue;
                    bestCost[level] = cost;
                    selectionValues.clear();
                    best = true;
                    continue;
                }
                bestCost[level] = cost;
            }
            if (selectionValues == null) {
                selectionValues = new ArrayList<Placement>(values.size());
            }
            if (fail) continue;
            selectionValues.add(value);
        }
        Placement selectedValue = null;
        if (this.iUseThreshold) {
            List<HeuristicSelector.Element> selectionElements = selector.selection();
            if (selectedVariable.getInitialAssignment() != null) {
                for (HeuristicSelector.Element element : selectionElements) {
                    Placement value = (Placement)((Object)element.getObject());
                    if (!value.equals(selectedVariable.getInitialAssignment())) continue;
                    selectedValue = value;
                    break;
                }
            }
            if (selectedValue == null) {
                HeuristicSelector.Element selection = (HeuristicSelector.Element)ToolBox.random(selectionElements);
                selectedValue = selection == null ? null : (Placement)((Object)selection.getObject());
            }
        } else {
            if (selectedVariable.getInitialAssignment() != null && selectionValues.contains(selectedVariable.getInitialAssignment())) {
                return (Placement)selectedVariable.getInitialAssignment();
            }
            selectedValue = (Placement)((Object)ToolBox.random(selectionValues));
        }
        if (selectedValue != null && this.iTabu != null) {
            if (this.iTabu.size() == this.iTabuPos) {
                this.iTabu.add(selectedValue);
            } else {
                this.iTabu.set(this.iTabuPos, selectedValue);
            }
            this.iTabuPos = (this.iTabuPos + 1) % this.iTabuSize;
        }
        return selectedValue;
    }

    public boolean containsItselfSingletonOrCommited(TimetableModel model, Set<Placement> values, Placement selectedValue) {
        if (values.contains((Object)selectedValue)) {
            return true;
        }
        if (model.hasConstantVariables()) {
            for (Placement placement : values) {
                Lecture lecture = (Lecture)placement.variable();
                if (lecture.isCommitted()) {
                    return true;
                }
                if (this.iCanUnassingSingleton || !lecture.isSingleton()) continue;
                return true;
            }
            return false;
        }
        if (this.iCanUnassingSingleton) {
            return false;
        }
        for (Placement placement : values) {
            Lecture lecture = (Lecture)placement.variable();
            if (!lecture.isSingleton()) continue;
            return true;
        }
        return false;
    }

    private double getCost(Assignment<Lecture, Placement> assignment, int level, Placement value, Set<Placement> conflicts) {
        double ret = 0.0;
        for (Criterion criterion : ((Lecture)value.variable()).getModel().getCriteria()) {
            if (criterion instanceof TimetablingCriterion) {
                double w = ((TimetablingCriterion)criterion).getPlacementSelectionWeight(level, assignment.getIndex() - 1);
                if (w == 0.0) continue;
                ret += w * criterion.getValue(assignment, (Value)value, conflicts);
                continue;
            }
            ret += criterion.getWeightedValue(assignment, (Value)value, conflicts);
        }
        return ret;
    }
}

