/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.coursett.constraint.SpreadConstraint;
import org.cpsolver.coursett.criteria.TimetablingCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.util.DataProperties;

public class SameSubpartBalancingPenalty
extends TimetablingCriterion {
    public SameSubpartBalancingPenalty() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.NoUpdate);
    }

    public double getWeightDefault(DataProperties config) {
        return 12.0 * config.getPropertyDouble("Comparator.SpreadPenaltyWeight", 1.0);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.SpreadPenaltyWeight";
    }

    public double getValue(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        double ret = 0.0;
        for (SpreadConstraint sc : ((Lecture)value.variable()).getSpreadConstraints()) {
            ret += (double)sc.getPenalty(assignment, value);
        }
        return ret / 12.0;
    }

    public double getValue(Assignment<Lecture, Placement> assignment) {
        return super.getValue(assignment) / 12.0;
    }

    public double getValue(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        double ret = 0.0;
        HashSet<SpreadConstraint> constraints = new HashSet<SpreadConstraint>();
        for (Lecture lect : variables) {
            for (SpreadConstraint sc : lect.getSpreadConstraints()) {
                if (!constraints.add(sc)) continue;
                ret += (double)sc.getPenalty(assignment);
            }
        }
        return ret / 12.0;
    }

    public double[] getBounds(Assignment<Lecture, Placement> assignment) {
        return new double[]{0.0, 0.0};
    }

    public double[] getBounds(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        return new double[]{0.0, 0.0};
    }
}

